/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import io.sarl.docs.generator.AbstractDocumentationMojo;
import io.sarl.docs.generator.Messages;
import io.sarl.docs.generator.TraceableTreeAppendable;
import io.sarl.docs.generator.markdown.MarkdownParser;
import io.sarl.docs.generator.parser.AbstractMarkerLanguageParser;
import io.sarl.docs.generator.parser.DynamicValidationComponent;
import io.sarl.docs.generator.parser.DynamicValidationContext;
import io.sarl.docs.generator.parser.ValidationComponent;
import io.sarl.docs.validator.DocumentationSetup;
import io.sarl.docs.validator.ScriptExecutor;
import io.sarl.lang.util.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Proxy;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

@Mojo(name="generatetests", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateTestsMojo
extends AbstractDocumentationMojo {
    private static final String BASE_PACKAGE = "io.sarl.docs.tests";
    @Parameter(defaultValue="true", required=false)
    protected boolean localLinkValidation;
    @Parameter(defaultValue="true", required=false)
    protected boolean remoteLinkValidation;
    @Parameter(defaultValue="5000", required=false)
    protected int remoteLinkTimeOut;
    @Parameter(defaultValue="true", required=false)
    protected boolean ignoreRemoteLinkTimeOut;
    @Parameter(defaultValue="true", required=false)
    protected boolean localImageValidation;
    private TraceRegionSerializer traceSerializer;

    protected TraceRegionSerializer getTraceSerializer() {
        if (this.traceSerializer == null) {
            this.traceSerializer = (TraceRegionSerializer)this.injector.getInstance(TraceRegionSerializer.class);
        }
        return this.traceSerializer;
    }

    @Override
    protected String getSkippingMessage() {
        int i;
        String[] variableNames = new String[]{"maven.test.skip", "skipTests", "io.sarl.docs.tests.skip"};
        String value = null;
        for (i = 0; Strings.isEmpty(value) && i < variableNames.length; ++i) {
            value = System.getProperty(variableNames[i]);
        }
        for (i = 0; Strings.isEmpty(value) && i < variableNames.length; ++i) {
            value = System.getenv(variableNames[i]);
        }
        if (Boolean.parseBoolean(value)) {
            return "Tests are skipped.";
        }
        return null;
    }

    @Override
    protected AbstractMarkerLanguageParser createLanguageParser(File inputFile) throws MojoExecutionException, IOException {
        AbstractMarkerLanguageParser parser = super.createLanguageParser(inputFile);
        if (parser instanceof MarkdownParser) {
            MarkdownParser mdParser = (MarkdownParser)parser;
            mdParser.setLocalImageReferenceValidation(this.localImageValidation);
            mdParser.setLocalFileReferenceValidation(this.localLinkValidation);
            mdParser.setRemoteReferenceValidation(!this.session.isOffline() && this.remoteLinkValidation);
        }
        return parser;
    }

    @Override
    protected String internalExecute(Map<File, File> files) {
        this.getLog().info((CharSequence)Messages.GenerateTestsMojo_11);
        File output = FileSystem.convertStringToFile((String)this.testSourceDirectory);
        String msg = this.internalExecute(files, output);
        if (!Strings.isEmpty((String)msg)) {
            return msg;
        }
        try {
            this.generateAbstractTest(output);
        }
        catch (IOException exception) {
            String message = Throwables.getRootCause((Throwable)exception).getLocalizedMessage();
            this.getLog().error((CharSequence)message);
            this.getLog().debug((Throwable)exception);
            return message;
        }
        return null;
    }

    @Override
    protected String internalExecute(Map<File, File> files, File outputFolder) {
        try {
            FileSystem.delete((File)outputFolder);
        }
        catch (IOException exception) {
            String message = this.formatErrorMessage(outputFolder, exception);
            this.getLog().error((CharSequence)message);
            this.getLog().debug((Throwable)exception);
            return message;
        }
        return super.internalExecute(files, outputFolder);
    }

    @Override
    protected void internalExecute(File sourceFolder, File inputFile, File relativeInputFile, File outputFolder, AbstractMarkerLanguageParser parser) throws IOException {
        this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateTestsMojo_0, inputFile.getName()));
        ArrayList<ValidationComponent> successCompilationComponents = new ArrayList<ValidationComponent>();
        ArrayList<ValidationComponent> failureCompilationComponents = new ArrayList<ValidationComponent>();
        ArrayList<ValidationComponent> factualComponents = new ArrayList<ValidationComponent>();
        for (ValidationComponent component : parser.getStandardValidationComponents(inputFile)) {
            if (component.isCompilable()) {
                if (component.isExecutable()) {
                    factualComponents.add(component);
                    continue;
                }
                successCompilationComponents.add(component);
                continue;
            }
            failureCompilationComponents.add(component);
        }
        DynamicValidationContext validationContext = new DynamicValidationContext();
        validationContext.setSourceRoots(this.session.getCurrentProject().getCompileSourceRoots());
        validationContext.setResourceRoots(Lists.transform((List)this.session.getCurrentProject().getResources(), it -> it.getDirectory()));
        validationContext.setDestinationRoots(Collections.singletonList(this.session.getCurrentProject().getBuild().getOutputDirectory()));
        List<DynamicValidationComponent> specificComponents = parser.getMarkerSpecificValidationComponents(inputFile, sourceFolder, validationContext);
        if (successCompilationComponents.isEmpty() && failureCompilationComponents.isEmpty() && factualComponents.isEmpty() && specificComponents.isEmpty()) {
            return;
        }
        String basicTestName = GenerateTestsMojo.toTestName(inputFile);
        String generalTestName = basicTestName + "Test";
        ImportManager importManager = new ImportManager();
        TraceableTreeAppendable it2 = new TraceableTreeAppendable(importManager);
        String displayName = GenerateTestsMojo.toClassDisplayName(relativeInputFile, basicTestName, generalTestName);
        it2.append("@").append(DisplayName.class).append((CharSequence)"(\"").append((CharSequence)displayName).append((CharSequence)"\")").newLine();
        it2.append("@").append(Tag.class).append((CharSequence)"(\"documentation\")").newLine();
        it2.append("@").append(Tag.class).append((CharSequence)"(\"doc\")").newLine();
        it2.append("public class ").append((CharSequence)generalTestName).append((CharSequence)" extends ").append((CharSequence)BASE_PACKAGE).append((CharSequence)".AbstractBaseTest").append((CharSequence)" {").increaseIndentation().newLine();
        File absoluteInputFile = FileSystem.makeAbsolute((File)relativeInputFile, (File)sourceFolder);
        this.generateTestsForSuccessCode(it2, true, importManager, relativeInputFile, successCompilationComponents);
        this.generateTestsForFailureCode(it2, true, importManager, relativeInputFile, failureCompilationComponents);
        this.generateTestsForFacts(it2, importManager, absoluteInputFile, factualComponents);
        this.generateDynamicTests(it2, importManager, relativeInputFile, specificComponents);
        it2.decreaseIndentation().newLine().append((CharSequence)"}").newLine();
        File packagePath = relativeInputFile.getParentFile();
        String packageName = GenerateTestsMojo.toPackageName("docs", packagePath);
        GenerateTestsMojo.write(outputFolder, packageName, generalTestName, importManager, it2);
    }

    private void generateTestsForSuccessCode(ITreeAppendable parent, boolean isDeprecationasError, ImportManager importManager, File inputFile, List<ValidationComponent> successCompilationComponents) {
        int i = 0;
        for (ValidationComponent component : successCompilationComponents) {
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateTestsMojo_1, inputFile.getName(), component.getLinenoInSourceFile(), component.getCode()));
            String actionName = GenerateTestsMojo.toActionName("success", component, i);
            String displayName = GenerateTestsMojo.toTestDisplayName(Messages.GenerateTestsMojo_7, i, component);
            LocationData location = new LocationData(component.getOffsetInSourceFile(), component.getLengthInSourceFile(), component.getLinenoInSourceFile(), component.getEndLinenoInSourceFile(), null);
            ITreeAppendable it = parent.trace((ILocationData)location);
            it.append((CharSequence)"@").append(Test.class).newLine();
            it.append((CharSequence)"@").append(DisplayName.class).append((CharSequence)"(\"").append((CharSequence)displayName).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"success\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"success_").append((CharSequence)Integer.toString(i)).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"public void ").append((CharSequence)actionName).append((CharSequence)"() throws ").append(Exception.class).append((CharSequence)" {").increaseIndentation().newLine();
            it.append(ScriptExecutor.class).append((CharSequence)" scriptExecutor = getScriptExecutor();").newLine();
            boolean deprecationError = isDeprecationasError;
            Boolean componentDeprecationError = component.isDeprecationIssuesAsErrors();
            if (componentDeprecationError != null) {
                deprecationError = componentDeprecationError;
            }
            it.append((CharSequence)"scriptExecutor.setDeprecationAsError(").append((CharSequence)Boolean.toString(deprecationError)).append((CharSequence)");").newLine();
            it.append(List.class).append((CharSequence)"<String> issues = scriptExecutor.compile(").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)", \"").append((CharSequence)GenerateTestsMojo.str(component.getCode())).append((CharSequence)"\");").newLine();
            it.append((CharSequence)"assertNoIssue(").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)", issues);").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            ++i;
        }
    }

    private void generateTestsForFailureCode(ITreeAppendable parent, boolean isDeprecationasError, ImportManager importManager, File inputFile, List<ValidationComponent> failureCompilationComponents) {
        int i = 0;
        for (ValidationComponent component : failureCompilationComponents) {
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateTestsMojo_2, inputFile.getName(), component.getLinenoInSourceFile(), component.getCode()));
            String actionName = GenerateTestsMojo.toActionName("failure", component, i);
            String displayName = GenerateTestsMojo.toTestDisplayName(Messages.GenerateTestsMojo_8, i, component);
            LocationData location = new LocationData(component.getOffsetInSourceFile(), component.getLengthInSourceFile(), component.getLinenoInSourceFile(), component.getEndLinenoInSourceFile(), null);
            ITreeAppendable it = parent.trace((ILocationData)location);
            it.append((CharSequence)"@").append(Test.class).newLine();
            it.append((CharSequence)"@").append(DisplayName.class).append((CharSequence)"(\"").append((CharSequence)displayName).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"failure\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"failure_").append((CharSequence)Integer.toString(i)).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"public void ").append((CharSequence)actionName).append((CharSequence)"() throws ").append(Exception.class).append((CharSequence)" {").increaseIndentation().newLine();
            it.append(ScriptExecutor.class).append((CharSequence)" scriptExecutor = getScriptExecutor();").newLine();
            boolean deprecationError = isDeprecationasError;
            Boolean componentDeprecationError = component.isDeprecationIssuesAsErrors();
            if (componentDeprecationError != null) {
                deprecationError = componentDeprecationError;
            }
            it.append((CharSequence)"scriptExecutor.setDeprecationAsError(").append((CharSequence)Boolean.toString(deprecationError)).append((CharSequence)");").newLine();
            it.append(List.class).append((CharSequence)"<String> issues = scriptExecutor.compile(").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)", \"").append((CharSequence)GenerateTestsMojo.str(component.getCode())).append((CharSequence)"\");").newLine();
            it.append((CharSequence)"assertIssues(").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)", issues);").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            ++i;
        }
    }

    private void generateTestsForFacts(ITreeAppendable parent, ImportManager importManager, File absoluteInputFile, List<ValidationComponent> factualComponents) {
        int i = 0;
        for (ValidationComponent component : factualComponents) {
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateTestsMojo_3, absoluteInputFile.getName(), component.getLinenoInSourceFile(), component.getCode()));
            String actionName = GenerateTestsMojo.toActionName("fact", component, i);
            String displayName = GenerateTestsMojo.toTestDisplayName(Messages.GenerateTestsMojo_9, i, component);
            LocationData location = new LocationData(component.getOffsetInSourceFile(), component.getLengthInSourceFile(), component.getLinenoInSourceFile(), component.getEndLinenoInSourceFile(), null);
            ITreeAppendable it = parent.trace((ILocationData)location);
            it.append((CharSequence)"@").append(Test.class).newLine();
            it.append((CharSequence)"@").append(DisplayName.class).append((CharSequence)"(\"").append((CharSequence)displayName).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"fact\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"fact_").append((CharSequence)Integer.toString(i)).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"public void ").append((CharSequence)actionName).append((CharSequence)"() throws ").append(Exception.class).append((CharSequence)" {").increaseIndentation().newLine();
            it.append(System.class).append((CharSequence)".setProperty(").append(ScriptExecutor.class).append((CharSequence)".PROP_CURRENT_FILE, \"").append((CharSequence)Strings.convertToJavaString((String)absoluteInputFile.getAbsolutePath(), (boolean)false)).append((CharSequence)"\");").newLine();
            it.append(System.class).append((CharSequence)".setProperty(").append(ScriptExecutor.class).append((CharSequence)".PROP_CURRENT_FOLDER, \"").append((CharSequence)Strings.convertToJavaString((String)absoluteInputFile.getParentFile().getAbsolutePath(), (boolean)false)).append((CharSequence)"\");").newLine();
            it.append((CharSequence)"final String expected = ").append(Utils.class).append((CharSequence)".dump(").append(Boolean.class).append((CharSequence)".TRUE, false) + \"\\nOR\\nObject {\\n}\\n\";").newLine();
            it.append((CharSequence)"Object result;").newLine();
            it.append((CharSequence)"try {").increaseIndentation().newLine();
            it.append((CharSequence)"result = getScriptExecutor().execute(").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)", \"").append((CharSequence)GenerateTestsMojo.str(component.getCode())).append((CharSequence)"\");").decreaseIndentation().newLine();
            it.append((CharSequence)"} catch (").append(Throwable.class).append((CharSequence)" exception) {").increaseIndentation().newLine();
            it.append((CharSequence)"throw new ").append(AssertionFailedError.class).append((CharSequence)"(exception.getLocalizedMessage() + \" [line: ").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)"]\", expected, ").append(Throwables.class).append((CharSequence)".getStackTraceAsString(exception));").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            it.append((CharSequence)"if (result instanceof ").append(Boolean.class).append((CharSequence)" $c$value) {").increaseIndentation().newLine();
            it.append((CharSequence)"boolean boolResult = $c$value.booleanValue();").newLine();
            it.append((CharSequence)"if (!boolResult) {").increaseIndentation().newLine();
            it.append((CharSequence)"throw new ").append(AssertionFailedError.class).append((CharSequence)"(\"Invalid expression result [line: ").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)"]\", expected, ").append(Utils.class).append((CharSequence)".dump(result, false));").decreaseIndentation().newLine();
            it.append((CharSequence)"}").decreaseIndentation().newLine();
            it.append((CharSequence)"} else if (result == null || result instanceof ").append(Exception.class).append((CharSequence)") {").increaseIndentation().newLine();
            it.append((CharSequence)"throw new ").append(AssertionFailedError.class).append((CharSequence)"(\"Invalid expression result [line: ").append((CharSequence)GenerateTestsMojo.str(component.getLinenoInSourceFile())).append((CharSequence)"]\", expected, ").append(Utils.class).append((CharSequence)".dump(result, false));").decreaseIndentation().newLine();
            it.append((CharSequence)"}").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            ++i;
        }
    }

    private void generateDynamicTests(ITreeAppendable parent, ImportManager importManager, File inputFile, List<DynamicValidationComponent> specificComponents) {
        int i = 0;
        for (DynamicValidationComponent component : specificComponents) {
            this.getLog().debug((CharSequence)MessageFormat.format(Messages.GenerateTestsMojo_4, inputFile.getName(), component.functionName() + i));
            String actionName = GenerateTestsMojo.toActionName("dyn_" + component.functionName(), component, i);
            String displayName = GenerateTestsMojo.toTestDisplayName(Messages.GenerateTestsMojo_10, i, component);
            LocationData location = new LocationData(component.getOffsetInSourceFile(), component.getLengthInSourceFile(), component.getLinenoInSourceFile(), component.getEndLinenoInSourceFile(), null);
            ITreeAppendable it = parent.trace((ILocationData)location);
            it.append((CharSequence)"@").append(Test.class).newLine();
            it.append((CharSequence)"@").append(DisplayName.class).append((CharSequence)"(\"").append((CharSequence)displayName).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"other\")").newLine();
            it.append((CharSequence)"@").append(Tag.class).append((CharSequence)"(\"other_").append((CharSequence)Integer.toString(i)).append((CharSequence)"\")").newLine();
            it.append((CharSequence)"public void ").append((CharSequence)actionName).append((CharSequence)"() throws ").append(Exception.class).append((CharSequence)" {").increaseIndentation().newLine();
            component.generateValidationCode(it);
            it.decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            ++i;
        }
    }

    private void generateAbstractTest(File outputFolder) throws IOException {
        this.getLog().debug((CharSequence)Messages.GenerateTestsMojo_5);
        ImportManager importManager = new ImportManager();
        FakeTreeAppendable it = new FakeTreeAppendable(importManager);
        it.append((CharSequence)"@").append(SuppressWarnings.class).append((CharSequence)"(\"all\")").newLine();
        it.append((CharSequence)"public class AbstractBaseTest {").increaseIndentation().newLine();
        it.append((CharSequence)"protected static String STR_SUCCESS = \"success\";").newLine();
        it.append((CharSequence)"protected static String STR_FAILURE = \"failure\";").newLine();
        it.append((CharSequence)"protected static String STR_FACT = \"fact\";").newLine();
        it.append((CharSequence)"private static ").append(Injector.class).append((CharSequence)" injector = ").append(DocumentationSetup.class).append((CharSequence)".doSetup();").newLine();
        it.append((CharSequence)"private ").append(ScriptExecutor.class).append((CharSequence)" scriptExecutor;").newLine();
        it.append((CharSequence)"protected ").append(ScriptExecutor.class).append((CharSequence)" getScriptExecutor() {").increaseIndentation().newLine();
        it.append((CharSequence)"if (this.scriptExecutor == null) {").increaseIndentation().newLine();
        it.append((CharSequence)"this.scriptExecutor = this.injector.getInstance(").append(ScriptExecutor.class).append((CharSequence)".class);").newLine();
        StringBuilder cp = new StringBuilder();
        for (File file : this.getClassPath()) {
            if (cp.length() > 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(file.getAbsolutePath());
        }
        it.append((CharSequence)"scriptExecutor.setClassPath(\"").append((CharSequence)GenerateTestsMojo.str(cp)).append((CharSequence)"\");").newLine();
        StringBuilder mp = new StringBuilder();
        for (File mpElement : this.getModulePath()) {
            if (mp.length() > 0) {
                mp.append(File.pathSeparator);
            }
            mp.append(mpElement.getAbsolutePath());
        }
        it.append((CharSequence)"scriptExecutor.setModulePath(\"").append((CharSequence)GenerateTestsMojo.str(mp)).append((CharSequence)"\");").newLine();
        String string = this.getBootClassPath();
        if (!Strings.isEmpty((String)string)) {
            it.append((CharSequence)"scriptExecutor.setBootClassPath(\"").append((CharSequence)GenerateTestsMojo.str(string)).append((CharSequence)"\");").newLine();
        }
        JavaVersion version = null;
        if (!Strings.isEmpty((String)this.source)) {
            try {
                version = JavaVersion.fromQualifier((String)this.source);
            }
            catch (Throwable exception) {
                version = null;
            }
        }
        if (version == null) {
            try {
                version = JavaVersion.fromQualifier((String)"21");
            }
            catch (Throwable exception) {
                version = null;
            }
        }
        if (version == null) {
            throw new IllegalStateException("unknown Java version");
        }
        it.append((CharSequence)"scriptExecutor.setJavaSourceVersion(\"").append((CharSequence)version.getQualifier()).append((CharSequence)"\");").newLine();
        it.append((CharSequence)"scriptExecutor.setTempFolder(new ").append(File.class).append((CharSequence)"(\"").append((CharSequence)GenerateTestsMojo.str(this.tempDirectory.getAbsolutePath())).append((CharSequence)"\"));").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"return this.scriptExecutor;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public void assertNoIssue(int lineno, ").append(List.class).append((CharSequence)"<String> issues) {").increaseIndentation().newLine();
        it.append((CharSequence)"if (issues != null && !issues.isEmpty()) {").increaseIndentation().newLine();
        it.append(StringBuilder.class).append((CharSequence)" msg = new ").append(StringBuilder.class).append((CharSequence)"();").newLine();
        it.append((CharSequence)"for (String message : issues) {").increaseIndentation().newLine();
        it.append((CharSequence)"msg.append(message).append(\"\\n\");").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"throw new ").append(AssertionFailedError.class).append((CharSequence)"(\"Expecting no issue but find one [line:\" + lineno + \"]\\n\" + msg, \"\", msg.toString());").decreaseIndentation().newLine();
        it.append((CharSequence)"}").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public void assertIssues(int lineno, ").append(List.class).append((CharSequence)"<String> issues) {").increaseIndentation().newLine();
        it.append((CharSequence)"if (issues == null || issues.isEmpty()) {").increaseIndentation().newLine();
        it.append(Assertions.class).append((CharSequence)".fail(\"Expecting issues but did not find one [line:\" + lineno + \"]\");").decreaseIndentation().newLine();
        it.append((CharSequence)"}").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public String computeHeaderIdWithSectionNumber(String header) {").increaseIndentation().newLine();
        it.append((CharSequence)"String id = header.replaceAll(\"[^a-zA-Z0-9]+\", \"-\");").newLine();
        it.append((CharSequence)"id = id.toLowerCase();").newLine();
        it.append((CharSequence)"id = id.replaceFirst(\"^[^a-zA-Z0-9]+\", \"\");").newLine();
        it.append((CharSequence)"id = id.replaceFirst(\"[^a-zA-Z0-9]+$\", \"\");").newLine();
        it.append((CharSequence)"if (").append(Strings.class).append((CharSequence)".isEmpty(id)) {").increaseIndentation().newLine();
        it.append((CharSequence)"return \"section\";").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"return id;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public String computeHeaderIdWithoutSectionNumber(String header) {").increaseIndentation().newLine();
        it.append((CharSequence)"String id = computeHeaderIdWithSectionNumber(header);").newLine();
        it.append((CharSequence)"id = id.replaceFirst(\"^[0-9.\\\\-]+\", \"\");").newLine();
        it.append((CharSequence)"return id;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public static String getHttpCodeExplanation(int code) {").increaseIndentation().newLine();
        it.append((CharSequence)"switch (code) {").increaseIndentation().newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_BAD_METHOD: return \"Method Not Allowed\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_CREATED: return \"Created\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_ACCEPTED: return \"Accepted\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NOT_AUTHORITATIVE: return \"Non-Authoritative Information\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NO_CONTENT: return \"No Content\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_RESET: return \"Reset Content\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_PARTIAL: return \"Partial Content\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_MULT_CHOICE: return \"Multiple Choices\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_MOVED_PERM: return \"Moved Permanently\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_MOVED_TEMP: return \"Temporary Redirect\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_SEE_OTHER: return \"See Other\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NOT_MODIFIED: return \"Not Modified\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_USE_PROXY: return \"Use Proxy\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_BAD_REQUEST: return \"Bad Request\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_UNAUTHORIZED: return \"Unauthorized\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_PAYMENT_REQUIRED: return \"Payment Required\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_FORBIDDEN: return \"Forbidden\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NOT_FOUND: return \"Not Found\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NOT_ACCEPTABLE: return \"Not Acceptable\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_PROXY_AUTH: return \"Proxy Authentication Required\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_CLIENT_TIMEOUT: return \"Request Time-Out\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_CONFLICT: return \"Conflict\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_GONE: return \"Gone\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_LENGTH_REQUIRED: return \"Length Required\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_PRECON_FAILED: return \"Precondition Failed\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_ENTITY_TOO_LARGE: return \"Request Entity Too Large\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_REQ_TOO_LONG: return \"Request-URI Too Large\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_UNSUPPORTED_TYPE: return \"Unsupported Media Type\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_INTERNAL_ERROR: return \"Internal Server Error\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_NOT_IMPLEMENTED: return \"Not Implemented\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_BAD_GATEWAY: return \"Bad Gateway\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_UNAVAILABLE: return \"Service Unavailable\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_GATEWAY_TIMEOUT: return \"Gateway Timeout\";").newLine();
        it.append((CharSequence)"case ").append(HttpURLConnection.class).append((CharSequence)".HTTP_VERSION: return \"HTTP Version Not Supported\";").newLine();
        it.append((CharSequence)"default: return null;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public static boolean isAcceptableHttpCode(int code) {").increaseIndentation().newLine();
        it.append((CharSequence)"return code == ").append(HttpURLConnection.class).append((CharSequence)".HTTP_OK || code == ").append(HttpURLConnection.class).append((CharSequence)".HTTP_MOVED_TEMP;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"public static void assertURLAccessibility(int lineno, ").append(URL.class).append((CharSequence)" url) throws ").append(Exception.class).append((CharSequence)" {").increaseIndentation().newLine();
        it.append((CharSequence)"int code;").newLine();
        it.append(HttpURLConnection.class).append((CharSequence)".setFollowRedirects(false);").newLine();
        it.append(URLConnection.class).append((CharSequence)" connection = url.openConnection();").newLine();
        it.append(Assumptions.class).append((CharSequence)".assumeTrue(connection instanceof ").append(HttpURLConnection.class).append((CharSequence)", \"Not an UTL with http[s] protocol\");").newLine();
        it.append(HttpURLConnection.class).append((CharSequence)" httpConnection = (").append(HttpURLConnection.class).append((CharSequence)") connection;").newLine();
        it.append((CharSequence)"try {").increaseIndentation().newLine();
        it.append((CharSequence)"httpConnection.setInstanceFollowRedirects(false);").newLine();
        it.append((CharSequence)"httpConnection.setConnectTimeout(").append((CharSequence)GenerateTestsMojo.str(this.remoteLinkTimeOut)).append((CharSequence)");").newLine();
        it.append((CharSequence)"httpConnection.setReadTimeout(").append((CharSequence)GenerateTestsMojo.str(this.remoteLinkTimeOut)).append((CharSequence)");").newLine();
        it.append((CharSequence)"httpConnection.setAllowUserInteraction(false);").newLine();
        it.append((CharSequence)"httpConnection.setRequestMethod(\"HEAD\");").newLine();
        it.append((CharSequence)"httpConnection.connect();").newLine();
        it.append((CharSequence)"code = httpConnection.getResponseCode();").decreaseIndentation().newLine();
        it.append((CharSequence)"} catch (").append(IOException.class).append((CharSequence)" exception) {").increaseIndentation().newLine();
        it.append(Throwable.class).append((CharSequence)" rootCause = ").append(Throwables.class).append((CharSequence)".getRootCause(exception);").newLine();
        if (this.ignoreRemoteLinkTimeOut) {
            it.append((CharSequence)"if (rootCause instanceof ").append(SocketTimeoutException.class).append((CharSequence)") {").increaseIndentation().newLine();
            it.append((CharSequence)"throw new ").append(TestAbortedException.class).append((CharSequence)"(\"Connection time-out at line \" + lineno + \" when connecting to: \" + url.toExternalForm());").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
        }
        it.append((CharSequence)"throw new ").append(RuntimeException.class).append((CharSequence)"(\"Error at line \" + lineno + \" when connecting to: \" + url.toExternalForm(), rootCause);").decreaseIndentation().newLine();
        it.append((CharSequence)"} finally {").increaseIndentation().newLine();
        it.append((CharSequence)"httpConnection.disconnect();").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"if (isAcceptableHttpCode(code)) {").increaseIndentation().newLine();
        it.append((CharSequence)"return;").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        it.append((CharSequence)"String explanation = getHttpCodeExplanation(code);").newLine();
        it.append((CharSequence)"String codeMsg = !").append(Strings.class).append((CharSequence)".isEmpty(explanation) ? code + \"\\\"\" + explanation + \"\\\"\" : Integer.toString(code);").newLine();
        it.append(Assertions.class).append((CharSequence)".fail(\"Invalid response code \" + codeMsg + \" at line \" + lineno + \" when connecting to: \" + url.toExternalForm());").decreaseIndentation().newLine();
        it.append((CharSequence)"}").newLine();
        if (!this.session.isOffline() && !this.session.getRequest().getProxies().isEmpty()) {
            it.append((CharSequence)"private static boolean proxyNameMatches(String pattern, String name) {").increaseIndentation().newLine();
            it.append(Pattern.class).append((CharSequence)" pat = ").append(Pattern.class).append((CharSequence)".compile(pattern, ").append(Pattern.class).append((CharSequence)".CASE_INSENSITIVE);").newLine();
            it.append(Matcher.class).append((CharSequence)" mat = pat.matcher(name);").newLine();
            it.append((CharSequence)"return mat.matches();").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            it.append((CharSequence)"static {").increaseIndentation().newLine();
            it.append((CharSequence)"final ").append(ProxySelector.class).append((CharSequence)" defaultSelector = ").append(ProxySelector.class).append((CharSequence)".getDefault();").newLine();
            it.append(ProxySelector.class).append((CharSequence)" newSelector = new ").append(ProxySelector.class).append((CharSequence)"() {").increaseIndentation().newLine();
            it.append((CharSequence)"public ").append(List.class).append((CharSequence)"<").append(java.net.Proxy.class).append((CharSequence)"> select(").append(URI.class).append((CharSequence)" uri) {").increaseIndentation().newLine();
            it.append(List.class).append((CharSequence)"<").append(java.net.Proxy.class).append((CharSequence)"> proxies = new ").append(ArrayList.class).append((CharSequence)"(defaultSelector.select(uri));").newLine();
            for (Proxy proxy : this.session.getRequest().getProxies()) {
                it.append((CharSequence)"if (\"").append((CharSequence)GenerateTestsMojo.str(proxy.getProtocol())).append((CharSequence)"\".equals(uri.getScheme())) {").increaseIndentation().newLine();
                String nonProxyHosts = proxy.getNonProxyHosts();
                boolean hasProxy = false;
                if (!Strings.isEmpty((String)nonProxyHosts) && nonProxyHosts != null) {
                    hasProxy = true;
                    it.append((CharSequence)"if (");
                    StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
                    boolean first = true;
                    while (tokenizer.hasMoreTokens()) {
                        String pattern = tokenizer.nextToken();
                        pattern = pattern.replace(".", "\\.").replace("*", ".*");
                        if (first) {
                            first = false;
                        } else {
                            it.newLine().append((CharSequence)" && ");
                        }
                        it.append((CharSequence)"!proxyNameMatches(\"^").append((CharSequence)Strings.convertToJavaString((String)pattern));
                        it.append((CharSequence)"$\", uri.getHost())");
                    }
                    it.append((CharSequence)") {");
                    it.increaseIndentation().newLine();
                }
                it.append((CharSequence)"proxies.add(new ").append(java.net.Proxy.class).append((CharSequence)"(").append(Proxy.Type.class).append((CharSequence)".HTTP, new ").append(InetSocketAddress.class).append((CharSequence)"(\"").append((CharSequence)GenerateTestsMojo.str(proxy.getHost())).append((CharSequence)"\", ").append((CharSequence)GenerateTestsMojo.str(proxy.getPort())).append((CharSequence)")));");
                if (hasProxy) {
                    it.decreaseIndentation().newLine();
                    it.append((CharSequence)"}");
                }
                it.decreaseIndentation().newLine();
                it.append((CharSequence)"}");
            }
            it.newLine().append((CharSequence)"return ").append(Collections.class).append((CharSequence)".unmodifiableList(proxies);").decreaseIndentation().newLine();
            it.append((CharSequence)"}").newLine();
            it.append((CharSequence)"public void connectFailed(").append(URI.class).append((CharSequence)" uri, ").append(SocketAddress.class).append((CharSequence)" sa, ").append(IOException.class).append((CharSequence)" ioe) {").increaseIndentation().newLine();
            it.append((CharSequence)"throw new ").append(RuntimeException.class).append((CharSequence)"(ioe);").decreaseIndentation().newLine();
            it.append((CharSequence)"}").decreaseIndentation().newLine();
            it.append((CharSequence)"};").newLine();
            it.append(ProxySelector.class).append((CharSequence)".setDefault(newSelector);").decreaseIndentation().newLine();
            it.append((CharSequence)"}");
        }
        it.decreaseIndentation().newLine().append((CharSequence)"}").newLine();
        GenerateTestsMojo.write(outputFolder, BASE_PACKAGE, "AbstractBaseTest", importManager, (ITreeAppendable)it);
    }

    private static File getOutputFolder(File root, String packageName) {
        File relativeFolder = GenerateTestsMojo.toPackageFolder(packageName);
        return FileSystem.join((File)root, (File[])new File[]{relativeFolder});
    }

    protected static File getOutputJavaFilename(File folderName, String typeName) {
        return new File(folderName, typeName + ".java");
    }

    protected static File getOutputTraceFilename(File folderName, String typeName) {
        return new File(folderName, typeName + ".java._trace");
    }

    private static void write(File root, String packageName, String typeName, ImportManager importManager, ITreeAppendable it) throws IOException {
        File outputFile = GenerateTestsMojo.getOutputFolder(root, packageName);
        outputFile.mkdirs();
        outputFile = GenerateTestsMojo.getOutputJavaFilename(outputFile, typeName);
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write("/* This file was automatically generated. Do not change its content. */\n\n");
            writer.write("package ");
            writer.write(packageName);
            writer.write(";\n");
            for (String importedType : importManager.getImports()) {
                writer.write("import ");
                writer.write(importedType);
                writer.write(";\n");
            }
            writer.write(it.getContent());
            writer.flush();
        }
    }

    private static String toTestName(File inputFile) {
        return Strings.toFirstUpper((String)FileSystem.shortBasename((File)inputFile).replaceAll("[^a-zA-Z0-9]+", ""));
    }

    private static String toActionName(String name, ValidationComponent component, int index) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(name).append("_").append(index).append("_");
        fullName.append(component.getLinenoInSourceFile()).append("_to_");
        fullName.append(component.getEndLinenoInSourceFile());
        return fullName.toString();
    }

    private static String toTestDisplayName(String name, int index, ValidationComponent component) {
        String nm;
        if (Strings.isEmpty((String)name)) {
            if (component instanceof DynamicValidationComponent) {
                DynamicValidationComponent cvalue = (DynamicValidationComponent)component;
                nm = cvalue.functionName();
            } else {
                nm = component.getSourceFile().getName();
            }
        } else {
            nm = name;
        }
        String filename = component.getSourceFile() != null ? component.getSourceFile().getName() : "?";
        return GenerateTestsMojo.str(MessageFormat.format(nm, index, filename, component.getLinenoInSourceFile()));
    }

    private static String toClassDisplayName(File inputFile, String basicTestName, String generalTestName) {
        return GenerateTestsMojo.str(MessageFormat.format(Messages.GenerateTestsMojo_12, inputFile.getName(), basicTestName, generalTestName, inputFile.getParentFile().getPath()));
    }

    private static String str(Object obj) {
        if (obj == null) {
            return "";
        }
        return Strings.convertToJavaString((String)obj.toString());
    }
}

