/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator;

import com.google.common.base.Throwables;
import io.sarl.docs.generator.AbstractDocumentationMojo;
import io.sarl.docs.generator.MavenJulHandler;
import io.sarl.docs.generator.Messages;
import io.sarl.docs.validator.DocumentationLogger;
import io.sarl.docs.validator.ShellCommandProvider;
import io.sarl.docs.validator.ShellExtensions;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.xtext.util.Strings;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class InitializeMojo
extends AbstractDocumentationMojo {
    @Parameter
    private List<ShellCommand> shellCommands;

    @Override
    protected String getSkippingMessage() {
        return null;
    }

    @Override
    protected String internalExecute() {
        try {
            DocumentationLogger.initializeLogger((Handler)new MavenJulHandler(this.getLog()));
            for (String sourceFolder : this.inferredSourceDirectories) {
                this.addSourceFolder(sourceFolder);
            }
            this.addTestSourceFolder(this.testSourceDirectory);
            this.registerShellCommands();
        }
        catch (Throwable exception) {
            String message = Throwables.getRootCause((Throwable)exception).getLocalizedMessage();
            this.getLog().error((CharSequence)message);
            this.getLog().debug(exception);
            return message;
        }
        return null;
    }

    protected void registerShellCommands() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Shell commands = " + String.valueOf(this.shellCommands)));
        if (this.shellCommands != null) {
            ShellCommandProvider provider = (ShellCommandProvider)this.injector.getInstance(ShellCommandProvider.class);
            if (provider == null) {
                throw new MojoExecutionException("No shell command provider defined in the mojo source code");
            }
            for (ShellCommand command : this.shellCommands) {
                if (this.registerShellCommand(command, provider)) continue;
                throw new MojoExecutionException("Artifact not found: " + command.toString());
            }
            ShellExtensions.shellCommandProvider = provider;
        }
    }

    private boolean registerShellCommand(ShellCommand command, ShellCommandProvider provider) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Register shell command: " + String.valueOf(command)));
        Dependency dep = this.findDependency(command.getGroupId(), command.getArtifactId(), command.getType());
        this.getLog().debug((CharSequence)("Associated dependency: " + String.valueOf(dep)));
        if (dep != null) {
            Set<Artifact> artifacts = this.resolve(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType());
            for (Artifact artifact : artifacts) {
                if (!Strings.equal((String)command.getGroupId(), (String)artifact.getGroupId()) || !Strings.equal((String)command.getArtifactId(), (String)artifact.getArtifactId()) || !Strings.equal((String)command.getType(), (String)artifact.getType())) continue;
                this.getLog().debug((CharSequence)("Artifact candidate: " + String.valueOf(artifact)));
                File artifactFile = artifact.getFile();
                this.getLog().debug((CharSequence)("Artifact file: " + String.valueOf(artifactFile)));
                if (artifactFile == null) continue;
                this.getLog().info((CharSequence)("Register shell command '" + command.getName() + "': " + String.valueOf(artifactFile)));
                provider.register(command.getName(), artifactFile);
                if (!artifactFile.canExecute()) {
                    this.getLog().info((CharSequence)("Force execution flag for: " + String.valueOf(artifactFile)));
                    artifactFile.setExecutable(true);
                }
                return true;
            }
        }
        return false;
    }

    protected Dependency findDependency(String groupId, String artifactId, String type) {
        for (Dependency dep : this.session.getCurrentProject().getDependencies()) {
            if (!Strings.equal((String)groupId, (String)dep.getGroupId()) || !Strings.equal((String)artifactId, (String)dep.getArtifactId()) || !Strings.equal((String)type, (String)dep.getType())) continue;
            return dep;
        }
        return null;
    }

    protected void addSourceFolder(String path) {
        List existingFolders1 = this.project.getCompileSourceRoots();
        List existingFolders2 = this.project.getTestCompileSourceRoots();
        if (!existingFolders1.contains(path) && !existingFolders2.contains(path)) {
            this.getLog().info((CharSequence)MessageFormat.format(Messages.InitializeMojo_0, path));
            this.session.getCurrentProject().addCompileSourceRoot(path);
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(Messages.InitializeMojo_1, path));
        }
    }

    protected void addSourceFolder(File path) {
        this.addSourceFolder(path.getAbsolutePath());
    }

    protected void addTestSourceFolder(String path) {
        List existingFolders1 = this.project.getCompileSourceRoots();
        List existingFolders2 = this.project.getTestCompileSourceRoots();
        if (!existingFolders1.contains(path) && !existingFolders2.contains(path)) {
            this.getLog().info((CharSequence)MessageFormat.format(Messages.InitializeMojo_2, path));
            this.session.getCurrentProject().addTestCompileSourceRoot(path);
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(Messages.InitializeMojo_3, path));
        }
    }

    protected void addTestSourceFolder(File path) {
        this.addTestSourceFolder(path.getAbsolutePath());
    }

    public static class ShellCommand {
        private String name;
        private String groupId;
        private String artifactId;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String id) {
            this.groupId = id;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String id) {
            this.artifactId = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(this.getGroupId()).append(":");
            str.append(this.getArtifactId()).append(":");
            str.append(this.getType()).append(":");
            str.append(this.getName());
            return str.toString();
        }
    }
}

