/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

class TraceableTreeAppendable
extends StringBuilderBasedAppendable
implements ITreeAppendable {
    private final List<TraceableTreeAppendable> children = new ArrayList<TraceableTreeAppendable>();
    private ILocationData location;
    private boolean useForDebugging = true;
    private WeakReference<TraceableTreeAppendable> parent;

    TraceableTreeAppendable() {
    }

    TraceableTreeAppendable(ImportManager importManager) {
        super(importManager);
    }

    protected TraceableTreeAppendable(TraceableTreeAppendable parent, boolean useForDebugging, ILocationData location) {
        super(parent.getImportManager());
        this.parent = new WeakReference<TraceableTreeAppendable>(parent);
        this.location = location;
        this.useForDebugging = useForDebugging;
    }

    private TraceableTreeAppendable getParent() {
        return this.parent == null ? null : (TraceableTreeAppendable)((Object)this.parent.get());
    }

    public String toString() {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            return p.toString();
        }
        return super.toString();
    }

    public ITreeAppendable append(JvmType type) {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.append(type);
        } else {
            super.append(type);
        }
        return this;
    }

    public ITreeAppendable append(Class<?> type) {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.append(type);
        } else {
            super.append(type);
        }
        return this;
    }

    public ITreeAppendable append(CharSequence string) {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.append(string);
        } else {
            super.append(string);
        }
        return this;
    }

    public ITreeAppendable append(LightweightTypeReference typeRef) {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.append(typeRef);
        } else {
            super.append(typeRef);
        }
        return this;
    }

    public ITreeAppendable decreaseIndentation() {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.decreaseIndentation();
        } else {
            super.decreaseIndentation();
        }
        return this;
    }

    public ITreeAppendable increaseIndentation() {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.increaseIndentation();
        } else {
            super.increaseIndentation();
        }
        return this;
    }

    public ITreeAppendable newLine() {
        TraceableTreeAppendable p = this.getParent();
        if (p != null) {
            p.newLine();
        } else {
            super.newLine();
        }
        return this;
    }

    public AbstractTraceRegion getTraceRegion() {
        if (this.location == null) {
            throw new IllegalStateException("appendable was used without tracing");
        }
        return new AppendableBasedTraceRegion(this);
    }

    private void getTraceRegions(List<AbstractTraceRegion> regions) {
        if (this.location != null) {
            regions.add(this.getTraceRegion());
        }
        for (TraceableTreeAppendable child : this.children) {
            child.getTraceRegions(regions);
        }
    }

    public List<AbstractTraceRegion> getTraceRegions() {
        ArrayList<AbstractTraceRegion> regions = new ArrayList<AbstractTraceRegion>();
        this.getTraceRegions(regions);
        return regions;
    }

    public List<? extends ITreeAppendable> getChildren() {
        return this.children;
    }

    public ITreeAppendable trace(ILocationData location) {
        return this.trace(location, this.useForDebugging);
    }

    public ITreeAppendable trace(ILocationData location, boolean useForDebugging) {
        if (useForDebugging) {
            TraceableTreeAppendable child = new TraceableTreeAppendable(this, useForDebugging, location);
            this.children.add(child);
            return child;
        }
        return this;
    }

    public ITreeAppendable trace(EObject object, boolean useForDebugging) {
        throw new UnsupportedOperationException();
    }

    public ITreeAppendable trace(Iterable<? extends EObject> objects) {
        throw new UnsupportedOperationException();
    }

    public ITreeAppendable trace(EObject object, EStructuralFeature feature, int indexInList) {
        throw new UnsupportedOperationException();
    }

    public ITreeAppendable trace(EObject object) {
        throw new UnsupportedOperationException();
    }

    public ErrorTreeAppendable errorChild() {
        throw new UnsupportedOperationException();
    }

    protected static class AppendableBasedTraceRegion
    extends AbstractTraceRegion {
        private final int offset;
        private final int lineNumber;
        private final int length;
        private final int endLineNumber;
        private final boolean useForDebugging;
        private final ILocationData location;

        public AppendableBasedTraceRegion(TraceableTreeAppendable delegate) {
            super(null);
            this.location = delegate.location;
            this.offset = this.location.getOffset();
            this.length = this.location.getLength();
            this.lineNumber = this.location.getLineNumber();
            this.endLineNumber = this.location.getEndLineNumber();
            this.useForDebugging = delegate.useForDebugging;
        }

        public boolean isUseForDebugging() {
            return this.useForDebugging;
        }

        public int getMyLength() {
            return this.length;
        }

        public int getMyOffset() {
            return this.offset;
        }

        public int getMyLineNumber() {
            return this.lineNumber;
        }

        public int getMyEndLineNumber() {
            return this.endLineNumber;
        }

        public List<ILocationData> getAssociatedLocations() {
            return Collections.singletonList(this.location);
        }

        public AppendableBasedTraceRegion getRoot() {
            return (AppendableBasedTraceRegion)super.getRoot();
        }
    }
}

