/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.bugfixes;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.URISchemeType;
import org.eclipse.xtext.xbase.lib.Pure;

public final class FileSystemAddons {
    private FileSystemAddons() {
    }

    @Pure
    public static URL convertFileToURL(File file, boolean allowRelativePath) {
        if (file == null) {
            return null;
        }
        try {
            URL url;
            File thefile = file;
            if (FileSystem.isWindowsNativeFilename((String)file.toString()) && (thefile = FileSystem.normalizeWindowsNativeFilename((String)file.toString())) == null) {
                thefile = file;
            }
            if (thefile.isAbsolute() || !allowRelativePath) {
                url = thefile.toURI().toURL();
            } else {
                String[] elements = FileSystem.split((File)thefile);
                StringBuilder path = new StringBuilder();
                for (String element : elements) {
                    if (path.length() > 0) {
                        path.append("/");
                    }
                    path.append(element);
                }
                path.insert(0, ':');
                path.insert(0, URISchemeType.FILE.name().toLowerCase());
                url = URI.create(path.toString()).toURL();
            }
            return FileSystem.toShortestURL((URL)url);
        }
        catch (Exception e) {
            return null;
        }
    }
}

