/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.markdown;

import com.google.common.collect.Iterables;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import io.sarl.docs.generator.bugfixes.FileSystemAddons;
import io.sarl.docs.generator.markdown.Messages;
import io.sarl.docs.generator.parser.AbstractMarkerLanguageParser;
import io.sarl.docs.generator.parser.DynamicValidationComponent;
import io.sarl.docs.generator.parser.DynamicValidationContext;
import io.sarl.docs.generator.parser.SarlDocumentationParser;
import io.sarl.docs.generator.parser.SectionNumber;
import io.sarl.docs.validator.ReflectExtensions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.URISchemeType;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.NodeVisitor;

public class MarkdownParser
extends AbstractMarkerLanguageParser {
    public static final String[] MARKDOWN_FILE_EXTENSIONS = new String[]{".md", ".markdown", ".mdown", ".mkdn", ".mkd", ".mdwn", ".mdtxt", ".mdtext"};
    public static final int DEFAULT_OUTLINE_TOP_LEVEL = 2;
    public static final boolean DEFAULT_SECTION_NUMBERING = true;
    public static final boolean DEFAULT_ADD_LINK_TO_OPERATION_NAME = true;
    public static final String DEFAULT_OUTLINE_STYLE_ID = "page_outline";
    public static final String DEFAULT_SECTION_TITLE_FORMAT = "{0} {1}. {2}";
    public static final String DEFAULT_OUTLINE_ENTRY_WO_AUTONUMBERING = "{0} [{1}](#{2})";
    public static final String DEFAULT_OUTLINE_ENTRY_W_AUTONUMBERING = "{0} [{1}. {2}](#{3})";
    public static final String INFO_NOTE_PATTERN_PROPERTY = "io.sarl.maven.docs.generator.infonote";
    public static final String WARNING_NOTE_PATTERN_PROPERTY = "io.sarl.maven.docs.generator.warningnote";
    public static final String DANGER_NOTE_PATTERN_PROPERTY = "io.sarl.maven.docs.generator.dangernote";
    private static final String MARKDOWN_INFORMATION_NOTE_PATTERN1 = "^\\>[ \t\n\r]*\\*\\*\\_(.*?):?\\_\\*\\*(.*)$";
    private static final String MARKDOWN_INFORMATION_NOTE_PATTERN2 = "^\\>(.*)$";
    private static final String SECTION_PATTERN_AUTONUMBERING = "^([#]+)\\s*([0-9]+(?:\\.[0-9]+)*\\.?)?\\s*(.*?)\\s*(?:\\{\\s*([a-z\\-]+)\\s*\\})?\\s*$";
    private static final String SECTION_PATTERN_NO_AUTONUMBERING = "^([#]+)\\s*(.*?)\\s*(?:\\{\\s*([a-z\\-]+)\\s*\\})?\\s*$";
    private static final String SECTION_PATTERN_TITLE_EXTRACTOR = "^(?:[#]+)\\s*((?:[0-9]+(?:\\.[0-9]+)*\\.?)?\\s*.*?\\s*(?:\\{\\s*([a-z\\-]+)\\s*\\})?)\\s*$";
    private static final String SECTION_PATTERN_TITLE_EXTRACTOR_WITHOUT_MD_PREFIX = "^\\s*([0-9]+(?:\\.[0-9]+)*\\.?)\\s*(.*?)$";
    private static final Set<String> WARNING_LABELS = new TreeSet<String>();
    private static final Set<String> DANGER_LABELS = new TreeSet<String>();
    private IntegerRange outlineDepthRange = new IntegerRange(2, 2);
    private boolean addLinkToOperationName = true;
    private boolean sectionNumbering = true;
    private String sectionTitleFormat = "{0} {1}. {2}";
    private String sectionNumberFormat = "{0}.{1}";
    private String outlineEntryWithNumberFormat = "{0} [{1}. {2}](#{3})";
    private String outlineEntryWithoutNumberFormat = "{0} [{1}](#{2})";
    private String outlineStyleId = "page_outline";
    private boolean localFileReferenceValidation = true;
    private boolean remoteReferenceValidation = true;
    private boolean localImageReferenceValidation = true;
    private boolean transformMdToHtmlReferences = true;
    private boolean transformPureHtmlReferences = true;
    private boolean generateOutline = true;
    private String externalOutlineMarker;
    private boolean kramdown;

    @Override
    @Inject
    public void setDocumentParser(SarlDocumentationParser parser) {
        super.setDocumentParser(parser);
        this.updateBlockFormatter();
    }

    @Override
    public void setGithubExtensionEnable(boolean enable) {
        super.setGithubExtensionEnable(enable);
        this.updateBlockFormatter();
    }

    private void updateBlockFormatter() {
        Functions.Function2<String, String, String> formatter = this.isGithubExtensionEnable() ? SarlDocumentationParser.getFencedCodeBlockFormatter() : SarlDocumentationParser.getBasicCodeBlockFormatter();
        this.getDocumentParser().setBlockCodeTemplate(formatter);
    }

    @Override
    public String extractPageTitle(String content) {
        Pattern sectionPattern = Pattern.compile(this.isAutoSectionNumbering() ? SECTION_PATTERN_AUTONUMBERING : SECTION_PATTERN_NO_AUTONUMBERING, 8);
        Matcher matcher = sectionPattern.matcher(content);
        IntegerRange depthRange = this.getOutlineDepthRange();
        int titleGroupId = this.isAutoSectionNumbering() ? 3 : 2;
        while (matcher.find()) {
            String title;
            String prefix = matcher.group(1);
            int clevel = prefix.length();
            if (clevel >= depthRange.getStart() || Strings.isEmpty((String)(title = matcher.group(titleGroupId)))) continue;
            return title;
        }
        return null;
    }

    public String getOutlineStyleId() {
        return this.outlineStyleId;
    }

    public void setOutlineStyleId(String id) {
        this.outlineStyleId = id;
    }

    public boolean isMarkdownToHtmlReferenceTransformation() {
        return this.transformMdToHtmlReferences;
    }

    public void setMarkdownToHtmlReferenceTransformation(boolean transform) {
        this.transformMdToHtmlReferences = transform;
    }

    public boolean isPureHtmlReferenceTransformation() {
        return this.transformPureHtmlReferences;
    }

    public void setPureHtmlReferenceTransformation(boolean transform) {
        this.transformPureHtmlReferences = transform;
    }

    public boolean isLocalFileReferenceValidation() {
        return this.localFileReferenceValidation;
    }

    public void setLocalFileReferenceValidation(boolean validate) {
        this.localFileReferenceValidation = validate;
    }

    public boolean isRemoteReferenceValidation() {
        return this.remoteReferenceValidation;
    }

    public void setRemoteReferenceValidation(boolean validate) {
        this.remoteReferenceValidation = validate;
    }

    public boolean isLocalImageReferenceValidation() {
        return this.localImageReferenceValidation;
    }

    public void setLocalImageReferenceValidation(boolean validate) {
        this.localImageReferenceValidation = validate;
    }

    public void setOutlineEntryFormat(String formatWithoutNumbers, String formatWithNumbers) {
        if (!Strings.isEmpty((String)formatWithoutNumbers)) {
            this.outlineEntryWithoutNumberFormat = formatWithoutNumbers;
        }
        if (!Strings.isEmpty((String)formatWithNumbers)) {
            this.outlineEntryWithNumberFormat = formatWithNumbers;
        }
    }

    public String getOutlineEntryFormat() {
        return this.isAutoSectionNumbering() ? this.outlineEntryWithNumberFormat : this.outlineEntryWithoutNumberFormat;
    }

    public void setSectionTitleFormat(String format) {
        if (!Strings.isEmpty((String)format)) {
            this.sectionTitleFormat = format;
        }
    }

    public String getSectionTitleFormat() {
        return this.sectionTitleFormat;
    }

    public void setSectionNumberFormat(String format) {
        if (!Strings.isEmpty((String)format)) {
            this.sectionNumberFormat = format;
        }
    }

    public String getSectionNumberFormat() {
        return this.sectionNumberFormat;
    }

    public void setOutlineGeneration(boolean enable) {
        this.generateOutline = enable;
    }

    public boolean isOutlineGeneration() {
        return this.generateOutline;
    }

    public void setOutlineExternalMarker(String marker) {
        this.externalOutlineMarker = marker;
    }

    public String getOutlineExternalMarker() {
        return this.externalOutlineMarker;
    }

    public void setKramdownFix(boolean enable) {
        this.kramdown = enable;
    }

    public boolean isKramdownFix() {
        return this.kramdown;
    }

    public void setOutlineDepthRange(IntegerRange level) {
        this.outlineDepthRange = level == null ? new IntegerRange(2, 2) : level;
    }

    public IntegerRange getOutlineDepthRange() {
        return this.outlineDepthRange;
    }

    public void setAutoSectionNumbering(boolean enable) {
        this.sectionNumbering = enable;
    }

    public boolean isAutoSectionNumbering() {
        return this.sectionNumbering;
    }

    public void setAddLinkToOperationName(boolean enable) {
        this.addLinkToOperationName = enable;
    }

    public boolean isAddLinkToOperationName() {
        return this.addLinkToOperationName;
    }

    protected URL findOperationLink(Method method) {
        return null;
    }

    @Override
    protected void preProcessingTransformation(CharSequence content, File inputFile, boolean validationOfInternalLinks) {
        Function<Method, String> formatter = null;
        if (this.isAddLinkToOperationName()) {
            formatter = it -> {
                URL url = this.findOperationLink((Method)it);
                if (url != null) {
                    StringBuilder name = new StringBuilder();
                    name.append("[").append(it.getName()).append("](");
                    name.append(url.toExternalForm()).append(")");
                    return name.toString();
                }
                return it.getName();
            };
        }
        ReflectExtensions.setDefaultMethodNameFormatter(formatter);
    }

    @Override
    protected String postProcessingTransformation(String content, boolean validationOfInternalLinks) {
        String result = this.updateOutline(content);
        AbstractMarkerLanguageParser.ReferenceContext references = validationOfInternalLinks ? this.extractReferencableElements(result) : null;
        result = this.transformMardownLinks(result, references);
        result = this.transformHtmlLinks(result, references);
        result = this.transformInformationNotes(result);
        return result;
    }

    protected String transformInformationNotes(String text) {
        String info = Strings.emptyIfNull((String)System.getProperty(INFO_NOTE_PATTERN_PROPERTY));
        String warning = Strings.emptyIfNull((String)System.getProperty(WARNING_NOTE_PATTERN_PROPERTY));
        String danger = Strings.emptyIfNull((String)System.getProperty(DANGER_NOTE_PATTERN_PROPERTY));
        if (Strings.isEmpty((String)info) && Strings.isEmpty((String)warning) && Strings.isEmpty((String)danger)) {
            return text;
        }
        Pattern startPattern = Pattern.compile(MARKDOWN_INFORMATION_NOTE_PATTERN1);
        Pattern continuePattern = Pattern.compile(MARKDOWN_INFORMATION_NOTE_PATTERN2);
        StringBuilder result = new StringBuilder();
        String currentName = null;
        StringBuilder currentNote = null;
        for (String line : text.split("\r*\n\r*")) {
            String newLine = null;
            if (currentName == null) {
                matcher = startPattern.matcher(line);
                if (matcher.matches()) {
                    currentName = matcher.group(1).trim();
                    currentNote = new StringBuilder(matcher.group(2).trim());
                } else {
                    currentNote = null;
                    newLine = line;
                }
            } else {
                matcher = continuePattern.matcher(line);
                if (matcher.matches()) {
                    assert (currentNote != null);
                    currentNote.append(" ").append(matcher.group(1).trim());
                } else {
                    MarkdownParser.updateBuffer(result, currentName, currentNote, info, warning, danger);
                    currentName = null;
                    currentNote = null;
                    newLine = line;
                }
            }
            MarkdownParser.updateBuffer(result, newLine);
        }
        MarkdownParser.updateBuffer(result, currentName, currentNote, info, warning, danger);
        return result.toString();
    }

    private static void updateBuffer(StringBuilder result, String name, StringBuilder note, String info, String warning, String danger) {
        if (!Strings.isEmpty((String)name) && note != null) {
            int type = MarkdownParser.parseType(name);
            switch (type) {
                case 0: {
                    if (!Strings.isEmpty((String)info)) {
                        String res = info.replaceAll(Pattern.quote("$1"), Matcher.quoteReplacement(name));
                        res = res.replaceAll(Pattern.quote("$2"), Matcher.quoteReplacement(note.toString()));
                        MarkdownParser.updateBuffer(result, res);
                        break;
                    }
                    MarkdownParser.updateBuffer(result, "> **_" + name + ":_** " + String.valueOf(note));
                    break;
                }
                case 1: {
                    if (!Strings.isEmpty((String)warning)) {
                        String res = warning.replaceAll(Pattern.quote("$1"), Matcher.quoteReplacement(name));
                        res = res.replaceAll(Pattern.quote("$2"), Matcher.quoteReplacement(note.toString()));
                        MarkdownParser.updateBuffer(result, res);
                        break;
                    }
                    MarkdownParser.updateBuffer(result, "> **_" + name + ":_** " + String.valueOf(note));
                    break;
                }
                case 2: {
                    if (!Strings.isEmpty((String)danger)) {
                        String res = danger.replaceAll(Pattern.quote("$1"), Matcher.quoteReplacement(name));
                        res = res.replaceAll(Pattern.quote("$2"), Matcher.quoteReplacement(note.toString()));
                        MarkdownParser.updateBuffer(result, res);
                        break;
                    }
                    MarkdownParser.updateBuffer(result, "> **_" + name + ":_** " + String.valueOf(note));
                    break;
                }
            }
        }
    }

    private static void updateBuffer(StringBuilder result, String line) {
        if (line != null) {
            result.append(line).append("\n");
        }
    }

    private static int parseType(String name) {
        String label = name.toLowerCase();
        if (WARNING_LABELS.contains(label)) {
            return 1;
        }
        if (DANGER_LABELS.contains(label)) {
            return 2;
        }
        return 0;
    }

    protected AbstractMarkerLanguageParser.ReferenceContext extractReferencableElements(String text) {
        AbstractMarkerLanguageParser.ReferenceContext context = new AbstractMarkerLanguageParser.ReferenceContext();
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        Document document = parser.parse(text);
        Pattern pattern = Pattern.compile(SECTION_PATTERN_AUTONUMBERING);
        com.vladsch.flexmark.util.ast.NodeVisitor visitor = new com.vladsch.flexmark.util.ast.NodeVisitor(new VisitHandler[]{new VisitHandler(Paragraph.class, it -> {
            BasedSequence paragraphText = it.getContentChars();
            Matcher matcher = pattern.matcher((CharSequence)paragraphText);
            if (matcher.find()) {
                String number = matcher.group(2);
                String title = matcher.group(3);
                String key1 = this.computeHeaderId(number, title);
                String key2 = this.computeHeaderId(null, title);
                context.registerSection(key1, key2, title);
            }
        })});
        visitor.visitChildren((Node)document);
        Pattern pattern1 = Pattern.compile(SECTION_PATTERN_TITLE_EXTRACTOR_WITHOUT_MD_PREFIX);
        visitor = new com.vladsch.flexmark.util.ast.NodeVisitor(new VisitHandler[]{new VisitHandler(Heading.class, it -> {
            String key = it.getAnchorRefId();
            String title = it.getText().toString();
            Matcher matcher = pattern1.matcher(title);
            if (matcher.find()) {
                String number = matcher.group(1);
                title = matcher.group(2);
                if (Strings.isEmpty((String)key)) {
                    key = this.computeHeaderId(number, title);
                }
            }
            String key2 = this.computeHeaderId(null, title);
            if (Strings.isEmpty((String)key)) {
                key = key2;
            }
            context.registerSection(key, key2, title);
        })});
        visitor.visitChildren((Node)document);
        return context;
    }

    protected String transformHtmlLinks(String content, final AbstractMarkerLanguageParser.ReferenceContext references) {
        if (!this.isPureHtmlReferenceTransformation()) {
            return content;
        }
        final TreeMap replacements = new TreeMap();
        NodeVisitor visitor = new NodeVisitor(){

            public void tail(org.jsoup.nodes.Node node, int depth) {
            }

            public void head(org.jsoup.nodes.Node node, int depth) {
                String href;
                Element tag;
                if (node instanceof Element && "a".equals((tag = (Element)node).nodeName()) && tag.hasAttr("href") && !Strings.isEmpty((String)(href = tag.attr("href")))) {
                    String newUrl;
                    URL url = FileSystem.convertStringToURL((String)href, (boolean)true);
                    if ((url = MarkdownParser.this.transformURL(url, -1, references)) != null && !Strings.isEmpty((String)(newUrl = MarkdownParser.convertURLToString(url))) && !Objects.equals(href, newUrl)) {
                        replacements.put(href, newUrl);
                    }
                }
            }
        };
        org.jsoup.nodes.Document htmlDocument = Jsoup.parse((String)content);
        htmlDocument.traverse(visitor);
        if (!replacements.isEmpty()) {
            String buffer = content;
            for (Map.Entry entry : replacements.entrySet()) {
                String source = (String)entry.getKey();
                String dest = (String)entry.getValue();
                buffer = buffer.replaceAll(Pattern.quote(source), Matcher.quoteReplacement(dest));
            }
            return buffer;
        }
        return content;
    }

    protected String transformMardownLinks(String content, AbstractMarkerLanguageParser.ReferenceContext references) {
        if (!this.isMarkdownToHtmlReferenceTransformation()) {
            return content;
        }
        TreeMap replacements = new TreeMap((cmp1, cmp2) -> {
            int cmp = Integer.compare(cmp2.getStartOffset(), cmp1.getStartOffset());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(cmp2.getEndOffset(), cmp1.getEndOffset());
        });
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        Document document = parser.parse(content);
        com.vladsch.flexmark.util.ast.NodeVisitor visitor = new com.vladsch.flexmark.util.ast.NodeVisitor(new VisitHandler[]{new VisitHandler(Link.class, it -> {
            URL url = FileSystem.convertStringToURL((String)it.getUrl().toString(), (boolean)true);
            if ((url = this.transformURL(url, it.getLineNumber(), references)) != null) {
                replacements.put(it.getUrl(), MarkdownParser.convertURLToString(url));
            }
        })});
        visitor.visitChildren((Node)document);
        if (!replacements.isEmpty()) {
            StringBuilder buffer = new StringBuilder(content);
            for (Map.Entry entry : replacements.entrySet()) {
                BasedSequence seq = (BasedSequence)entry.getKey();
                buffer.replace(seq.getStartOffset(), seq.getEndOffset(), (String)entry.getValue());
            }
            return buffer.toString();
        }
        return content;
    }

    static String convertURLToString(URL url) {
        if (URISchemeType.FILE.isURL(url)) {
            StringBuilder externalForm = new StringBuilder();
            externalForm.append(url.getPath());
            String ref = url.getRef();
            if (!Strings.isEmpty((String)ref)) {
                externalForm.append("#").append(ref);
            }
            return externalForm.toString();
        }
        return url.toExternalForm();
    }

    protected URL transformURL(URL link, int line, AbstractMarkerLanguageParser.ReferenceContext references) {
        if (URISchemeType.FILE.isURL(link)) {
            File filename = FileSystem.convertURLToFile((URL)link);
            if (Strings.isEmpty((String)filename.getName())) {
                String anchor = this.transformURLAnchor(filename, line, link.getRef(), references);
                URL url = FileSystemAddons.convertFileToURL(filename, true);
                if (!Strings.isEmpty((String)anchor)) {
                    try {
                        return new URI(url.toExternalForm() + "#" + anchor).toURL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return url;
            }
            String extension = FileSystem.extension((File)filename);
            if (MarkdownParser.isMarkdownFileExtension(extension)) {
                filename = FileSystem.replaceExtension((File)filename, (String)".html");
                String anchor = this.transformURLAnchor(filename, line, link.getRef(), null);
                URL url = FileSystemAddons.convertFileToURL(filename, true);
                if (!Strings.isEmpty((String)anchor)) {
                    try {
                        return new URI(url.toExternalForm() + "#" + anchor).toURL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return url;
            }
        }
        return null;
    }

    protected String transformURLAnchor(File file, int line, String anchor, AbstractMarkerLanguageParser.ReferenceContext references) {
        String anc = anchor;
        if (references != null) {
            anc = references.validateAnchor(anc, line);
        }
        return anc;
    }

    public static boolean isMarkdownFileExtension(String extension) {
        for (String ext : MARKDOWN_FILE_EXTENSIONS) {
            if (!Strings.equal((String)ext, (String)extension)) continue;
            return true;
        }
        return false;
    }

    protected String updateOutline(String content) {
        String newContent;
        int titleGroupId;
        SectionNumber sections;
        StringBuffer output;
        boolean styledOutline;
        Pattern sectionPattern = Pattern.compile(this.isAutoSectionNumbering() ? SECTION_PATTERN_AUTONUMBERING : SECTION_PATTERN_NO_AUTONUMBERING, 8);
        Matcher matcher = sectionPattern.matcher(content);
        TreeSet<Object> identifiers = new TreeSet<Object>();
        StringBuilder outline = new StringBuilder();
        outline.append("\n");
        String outlineStyleId = this.getOutlineStyleId();
        boolean bl = styledOutline = !Strings.isEmpty((String)outlineStyleId);
        if (styledOutline) {
            outline.append("<ul class=\"").append(Strings.convertToJavaString((String)outlineStyleId));
            outline.append("\" id=\"").append(Strings.convertToJavaString((String)outlineStyleId));
            outline.append("\">\n\n");
        }
        IntegerRange outlineDepthRange = this.getOutlineDepthRange();
        if (this.isAutoSectionNumbering()) {
            output = new StringBuffer();
            sections = new SectionNumber();
            titleGroupId = 3;
        } else {
            output = null;
            sections = null;
            titleGroupId = 2;
        }
        int prevLevel = 0;
        int nbOpened = 0;
        while (matcher.find()) {
            String prefix = matcher.group(1);
            int clevel = prefix.length();
            if (!outlineDepthRange.contains(clevel)) continue;
            int relLevel = clevel - outlineDepthRange.getStart();
            String title = matcher.group(titleGroupId);
            Object sectionId = matcher.group(titleGroupId + 1);
            if (output != null) {
                assert (sections != null);
                String sectionNumber = matcher.group(2);
                if (!Strings.isEmpty((String)sectionNumber)) {
                    sections.setFromString(sectionNumber, relLevel + 1);
                } else {
                    sections.increment(relLevel + 1);
                }
                sectionNumber = this.formatSectionNumber(sections);
                if (Strings.isEmpty((String)sectionId) && !identifiers.add(sectionId = this.computeHeaderId(sectionNumber, title))) {
                    int idNum = 1;
                    String nbId = (String)sectionId + "-" + idNum;
                    while (!identifiers.add(nbId)) {
                        nbId = (String)sectionId + "-" + ++idNum;
                    }
                    sectionId = nbId;
                }
                matcher.appendReplacement(output, this.formatSectionTitle(prefix, sectionNumber, title, (String)sectionId));
                if (styledOutline && (relLevel > 0 || prevLevel > 0) && relLevel != prevLevel) {
                    if (relLevel > prevLevel) {
                        for (i = prevLevel; i < relLevel; ++i) {
                            outline.append("<ul>\n");
                            ++nbOpened;
                        }
                    } else {
                        for (i = relLevel; i < prevLevel; ++i) {
                            outline.append("</ul>\n");
                            --nbOpened;
                        }
                    }
                }
                this.addOutlineEntry(outline, relLevel + 1, sectionNumber, title, (String)sectionId, styledOutline);
            } else {
                if (Strings.isEmpty((String)sectionId) && !identifiers.add(sectionId = this.computeHeaderId(null, title))) {
                    int idNum = 1;
                    String nbId = (String)sectionId + "-" + idNum;
                    while (!identifiers.add(nbId)) {
                        nbId = (String)sectionId + "-" + ++idNum;
                    }
                    sectionId = nbId;
                }
                this.addOutlineEntry(outline, relLevel + 1, null, title, (String)sectionId, styledOutline);
            }
            prevLevel = relLevel;
        }
        if (output != null) {
            matcher.appendTail(output);
            newContent = output.toString();
        } else {
            newContent = content;
        }
        outline.append("\n");
        if (styledOutline) {
            for (int i = 0; i <= nbOpened; ++i) {
                outline.append("</ul>\n");
            }
        }
        String outlineTag = this.getDocumentParser().getOutlineOutputTag();
        if (this.isOutlineGeneration()) {
            String externalMarker = this.getOutlineExternalMarker();
            if (!Strings.isEmpty((String)externalMarker)) {
                return newContent.replaceAll(Pattern.quote(outlineTag), Matcher.quoteReplacement(externalMarker));
            }
            return newContent.replaceAll(Pattern.quote(outlineTag), outline.toString());
        }
        return newContent.replaceAll(Pattern.quote(outlineTag), "");
    }

    public String computeHeaderId(String headerNumber, String headerText) {
        if (Strings.isEmpty((String)headerNumber)) {
            return MarkdownParser.computeHeaderIdForText(Strings.emptyIfNull((String)headerText));
        }
        String nb = this.computeHeaderIdForNumber(headerNumber);
        return nb + "-" + MarkdownParser.computeHeaderIdForText(Strings.emptyIfNull((String)headerText));
    }

    private String computeHeaderIdForNumber(String header) {
        String id = header;
        if (this.isKramdownFix()) {
            id = id.replaceAll("\\.", "");
        }
        id = id.replaceAll("[^a-zA-Z0-9]+", "-");
        id = id.toLowerCase();
        id = id.replaceFirst("^[^a-zA-Z0-9]+", "");
        if (Strings.isEmpty((String)(id = id.replaceFirst("[^a-zA-Z0-9]+$", "")))) {
            return "section";
        }
        return id;
    }

    private static String computeHeaderIdForText(String header) {
        String id = header.replaceAll("[^a-zA-Z0-9]+", "-");
        id = id.toLowerCase();
        id = id.replaceFirst("^[^a-zA-Z0-9]+", "");
        if (Strings.isEmpty((String)(id = id.replaceFirst("[^a-zA-Z0-9]+$", "")))) {
            return "section";
        }
        return id;
    }

    protected void addOutlineEntry(StringBuilder outline, int level, String sectionNumber, String title, String sectionId, boolean htmlOutput) {
        if (htmlOutput) {
            MarkdownParser.indent(outline, level - 1, "  ");
            outline.append("<li><a href=\"#");
            outline.append(sectionId);
            outline.append("\">");
            if (this.isAutoSectionNumbering() && !Strings.isEmpty((String)sectionNumber)) {
                outline.append(sectionNumber).append(". ");
            }
            outline.append(title);
            outline.append("</a></li>");
        } else {
            String prefix = "*";
            outline.append("> ");
            MarkdownParser.indent(outline, level - 1, "\t");
            String entry = this.isAutoSectionNumbering() ? MessageFormat.format(this.getOutlineEntryFormat(), "*", Strings.emptyIfNull((String)sectionNumber), title, sectionId) : MessageFormat.format(this.getOutlineEntryFormat(), "*", title, sectionId);
            outline.append(entry);
        }
        outline.append("\n");
    }

    protected String formatSectionNumber(SectionNumber numbers) {
        return numbers.toString(this.getSectionNumberFormat());
    }

    protected String formatSectionTitle(String prefix, String sectionNumber, String title, String sectionId) {
        return MessageFormat.format(this.getSectionTitleFormat(), prefix, sectionNumber, title, sectionId) + "\n";
    }

    protected static void indent(StringBuilder buffer, int number, String character) {
        for (int i = 0; i < number; ++i) {
            buffer.append(character);
        }
    }

    @Override
    protected List<DynamicValidationComponent> getSpecificValidationComponents(String text, File inputFile, File rootFolder, DynamicValidationContext context) {
        File cfile;
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        Document document = parser.parse(text);
        ArrayList<DynamicValidationComponent> validators = new ArrayList<DynamicValidationComponent>();
        try {
            cfile = FileSystem.makeRelative((File)inputFile, (File)rootFolder);
        }
        catch (IOException exception) {
            cfile = inputFile.getParentFile();
        }
        File currentFile = cfile;
        com.vladsch.flexmark.util.ast.NodeVisitor visitor = new com.vladsch.flexmark.util.ast.NodeVisitor(new VisitHandler[]{new VisitHandler(Link.class, it -> {
            Iterable<DynamicValidationComponent> components = this.createValidatorComponents((Link)it, currentFile, context);
            for (DynamicValidationComponent component : components) {
                validators.add(component);
            }
        }), new VisitHandler(Image.class, it -> {
            Iterable<DynamicValidationComponent> components = this.createValidatorComponents((Image)it, currentFile, context);
            for (DynamicValidationComponent component : components) {
                validators.add(component);
            }
        })});
        visitor.visitChildren((Node)document);
        return validators;
    }

    protected static int computeLineNo(Node node) {
        int offset = node.getStartOffset();
        BasedSequence seq = node.getDocument().getChars();
        int tmpOffset = seq.endOfLine(0);
        int lineno = 1;
        while (tmpOffset < offset) {
            ++lineno;
            tmpOffset = seq.endOfLineAnyEOL(tmpOffset + seq.eolStartLength(tmpOffset));
        }
        return lineno;
    }

    protected Iterable<DynamicValidationComponent> createValidatorComponents(Image it, File currentFile, DynamicValidationContext context) {
        ArrayList<DynamicValidationComponent> components = new ArrayList<DynamicValidationComponent>();
        if (this.isLocalImageReferenceValidation()) {
            DynamicValidationComponent component;
            int lineno = MarkdownParser.computeLineNo((Node)it);
            URL url = FileSystem.convertStringToURL((String)it.getUrl().toString(), (boolean)true);
            if (URISchemeType.FILE.isURL(url) && (component = this.createLocalImageValidatorComponent(it, url, lineno, currentFile, context)) != null) {
                components.add(component);
            }
        }
        return components;
    }

    protected Iterable<DynamicValidationComponent> createValidatorComponents(Link it, File currentFile, DynamicValidationContext context) {
        ArrayList<DynamicValidationComponent> components = new ArrayList<DynamicValidationComponent>();
        if (Strings.equal((String)":", (String)it.getUrl().toStringOrNull())) {
            return components;
        }
        if (this.isLocalFileReferenceValidation() || this.isRemoteReferenceValidation()) {
            Collection<DynamicValidationComponent> newComponents;
            int lineno = MarkdownParser.computeLineNo((Node)it);
            URL url = FileSystem.convertStringToURL((String)it.getUrl().toString(), (boolean)true);
            if (URISchemeType.HTTP.isURL(url) || URISchemeType.HTTPS.isURL(url) || URISchemeType.FTP.isURL(url)) {
                Collection<DynamicValidationComponent> newComponents2;
                if (this.isRemoteReferenceValidation() && (newComponents2 = this.createRemoteReferenceValidatorComponents(it, url, lineno, currentFile, context)) != null && !newComponents2.isEmpty()) {
                    components.addAll(newComponents2);
                }
            } else if (URISchemeType.FILE.isURL(url) && this.isLocalFileReferenceValidation() && (newComponents = this.createLocalFileValidatorComponents(it, url, lineno, currentFile, context)) != null && !newComponents.isEmpty()) {
                components.addAll(newComponents);
            }
        }
        return components;
    }

    protected DynamicValidationComponent createLocalImageValidatorComponent(Image it, URL url, final int lineno, File currentFile, final DynamicValidationContext context) {
        File fn = FileSystem.convertURLToFile((URL)url);
        if (!fn.isAbsolute()) {
            fn = FileSystem.join((File)currentFile.getParentFile(), (File[])new File[]{fn});
        }
        final File filename = fn;
        return new DynamicValidationComponent(this){

            @Override
            public String functionName() {
                return "Image_reference_test_" + lineno + "_";
            }

            @Override
            public void generateValidationCode(ITreeAppendable it) {
                context.appendFileExistenceTest(it, filename, Messages.MarkdownParser_0);
            }
        };
    }

    protected Collection<DynamicValidationComponent> createLocalFileValidatorComponents(Link it, final URL url, final int lineno, final File currentFile, final DynamicValidationContext context) {
        File filename;
        String extension;
        File fn = FileSystem.convertURLToFile((URL)url);
        if (Strings.isEmpty((String)fn.getName())) {
            String linkRef = url.getRef();
            if (!Strings.isEmpty((String)linkRef)) {
                return Arrays.asList(new DynamicValidationComponent(this){

                    @Override
                    public String functionName() {
                        return "Documentation_reference_anchor_test_" + lineno + "_";
                    }

                    @Override
                    public void generateValidationCode(ITreeAppendable it) {
                        context.setTempResourceRoots(null);
                        context.appendTitleAnchorExistenceTest(it, currentFile, url.getRef(), MarkdownParser.SECTION_PATTERN_TITLE_EXTRACTOR, Iterables.concat(Arrays.asList(MARKDOWN_FILE_EXTENSIONS), Arrays.asList(AbstractMarkerLanguageParser.HTML_FILE_EXTENSIONS)));
                    }
                });
            }
            return null;
        }
        if (!fn.isAbsolute()) {
            fn = FileSystem.join((File)currentFile.getParentFile(), (File[])new File[]{fn});
        }
        if (MarkdownParser.isMarkdownFileExtension(extension = FileSystem.extension((File)(filename = fn))) || MarkdownParser.isHtmlFileExtension(extension)) {
            DynamicValidationComponent existence = new DynamicValidationComponent(this){

                @Override
                public String functionName() {
                    return "Documentation_reference_test_" + lineno + "_";
                }

                @Override
                public void generateValidationCode(ITreeAppendable it) {
                    context.setTempResourceRoots(context.getSourceRoots());
                    context.appendFileExistenceTest(it, filename, Messages.MarkdownParser_1, Iterables.concat(Arrays.asList(MARKDOWN_FILE_EXTENSIONS), Arrays.asList(AbstractMarkerLanguageParser.HTML_FILE_EXTENSIONS)));
                }
            };
            if (!Strings.isEmpty((String)url.getRef())) {
                DynamicValidationComponent refValidity = new DynamicValidationComponent(this){

                    @Override
                    public String functionName() {
                        return "Documentation_reference_anchor_test_" + lineno + "_";
                    }

                    @Override
                    public void generateValidationCode(ITreeAppendable it) {
                        context.setTempResourceRoots(null);
                        context.appendTitleAnchorExistenceTest(it, filename, url.getRef(), MarkdownParser.SECTION_PATTERN_TITLE_EXTRACTOR, Iterables.concat(Arrays.asList(MARKDOWN_FILE_EXTENSIONS), Arrays.asList(AbstractMarkerLanguageParser.HTML_FILE_EXTENSIONS)));
                    }
                };
                return Arrays.asList(existence, refValidity);
            }
            return Collections.singleton(existence);
        }
        return Arrays.asList(new DynamicValidationComponent(this){

            @Override
            public String functionName() {
                return "File_reference_test_" + lineno + "_";
            }

            @Override
            public void generateValidationCode(ITreeAppendable it) {
                context.appendFileExistenceTest(it, filename, Messages.MarkdownParser_1);
            }
        });
    }

    protected Collection<DynamicValidationComponent> createRemoteReferenceValidatorComponents(Link it, final URL url, final int lineno, File currentFile, DynamicValidationContext context) {
        return Collections.singleton(new DynamicValidationComponent(this){

            @Override
            public String functionName() {
                return "Web_reference_test_" + lineno + "_";
            }

            @Override
            public void generateValidationCode(ITreeAppendable it) {
                it.append((CharSequence)"assertURLAccessibility(").append((CharSequence)Integer.toString(lineno));
                it.append((CharSequence)", new ");
                it.append(URL.class).append((CharSequence)"(\"");
                it.append((CharSequence)Strings.convertToJavaString((String)url.toExternalForm()));
                it.append((CharSequence)"\"));");
            }
        });
    }

    static {
        for (String label : Messages.WARNING.split(",")) {
            WARNING_LABELS.add(label.trim().toLowerCase());
        }
        for (String label : Messages.DANGER.split(",")) {
            DANGER_LABELS.add(label.trim().toLowerCase());
        }
    }
}

