/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.parser;

import com.google.inject.Inject;
import io.sarl.docs.generator.Messages;
import io.sarl.docs.generator.parser.DynamicValidationComponent;
import io.sarl.docs.generator.parser.DynamicValidationContext;
import io.sarl.docs.generator.parser.InvalidAnchorLabelException;
import io.sarl.docs.generator.parser.SarlDocumentationParser;
import io.sarl.docs.generator.parser.ValidationComponent;
import io.sarl.docs.generator.parser.ValidationComponentData;
import java.io.File;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class AbstractMarkerLanguageParser {
    public static final String[] HTML_FILE_EXTENSIONS = new String[]{".html", ".htm"};
    private SarlDocumentationParser parser;
    private boolean githubExtension;

    private static String select(String str1, String str2) {
        if (Strings.isEmpty((String)str1)) {
            return str2;
        }
        return str1;
    }

    public static IntegerRange parseRange(String stringRange, int minValue) {
        block7: {
            String sepPattern = "[,;\\-:]";
            try {
                Matcher matcher = Pattern.compile("^\\s*(?:(?<left>[0-9]+)\\s*(?:(?<sep1>[,;\\-:])\\s*(?<right1>[0-9]+)?)?)|(?:(?<sep2>[,;\\-:])\\s*(?<right2>[0-9]+))\\s*$").matcher(stringRange);
                if (!matcher.matches()) break block7;
                String left = matcher.group("left");
                String sep = AbstractMarkerLanguageParser.select(matcher.group("sep1"), matcher.group("sep2"));
                String right = AbstractMarkerLanguageParser.select(matcher.group("right1"), matcher.group("right2"));
                if (Strings.isEmpty((String)left)) {
                    if (!Strings.isEmpty((String)sep) && !Strings.isEmpty((String)right)) {
                        return new IntegerRange(minValue, Math.max(minValue, Integer.parseInt(right)));
                    }
                    break block7;
                }
                int leftValue = Math.max(minValue, Integer.parseInt(left));
                if (Strings.isEmpty((String)sep)) {
                    return new IntegerRange(leftValue, leftValue);
                }
                if (Strings.isEmpty((String)right)) {
                    return new IntegerRange(leftValue, Integer.MAX_VALUE);
                }
                int rightValue = Math.max(minValue, Integer.parseInt(right));
                if (rightValue < leftValue) {
                    return new IntegerRange(rightValue, leftValue);
                }
                return new IntegerRange(leftValue, rightValue);
            }
            catch (Throwable exception) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.GenerateMojo_4, stringRange), exception);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.GenerateMojo_4, stringRange));
    }

    public boolean isGithubExtensionEnable() {
        return this.githubExtension;
    }

    public void setGithubExtensionEnable(boolean enable) {
        this.githubExtension = enable;
    }

    public static boolean isHtmlFileExtension(String extension) {
        for (String ext : HTML_FILE_EXTENSIONS) {
            if (!Strings.equal((String)ext, (String)extension)) continue;
            return true;
        }
        return false;
    }

    @Inject
    public void setDocumentParser(SarlDocumentationParser parser) {
        assert (parser != null);
        this.parser = parser;
        this.parser.reset();
    }

    public SarlDocumentationParser getDocumentParser() {
        return this.parser;
    }

    public abstract String extractPageTitle(String var1);

    public final String transform(File inputFile) {
        return this.transform(inputFile, true);
    }

    public final String transform(Reader reader, File inputFile) {
        return this.transform(reader, inputFile, true);
    }

    public final String transform(CharSequence content, File inputFile) {
        return this.transform(content, inputFile, true);
    }

    public String transform(File inputFile, boolean validationOfInternalLinks) {
        this.preProcessingTransformation(null, inputFile, validationOfInternalLinks);
        String rawContent = this.getDocumentParser().transform(inputFile);
        return this.postProcessingTransformation(rawContent, validationOfInternalLinks);
    }

    public String transform(Reader reader, File inputFile, boolean validationOfInternalLinks) {
        this.preProcessingTransformation(null, inputFile, validationOfInternalLinks);
        String rawContent = this.getDocumentParser().transform(reader, inputFile);
        return this.postProcessingTransformation(rawContent, validationOfInternalLinks);
    }

    public String transform(CharSequence content, File inputFile, boolean validationOfInternalLinks) {
        this.preProcessingTransformation(content, inputFile, validationOfInternalLinks);
        String rawContent = this.getDocumentParser().transform(content, inputFile);
        return this.postProcessingTransformation(rawContent, validationOfInternalLinks);
    }

    protected void preProcessingTransformation(CharSequence content, File inputFile, boolean validationOfInternalLinks) {
    }

    protected abstract String postProcessingTransformation(String var1, boolean var2);

    public Iterable<ValidationComponent> getStandardValidationComponents(File inputFile) {
        ValidationHandler handler = new ValidationHandler();
        SarlDocumentationParser parser = this.getDocumentParser();
        parser.extractValidationComponents(inputFile, handler);
        return handler.getComponents();
    }

    public Iterable<ValidationComponent> getStandardValidationComponents(CharSequence content, File inputFile) {
        ValidationHandler handler = new ValidationHandler();
        this.getDocumentParser().extractValidationComponents(content, inputFile, (Procedures.Procedure1<Map<SarlDocumentationParser.Tag, List<ValidationComponentData>>>)handler);
        return handler.getComponents();
    }

    public final List<DynamicValidationComponent> getMarkerSpecificValidationComponents(File inputFile, File rootFolder, DynamicValidationContext context) {
        return this.getSpecificValidationComponents(this.transform(inputFile, false), inputFile, rootFolder, context);
    }

    public final List<DynamicValidationComponent> getMarkerSpecificValidationComponents(String text, File inputFile, File rootFolder, DynamicValidationContext context) {
        return this.getSpecificValidationComponents(this.transform(inputFile, false), inputFile, rootFolder, context);
    }

    protected abstract List<DynamicValidationComponent> getSpecificValidationComponents(String var1, File var2, File var3, DynamicValidationContext var4);

    private static class ValidationHandler
    implements Procedures.Procedure1<Map<SarlDocumentationParser.Tag, List<ValidationComponentData>>> {
        private final List<ValidationComponent> components = new ArrayList<ValidationComponent>();

        ValidationHandler() {
        }

        public List<ValidationComponent> getComponents() {
            return this.components;
        }

        public void apply(Map<SarlDocumentationParser.Tag, List<ValidationComponentData>> it) {
            block5: for (Map.Entry<SarlDocumentationParser.Tag, List<ValidationComponentData>> entry : it.entrySet()) {
                boolean isExecutable;
                boolean isCompilable;
                switch (entry.getKey()) {
                    case SUCCESS: {
                        isCompilable = true;
                        isExecutable = false;
                        break;
                    }
                    case FAILURE: {
                        isCompilable = false;
                        isExecutable = false;
                        break;
                    }
                    case FACT: {
                        isCompilable = true;
                        isExecutable = true;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                for (ValidationComponentData code : entry.getValue()) {
                    ValidationComponent component = new ValidationComponent();
                    component.setCompilable(isCompilable);
                    component.setExecutable(isExecutable);
                    component.setSourceFile(code.file);
                    component.setOffsetInSourceFile(code.offset);
                    component.setLengthInSourceFile(code.length);
                    component.setLinenoInSourceFile(code.lineno);
                    component.setEndLinenoInSourceFile(code.endLineno);
                    component.setDeprecationIssuesAsErrors(code.deprecationAsError);
                    component.setCode(code.code);
                    this.components.add(component);
                }
            }
        }
    }

    public static class ReferenceContext {
        private static final String MANY = new String();
        private Map<String, String> anchorToTitle = new TreeMap<String, String>();
        private Map<String, String> simpleAnchorToAnchor = new TreeMap<String, String>();
        private Map<String, String> titleToAnchor = new TreeMap<String, String>();

        public void registerSection(String keyWithSectionNumber, String keyWithoutSectionNumber, String title) {
            this.anchorToTitle.put(keyWithSectionNumber, title);
            if (this.simpleAnchorToAnchor.containsKey(keyWithoutSectionNumber)) {
                this.simpleAnchorToAnchor.put(keyWithoutSectionNumber, MANY);
            } else {
                this.simpleAnchorToAnchor.put(keyWithoutSectionNumber, keyWithSectionNumber);
            }
            if (this.titleToAnchor.containsKey(title)) {
                this.titleToAnchor.put(title, MANY);
            } else {
                this.titleToAnchor.put(title, keyWithSectionNumber);
            }
        }

        public String validateAnchor(String anchor, int line) {
            if (!this.anchorToTitle.containsKey(anchor)) {
                String anc = this.simpleAnchorToAnchor.get(anchor);
                if (!Strings.isEmpty((String)anc) && anc != MANY) {
                    return anc;
                }
                anc = this.titleToAnchor.get(anchor);
                if (!Strings.isEmpty((String)anc) && anc != MANY) {
                    return anc;
                }
                Object[] anchors = new String[this.anchorToTitle.size()];
                int i = 0;
                for (String eanchor : this.anchorToTitle.keySet()) {
                    anchors[i] = eanchor;
                    ++i;
                }
                Arrays.sort(anchors);
                throw new InvalidAnchorLabelException(anchor, line, (String[])anchors);
            }
            return anchor;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (String key : this.anchorToTitle.keySet()) {
                b.append(key);
                b.append("\n");
            }
            return b.toString();
        }
    }
}

