/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.parser;

import com.google.common.io.Files;
import io.sarl.docs.generator.parser.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.junit.jupiter.api.Assertions;

public class DynamicValidationContext {
    private List<String> sources;
    private List<String> resources;
    private List<String> destinations;
    private List<String> tmpResources;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("sources = ").append(this.getSourceRoots()).append("\n");
        buffer.append("resources = ").append(this.getResourceRoots()).append("\n");
        buffer.append("tmp = ").append(this.getTempResourceRoots()).append("\n");
        buffer.append("destinations = ").append(this.getDestinationRoots()).append("\n");
        return buffer.toString();
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public List<String> getSourceRoots() {
        return this.sources == null ? Collections.emptyList() : this.sources;
    }

    public void setSourceRoots(List<String> roots) {
        this.sources = roots;
    }

    public List<String> getDestinationRoots() {
        return this.destinations == null ? Collections.emptyList() : this.destinations;
    }

    public void setDestinationRoots(List<String> roots) {
        this.destinations = roots;
    }

    public List<String> getResourceRoots() {
        return this.resources == null ? Collections.emptyList() : this.resources;
    }

    public void setResourceRoots(List<String> roots) {
        this.resources = roots;
    }

    public List<String> getTempResourceRoots() {
        List<String> tmp = this.tmpResources == null ? Collections.emptyList() : this.tmpResources;
        this.tmpResources = null;
        return tmp;
    }

    public void setTempResourceRoots(List<String> roots) {
        this.tmpResources = roots;
    }

    public void appendFileExistenceTest(ITreeAppendable receiver, File relativeFile, String errorLabel) {
        if (relativeFile.isAbsolute()) {
            receiver.newLine();
            receiver.append((CharSequence)"{");
            receiver.increaseIndentation().newLine();
            receiver.append(File.class).append((CharSequence)" file = new ").append(File.class);
            receiver.append((CharSequence)"(\"").append((CharSequence)Strings.convertToJavaString((String)relativeFile.toString())).append((CharSequence)"\");");
            receiver.newLine();
            receiver.append(Assertions.class).append((CharSequence)(".assertTrue(file.exists(), () -> \"" + Strings.convertToJavaString((String)errorLabel) + ": \" + file);"));
            receiver.decreaseIndentation().newLine();
            receiver.append((CharSequence)"}");
        }
        this.appendFileExistenceTestsInReferenceFolders(receiver, relativeFile);
        receiver.newLine();
        receiver.append(Assertions.class).append((CharSequence)(".fail(\"" + Strings.convertToJavaString((String)errorLabel) + ": " + Strings.convertToJavaString((String)relativeFile.toString()) + "\");"));
    }

    public void appendFileExistenceTest(ITreeAppendable receiver, File relativeFile, String errorLabel, Iterable<String> extensions) {
        if (!DynamicValidationContext.hasExtension(relativeFile, extensions)) {
            this.appendFileExistenceTest(receiver, relativeFile, errorLabel);
            return;
        }
        File fileWithoutExtension = FileSystem.removeExtension((File)relativeFile);
        for (String newExtension : extensions) {
            File fileWithNewExtension = FileSystem.addExtension((File)fileWithoutExtension, (String)newExtension);
            if (relativeFile.isAbsolute()) {
                DynamicValidationContext.appendSafeFileExistenceTest(receiver, fileWithNewExtension);
                continue;
            }
            this.appendFileExistenceTestsInReferenceFolders(receiver, fileWithNewExtension);
        }
        receiver.newLine();
        receiver.append(Assertions.class).append((CharSequence)".fail(\"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)errorLabel));
        receiver.append((CharSequence)": ").append((CharSequence)Strings.convertToJavaString((String)fileWithoutExtension.toString()));
        receiver.append((CharSequence)"[");
        boolean first = true;
        for (String ext : extensions) {
            if (first) {
                first = false;
            } else {
                receiver.append((CharSequence)"|");
            }
            receiver.append((CharSequence)Strings.convertToJavaString((String)ext));
        }
        receiver.append((CharSequence)"]\");");
    }

    private void appendFileExistenceTestsInReferenceFolders(ITreeAppendable receiver, File relativeFile) {
        File fileInResource;
        for (String resource : this.getDestinationRoots()) {
            fileInResource = DynamicValidationContext.canon(FileSystem.makeAbsolute((File)relativeFile, (File)new File(resource)));
            DynamicValidationContext.appendSafeFileExistenceTest(receiver, fileInResource);
        }
        for (String resource : this.getResourceRoots()) {
            fileInResource = DynamicValidationContext.canon(FileSystem.makeAbsolute((File)relativeFile, (File)new File(resource)));
            DynamicValidationContext.appendSafeFileExistenceTest(receiver, fileInResource);
        }
        for (String resource : this.getTempResourceRoots()) {
            fileInResource = DynamicValidationContext.canon(FileSystem.makeAbsolute((File)relativeFile, (File)new File(resource)));
            DynamicValidationContext.appendSafeFileExistenceTest(receiver, fileInResource);
        }
    }

    private static void appendSafeFileExistenceTest(ITreeAppendable receiver, File fileInResource) {
        receiver.newLine();
        receiver.append((CharSequence)"{");
        receiver.increaseIndentation().newLine();
        receiver.append(File.class).append((CharSequence)" file = new ").append(File.class);
        receiver.append((CharSequence)"(\"").append((CharSequence)Strings.convertToJavaString((String)fileInResource.toString())).append((CharSequence)"\");");
        receiver.newLine();
        receiver.append((CharSequence)"if (file.exists()) {");
        receiver.increaseIndentation().newLine();
        receiver.append((CharSequence)"return;");
        receiver.decreaseIndentation().newLine();
        receiver.append((CharSequence)"}");
        receiver.decreaseIndentation().newLine();
        receiver.append((CharSequence)"}");
    }

    private static boolean hasExtension(File file, Iterable<String> extensions) {
        String extension = FileSystem.extension((File)file);
        for (String ext : extensions) {
            if (!Strings.equal((String)ext, (String)extension)) continue;
            return true;
        }
        return false;
    }

    public void appendTitleAnchorExistenceTest(ITreeAppendable receiver, File relativeFile, String anchor, String sectionPatternSpecification, Iterable<String> extensions) {
        if (!DynamicValidationContext.hasExtension(relativeFile, extensions)) {
            return;
        }
        File fileWithoutExtension = FileSystem.removeExtension((File)relativeFile);
        receiver.append(Pattern.class).append((CharSequence)" sectionPattern = ");
        receiver.append(Pattern.class).append((CharSequence)".compile(\"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)sectionPatternSpecification));
        receiver.append((CharSequence)"\", ").append(Pattern.class).append((CharSequence)".MULTILINE);").newLine();
        receiver.append(Set.class).append((CharSequence)" alternatives = new ");
        receiver.append(TreeSet.class).append((CharSequence)"<>();").newLine();
        for (String newExtension : extensions) {
            File fileInResource;
            File fileWithNewExtension = FileSystem.addExtension((File)fileWithoutExtension, (String)newExtension);
            if (relativeFile.isAbsolute()) {
                DynamicValidationContext.appendSafeTitleAnchorExistenceTest(receiver, fileWithNewExtension, anchor);
                continue;
            }
            for (String resource : this.getDestinationRoots()) {
                fileInResource = DynamicValidationContext.canon(FileSystem.makeAbsolute((File)fileWithNewExtension, (File)new File(resource)));
                DynamicValidationContext.appendSafeTitleAnchorExistenceTest(receiver, fileInResource, anchor);
            }
            for (String resource : this.getTempResourceRoots()) {
                fileInResource = DynamicValidationContext.canon(FileSystem.makeAbsolute((File)fileWithNewExtension, (File)new File(resource)));
                DynamicValidationContext.appendSafeTitleAnchorExistenceTest(receiver, fileInResource, anchor);
            }
        }
        receiver.newLine();
        StringBuilder errorFilename = new StringBuilder();
        errorFilename.append(Strings.convertToJavaString((String)fileWithoutExtension.toString()));
        errorFilename.append(".*");
        receiver.append(List.class).append((CharSequence)"<String> alternativeLists = new ");
        receiver.append(ArrayList.class).append((CharSequence)"<>(alternatives);").newLine();
        receiver.append(Collections.class).append((CharSequence)".sort(alternativeLists, (a, b) -> {");
        receiver.increaseIndentation().newLine();
        receiver.append((CharSequence)"int la = ").append(StringUtils.class).append((CharSequence)".getLevenshteinDistance(a, \"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)anchor)).append((CharSequence)"\");").newLine();
        receiver.append((CharSequence)"int lb = ").append(StringUtils.class).append((CharSequence)".getLevenshteinDistance(b, \"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)anchor)).append((CharSequence)"\");").newLine();
        receiver.append((CharSequence)"int cmp = la - lb;").newLine();
        receiver.append((CharSequence)"if (cmp != 0) return cmp;").newLine();
        receiver.append((CharSequence)"return a.compareTo(b);").decreaseIndentation().newLine();
        receiver.append((CharSequence)"});").newLine();
        receiver.append((CharSequence)"throw new ").append(AssertionError.class).append((CharSequence)"(\"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)MessageFormat.format(Messages.DynamicValidationContext_1, anchor, errorFilename)));
        receiver.append((CharSequence)"\" + alternativeLists.toString());");
    }

    private static void appendSafeTitleAnchorExistenceTest(ITreeAppendable receiver, File fileInResource, String anchor) {
        receiver.newLine();
        receiver.append((CharSequence)"{").increaseIndentation().newLine();
        receiver.append((CharSequence)"// ").append((CharSequence)FileSystem.extension((File)fileInResource)).append((CharSequence)": ");
        receiver.append((CharSequence)fileInResource.getName()).newLine();
        receiver.append(File.class).append((CharSequence)" theFile = new ").append(File.class).append((CharSequence)"(\"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)fileInResource.toString())).append((CharSequence)"\");");
        receiver.newLine().append((CharSequence)"if (theFile.exists()) {");
        receiver.increaseIndentation().newLine();
        receiver.append((CharSequence)"String content = ").append(Strings.class);
        receiver.append((CharSequence)".concat(\"\\n\", ").append(Files.class);
        receiver.append((CharSequence)".readLines(theFile, ");
        receiver.append(Charset.class).append((CharSequence)".defaultCharset()));").newLine();
        receiver.append((CharSequence)"if (content != null) {").increaseIndentation().newLine();
        receiver.append(Matcher.class).append((CharSequence)" matcher = sectionPattern.matcher(content);").newLine();
        receiver.append((CharSequence)"while (matcher.find()) {").increaseIndentation().newLine();
        receiver.append((CharSequence)"String title = matcher.group(1);").newLine();
        receiver.append((CharSequence)"String key1 = computeHeaderIdWithSectionNumber(title);").newLine();
        receiver.append((CharSequence)"String key2 = computeHeaderIdWithoutSectionNumber(title);").newLine();
        receiver.append((CharSequence)"if (\"").append((CharSequence)Strings.convertToJavaString((String)anchor)).append((CharSequence)"\".equals(key1) || \"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)anchor)).append((CharSequence)"\".equals(key2)) {");
        receiver.increaseIndentation().newLine().append((CharSequence)"return;").decreaseIndentation().newLine();
        receiver.append((CharSequence)"}").decreaseIndentation().newLine();
        receiver.append((CharSequence)"}").newLine().append((CharSequence)"}").newLine();
        receiver.append(Assertions.class).append((CharSequence)".fail(\"");
        receiver.append((CharSequence)Strings.convertToJavaString((String)MessageFormat.format(Messages.DynamicValidationContext_0, anchor, fileInResource.getName())));
        receiver.append((CharSequence)"\");").newLine();
        receiver.append((CharSequence)"return;");
        receiver.decreaseIndentation().newLine();
        receiver.append((CharSequence)"}").decreaseIndentation().newLine().append((CharSequence)"}");
    }
}

