/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.parser;

import io.sarl.docs.generator.parser.Messages;
import java.text.MessageFormat;

public class InvalidAnchorLabelException
extends RuntimeException {
    private static final long serialVersionUID = 4282853898682563456L;
    private final String anchor;
    private final int line;

    public InvalidAnchorLabelException(String anchor, int line, String ... existingAnchors) {
        super(InvalidAnchorLabelException.errorMessage(anchor, line, existingAnchors));
        this.anchor = anchor;
        this.line = line;
    }

    private static String errorMessage(String anchor, int line, String ... existingAnchors) {
        if (line < 0) {
            return MessageFormat.format(Messages.InvalidAnchorLabelException_1, anchor, InvalidAnchorLabelException.format(existingAnchors));
        }
        return MessageFormat.format(Messages.InvalidAnchorLabelException_0, anchor, Integer.toString(line), InvalidAnchorLabelException.format(existingAnchors));
    }

    private static String format(String[] anchors) {
        StringBuilder builder = new StringBuilder();
        for (String anchor : anchors) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(anchor);
        }
        return builder.toString();
    }

    public String getAnchor() {
        return this.anchor;
    }

    public int getLine() {
        return this.line;
    }
}

