/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.parser;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import io.sarl.docs.generator.parser.Messages;
import io.sarl.docs.generator.parser.ValidationComponentData;
import io.sarl.docs.validator.NoXtextResourceException;
import io.sarl.docs.validator.ReflectExtensions;
import io.sarl.docs.validator.ScriptExecutor;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.ReflectionUtil;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SarlDocumentationParser {
    public static final String DEFAULT_INLINE_FORMAT = "`{0}`";
    public static final String DEFAULT_OUTLINE_OUTPUT_TAG = "[::Outline::]";
    public static final String DEFAULT_LINE_CONTINUATION = " ";
    private static final String DEFAULT_TAG_NAME_PATTERN = "\\[:(.*?)[:!]?\\]";
    private static final int PATTERN_COMPILE_OPTIONS = 40;
    private Injector injector;
    private IActionPrototypeProvider actionPrototypeProvider;
    private Map<Tag, String> rawPatterns = new HashMap<Tag, String>();
    private Map<Tag, Pattern> compiledPatterns = new HashMap<Tag, Pattern>();
    private String inlineFormat;
    private Functions.Function2<String, String, String> blockFormat;
    private String outlineOutputTag;
    private String dynamicNameExtractionPattern;
    private Deque<Properties> additionalPropertyProvidersByPriority = new LinkedList<Properties>();
    private String lineSeparator;
    private String languageName;
    private ScriptExecutor scriptExecutor;
    private String lineContinuation;

    public SarlDocumentationParser() {
        this.reset();
    }

    @Inject
    public void setInjector(Injector injector) {
        assert (injector != null);
        this.injector = injector;
    }

    @Inject
    public void setOutputLanguage(@Named(value="languageName") String outputLanguage) {
        String simpleName;
        String[] parts;
        if (!Strings.isNullOrEmpty((String)outputLanguage) && (parts = outputLanguage.split("\\.+")).length > 0 && !Strings.isNullOrEmpty((String)(simpleName = parts[parts.length - 1]))) {
            this.languageName = simpleName;
            return;
        }
        this.languageName = null;
    }

    @Inject
    public void setScriptExecutor(ScriptExecutor executor) {
        this.scriptExecutor = executor;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public String getLineContinuation() {
        return this.lineContinuation;
    }

    public void setLineContinuation(String lineContinuationText) {
        this.lineContinuation = lineContinuationText;
    }

    public static Functions.Function2<String, String, String> getFencedCodeBlockFormatter() {
        return (languageName, content) -> "```" + Strings.nullToEmpty((String)languageName).toLowerCase() + "\n" + content + "```\n";
    }

    public static Functions.Function2<String, String, String> getBasicCodeBlockFormatter() {
        return (languageName, content) -> Pattern.compile("^", 8).matcher((CharSequence)content).replaceAll("\t");
    }

    public String getOutputLanguage() {
        return this.languageName;
    }

    @Inject
    public void setActionPrototypeProvider(IActionPrototypeProvider provider) {
        assert (provider != null);
        this.actionPrototypeProvider = provider;
    }

    @Inject
    public IActionPrototypeProvider getActionPrototypeProvider() {
        return this.actionPrototypeProvider;
    }

    public void reset() {
        this.rawPatterns.clear();
        this.compiledPatterns.clear();
        this.inlineFormat = DEFAULT_INLINE_FORMAT;
        this.blockFormat = null;
        this.outlineOutputTag = DEFAULT_OUTLINE_OUTPUT_TAG;
        this.dynamicNameExtractionPattern = DEFAULT_TAG_NAME_PATTERN;
        this.lineContinuation = DEFAULT_LINE_CONTINUATION;
    }

    public void addHighPropertyProvider(Properties properties) {
        this.additionalPropertyProvidersByPriority.addFirst(properties);
    }

    public void addLowPropertyProvider(Properties properties) {
        this.additionalPropertyProvidersByPriority.addLast(properties);
    }

    public Iterable<Properties> getPropertyProvidersByPriority() {
        return Collections.unmodifiableCollection(this.additionalPropertyProvidersByPriority);
    }

    public void setPattern(Tag tag, String regex) {
        if (Strings.isNullOrEmpty((String)regex)) {
            this.rawPatterns.remove((Object)tag);
            this.compiledPatterns.remove((Object)tag);
        } else {
            this.rawPatterns.put(tag, regex);
            this.compiledPatterns.put(tag, Pattern.compile("^\\s*" + regex, 40));
        }
    }

    public String getPattern(Tag tag) {
        String pattern = this.rawPatterns.get((Object)tag);
        if (pattern == null) {
            return tag.getDefaultPattern();
        }
        return pattern;
    }

    public Tag getTagForPattern(CharSequence text) {
        for (Tag tag : Tag.values()) {
            Matcher matcher;
            Pattern pattern = this.compiledPatterns.get((Object)tag);
            if (pattern == null) {
                pattern = Pattern.compile("^\\s*" + this.getPattern(tag), 32);
                this.compiledPatterns.put(tag, pattern);
            }
            if (!(matcher = pattern.matcher(text)).find()) continue;
            return tag;
        }
        return null;
    }

    public final void setFailurePattern(String regex) {
        this.setPattern(Tag.FAILURE, regex);
    }

    public final String getFailurePattern() {
        return this.getPattern(Tag.FAILURE);
    }

    public final void setSuccessPattern(String regex) {
        this.setPattern(Tag.SUCCESS, regex);
    }

    public final String getSuccessPattern() {
        return this.getPattern(Tag.SUCCESS);
    }

    public final void setDefinitionPattern(String regex) {
        this.setPattern(Tag.DEFINITION, regex);
    }

    public final String getDefinitionPattern() {
        return this.getPattern(Tag.DEFINITION);
    }

    public final void setReferencePattern(String regex) {
        this.setPattern(Tag.REFERENCE, regex);
    }

    public final String getReferencePattern() {
        return this.getPattern(Tag.REFERENCE);
    }

    public final void setOffPattern(String regex) {
        this.setPattern(Tag.OFF, regex);
    }

    public final String getOffPattern() {
        return this.getPattern(Tag.OFF);
    }

    public final void setOnPattern(String regex) {
        this.setPattern(Tag.ON, regex);
    }

    public final String getOnPattern() {
        return this.getPattern(Tag.ON);
    }

    public final void setFactPattern(String regex) {
        this.setPattern(Tag.FACT, regex);
    }

    public final String getFactPattern() {
        return this.getPattern(Tag.FACT);
    }

    public final void setIncludePattern(String regex) {
        this.setPattern(Tag.INCLUDE, regex);
    }

    public final String getIncludePattern() {
        return this.getPattern(Tag.INCLUDE);
    }

    public final void setOutlinePattern(String regex) {
        this.setPattern(Tag.OUTLINE, regex);
    }

    public final String getOutlinePattern() {
        return this.getPattern(Tag.OUTLINE);
    }

    public void setInlineCodeTemplate(String template) {
        if (!Strings.isNullOrEmpty((String)template)) {
            this.inlineFormat = template;
        }
    }

    public String getInlineCodeTemplate() {
        return this.inlineFormat;
    }

    public void setBlockCodeTemplate(Functions.Function2<String, String, String> template) {
        this.blockFormat = template;
    }

    public Functions.Function2<String, String, String> getBlockCodeTemplate() {
        return this.blockFormat;
    }

    protected void setOutlineOutputTag(String tag) {
        this.outlineOutputTag = tag;
    }

    public String getOutlineOutputTag() {
        return this.outlineOutputTag;
    }

    public void setDynamicNameExtractionPattern(String pattern) {
        if (!Strings.isNullOrEmpty((String)pattern)) {
            this.dynamicNameExtractionPattern = pattern;
        }
    }

    public String getDynamicNameExtractionPattern() {
        return this.dynamicNameExtractionPattern;
    }

    public String getLineSeparator() {
        if (Strings.isNullOrEmpty((String)this.lineSeparator)) {
            String nl = System.getProperty("line.separator");
            if (Strings.isNullOrEmpty((String)nl)) {
                return "\n";
            }
            return nl;
        }
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private String buildGeneralTagPattern() {
        StringBuilder pattern = new StringBuilder();
        int nbTags = 0;
        for (Tag tag : Tag.values()) {
            if (nbTags >= 1) {
                pattern.append("|");
            }
            pattern.append("(?:");
            if (tag.isEnclosingSpaceCouldRemovable()) {
                pattern.append("[ \\t]*");
            }
            pattern.append("(");
            pattern.append(this.getPattern(tag));
            pattern.append(")");
            if (tag.hasParameter()) {
                pattern.append("(?:");
                pattern.append("(?:\\(\\s*([^\\)]*?)\\s*\\))|");
                pattern.append("(?:\\{\\s*([^\\}]*?)\\s*\\})|");
                pattern.append("(?:\\|\\s*([^\\|]*?)\\s*\\|)|");
                pattern.append("(?:\\$\\s*([^\\$]*?)\\s*\\$)");
                pattern.append(")");
            }
            if (tag.isEnclosingSpaceCouldRemovable()) {
                pattern.append("[ \\t]*");
            }
            pattern.append(")");
            ++nbTags;
        }
        if (nbTags > 0) {
            pattern.insert(0, "(" + org.eclipse.xtext.util.Strings.convertToJavaString((String)this.getLineSeparator()) + ")|");
            return pattern.toString();
        }
        return null;
    }

    protected void extractDynamicName(Tag tag, CharSequence name, OutParameter<String> dynamicName) {
        Pattern pattern;
        Matcher matcher;
        if (tag.hasDynamicName() && (matcher = (pattern = Pattern.compile(this.getDynamicNameExtractionPattern())).matcher(name)).matches()) {
            dynamicName.set((Object)Strings.nullToEmpty((String)matcher.group(1)));
            return;
        }
        dynamicName.set((Object)name.toString());
    }

    private static int findFirstGroup(Matcher matcher, int startIdx) {
        int len = matcher.groupCount();
        for (int i = startIdx + 1; i <= len; ++i) {
            String value = matcher.group(i);
            if (value == null) continue;
            return i;
        }
        return 1;
    }

    public String transform(File inputFile) {
        String content;
        try (FileReader reader = new FileReader(inputFile);){
            content = SarlDocumentationParser.read(reader, null);
        }
        catch (IOException exception) {
            SarlDocumentationParser.reportError(Messages.SarlDocumentationParser_0, exception);
            return null;
        }
        return this.transform(content, inputFile);
    }

    public String transform(Reader reader, File inputFile) {
        String content;
        try {
            content = SarlDocumentationParser.read(reader, null);
        }
        catch (IOException exception) {
            SarlDocumentationParser.reportError(Messages.SarlDocumentationParser_0, exception);
            return null;
        }
        return this.transform(content, inputFile);
    }

    public String transform(CharSequence content, File inputFile) {
        ParsingContext rootContextForReplacements = new ParsingContext();
        this.initializeContext(rootContextForReplacements);
        CharSequence rawContent = this.preProcessing(content);
        Stage stage = Stage.first();
        do {
            ContentParserInterceptor interceptor = new ContentParserInterceptor();
            rootContextForReplacements.setLineNo(1);
            rootContextForReplacements.setOffset(0);
            boolean hasChanged = this.parse(rawContent, inputFile, 0, stage, rootContextForReplacements, interceptor);
            if (!hasChanged) continue;
            rawContent = interceptor.getResult();
        } while ((stage = stage.next()) != null);
        return this.postProcessing(rawContent);
    }

    protected CharSequence preProcessing(CharSequence text) {
        return text;
    }

    protected String postProcessing(CharSequence text) {
        String lineContinuation = this.getLineContinuation();
        if (lineContinuation != null) {
            Pattern pattern = Pattern.compile("\\s*\\\\[\\n\\r]+\\s*", 32);
            Matcher matcher = pattern.matcher(text.toString().trim());
            return matcher.replaceAll(lineContinuation);
        }
        return text.toString().trim();
    }

    public void extractValidationComponents(File inputFile, Procedures.Procedure1<Map<Tag, List<ValidationComponentData>>> observer) {
        String content;
        AtomicInteger nblines = new AtomicInteger();
        try (FileReader reader = new FileReader(inputFile);){
            content = SarlDocumentationParser.read(reader, nblines);
        }
        catch (IOException exception) {
            SarlDocumentationParser.reportError(Messages.SarlDocumentationParser_0, exception);
            return;
        }
        this.extractValidationComponents(content, inputFile, observer);
    }

    public void extractValidationComponents(Reader reader, File inputFile, Procedures.Procedure1<Map<Tag, List<ValidationComponentData>>> observer) {
        String content;
        AtomicInteger nblines = new AtomicInteger();
        try {
            content = SarlDocumentationParser.read(reader, nblines);
        }
        catch (IOException exception) {
            SarlDocumentationParser.reportError(Messages.SarlDocumentationParser_0, exception);
            return;
        }
        this.extractValidationComponents(content, inputFile, observer);
    }

    public void extractValidationComponents(CharSequence content, File inputFile, Procedures.Procedure1<Map<Tag, List<ValidationComponentData>>> observer) {
        final TreeMap components = new TreeMap();
        ContentParserInterceptor interceptor = new ContentParserInterceptor(new ParserInterceptor(){

            @Override
            public void tag(ParsingContext context, Tag tag, String dynamicName, String parameter, String blockValue) {
                if (tag.isOpeningTag() || tag.hasParameter()) {
                    ArrayList<ValidationComponentData> values = (ArrayList<ValidationComponentData>)components.get((Object)tag);
                    if (values == null) {
                        values = new ArrayList<ValidationComponentData>();
                        components.put(tag, values);
                    }
                    ValidationComponentData data = new ValidationComponentData();
                    data.file = context.getCurrentFile();
                    data.lineno = context.getLineNo();
                    data.endLineno = context.getEndLineNo();
                    data.offset = context.getOffset();
                    data.length = context.getLength();
                    data.deprecationAsError = context.isDeprecationIssuesAsErrors();
                    data.code = tag.isOpeningTag() ? Strings.nullToEmpty((String)blockValue).trim() : Strings.nullToEmpty((String)parameter).trim();
                    values.add(data);
                }
            }
        });
        ParsingContext rootContextForReplacements = new ParsingContext(true, true);
        this.initializeContext(rootContextForReplacements);
        this.parse(content, inputFile, 0, Stage.FIRST, rootContextForReplacements, interceptor);
        ArrayList allTexts = new ArrayList(components.values());
        for (List values : allTexts) {
            for (ValidationComponentData data : values) {
                String newCapturedText;
                ContentParserInterceptor localInterceptor = new ContentParserInterceptor(interceptor);
                this.parse(data.code, inputFile, 0, Stage.SECOND, rootContextForReplacements, localInterceptor);
                data.code = newCapturedText = localInterceptor.getResult();
            }
        }
        observer.apply(components);
    }

    protected void initializeContext(ParsingContext context) {
        context.setLineNo(1);
        context.setOffset(0);
        context.setScriptExecutor(this.getScriptExecutor());
    }

    protected boolean parse(CharSequence source, File file, int startIndex, Stage stage, ParsingContext parentContext, ParserInterceptor interceptor) {
        ParsingContext context = (ParsingContext)this.injector.getInstance(ParsingContext.class);
        context.setParser(this);
        context.setText(source);
        context.setCurrentFile(file);
        context.setStartIndex(startIndex);
        context.setParserInterceptor(interceptor);
        context.setInlineCodeFormat(this.getInlineCodeTemplate());
        context.setBlockCodeFormat(this.getBlockCodeTemplate());
        context.setOutlineOutputTag(this.getOutlineOutputTag());
        context.setLineSeparator(this.getLineSeparator());
        context.setOutputLanguage(this.getOutputLanguage());
        context.setStage(stage);
        String regex = this.buildGeneralTagPattern();
        if (!Strings.isNullOrEmpty((String)regex)) {
            Pattern patterns = Pattern.compile(regex, 40);
            Matcher matcher = patterns.matcher(source);
            context.setMatcher(matcher);
            if (parentContext != null) {
                context.linkTo(parentContext);
            }
            boolean foundSpecialTag = this.parse(context);
            if (parentContext != null) {
                context.propagateTo(parentContext);
            }
            return foundSpecialTag;
        }
        return false;
    }

    protected boolean parse(ParsingContext context) {
        try {
            context.getParserInterceptor().openContext(context);
            boolean specialTagFound = false;
            String lineSeparator = this.getLineSeparator();
            while (context.getMatcher().find()) {
                int groupIndex = SarlDocumentationParser.findFirstGroup(context.getMatcher(), 0);
                String tagName = context.getMatcher().group(groupIndex);
                if (lineSeparator.equals(tagName)) {
                    context.incrementLineNo();
                    context.incrementOffset(lineSeparator.length());
                    continue;
                }
                int regionOffset = context.getMatcher().start();
                int regionLength = context.getMatcher().end() - regionOffset;
                context.setOffset(regionOffset);
                context.setLength(regionLength);
                int startLine = context.getLineNo();
                int nbLines = this.countLines(context.getMatcher().group());
                int endLine = startLine + nbLines - 1;
                context.setEndLineNo(endLine);
                Tag tag = this.getTagForPattern(tagName);
                if (tag != null) {
                    if (tag.isActive(context)) {
                        String blockContent;
                        String parameterValue;
                        String tagDynamicName;
                        if (tag.hasDynamicName()) {
                            OutParameter dname = new OutParameter();
                            this.extractDynamicName(tag, tagName, (OutParameter<String>)dname);
                            tagDynamicName = (String)dname.get();
                        } else {
                            tagDynamicName = null;
                        }
                        if (tag.hasParameter()) {
                            groupIndex = SarlDocumentationParser.findFirstGroup(context.getMatcher(), groupIndex);
                            String parameter = Strings.nullToEmpty((String)context.getMatcher().group(groupIndex));
                            ContentParserInterceptor subInterceptor = new ContentParserInterceptor(context.getParserInterceptor());
                            boolean inBlock = context.setInBlock(false);
                            boolean inParam = context.setInParameter(true);
                            this.parse(parameter, context.getCurrentFile(), context.getMatcher().start(groupIndex) + context.getStartIndex(), context.getStage(), context, subInterceptor);
                            context.setInParameter(inParam);
                            context.setInBlock(inBlock);
                            parameterValue = Strings.emptyToNull((String)subInterceptor.getResult());
                        } else {
                            parameterValue = null;
                        }
                        if (tag.isOpeningTag()) {
                            groupIndex = SarlDocumentationParser.findFirstGroup(context.getMatcher(), groupIndex);
                            String tagContent = context.getMatcher().group(groupIndex);
                            ContentParserInterceptor subInterceptor = new ContentParserInterceptor(context.getParserInterceptor());
                            boolean inBlock = context.setInBlock(true);
                            boolean inParam = context.setInParameter(false);
                            context.setVisibleInBlock(false);
                            this.parse(Strings.nullToEmpty((String)tagContent), context.getCurrentFile(), context.getMatcher().start(groupIndex) + context.getStartIndex(), context.getStage(), context, subInterceptor);
                            context.setInParameter(inParam);
                            context.setInBlock(inBlock);
                            blockContent = Strings.nullToEmpty((String)subInterceptor.getResult());
                        } else {
                            blockContent = null;
                        }
                        specialTagFound = true;
                        try {
                            context.getParserInterceptor().tag(context, tag, tagDynamicName, parameterValue, blockContent);
                        }
                        catch (Throwable exception) {
                            SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_6, tagName, exception);
                            return false;
                        }
                    }
                } else {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_1, tagName);
                    return false;
                }
                context.setLineNo(endLine);
                context.setEndLineNo(endLine);
            }
            context.getParserInterceptor().closeContext(context);
            return specialTagFound;
        }
        catch (ParsingException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            Throwable rootException = Throwables.getRootCause((Throwable)exception);
            throw new ParsingException(rootException.getClass().getName() + " - " + rootException.getLocalizedMessage(), context.getCurrentFile(), context.getLineNo(), rootException);
        }
    }

    private int countLines(String text) {
        String[] lines = text.split(Pattern.quote(this.getLineSeparator()));
        return lines.length;
    }

    protected static void reportError(ParsingContext context, String message, Object ... parameter) {
        File file = context.getCurrentFile();
        int offset = context.getMatcher().start() + context.getStartIndex();
        int lineno = context.getLineNo();
        Throwable cause = null;
        for (Object param : parameter) {
            Throwable cvalue;
            if (!(param instanceof Throwable)) continue;
            cause = cvalue = (Throwable)param;
            break;
        }
        Object[] args = new Object[parameter.length + 3];
        args[0] = file;
        args[1] = lineno;
        args[2] = offset;
        System.arraycopy(parameter, 0, args, 3, parameter.length);
        String msg = MessageFormat.format(message, args);
        if (cause != null) {
            throw new ParsingException(msg, file, lineno, Throwables.getRootCause((Throwable)cause));
        }
        throw new ParsingException(msg, file, lineno);
    }

    protected static void reportError(String message, Object ... parameters) {
        Throwable cause = null;
        for (int i = 0; cause == null && i < parameters.length; ++i) {
            Throwable cvalue;
            Object object = parameters[i];
            if (!(object instanceof Throwable)) continue;
            cause = cvalue = (Throwable)object;
        }
        String msg = MessageFormat.format(message, parameters);
        if (cause != null) {
            throw new ParsingException(msg, null, 1, Throwables.getRootCause(cause));
        }
        throw new ParsingException(msg, null, 1);
    }

    protected static String read(ParsingContext context, File file) throws IOException {
        File filename = file;
        if (context != null && !filename.isAbsolute()) {
            filename = FileSystem.makeAbsolute((File)filename, (File)context.getCurrentDirectory());
        }
        try (FileReader reader = new FileReader(filename);){
            String string = SarlDocumentationParser.read(reader, null);
            return string;
        }
    }

    protected static String read(Reader file, AtomicInteger nblines) throws IOException {
        if (nblines != null) {
            nblines.set(0);
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(file);){
            String line = reader.readLine();
            boolean first = true;
            while (line != null) {
                if (nblines != null) {
                    nblines.incrementAndGet();
                }
                if (first) {
                    first = false;
                } else {
                    content.append("\n");
                }
                content.append(line);
                line = reader.readLine();
            }
        }
        return content.toString();
    }

    protected static String formatBlockText(String content, String languageName, Functions.Function2<String, String, String> blockFormat) {
        int n;
        String line;
        Matcher matcher;
        int i;
        String replacement = Strings.nullToEmpty((String)content);
        String[] lines = replacement.trim().split("[\n\r]+");
        int minIndent = Integer.MAX_VALUE;
        Pattern wpPattern = Pattern.compile("^(\\s*)[^\\s]");
        int n2 = i = lines.length > 1 ? 1 : 0;
        while (!(i >= lines.length || (matcher = wpPattern.matcher(line = lines[i])).find() && (n = matcher.group(1).length()) < minIndent && (minIndent = n) <= 0)) {
            ++i;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(lines[0]);
        buffer.append("\n");
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line2 = lines[i2];
            buffer.append(line2.replaceFirst("^\\s{0," + minIndent + "}", ""));
            buffer.append("\n");
        }
        replacement = buffer.toString().replaceFirst("[\n\r]+$", "\n");
        if (!Strings.isNullOrEmpty((String)replacement) && !"\n".equals(replacement)) {
            if (blockFormat != null) {
                return (String)blockFormat.apply((Object)languageName, (Object)replacement);
            }
            return replacement;
        }
        return "";
    }

    public static enum Tag {
        PARSER_ON{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_PARSERON_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.setParsing(true);
                return context.getStage() == Stage.SECOND ? "" : "[:ParserOn]";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return true;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        PARSER_OFF{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_PARSEROFF_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.setParsing(false);
                return context.getStage() == Stage.SECOND ? "" : "[:ParserOff]";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return true;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        OUTLINE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_OUTLINE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                String tag;
                context.getParserInterceptor().outline(context);
                if (!context.isTestingPhase() && !Strings.isNullOrEmpty((String)(tag = context.getOutlineOutputTag()))) {
                    return Strings.nullToEmpty((String)context.getOutlineOutputTag());
                }
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        INCLUDE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_INCLUDE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (parameter == null) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_2, this.name());
                    return null;
                }
                File filename = FileSystem.convertStringToFile((String)parameter);
                try {
                    int oldLine = context.getLineNo();
                    int oldEndLine = context.getEndLineNo();
                    int oldOffset = context.getOffset();
                    int oldLength = context.getLength();
                    File oldFile = context.getCurrentFile();
                    String fileContent = SarlDocumentationParser.read(context, filename);
                    context.setLineNo(1);
                    context.setEndLineNo(1);
                    context.setOffset(0);
                    context.setLength(0);
                    context.setCurrentFile(filename);
                    ContentParserInterceptor subInterceptor = new ContentParserInterceptor(context.getParserInterceptor());
                    context.getParser().parse(fileContent, filename, 0, context.getStage(), context, subInterceptor);
                    context.setLineNo(oldLine);
                    context.setEndLineNo(oldEndLine);
                    context.setOffset(oldOffset);
                    context.setLength(oldLength);
                    context.setCurrentFile(oldFile);
                    return subInterceptor.getResult();
                }
                catch (IOException exception) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_3, exception);
                    return null;
                }
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        FACT{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_FACT_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        DYNAMIC{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_DYNAMIC_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                if (!context.isTestingPhase()) {
                    ScriptExecutor executor;
                    String code = parameter;
                    if (Strings.isNullOrEmpty((String)code)) {
                        code = blockValue;
                    }
                    if (!Strings.isNullOrEmpty((String)code) && (executor = context.getScriptExecutor()) != null) {
                        System.setProperty("SARL_DOC_CURRENT_FILE", context.getCurrentFile().getAbsolutePath());
                        System.setProperty("SARL_DOC_CURRENT_FOLDER", context.getCurrentFile().getParentFile().getAbsolutePath());
                        try {
                            Object result = executor.execute(context.getLineNo(), code);
                            if (result != null) {
                                String stringResult = Strings.nullToEmpty((String)Objects.toString(result));
                                return stringResult;
                            }
                        }
                        catch (NoXtextResourceException result) {
                        }
                        catch (Throwable exception) {
                            Throwable root = Throwables.getRootCause((Throwable)exception);
                            Throwables.throwIfUnchecked((Throwable)root);
                            throw new RuntimeException(root);
                        }
                    }
                }
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        DYNAMIC_CODE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_DYNAMIC_CODE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                if (!context.isTestingPhase()) {
                    ScriptExecutor executor;
                    String code = blockValue;
                    if (Strings.isNullOrEmpty((String)code)) {
                        code = parameter;
                    }
                    if (!Strings.isNullOrEmpty((String)code) && (executor = context.getScriptExecutor()) != null) {
                        System.setProperty("SARL_DOC_CURRENT_FILE", context.getCurrentFile().getAbsolutePath());
                        System.setProperty("SARL_DOC_CURRENT_FOLDER", context.getCurrentFile().getParentFile().getAbsolutePath());
                        try {
                            Object result = executor.execute(context.getLineNo(), code);
                            if (result != null) {
                                String stringResult = Strings.nullToEmpty((String)Objects.toString(result));
                                return SarlDocumentationParser.formatBlockText(stringResult, context.getOutputLanguage(), context.getBlockCodeFormat());
                            }
                        }
                        catch (NoXtextResourceException result) {
                        }
                        catch (Throwable exception) {
                            Throwable root = Throwables.getRootCause((Throwable)exception);
                            Throwables.throwIfUnchecked((Throwable)root);
                            throw new RuntimeException(root);
                        }
                    }
                }
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return true;
            }
        }
        ,
        ON{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_ON_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.setVisibleInBlock(true);
                context.setInHtmlBlock(false);
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        ONHTML{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_ONHTML_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.setVisibleInBlock(true);
                context.setInHtmlBlock(true);
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        OFF{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_OFF_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.setVisibleInBlock(false);
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        CONFIGURE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_CONFIGURE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (parameter != null) {
                    for (String definition : parameter.split("\\s*[,;:]\\s*")) {
                        if (definition == null) continue;
                        String[] pair = definition.split("\\s*=\\s*");
                        if (pair.length == 2 && pair[0] != null && pair[1] != null) {
                            switch (pair[0].toLowerCase()) {
                                case "deprecationaserror": {
                                    Boolean value = null;
                                    switch (pair[1].toLowerCase()) {
                                        case "true": {
                                            value = Boolean.TRUE;
                                            break;
                                        }
                                        case "false": {
                                            value = Boolean.FALSE;
                                            break;
                                        }
                                    }
                                    context.setDeprecationIssuesAsErrors(value);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unrecognized property: " + pair[0]);
                                }
                            }
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid format for the parameter: " + parameter);
                    }
                }
                return "";
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isTestingPhase();
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        SUCCESS{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_SUCCESS_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return true;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                return SarlDocumentationParser.formatBlockText(blockValue, context.getOutputLanguage(), context.getBlockCodeFormatHtmlCodeBlock());
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        FAILURE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_FAILURE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return true;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                return SarlDocumentationParser.formatBlockText(blockValue, context.getOutputLanguage(), context.getBlockCodeFormatHtmlCodeBlock());
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        COMMENT{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_COMMENT_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                return new String();
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return true;
            }
        }
        ,
        SHOW_TYPE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_SHOWTYPE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return false;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                if (context.isInBlock() || context.isInParameter()) {
                    SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_5, this.name());
                    return null;
                }
                if (!context.isTestingPhase()) {
                    Class javaType;
                    try {
                        javaType = ReflectionUtil.forName((String)parameter);
                    }
                    catch (ClassNotFoundException exception) {
                        SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_0, exception);
                        return null;
                    }
                    String block = javaType.isInterface() ? (Capacity.class.isAssignableFrom(javaType) ? this.extractCapacity(javaType.asSubclass(Capacity.class)) : this.extractInterface(javaType)) : (javaType.isEnum() ? this.extractEnumeration(javaType) : (javaType.isAnnotation() ? this.extractAnnotation(javaType) : (Event.class.isAssignableFrom(javaType) ? this.extractEvent(javaType.asSubclass(Event.class)) : this.extractClass(javaType))));
                    return SarlDocumentationParser.formatBlockText(block, context.getOutputLanguage(), context.getBlockCodeFormat());
                }
                return "";
            }

            private void appendGenericTypes(StringBuilder it, Class<?> type) {
                if (type.getTypeParameters() != null && type.getTypeParameters().length > 0) {
                    it.append("<");
                    boolean first = true;
                    for (TypeVariable<Class<?>> genType : type.getTypeParameters()) {
                        if (first) {
                            first = false;
                        } else {
                            it.append(", ");
                        }
                        it.append(genType.getName());
                    }
                    it.append(">");
                }
            }

            private String extractCapacity(Class<? extends Capacity> type) {
                StringBuilder it = new StringBuilder();
                it.append("capacity ").append(type.getSimpleName());
                if (type.getSuperclass() != null && !Capacity.class.equals(type.getSuperclass())) {
                    it.append(" extends ").append(type.getSuperclass().getSimpleName());
                }
                it.append(" {\n");
                ReflectExtensions.appendPublicMethods((StringBuilder)it, (boolean)true, (Class[])new Class[]{type});
                it.append("}");
                return it.toString();
            }

            private String extractEvent(Class<? extends Event> type) {
                StringBuilder it = new StringBuilder();
                it.append("event ").append(type.getSimpleName());
                if (type.getSuperclass() != null && !Event.class.equals(type.getSuperclass())) {
                    it.append(" extends ").append(type.getSuperclass().getSimpleName());
                }
                it.append(" {\n");
                ReflectExtensions.appendPublicFields((StringBuilder)it, (boolean)true, (Class[])new Class[]{type});
                it.append("}");
                return it.toString();
            }

            private String extractInterface(Class<?> type) {
                StringBuilder it = new StringBuilder();
                it.append("interface ").append(type.getSimpleName());
                this.appendGenericTypes(it, type);
                if (type.getSuperclass() != null && !Object.class.equals(type.getSuperclass())) {
                    it.append(" extends ").append(type.getSuperclass().getSimpleName());
                }
                it.append(" {\n");
                ReflectExtensions.appendPublicMethods((StringBuilder)it, (boolean)true, (Class[])new Class[]{type});
                it.append("}");
                return it.toString();
            }

            private String extractEnumeration(Class<?> type) {
                StringBuilder it = new StringBuilder();
                it.append("enum ").append(type.getSimpleName());
                it.append(" {\n");
                for (Object cst : type.getEnumConstants()) {
                    it.append("\t").append(((Enum)cst).name()).append(",\n");
                }
                it.append("}");
                return it.toString();
            }

            private String extractAnnotation(Class<?> type) {
                StringBuilder it = new StringBuilder();
                it.append("annotation ").append(type.getSimpleName());
                it.append(" {\n");
                ReflectExtensions.appendPublicMethods((StringBuilder)it, (boolean)true, (Class[])new Class[]{type});
                it.append("}");
                return it.toString();
            }

            private String extractClass(Class<?> type) {
                StringBuilder it = new StringBuilder();
                it.append("class ").append(type.getSimpleName());
                this.appendGenericTypes(it, type);
                if (type.getSuperclass() != null && !Object.class.equals(type.getSuperclass())) {
                    it.append(" extends ").append(type.getSuperclass().getSimpleName());
                }
                if (type.getInterfaces().length > 0) {
                    if (type.getSuperclass() != null && !Object.class.equals(type.getSuperclass())) {
                        it.append("\n\t\t");
                    } else {
                        it.append(SarlDocumentationParser.DEFAULT_LINE_CONTINUATION);
                    }
                    it.append("implements ");
                    boolean first = true;
                    for (Class<?> interfaceType : type.getInterfaces()) {
                        if (first) {
                            first = false;
                        } else {
                            it.append(", ");
                        }
                        it.append(interfaceType.getSimpleName());
                    }
                }
                it.append(" {\n");
                ReflectExtensions.appendPublicMethods((StringBuilder)it, (boolean)true, (Class[])new Class[]{type});
                it.append("}");
                return it.toString();
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return true;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        REFERENCE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_REFERENCE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return true;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                String format;
                String replacement = 16.getCapturedValue(context, dynamicTag);
                if (!(context.isInBlock() || context.isInParameter() || Strings.isNullOrEmpty((String)(format = context.getInlineCodeFormat())))) {
                    return MessageFormat.format(format, replacement);
                }
                return replacement;
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.SECOND;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        RAW_REFERENCE{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_RAW_REFERENCE_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return true;
            }

            @Override
            public boolean hasParameter() {
                return false;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                return 17.getCapturedValue(context, dynamicTag);
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.SECOND;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        }
        ,
        DEFINITION{

            @Override
            public String getDefaultPattern() {
                return Tag.DEFAULT_DEFINITION_PATTERN;
            }

            @Override
            public boolean hasDynamicName() {
                return true;
            }

            @Override
            public boolean hasParameter() {
                return true;
            }

            @Override
            public boolean isOpeningTag() {
                return false;
            }

            @Override
            public String passThrough(ParsingContext context, String dynamicTag, String parameter, String blockValue) {
                context.declareReplacement(dynamicTag, parameter);
                return parameter;
            }

            @Override
            public boolean isActive(ParsingContext context) {
                return context.isParsing() && context.getStage() == Stage.FIRST;
            }

            @Override
            public boolean isEnclosingSpaceCouldRemovable() {
                return false;
            }

            @Override
            public boolean isInternalTextAsBlockContent() {
                return false;
            }
        };

        static final String DEFAULT_OUTLINE_PATTERN = "\\[:Outline:\\]";
        static final String DEFAULT_INCLUDE_PATTERN = "\\[:Include:\\]";
        static final String DEFAULT_FACT_PATTERN = "\\[:Fact:\\]";
        static final String DEFAULT_DYNAMIC_PATTERN = "\\[:Dynamic:\\]";
        static final String DEFAULT_DYNAMIC_CODE_PATTERN = "\\[:DynamicCode:\\]";
        static final String DEFAULT_ON_PATTERN = "\\[:On\\]";
        static final String DEFAULT_ONHTML_PATTERN = "\\[:OnHtml\\]";
        static final String DEFAULT_CONFIGURE_PATTERN = "\\[:Configure\\]";
        static final String DEFAULT_OFF_PATTERN = "\\[:Off\\]";
        static final String DEFAULT_REFERENCE_PATTERN = "\\[:[a-zA-Z0-9\\._\\-@~]+:\\]";
        static final String DEFAULT_RAW_REFERENCE_PATTERN = "\\[:[a-zA-Z0-9\\._\\-@~]+\\!\\]";
        static final String DEFAULT_DEFINITION_PATTERN = "\\[:[a-zA-Z0-9\\._\\-@~]+\\]";
        static final String DEFAULT_SUCCESS_PATTERN = "\\[:Success:\\](.*?)\\[:End:\\]";
        static final String DEFAULT_FAILURE_PATTERN = "\\[:Failure:\\](.*?)\\[:End:\\]";
        static final String DEFAULT_SHOWTYPE_PATTERN = "\\[:ShowType:\\]";
        static final String DEFAULT_COMMENT_PATTERN = "\\<\\!\\-{3}(.*?)\\-{2}\\>";
        static final String DEFAULT_PARSERON_PATTERN = "\\[:ParserOn\\]";
        static final String DEFAULT_PARSEROFF_PATTERN = "\\[:ParserOff\\]";

        public abstract String getDefaultPattern();

        public abstract boolean hasParameter();

        public abstract boolean hasDynamicName();

        public abstract boolean isOpeningTag();

        public abstract boolean isInternalTextAsBlockContent();

        public abstract String passThrough(ParsingContext var1, String var2, String var3, String var4);

        public abstract boolean isEnclosingSpaceCouldRemovable();

        public abstract boolean isActive(ParsingContext var1);

        protected static String getCapturedValue(ParsingContext context, String tagName) {
            String replacement = null;
            if (!Strings.isNullOrEmpty((String)tagName)) {
                replacement = context.getReplacement(tagName);
                if (replacement == null) {
                    for (Properties provider : context.getParser().getPropertyProvidersByPriority()) {
                        Object obj;
                        if (provider == null || (obj = provider.getOrDefault((Object)tagName, (Object)null)) == null) continue;
                        replacement = obj.toString();
                        break;
                    }
                }
                if (replacement == null) {
                    replacement = System.getProperty(tagName);
                }
                if (replacement == null) {
                    replacement = System.getenv(tagName);
                }
            }
            if (replacement == null) {
                SarlDocumentationParser.reportError(context, Messages.SarlDocumentationParser_4, tagName);
                return null;
            }
            return replacement;
        }
    }

    public static class ParsingContext {
        private Map<String, String> replacements = new TreeMap<String, String>();
        private CharSequence text;
        private Matcher matcher;
        private File currentFile;
        private ParserInterceptor interceptor;
        private String inlineCodeFormat;
        private Functions.Function2<String, String, String> blockCodeFormat;
        private String outlineOutputTag;
        private int startIndex;
        private Stage stage = Stage.FIRST;
        private boolean inParameter;
        private boolean inBlock;
        private boolean isVisibleInblock;
        private boolean isHtmlCodeBlock;
        private boolean forceVisibility;
        private boolean[] isParsing = new boolean[]{true};
        private WeakReference<SarlDocumentationParser> parser;
        private int[] lineno = new int[]{1};
        private int endLineno = 1;
        private int[] offset = new int[]{0};
        private int length;
        private String lineSeparator;
        private String outputLanguage;
        private ScriptExecutor scriptExecutor;
        private boolean isTestingPhase;
        private Boolean deprecationAsError;

        public ParsingContext() {
        }

        public ParsingContext(boolean forceVisibility, boolean isTestingPhase) {
            this.forceVisibility = forceVisibility;
            this.isTestingPhase = isTestingPhase;
        }

        public Boolean isDeprecationIssuesAsErrors() {
            return this.deprecationAsError;
        }

        public void setDeprecationIssuesAsErrors(Boolean state) {
            this.deprecationAsError = state;
        }

        public void setScriptExecutor(ScriptExecutor executor) {
            this.scriptExecutor = executor;
        }

        public ScriptExecutor getScriptExecutor() {
            return this.scriptExecutor;
        }

        public void setOutputLanguage(String outputLanguage) {
            this.outputLanguage = outputLanguage;
        }

        public String getOutputLanguage() {
            return this.outputLanguage;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public void setLineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
        }

        public int getLineNo() {
            return this.lineno[0];
        }

        public void incrementLineNo() {
            this.lineno[0] = this.lineno[0] + 1;
            if (this.lineno[0] > this.endLineno) {
                this.endLineno = this.lineno[0];
            }
        }

        public void incrementLineNo(int amount) {
            if (amount > 0) {
                this.lineno[0] = this.lineno[0] + amount;
                if (this.lineno[0] > this.endLineno) {
                    this.endLineno = this.lineno[0];
                }
            }
        }

        public void setLineNo(int lineno) {
            this.lineno[0] = lineno;
            if (this.lineno[0] > this.endLineno) {
                this.endLineno = this.lineno[0];
            }
        }

        public void setEndLineNo(int lineno) {
            this.endLineno = lineno;
        }

        public int getEndLineNo() {
            return this.endLineno;
        }

        public int getOffset() {
            return this.offset[0];
        }

        public void incrementOffset(int amount) {
            if (amount > 0) {
                this.offset[0] = this.offset[0] + amount;
            }
        }

        public void setOffset(int offset) {
            this.offset[0] = offset;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            return this.interceptor.toString();
        }

        public void setVisibleInBlock(boolean visible) {
            this.isVisibleInblock = visible;
        }

        public boolean isVisible() {
            return !this.isInBlock() || this.isVisibleInblock || this.forceVisibility;
        }

        public void setInHtmlBlock(boolean html) {
            this.isHtmlCodeBlock = html;
        }

        public boolean isInHtmlCodeBlock() {
            return this.isHtmlCodeBlock;
        }

        public boolean isTestingPhase() {
            return this.isTestingPhase;
        }

        public void setParsing(boolean enable) {
            this.isParsing[0] = enable;
        }

        public boolean isParsing() {
            return this.isParsing[0];
        }

        public boolean setInBlock(boolean inblock) {
            boolean old = this.inBlock;
            this.inBlock = inblock;
            return old;
        }

        public boolean isInBlock() {
            return this.inBlock;
        }

        public boolean setInParameter(boolean inparam) {
            boolean old = this.inParameter;
            this.inParameter = inparam;
            return old;
        }

        public boolean isInParameter() {
            return this.inParameter;
        }

        public void linkTo(ParsingContext parentContext) {
            this.replacements = parentContext.replacements;
            this.inBlock = parentContext.inBlock;
            this.isParsing = parentContext.isParsing;
            this.isVisibleInblock = parentContext.isVisibleInblock;
            this.isHtmlCodeBlock = parentContext.isHtmlCodeBlock;
            this.forceVisibility = parentContext.forceVisibility;
            this.isTestingPhase = parentContext.isTestingPhase;
            this.lineno = parentContext.lineno;
            this.offset = parentContext.offset;
            this.scriptExecutor = parentContext.scriptExecutor;
            this.deprecationAsError = parentContext.deprecationAsError;
        }

        public void propagateTo(ParsingContext parentContext) {
            parentContext.isHtmlCodeBlock = this.isHtmlCodeBlock;
            if (this.deprecationAsError != null) {
                parentContext.deprecationAsError = this.deprecationAsError;
            }
        }

        public void declareReplacement(String id, String to) {
            this.replacements.put(id, to);
        }

        public String getReplacement(String id) {
            return this.replacements.get(id);
        }

        protected void setStage(Stage stage) {
            assert (stage != null);
            this.stage = stage;
        }

        public Stage getStage() {
            return this.stage;
        }

        protected void setText(CharSequence text) {
            this.text = text;
        }

        public CharSequence getText() {
            return this.text;
        }

        protected void setParser(SarlDocumentationParser parser) {
            this.parser = new WeakReference<SarlDocumentationParser>(parser);
        }

        public SarlDocumentationParser getParser() {
            return (SarlDocumentationParser)this.parser.get();
        }

        protected void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        protected void setInlineCodeFormat(String format) {
            this.inlineCodeFormat = format;
        }

        public String getInlineCodeFormat() {
            return this.inlineCodeFormat;
        }

        protected void setBlockCodeFormat(Functions.Function2<String, String, String> format) {
            this.blockCodeFormat = format;
        }

        public Functions.Function2<String, String, String> getBlockCodeFormat() {
            return this.blockCodeFormat;
        }

        public Functions.Function2<String, String, String> getBlockCodeFormatHtmlCodeBlock() {
            if (this.isInHtmlCodeBlock()) {
                return (languageName, content) -> {
                    StringBuilder result = new StringBuilder();
                    result.append("<pre><code");
                    if (!Strings.isNullOrEmpty((String)languageName)) {
                        result.append(" class=\"language-").append(languageName.toLowerCase()).append("\"");
                    }
                    result.append(">\n").append((String)content).append("</code></pre>\n");
                    return result.toString();
                };
            }
            return this.getBlockCodeFormat();
        }

        protected void setOutlineOutputTag(String tag) {
            this.outlineOutputTag = tag;
        }

        public String getOutlineOutputTag() {
            return this.outlineOutputTag;
        }

        protected void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        protected void setCurrentFile(File file) {
            this.currentFile = file;
        }

        public File getCurrentDirectory() {
            return this.currentFile.getParentFile();
        }

        public File getCurrentFile() {
            return this.currentFile;
        }

        protected void setParserInterceptor(ParserInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public ParserInterceptor getParserInterceptor() {
            return this.interceptor;
        }
    }

    public static enum Stage {
        FIRST{

            @Override
            public Stage next() {
                return SECOND;
            }
        }
        ,
        SECOND{

            @Override
            public Stage next() {
                return null;
            }
        };


        public static Stage first() {
            return FIRST;
        }

        public abstract Stage next();
    }

    private static class ContentParserInterceptor
    extends DelegateParserInterceptor {
        final StringBuffer buffer = new StringBuffer();

        ContentParserInterceptor(ParserInterceptor delegate) {
            ParserInterceptor del = delegate;
            while (del instanceof ContentParserInterceptor) {
                ContentParserInterceptor cvalue = (ContentParserInterceptor)del;
                del = cvalue.getDelegate();
            }
            this.setDelegate(del);
        }

        ContentParserInterceptor() {
        }

        public String toString() {
            return this.getResult();
        }

        public String getResult() {
            return this.buffer.toString();
        }

        private StringBuffer getVisibleBuffer(boolean isVisible) {
            return isVisible ? this.buffer : new StringBuffer();
        }

        @Override
        public void closeContext(ParsingContext context) {
            context.getMatcher().appendTail(this.getVisibleBuffer(context.isVisible()));
        }

        @Override
        public void tag(ParsingContext context, Tag tag, String dynamicName, String parameter, String blockValue) {
            try {
                boolean isVisible = context.isVisible();
                String replacement = tag.passThrough(context, dynamicName, parameter, blockValue);
                context.getMatcher().appendReplacement(this.getVisibleBuffer(isVisible), replacement);
                super.tag(context, tag, dynamicName, parameter, blockValue);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Invalid regex for tag: " + tag.toString() + "; and dynamic name: " + dynamicName, ex);
            }
        }
    }

    public static interface ParserInterceptor {
        default public void openContext(ParsingContext context) {
        }

        default public void closeContext(ParsingContext context) {
        }

        default public void tag(ParsingContext context, Tag tag, String dynamicName, String parameter, String blockValue) {
        }

        default public void outline(ParsingContext context) {
        }
    }

    public static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = 6654436628872799744L;
        private final File file;
        private final int lineno;

        public ParsingException(String message, File file, int lineno) {
            super(message);
            this.file = file;
            this.lineno = lineno;
        }

        public ParsingException(String message, File file, int lineno, Throwable cause) {
            super(message, cause);
            this.file = file;
            this.lineno = lineno;
        }

        public File getFile() {
            return this.file;
        }

        public int getLineno() {
            return this.lineno;
        }
    }

    public static class DelegateParserInterceptor
    implements ParserInterceptor {
        private ParserInterceptor delegate;

        public DelegateParserInterceptor() {
        }

        public DelegateParserInterceptor(ParserInterceptor delegate) {
            this.delegate = delegate;
        }

        public void setDelegate(ParserInterceptor delegate) {
            this.delegate = delegate;
        }

        public ParserInterceptor getDelegate() {
            return this.delegate;
        }

        @Override
        public void openContext(ParsingContext context) {
            ParserInterceptor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.openContext(context);
            }
        }

        @Override
        public void closeContext(ParsingContext context) {
            ParserInterceptor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.closeContext(context);
            }
        }

        @Override
        public void tag(ParsingContext context, Tag tag, String dynamicName, String parameter, String blockValue) {
            ParserInterceptor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.tag(context, tag, dynamicName, parameter, blockValue);
            }
        }

        @Override
        public void outline(ParsingContext context) {
            ParserInterceptor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.outline(context);
            }
        }
    }
}

