/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.generator.parser;

import java.text.MessageFormat;
import java.util.LinkedList;

public class SectionNumber {
    public static final String DEFAULT_SECTION_NUMBER_FORMAT = "{0}.{1}";
    private final LinkedList<Integer> numbers = new LinkedList();

    public SectionNumber() {
        this.numbers.add(0);
    }

    public void setFromString(String sectionNumber, int level) {
        int i;
        assert (level >= 1);
        String[] numbers = sectionNumber.split("[^0-9]+");
        int len = Math.max(0, this.numbers.size() - numbers.length);
        for (i = 0; i < len; ++i) {
            this.numbers.removeLast();
        }
        for (i = 0; i < numbers.length && i < level; ++i) {
            this.numbers.addLast(Integer.valueOf(numbers[i]));
        }
    }

    public void increment(int level) {
        assert (level >= 1);
        if (this.numbers.size() < level) {
            do {
                this.numbers.addLast(0);
            } while (this.numbers.size() < level);
        } else if (this.numbers.size() > level) {
            do {
                this.numbers.removeLast();
            } while (this.numbers.size() > level);
        }
        assert (this.numbers.size() == level);
        int previousSection = this.numbers.removeLast();
        this.numbers.addLast(previousSection + 1);
    }

    public String toString() {
        return this.toString(DEFAULT_SECTION_NUMBER_FORMAT);
    }

    public String toString(String format) {
        String str = null;
        for (Integer nb : this.numbers) {
            if (str == null) {
                str = nb.toString();
                continue;
            }
            str = MessageFormat.format(format, str, nb.toString());
        }
        return str;
    }
}

