/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CollectionExtensions {
    private CollectionExtensions() {
    }

    public static <T extends Comparable<?>> T[] sort(T[] array) throws Exception {
        if (array == null) {
            return null;
        }
        Object[] copy = (Comparable[])Arrays.copyOf(array, array.length);
        Arrays.sort(copy);
        return copy;
    }

    public static Class<?>[] sort(Class<?>[] array) throws Exception {
        if (array == null) {
            return null;
        }
        Class<?>[] copy = Arrays.copyOf(array, array.length);
        Arrays.sort(copy, (a, b) -> {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.getName().compareTo(b.getName());
        });
        return copy;
    }

    public static Class<?>[] sortOnSimpleName(Class<?>[] array) throws Exception {
        if (array == null) {
            return null;
        }
        Class<?>[] copy = Arrays.copyOf(array, array.length);
        Arrays.sort(copy, (a, b) -> {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.getSimpleName().compareTo(b.getSimpleName());
        });
        return copy;
    }

    public static List<List<String>> toHorizontalStringMatrix(Object value) throws Exception {
        Object element;
        List input;
        List<List<String>> list = null;
        if (value instanceof Class[]) {
            Class[] cvalue = (Class[])value;
            list = CollectionExtensions._toHorizontalStringMatrix(cvalue);
        } else if (value instanceof List && !(input = (List)value).isEmpty() && (element = Iterables.find((Iterable)input, it -> it != null)) instanceof Class) {
            list = CollectionExtensions._toHorizontalStringMatrix(input);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    protected static List<List<String>> _toHorizontalStringMatrix(List<Class<?>> value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (Class<?> type : value) {
            list.add(type.getName());
        }
        return Collections.singletonList(list);
    }

    protected static List<List<String>> _toHorizontalStringMatrix(Class<?>[] value) throws Exception {
        return CollectionExtensions._toHorizontalStringMatrix(Arrays.asList(value));
    }

    public static List<List<String>> toVerticalStringMatrix(Object value) throws Exception {
        Object element;
        List input;
        List<List<String>> list = null;
        if (value instanceof Class[]) {
            Class[] cvalue = (Class[])value;
            list = CollectionExtensions._toVerticalStringMatrix(cvalue);
        } else if (value instanceof List && !(input = (List)value).isEmpty() && (element = Iterables.find((Iterable)input, it -> it != null)) instanceof Class) {
            list = CollectionExtensions._toVerticalStringMatrix(input);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    protected static List<List<String>> _toVerticalStringMatrix(List<Class<?>> value) throws Exception {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Class<?> type : value) {
            list.add(Collections.singletonList(type.getName()));
        }
        return list;
    }

    protected static List<List<String>> _toVerticalStringMatrix(Class<?>[] value) throws Exception {
        return CollectionExtensions._toVerticalStringMatrix(Arrays.asList(value));
    }
}

