/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.inject.ImplementedBy;
import io.sarl.lang.typesystem.IPureOperationNameValidator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

public final class FactExtensions {
    private static IPureOperationNameValidator nameValidator;

    private FactExtensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IPureOperationNameValidator getOperationNameValidator() {
        Class<FactExtensions> clazz = FactExtensions.class;
        synchronized (FactExtensions.class) {
            if (nameValidator == null) {
                ImplementedBy anno = IPureOperationNameValidator.class.getAnnotation(ImplementedBy.class);
                assert (anno != null);
                try {
                    nameValidator = (IPureOperationNameValidator)anno.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new Error(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return nameValidator;
        }
    }

    public static Field findField(Class<?> type, Functions.Function3<Class<?>, Field, Boolean, Boolean> matcher) {
        if (matcher != null) {
            for (Field field : type.getDeclaredFields()) {
                boolean deprecated;
                Deprecated deprecatedAnnotation = field.getAnnotation(Deprecated.class);
                boolean bl = deprecated = deprecatedAnnotation != null;
                if (!((Boolean)matcher.apply(type, (Object)field, (Object)deprecated)).booleanValue()) continue;
                return field;
            }
        }
        return null;
    }

    public static boolean allFields(Class<?> type, Functions.Function3<Class<?>, Field, Boolean, Boolean> matcher) {
        if (matcher != null) {
            for (Field field : type.getDeclaredFields()) {
                boolean deprecated;
                Deprecated deprecatedAnnotation = field.getAnnotation(Deprecated.class);
                boolean bl = deprecated = deprecatedAnnotation != null;
                if (((Boolean)matcher.apply(type, (Object)field, (Object)deprecated)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean similarTo(Iterable<?> iter1, Iterable<?> iter2) {
        Iterator<?> iterator1 = iter1.iterator();
        Iterator<?> iterator2 = iter2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Object obj2;
            Object obj1 = iterator1.next();
            if (Objects.equals(obj1, obj2 = iterator2.next())) continue;
            return false;
        }
        return iterator1.hasNext() == iterator2.hasNext();
    }

    public static boolean similarTo(Map<?, ?> map1, Map<?, ?> map2) {
        HashMap m1 = new HashMap(map1);
        HashMap m2 = new HashMap(map2);
        Iterator<Map.Entry<?, ?>> iterator1 = m1.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<?, ?> entry = iterator1.next();
            iterator1.remove();
            if (!m2.containsKey(entry.getKey())) {
                return false;
            }
            Object v = m2.remove(entry.getKey());
            if (Objects.equals(entry.getValue(), v)) continue;
            return false;
        }
        return m1.isEmpty() == m2.isEmpty();
    }

    public static boolean isPureFunctionPrototype(Class<?> type, String name, Class<?> ... parameters) {
        Method method;
        try {
            method = type.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
        if (method.getAnnotation(Pure.class) != null) {
            return true;
        }
        if (FactExtensions.getOperationNameValidator().isNamePatternForNotPureOperation(method.getName())) {
            return false;
        }
        return FactExtensions.getOperationNameValidator().isNamePatternForPureOperation(method.getName());
    }
}

