/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.sarl.docs.validator.DocumentationLogger;
import io.sarl.docs.validator.Messages;
import io.sarl.lang.validation.SyntaxIssueCodes;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.json.JsonBuffer;
import org.arakhne.afc.vmutil.json.JsonableObject;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.validation.IssueCodes;

public final class IssueDatabaseExtensions {
    private static String DEFAULT_ISSUE_DESCRIPTION_FILENAME = "issue_descriptions.json";
    private static String DEFAULT_SARL_ISSUE_DESCRIPTION_FILENAME = "issue_descriptions_sarl.json";
    private static String DEFAULT_XTEND_ISSUE_DESCRIPTION_FILENAME = "issue_descriptions_xtend.json";
    private static String DEFAULT_XBASE_ISSUE_DESCRIPTION_FILENAME = "issue_descriptions_xbase.json";
    private static String DEFAULT_XTEXT_ISSUE_DESCRIPTION_FILENAME = "issue_descriptions_xtext.json";
    private static final String[] MESSAGES_TO_IGNORE = new String[]{"AbstractSARLSubValidator_3", "AbstractSARLSubValidator_4", "AbstractSARLSubValidator_5", "AbstractSARLSubValidator_6", "AbstractSARLSubValidator_7", "AbstractSARLSubValidator_8", "SARLBehaviorUnitValidator_10", "SARLFeatureModifierValidator_1", "SARLFeatureModifierValidator_3", "SARLFeatureModifierValidator_11", "SARLInheritanceValidator_4", "SARLInheritanceValidator_5", "SARLMemberValidator_4", "SARLMemberValidator_5", "SARLMemberValidator_31", "SARLMemberValidator_32", "SARLModifierValidator_4", "SARLModifierValidator_5", "SARLNamingValidator_3", "SARLNamingValidator_7", "SARLNamingValidator_8"};
    private static final String HIDDEN_STRING = "****";

    @Pure
    public static List<IssueDescription> readIssueDescriptionsFromSarlJsonFiles() {
        ArrayList<IssueDescription> props = new ArrayList<IssueDescription>();
        IssueDatabaseExtensions.readIssueDescriptions(DEFAULT_SARL_ISSUE_DESCRIPTION_FILENAME, props);
        IssueDatabaseExtensions.readIssueDescriptions(DEFAULT_XTEND_ISSUE_DESCRIPTION_FILENAME, props);
        IssueDatabaseExtensions.readIssueDescriptions(DEFAULT_XBASE_ISSUE_DESCRIPTION_FILENAME, props);
        IssueDatabaseExtensions.readIssueDescriptions(DEFAULT_XTEXT_ISSUE_DESCRIPTION_FILENAME, props);
        return props;
    }

    @Pure
    public static List<IssueDescription> readIssueDescriptionsFromDefaultJsonFile() {
        ArrayList<IssueDescription> props = new ArrayList<IssueDescription>();
        IssueDatabaseExtensions.readIssueDescriptions(DEFAULT_ISSUE_DESCRIPTION_FILENAME, props);
        return props;
    }

    @Pure
    public static List<IssueDescription> readIssueDescriptions(String filename) {
        ArrayList<IssueDescription> props = new ArrayList<IssueDescription>();
        IssueDatabaseExtensions.readIssueDescriptions(filename, props);
        DocumentationLogger.getLogger().info(MessageFormat.format(Messages.IssueDatabaseExtensions_7, props.size(), filename));
        return props;
    }

    public static void readIssueDescriptions(String filename, List<IssueDescription> descriptions) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            File folder = FileSystem.convertStringToFile((String)System.getProperty("SARL_DOC_CURRENT_FOLDER"));
            assert (folder != null) : "Folder not found in system properties: SARL_DOC_CURRENT_FOLDER";
            file = FileSystem.makeAbsolute((File)file, (File)folder);
            IssueDatabaseExtensions.readIssueDescriptions(file, descriptions);
        }
    }

    @Pure
    public static List<IssueDescription> readIssueDescriptions(File filename) {
        ArrayList<IssueDescription> props = new ArrayList<IssueDescription>();
        IssueDatabaseExtensions.readIssueDescriptions(filename, props);
        DocumentationLogger.getLogger().info(MessageFormat.format(Messages.IssueDatabaseExtensions_7, props.size(), filename.getName()));
        return props;
    }

    public static void readIssueDescriptions(File filename, List<IssueDescription> descriptions) {
        Gson gson = new Gson();
        try (FileReader stream = new FileReader(filename);){
            JsonReader reader = gson.newJsonReader((Reader)stream);
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                String code = null;
                String message = null;
                String cause = null;
                String solution = null;
                String levelStr = null;
                boolean checkJavaDef = true;
                block24: while (reader.hasNext()) {
                    String name = reader.nextName();
                    switch (Strings.emptyIfNull((String)name)) {
                        case "code": {
                            code = reader.nextString();
                            continue block24;
                        }
                        case "message": {
                            message = reader.nextString();
                            continue block24;
                        }
                        case "cause": {
                            cause = reader.nextString();
                            continue block24;
                        }
                        case "solution": {
                            solution = reader.nextString();
                            continue block24;
                        }
                        case "level": {
                            levelStr = reader.nextString();
                            continue block24;
                        }
                        case "ignoreMessageCheck": {
                            checkJavaDef = !reader.nextBoolean();
                            continue block24;
                        }
                    }
                    reader.skipValue();
                }
                reader.endObject();
                if (Strings.isEmpty(code)) continue;
                IssueLevel level = null;
                String delegate = null;
                IssueLevel defaultLevel = null;
                level = IssueLevel.fromJson(levelStr);
                if (level == null) {
                    throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_0, code, levelStr));
                }
                if (level == IssueLevel.DELEGATE && Strings.isEmpty((String)(delegate = level.getDelegate(levelStr)))) {
                    throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_1, code, levelStr));
                }
                if ((level == IssueLevel.CONFIGURABLE || level == IssueLevel.DELEGATE) && (defaultLevel = level.getDefaultLevel(levelStr)) == null) {
                    throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_2, code, levelStr));
                }
                if (level != IssueLevel.IGNORE) {
                    if (Strings.isEmpty((String)message)) {
                        throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_3, code));
                    }
                    if (Strings.isEmpty((String)cause)) {
                        throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_4, code));
                    }
                    if (Strings.isEmpty((String)levelStr)) {
                        throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_5, code));
                    }
                }
                IssueDescription description = new IssueDescription(code);
                description.message = message;
                description.cause = cause;
                description.solution = solution;
                description.level = level;
                description.delegate = Strings.isEmpty((String)delegate) ? null : delegate;
                description.defaultLevel = defaultLevel;
                description.javaMessageDefinitionCheck = checkJavaDef;
                descriptions.add(description);
            }
            reader.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format(Messages.IssueDatabaseExtensions_6, e.getLocalizedMessage()), e);
        }
    }

    @Pure
    public static List<List<String>> asTable(List<IssueDescription> descriptions) {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        int major = 0;
        int minor = 1;
        IssueDescription prevIssue = null;
        for (int i = 0; i < descriptions.size(); ++i) {
            IssueDescription description = descriptions.get(i);
            if (description.level == IssueLevel.IGNORE) continue;
            ArrayList<String> columns = new ArrayList<String>();
            if (Strings.equal((String)(prevIssue == null ? null : prevIssue.getCode()), (String)description.getCode())) {
                ++minor;
            } else {
                ++major;
                minor = 1;
            }
            IssueDescription nextIssue = i < descriptions.size() - 1 ? descriptions.get(i + 1) : null;
            columns.add(IssueDatabaseExtensions.formatIndex(major, minor, prevIssue, description, nextIssue));
            StringBuilder msg = new StringBuilder();
            msg.append(IssueDatabaseExtensions.head(Messages.IssueDatabaseExtensions_8)).append(description.message).append(IssueDatabaseExtensions.nl());
            msg.append(IssueDatabaseExtensions.head(Messages.IssueDatabaseExtensions_9)).append(description.cause);
            if (!Strings.isEmpty((String)description.solution)) {
                msg.append(IssueDatabaseExtensions.nl()).append(IssueDatabaseExtensions.head(Messages.IssueDatabaseExtensions_10)).append(description.solution);
            }
            if (!Strings.isEmpty((String)description.delegate)) {
                msg.append(IssueDatabaseExtensions.nl()).append(IssueDatabaseExtensions.head(Messages.IssueDatabaseExtensions_11)).append(description.delegate);
            }
            columns.add(msg.toString());
            columns.add(description.level.getLabel(description.delegate, description.defaultLevel));
            StringBuilder code = new StringBuilder();
            code.append("[");
            code.append(description.getShortDisplayCode());
            code.append("](: \"");
            code.append(description.getLongDisplayCode());
            code.append("\")");
            columns.add(code.toString());
            content.add(columns);
            prevIssue = description;
        }
        DocumentationLogger.getLogger().info(MessageFormat.format(Messages.IssueDatabaseExtensions_12, descriptions.size(), major));
        return content;
    }

    private static String formatIndex(int major, int minor, IssueDescription prevIssue, IssueDescription currentIssue, IssueDescription nextIssue) {
        String ncode;
        String pcode = prevIssue == null ? null : prevIssue.getCode();
        String ccode = currentIssue == null ? null : currentIssue.getCode();
        String string = ncode = nextIssue == null ? null : nextIssue.getCode();
        if (Strings.equal((String)pcode, (String)ccode) || Strings.equal((String)ccode, (String)ncode)) {
            char c = (char)(97 + (minor - 1));
            return major + Character.toString(c);
        }
        return Integer.toString(major);
    }

    @Pure
    public static List<IssueDescription> sort(List<IssueDescription> descriptions) {
        descriptions.sort((a, b) -> {
            int cmp = a.getShortDisplayCode().compareToIgnoreCase(b.getShortDisplayCode());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getCodePrefix().compareToIgnoreCase(b.getCodePrefix());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getSortLevel().compareTo(b.getSortLevel());
            if (cmp != 0) {
                return cmp;
            }
            return a.message.compareToIgnoreCase(b.message);
        });
        return descriptions;
    }

    private static String head(String value) {
        return "**" + value + "** ";
    }

    private static String nl() {
        return "\n";
    }

    @Pure
    public static List<IssueDescription> validateSarlIssueCodes(List<IssueDescription> descriptions) {
        Set<String> definedCodes = IssueDatabaseExtensions.buildSarlIssueCodeList();
        DocumentationLogger.getLogger().info(MessageFormat.format(Messages.IssueDatabaseExtensions_13, definedCodes.size()));
        if (!IssueDatabaseExtensions.validateIssueCodes(descriptions, definedCodes, "SARL")) {
            throw new IllegalStateException(Messages.IssueDatabaseExtensions_14);
        }
        return descriptions;
    }

    private static boolean validateIssueCodes(List<IssueDescription> descriptions, Set<String> definedCodes, String label) {
        boolean success = true;
        TreeSet<String> notDocumentedCodes = new TreeSet<String>();
        notDocumentedCodes.addAll(definedCodes);
        for (IssueDescription description : descriptions) {
            notDocumentedCodes.remove(description.getCode());
            if (definedCodes.contains(description.getCode())) continue;
            success = false;
            DocumentationLogger.getLogger().severe(MessageFormat.format(Messages.IssueDatabaseExtensions_15, description.getCode(), label));
        }
        if (!success) {
            return false;
        }
        for (String notDocumentedCode : notDocumentedCodes) {
            success = false;
            DocumentationLogger.getLogger().severe(MessageFormat.format(Messages.IssueDatabaseExtensions_16, notDocumentedCode, label));
        }
        return success;
    }

    @Pure
    public static List<IssueDescription> validate(List<IssueDescription> descriptions, Collection<Class<?>> issueListList, String sourceName) {
        Set<String> definedCodes = IssueDatabaseExtensions.buildIssueCodeList(issueListList);
        DocumentationLogger.getLogger().info(MessageFormat.format(Messages.IssueDatabaseExtensions_17, definedCodes.size()));
        if (!IssueDatabaseExtensions.validateIssueCodes(descriptions, definedCodes, sourceName)) {
            throw new IllegalStateException(MessageFormat.format(Messages.IssueDatabaseExtensions_18, sourceName));
        }
        return descriptions;
    }

    private static Set<String> buildIssueCodeList(Collection<Class<?>> types) {
        TreeSet<String> codes = new TreeSet<String>();
        for (Class<?> type : types) {
            IssueDatabaseExtensions.extractIssueCodes(type, codes);
        }
        return codes;
    }

    private static void extractIssueCodes(Class<?> definitions, Set<String> codes) {
        for (Field field : definitions.getDeclaredFields()) {
            if (!String.class.equals(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                String value = (String)field.get(null);
                if (Strings.isEmpty((String)value) || value.endsWith(".")) continue;
                codes.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Set<String> buildSarlIssueCodeList() {
        TreeSet<String> codes = new TreeSet<String>();
        IssueDatabaseExtensions.extractIssueCodes(io.sarl.lang.validation.IssueCodes.class, codes);
        IssueDatabaseExtensions.extractIssueCodes(org.eclipse.xtend.core.validation.IssueCodes.class, codes);
        IssueDatabaseExtensions.extractIssueCodes(IssueCodes.class, codes);
        IssueDatabaseExtensions.extractIssueCodes(org.eclipse.xtext.validation.IssueCodes.class, codes);
        IssueDatabaseExtensions.extractIssueCodes(SyntaxIssueCodes.class, codes);
        codes.add("org.eclipse.xtext.diagnostics.Diagnostic.Syntax");
        codes.add("org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range");
        codes.add("org.eclipse.xtext.diagnostics.Diagnostic.Linking");
        return codes;
    }

    private static Set<String> buildSarlIssueMessageSourceList() {
        TreeSet<String> codes = new TreeSet<String>();
        IssueDatabaseExtensions.extractIssueMessages(io.sarl.lang.validation.Messages.class, codes, new String[0]);
        IssueDatabaseExtensions.extractIssueMessages(io.sarl.lang.validation.subvalidators.Messages.class, codes, MESSAGES_TO_IGNORE);
        return codes;
    }

    private static void extractIssueMessages(Class<?> definitions, Set<String> messages, String ... ignorableLabels) {
        TreeSet<String> ignore = new TreeSet<String>(Arrays.asList(ignorableLabels));
        Pattern regex = Pattern.compile("^[a-zA-Z0-9_]+_[0-9]+$");
        for (Field field : definitions.getDeclaredFields()) {
            Matcher matcher;
            if (!String.class.equals(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !ignore.isEmpty() && ignore.contains(field.getName()) || !(matcher = regex.matcher(field.getName())).find()) continue;
            try {
                String value = (String)field.get(null);
                if (Strings.isEmpty((String)value)) continue;
                messages.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Pure
    public static boolean validateSarlIssueMessages(List<IssueDescription> descriptions) {
        Set<String> definedMessages = IssueDatabaseExtensions.buildSarlIssueMessageSourceList();
        Logger logger = DocumentationLogger.getLogger();
        logger.info(MessageFormat.format(Messages.IssueDatabaseExtensions_30, definedMessages.size()));
        Pattern patternSelection0 = Pattern.compile("\\*+[^*]+\\*+");
        Set documentedMessages = descriptions.stream().filter(it -> it.javaMessageDefinitionCheck).map(it -> IssueDatabaseExtensions.canonicalMessage(it.message, patternSelection0)).collect(Collectors.toSet());
        Integer count = definedMessages.size();
        int i = 1;
        for (String dm : definedMessages) {
            String definedMessage = IssueDatabaseExtensions.canonicalMessage(dm);
            if (!documentedMessages.remove(definedMessage)) {
                throw new RuntimeException(MessageFormat.format(Messages.IssueDatabaseExtensions_31, dm, definedMessage, i, count));
            }
            ++i;
        }
        if (!documentedMessages.isEmpty()) {
            if (documentedMessages.size() > 1) {
                StringBuilder buffer = new StringBuilder();
                for (String message : documentedMessages) {
                    if (Strings.isEmpty((String)message)) continue;
                    buffer.append(message).append("\n");
                }
                DocumentationLogger.getLogger().warning(MessageFormat.format(Messages.IssueDatabaseExtensions_33, buffer.toString()));
            } else {
                DocumentationLogger.getLogger().warning(MessageFormat.format(Messages.IssueDatabaseExtensions_32, documentedMessages.iterator().next()));
            }
        }
        return true;
    }

    private static String canonicalMessage(String message, Pattern pattern) {
        if (!Strings.isEmpty((String)message)) {
            Matcher matcher = pattern.matcher(message);
            return matcher.replaceAll(HIDDEN_STRING);
        }
        return message;
    }

    private static String canonicalMessage(String message) {
        if (!Strings.isEmpty((String)message) && message.contains("{")) {
            return MessageFormat.format(message, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING, HIDDEN_STRING).replaceAll(Pattern.quote(HIDDEN_STRING) + "(" + Pattern.quote(HIDDEN_STRING) + ")+", HIDDEN_STRING);
        }
        return message;
    }

    public static enum IssueLevel {
        ERROR{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                return "error";
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                return Messages.IssueDatabaseExtensions_19;
            }

            @Override
            public String getDelegate(String json) {
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                return null;
            }
        }
        ,
        WARNING{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                return "warning";
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                return Messages.IssueDatabaseExtensions_20;
            }

            @Override
            public String getDelegate(String json) {
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                return null;
            }
        }
        ,
        INFO{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                return "info";
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                return Messages.IssueDatabaseExtensions_21;
            }

            @Override
            public String getDelegate(String json) {
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                return null;
            }
        }
        ,
        IGNORE{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                return "ignore";
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                return Messages.IssueDatabaseExtensions_22;
            }

            @Override
            public String getDelegate(String json) {
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                return null;
            }
        }
        ,
        CONFIGURABLE{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                return "c/" + defaultLevel.toLowerCase();
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                if (defaultLevel != null) {
                    return MessageFormat.format(Messages.IssueDatabaseExtensions_23, defaultLevel.getLabel(null, null));
                }
                return Messages.IssueDatabaseExtensions_24;
            }

            @Override
            public String getDelegate(String json) {
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                try {
                    if (json.startsWith("c/")) {
                        return 5.fromJson(json.substring(2));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }
        ,
        DELEGATE{

            @Override
            public String toJson(String delegate, String defaultLevel) {
                assert (delegate != null);
                return "d/" + delegate + "/" + defaultLevel.toLowerCase();
            }

            @Override
            public String getLabel(String delegate, IssueLevel defaultLevel) {
                if (defaultLevel != null) {
                    return MessageFormat.format(Messages.IssueDatabaseExtensions_25, defaultLevel.getLabel(null, null));
                }
                return Messages.IssueDatabaseExtensions_26;
            }

            @Override
            public String getDelegate(String json) {
                try {
                    int idx;
                    if (json.startsWith("d/") && (idx = json.indexOf(47, 2)) > 2) {
                        return json.substring(2, idx);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public IssueLevel getDefaultLevel(String json) {
                try {
                    int idx;
                    if (json.startsWith("d/") && (idx = json.indexOf(47, 2)) >= 2 && idx < json.length() - 1) {
                        return 6.fromJson(json.substring(idx + 1));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        };


        public abstract String toJson(String var1, String var2);

        public static IssueLevel fromJson(String label) {
            try {
                if (label.startsWith("c/")) {
                    return CONFIGURABLE;
                }
                if (label.startsWith("d/")) {
                    return DELEGATE;
                }
                return IssueLevel.valueOf(label.toUpperCase());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public abstract String getDelegate(String var1);

        public abstract IssueLevel getDefaultLevel(String var1);

        public abstract String getLabel(String var1, IssueLevel var2);
    }

    public static final class IssueDescription
    implements JsonableObject {
        private final String rawCode;
        private final String shortDisplayCode;
        public String message;
        public String cause;
        public String solution;
        public IssueLevel level;
        public String delegate;
        public IssueLevel defaultLevel;
        public boolean javaMessageDefinitionCheck = true;

        IssueDescription(String code) {
            int lastIndex = code.lastIndexOf(46);
            this.rawCode = code.replaceAll(Pattern.quote("&dot;"), ".");
            this.shortDisplayCode = lastIndex >= 0 && lastIndex < code.length() - 1 ? code.substring(lastIndex + 1).replaceAll(Pattern.quote("&dot;"), ".") : code;
        }

        public String toString() {
            JsonBuffer buf = new JsonBuffer();
            this.toJson(buf);
            return buf.toString();
        }

        public void toJson(JsonBuffer buf) {
            buf.add("rawCode", (Object)this.rawCode);
            buf.add("displayCode", (Object)this.shortDisplayCode);
            buf.add("message", (Object)this.message);
            buf.add("cause", (Object)this.cause);
            buf.add("solving", (Object)this.solution);
            String substring = this.level.toJson(this.delegate, this.defaultLevel == null ? null : this.defaultLevel.toJson(null, null));
            buf.add("level", (Object)substring);
        }

        public String getCode() {
            return this.rawCode;
        }

        public String getCodePrefix() {
            int lastIndex = this.rawCode.lastIndexOf(46);
            if (lastIndex > 0) {
                return this.rawCode.substring(0, lastIndex);
            }
            return "";
        }

        public String getShortDisplayCode() {
            return this.shortDisplayCode;
        }

        public String getLongDisplayCode() {
            return this.rawCode;
        }

        private IssueLevel getSortLevel() {
            if (this.level == IssueLevel.CONFIGURABLE) {
                return this.defaultLevel;
            }
            return this.level;
        }
    }
}

