/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import io.sarl.docs.validator.MarkdownEmptyArrayException;
import io.sarl.lang.core.util.CliUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class MarkdownExtensions {
    private MarkdownExtensions() {
    }

    public static String renderToMarkdown(Object options) {
        if (options instanceof Options) {
            Options cvalue = (Options)options;
            return MarkdownExtensions._renderToMarkdown(cvalue);
        }
        if (options instanceof List) {
            List rootList = (List)options;
            if (!rootList.isEmpty()) {
                Object element = rootList.get(0);
                if (element instanceof List) {
                    return MarkdownExtensions._renderToMarkdown((List)options);
                }
            } else {
                return MarkdownExtensions._renderToMarkdown((List)options);
            }
        }
        return "";
    }

    protected static String _renderToMarkdown(Options options) {
        if (options == null) {
            return "";
        }
        ArrayList optList = new ArrayList(options.getOptions());
        if (optList.isEmpty()) {
            return "";
        }
        Collections.sort(optList, new OptionComparator());
        StringBuilder buffer = new StringBuilder();
        for (Option option : optList) {
            buffer.append("| `");
            if (option.getOpt() == null) {
                buffer.append(CliUtilities.getCommandLineOption((String)option.getLongOpt()));
            } else {
                buffer.append(CliUtilities.getCommandLineOption((String)option.getOpt()));
                if (option.hasLongOpt()) {
                    buffer.append("`, `");
                    buffer.append(CliUtilities.getCommandLineOption((String)option.getLongOpt()));
                }
            }
            if (option.hasArg() && option.hasArgName()) {
                buffer.append(" <").append(option.getArgName()).append(">");
            }
            buffer.append("` | ");
            if (option.getDescription() != null) {
                String text = option.getDescription().replaceAll("[ \t\n\r\f]+", " ");
                text = text.replaceAll("\\<", "&lt;");
                text = text.replaceAll("\\>", "&gt;");
                buffer.append(text);
            }
            buffer.append(" |\n");
        }
        return buffer.toString();
    }

    protected static String _renderToMarkdown(List<List<String>> table) {
        if (table == null || table.isEmpty()) {
            throw new MarkdownEmptyArrayException();
        }
        StringBuilder buffer = new StringBuilder();
        for (List<String> line : table) {
            buffer.append("| ");
            if (line != null) {
                boolean first = true;
                for (String column : line) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(" | ");
                    }
                    if (column == null) continue;
                    String text = column;
                    text = text.replaceAll("\\<", "&lt;");
                    text = text.replaceAll("\\>", "&gt;");
                    text = text.replaceAll("\n+", "<br>");
                    text = text.replaceAll("[ \t\r\f]+", " ");
                    text = text.replaceAll(Pattern.quote("&p.lt;"), "<");
                    text = text.replaceAll(Pattern.quote("&p.gt;"), ">");
                    buffer.append(text);
                }
            }
            buffer.append(" |\n");
        }
        return buffer.toString();
    }

    private static class OptionComparator
    implements Comparator<Option> {
        OptionComparator() {
        }

        private static String getKey(Option opt) {
            String val = opt.getLongOpt();
            if (val == null) {
                return opt.getOpt();
            }
            return val;
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return OptionComparator.getKey(opt1).compareToIgnoreCase(OptionComparator.getKey(opt2));
        }
    }
}

