/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.inject.Injector;
import com.google.inject.Provider;
import io.sarl.docs.validator.DocumentationSetup;
import io.sarl.docs.validator.Messages;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.util.Utils;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public final class OperatorExtensions {
    private static final boolean SHOW_ERROR_ASSOCIATIVITY = false;
    private static final boolean SHOW_ERROR_PRECEDENCE = false;
    private static Provider<ParseHelper<SarlScript>> parser;
    private static ValidationTestHelper validation;

    private OperatorExtensions() {
    }

    public static void main(String[] args) throws Exception {
        List<String> operators = Arrays.asList("$v=$i", "$i||$i", "$i&&$i", "$i==$i", "$i!=$i", "$i===$i", "$i!==$i", "$i>=$i", "$i<=$i", "$i<$i", "$i>$i", "$o instanceof $t", "$i<=>$i", "$i<>$i", "$i..$i", "$i>..$i", "$i..<$i", "$i->$i", "$i=>$i", "$i?:$i", "$i>>$i", "$i<<$i", "$i>>>$i", "$i<<<$i", "$i+$i", "$i-$i", "$i*$i", "$i/$i", "$i%$i", "$L as $t", "$i**$i", "!$R", "-$R", "+$R", "$v++", "$v--");
        System.out.println(OperatorExtensions.generateOperatorPrecedenceMarkdownTable(operators));
    }

    public static String generateOperatorPrecedenceMarkdownTable(List<String> operators) throws Exception {
        HashMap<String, Associativity> associativities = new HashMap<String, Associativity>();
        HashMap<String, String> labels = new HashMap<String, String>();
        ArrayList<List<String>> precedenceGroups = new ArrayList<List<String>>();
        OperatorExtensions.buildOperatorInfo(operators, associativities, labels, precedenceGroups);
        int length1 = 0;
        int length2 = 0;
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<Associativity> assocs = new ArrayList<Associativity>();
        for (List<String> ops : precedenceGroups) {
            boolean first = true;
            StringBuilder result = new StringBuilder();
            Associativity assoc = null;
            for (String op : ops) {
                if (first) {
                    first = false;
                    assoc = associativities.get(op);
                } else {
                    result.append(", ");
                }
                result.append(labels.get(op));
            }
            groups.add(result.toString());
            assert (assoc != null);
            assocs.add(assoc);
            int len = result.length();
            if (len > length1) {
                length1 = len;
            }
            if ((len = assoc.toLabel().length()) <= length2) continue;
            length2 = len;
        }
        StringBuilder result = new StringBuilder();
        result.append("| ").append(Messages.OperatorExtensions_0);
        OperatorExtensions.append(result, ' ', length1 - 9);
        result.append(" | ").append(Messages.OperatorExtensions_1);
        OperatorExtensions.append(result, ' ', length2 - 13);
        result.append(" |\n");
        result.append("| ");
        OperatorExtensions.append(result, '-', length1);
        result.append(" | ");
        OperatorExtensions.append(result, '-', length2);
        result.append(" |\n");
        for (int i = 0; i < groups.size(); ++i) {
            String ops = (String)groups.get(i);
            Associativity assoc = (Associativity)((Object)assocs.get(i));
            result.append("| ");
            result.append(ops);
            OperatorExtensions.append(result, ' ', length1 - ops.length());
            result.append(" | ");
            result.append(assoc.toLabel());
            OperatorExtensions.append(result, ' ', length2 - assoc.toLabel().length());
            result.append(" |\n");
        }
        return result.toString();
    }

    public static boolean validateOperatorOrder(List<List<String>> operators) {
        Logger logger = (Logger)OperatorExtensions.getInjector().getInstance(Logger.class);
        int result = OperatorExtensions.validateOperatorOrder(operators, (Procedures.Procedure2<String, Throwable>)((Procedures.Procedure2)(message, exception) -> {
            if (exception != null) {
                logger.log(Level.SEVERE, (String)message, (Throwable)exception);
            } else {
                logger.severe((String)message);
            }
        }));
        return result == 0;
    }

    public static int validateOperatorOrder(List<List<String>> operators, Procedures.Procedure2<String, Throwable> errorLogger) {
        ArrayList<String> flatOperators = new ArrayList<String>();
        for (List<String> ops : operators) {
            flatOperators.addAll(ops);
        }
        HashMap<String, Associativity> associativities = new HashMap<String, Associativity>();
        HashMap<String, String> labels = new HashMap<String, String>();
        ArrayList<List<String>> precedenceGroups = new ArrayList<List<String>>();
        try {
            OperatorExtensions.buildOperatorInfo(flatOperators, associativities, labels, precedenceGroups);
        }
        catch (Exception exception) {
            if (errorLogger != null) {
                errorLogger.apply((Object)exception.getLocalizedMessage(), (Object)exception);
            }
            return 1;
        }
        int result = 0;
        Iterator<List<String>> iterator = operators.iterator();
        for (List<String> actualGroup : precedenceGroups) {
            List<String> originalExpectedGroup;
            ArrayList<String> expectedGroup;
            if (!iterator.hasNext()) {
                OperatorExtensions.error(errorLogger, Messages.OperatorExtensions_2, operators, precedenceGroups);
                ++result;
            }
            if ((expectedGroup = new ArrayList<String>(originalExpectedGroup = iterator.next())).size() != actualGroup.size()) {
                OperatorExtensions.error(errorLogger, MessageFormat.format(Messages.OperatorExtensions_3, actualGroup, originalExpectedGroup), operators, precedenceGroups);
                ++result;
            }
            for (String actualOp : actualGroup) {
                if (expectedGroup.remove(actualOp)) continue;
                OperatorExtensions.error(errorLogger, MessageFormat.format(Messages.OperatorExtensions_3, actualGroup, originalExpectedGroup), operators, precedenceGroups);
                ++result;
            }
            if (expectedGroup.isEmpty()) continue;
            OperatorExtensions.error(errorLogger, MessageFormat.format(Messages.OperatorExtensions_3, actualGroup, originalExpectedGroup), operators, precedenceGroups);
            ++result;
        }
        return result;
    }

    private static void error(Procedures.Procedure2<String, Throwable> errorLogger, String message, List<List<String>> expectedPrecedence, List<List<String>> actualPrecedence) {
        if (errorLogger != null) {
            errorLogger.apply((Object)message, null);
            errorLogger.apply((Object)MessageFormat.format(Messages.OperatorExtensions_4, expectedPrecedence), null);
            errorLogger.apply((Object)MessageFormat.format(Messages.OperatorExtensions_5, actualPrecedence), null);
        }
    }

    private static Injector getInjector() {
        return DocumentationSetup.doSetup();
    }

    private static ParseHelper<SarlScript> getParseHelper() {
        if (parser == null) {
            parser = OperatorExtensions.getInjector().getProvider(ParseHelper.class);
            OperatorExtensions.loggerOff(ProcessorInstanceForJvmTypeProvider.class, "logger");
        }
        return (ParseHelper)parser.get();
    }

    private static void loggerOff(Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)field.get(null);
            if (logger != null) {
                logger.setLevel(org.apache.log4j.Level.OFF);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static ValidationTestHelper getValidation() {
        if (validation == null) {
            validation = (ValidationTestHelper)OperatorExtensions.getInjector().getInstance(ValidationTestHelper.class);
        }
        return validation;
    }

    private static SarlScript scriptToEMF(String code) throws Exception {
        ParseHelper<SarlScript> parser = OperatorExtensions.getParseHelper();
        return (SarlScript)parser.parse((CharSequence)code);
    }

    private static String getDefinitionsForOperators() {
        String[] unaryOperators;
        String[] binaryOperators = new String[]{"or", "and", "equals", "notEquals", "tripleEquals", "tripleNotEquals", "greaterThan", "lessThan", "greaterEqualsThan", "lessEqualsThan", "spaceship", "diamond", "upTo", "greaterThanDoubleDot", "doubleDotLessThan", "mappedTo", "doubleArrow", "elvis", "doubleGreaterThan", "doubleLessThan", "tripleGreaterThan", "tripleLessThan", "plus", "minus", "multiply", "divide", "modulo", "power"};
        StringBuilder buf = new StringBuilder();
        for (String op : binaryOperators) {
            buf.append("static def operator_").append(op).append("(a : int, b : int) : int {0}\n");
            buf.append("static def operator_").append(op).append("(a : boolean, b : int) : int {0}\n");
            buf.append("static def operator_").append(op).append("(a : int, b : boolean) : int {0}\n");
            buf.append("static def operator_").append(op).append("(a : boolean, b : boolean) : int {0}\n");
        }
        for (String op : unaryOperators = new String[]{"minus", "not", "plusPlus", "moinsMoins"}) {
            buf.append("static def operator_").append(op).append("(a : int) : int {0}\n");
            buf.append("static def operator_").append(op).append("(a : boolean) : int {0}\n");
        }
        return buf.toString();
    }

    private static XExpression toEMFExpression(String expression, boolean showError) throws Exception {
        String code = "class ___X {\nstatic var OBJ = new Integer(1);\nstatic var VAR = 1;\n" + OperatorExtensions.getDefinitionsForOperators() + "var __expr  : int = (" + expression + ");\n}";
        SarlScript script = OperatorExtensions.scriptToEMF(code);
        try {
            OperatorExtensions.getValidation().assertNoErrors(script.eResource());
        }
        catch (Throwable exception) {
            if (showError) {
                System.err.println(exception.getLocalizedMessage());
                System.err.println(code);
            }
            return null;
        }
        EList members = ((XtendTypeDeclaration)script.getXtendTypes().get(0)).getMembers();
        SarlField field = (SarlField)members.get(members.size() - 1);
        return field.getInitialValue();
    }

    private static void dump(XExpression expr, OutParameter<String> raw, OutParameter<Integer> depth, OutParameter<Associativity> assoc) {
        if (expr instanceof XBinaryOperation) {
            XBinaryOperation operator = (XBinaryOperation)expr;
            QualifiedName name = QualifiedName.create((String)operator.getFeature().getSimpleName());
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            OutParameter leftRaw = new OutParameter();
            OutParameter leftDepth = new OutParameter();
            OperatorExtensions.dump(operator.getLeftOperand(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            rawb.append((String)leftRaw.get());
            rawb.append(((OperatorMapping)OperatorExtensions.getInjector().getInstance(OperatorMapping.class)).getOperator(name));
            OutParameter rightRaw = new OutParameter();
            OutParameter rightDepth = new OutParameter();
            OperatorExtensions.dump(operator.getRightOperand(), (OutParameter<String>)rightRaw, (OutParameter<Integer>)rightDepth, null);
            rawb.append((String)rightRaw.get());
            rawb.append(")");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)(Math.max((Integer)leftDepth.get(), (Integer)rightDepth.get()) + 1));
            }
            if (assoc != null) {
                if ((Integer)leftDepth.get() > (Integer)rightDepth.get()) {
                    assoc.set((Object)Associativity.LEFT_TO_RIGHT);
                } else if ((Integer)leftDepth.get() < (Integer)rightDepth.get()) {
                    assoc.set((Object)Associativity.RIGHT_TO_LEFT);
                } else {
                    assoc.set((Object)Associativity.NONE);
                }
            }
        } else if (expr instanceof XUnaryOperation) {
            XUnaryOperation operator = (XUnaryOperation)expr;
            QualifiedName name = QualifiedName.create((String)operator.getFeature().getSimpleName());
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            rawb.append(((OperatorMapping)OperatorExtensions.getInjector().getInstance(OperatorMapping.class)).getOperator(name));
            OutParameter leftRaw = new OutParameter();
            OutParameter leftDepth = new OutParameter();
            OperatorExtensions.dump(operator.getOperand(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            rawb.append((String)leftRaw.get());
            rawb.append(")");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)((Integer)leftDepth.get() + 1));
            }
            if (assoc != null) {
                if ((Integer)leftDepth.get() > 1) {
                    assoc.set((Object)Associativity.RIGHT_TO_LEFT);
                } else {
                    assoc.set((Object)Associativity.NONE);
                }
            }
        } else if (expr instanceof XPostfixOperation) {
            XPostfixOperation operator = (XPostfixOperation)expr;
            QualifiedName name = QualifiedName.create((String)operator.getFeature().getSimpleName());
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            OutParameter leftRaw = new OutParameter();
            OutParameter leftDepth = new OutParameter();
            OperatorExtensions.dump(operator.getOperand(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            rawb.append((String)leftRaw.get());
            rawb.append(((OperatorMapping)OperatorExtensions.getInjector().getInstance(OperatorMapping.class)).getOperator(name));
            rawb.append(")");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)((Integer)leftDepth.get() + 1));
            }
            if (assoc != null) {
                if ((Integer)leftDepth.get() > 1) {
                    assoc.set((Object)Associativity.LEFT_TO_RIGHT);
                } else {
                    assoc.set((Object)Associativity.NONE);
                }
            }
        } else if (expr instanceof XInstanceOfExpression) {
            XInstanceOfExpression instanceofExpr = (XInstanceOfExpression)expr;
            OutParameter leftRaw = new OutParameter();
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            OutParameter leftDepth = new OutParameter();
            OperatorExtensions.dump(instanceofExpr.getExpression(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            rawb.append((String)leftRaw.get());
            rawb.append(" instanceof T)");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)((Integer)leftDepth.get() + 1));
            }
            if (assoc != null) {
                assoc.set((Object)Associativity.NONE);
            }
        } else if (expr instanceof XCastedExpression) {
            XCastedExpression castExpr = (XCastedExpression)expr;
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            OutParameter leftRaw = new OutParameter();
            OutParameter leftDepth = new OutParameter();
            OperatorExtensions.dump(castExpr.getTarget(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            rawb.append((String)leftRaw.get());
            rawb.append(" as T)");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)((Integer)leftDepth.get() + 1));
            }
            if (assoc != null) {
                if ((Integer)leftDepth.get() > 1) {
                    assoc.set((Object)Associativity.LEFT_TO_RIGHT);
                } else {
                    assoc.set((Object)Associativity.NONE);
                }
            }
        } else if (expr instanceof XAssignment) {
            XAssignment ass = (XAssignment)expr;
            StringBuilder rawb = new StringBuilder();
            rawb.append("(");
            OutParameter leftRaw = new OutParameter();
            OutParameter leftDepth = new OutParameter();
            if (ass.getActualReceiver() == null) {
                leftRaw.set((Object)ass.getFeature().getSimpleName());
                leftDepth.set((Object)1);
            } else {
                OperatorExtensions.dump(ass.getActualReceiver(), (OutParameter<String>)leftRaw, (OutParameter<Integer>)leftDepth, null);
            }
            rawb.append((String)leftRaw.get());
            rawb.append("=");
            OutParameter rightRaw = new OutParameter();
            OutParameter rightDepth = new OutParameter();
            OperatorExtensions.dump(ass.getValue(), (OutParameter<String>)rightRaw, (OutParameter<Integer>)rightDepth, null);
            rawb.append((String)rightRaw.get());
            rawb.append(")");
            if (raw != null) {
                raw.set((Object)rawb.toString());
            }
            if (depth != null) {
                depth.set((Object)(Math.max((Integer)leftDepth.get(), (Integer)rightDepth.get()) + 1));
            }
            if (assoc != null) {
                if ((Integer)leftDepth.get() > (Integer)rightDepth.get()) {
                    assoc.set((Object)Associativity.LEFT_TO_RIGHT);
                } else if ((Integer)leftDepth.get() < (Integer)rightDepth.get()) {
                    assoc.set((Object)Associativity.RIGHT_TO_LEFT);
                } else {
                    assoc.set((Object)Associativity.NONE);
                }
            }
        } else if (expr instanceof XBooleanLiteral || expr instanceof XNumberLiteral || expr instanceof XFeatureCall) {
            if (raw != null) {
                raw.set((Object)"x");
            }
            if (depth != null) {
                depth.set((Object)1);
            }
            if (assoc != null) {
                assoc.set((Object)Associativity.NONE);
            }
        } else {
            throw new UnsupportedOperationException(Utils.dump((EObject)expr));
        }
    }

    private static void buildOperatorInfo(List<String> operators, Map<String, Associativity> associativities, Map<String, String> labels, List<List<String>> precedenceGroups) throws Exception {
        HashMap<Object, ArrayList<String>> operatorNames = new HashMap<Object, ArrayList<String>>();
        for (String string : operators) {
            Associativity assoc = OperatorExtensions.detectAssociativity(string);
            assert (assoc != null) : "No associativity for " + string;
            associativities.put(string, assoc);
            String simpleText = OperatorExtensions.toText(string);
            ArrayList<String> ops = (ArrayList<String>)operatorNames.get(simpleText);
            if (ops == null) {
                ops = new ArrayList<String>();
                operatorNames.put(simpleText, ops);
            }
            ops.add(string);
        }
        for (Map.Entry entry : operatorNames.entrySet()) {
            List ops = (List)entry.getValue();
            if (ops.size() > 1) {
                for (String op : ops) {
                    if (OperatorExtensions.isBinaryOperator(op)) {
                        labels.put(op, (String)entry.getKey());
                        continue;
                    }
                    labels.put(op, (String)entry.getKey() + " (unary)");
                }
                continue;
            }
            labels.put((String)ops.get(0), (String)entry.getKey());
        }
        HashMap precBuffer = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>(operators);
        Comparator comp = (op1, op2) -> {
            String expr2;
            String expr1;
            String key1 = op1 + "   " + op2;
            Integer cmp = (Integer)precBuffer.get(key1);
            if (cmp != null) {
                return cmp;
            }
            String key2 = op2 + "   " + op1;
            cmp = (Integer)precBuffer.get(key2);
            if (cmp != null) {
                return -cmp.intValue();
            }
            if (!(op1.contains("$i") || op1.contains("$R") || op1.contains("$L") || op1.contains("$o"))) {
                if (!(op2.contains("$i") || op2.contains("$R") || op2.contains("$L") || op2.contains("$o"))) {
                    cmp = ((Associativity)((Object)((Object)((Object)associativities.get(op1))))).compareTo((Associativity)((Object)((Object)((Object)associativities.get(op2)))));
                    if (cmp == 0) {
                        cmp = !op1.contains("$v") ? Integer.valueOf(1) : (!op2.contains("$v") ? Integer.valueOf(-1) : Integer.valueOf(0));
                    }
                    precBuffer.put(key1, cmp);
                    precBuffer.put(key2, cmp);
                    return cmp;
                }
                precBuffer.put(key1, 1);
                precBuffer.put(key2, -1);
                return 1;
            }
            if (!(op2.contains("$i") || op2.contains("$R") || op2.contains("$L") || op2.contains("$o"))) {
                precBuffer.put(key1, -1);
                precBuffer.put(key2, 1);
                return -1;
            }
            boolean binary1 = OperatorExtensions.isBinaryOperator(op1);
            if (binary1) {
                String rep = OperatorExtensions.toSARLExpression(op2);
                expr1 = OperatorExtensions.toSARLExpressionRight(op1, rep);
                expr2 = OperatorExtensions.toSARLExpressionLeft(op1, rep);
            } else {
                boolean binary2 = OperatorExtensions.isBinaryOperator(op2);
                if (binary2) {
                    String rep = OperatorExtensions.toSARLExpression(op1);
                    expr1 = OperatorExtensions.toSARLExpressionLeft(op2, rep);
                    expr2 = OperatorExtensions.toSARLExpressionRight(op2, rep);
                } else {
                    String rep2 = OperatorExtensions.toSARLExpression(op2);
                    String rep1 = OperatorExtensions.toSARLExpression(op1);
                    expr1 = OperatorExtensions.toSARLExpressionRight(op1, rep2);
                    expr2 = OperatorExtensions.toSARLExpressionRight(op2, rep1);
                }
            }
            Integer prec1 = OperatorExtensions.computePrecedence(expr1);
            Integer prec2 = OperatorExtensions.computePrecedence(expr2);
            if (prec1 == null && prec2 == null) {
                cmp = ((Associativity)((Object)((Object)((Object)associativities.get(op1))))).compareTo((Associativity)((Object)((Object)((Object)associativities.get(op2)))));
                precBuffer.put(key1, cmp);
                precBuffer.put(key2, -cmp.intValue());
                return cmp;
            }
            if (prec1 == null && prec2 != null) {
                precBuffer.put(key1, -prec2.intValue());
                precBuffer.put(key2, Integer.valueOf(prec2));
                return -prec2.intValue();
            }
            if (prec1 != null && prec2 == null) {
                precBuffer.put(key1, Integer.valueOf(prec1));
                precBuffer.put(key2, -prec1.intValue());
                return prec1;
            }
            assert (prec1 != null && prec2 != null);
            if (prec1.intValue() == prec2.intValue()) {
                cmp = ((Associativity)((Object)((Object)((Object)associativities.get(op1))))).compareTo((Associativity)((Object)((Object)((Object)associativities.get(op2)))));
                precBuffer.put(key1, cmp);
                precBuffer.put(key2, -cmp.intValue());
                return cmp;
            }
            precBuffer.put(key1, Integer.valueOf(prec1));
            precBuffer.put(key2, -prec1.intValue());
            return prec1;
        };
        arrayList.sort(comp);
        Iterator<String> iterator = arrayList.iterator();
        String op12 = iterator.next();
        ArrayList<String> group = new ArrayList<String>();
        precedenceGroups.add(group);
        group.add(op12);
        while (iterator.hasNext()) {
            String op22 = iterator.next();
            int prec = comp.compare(op12, op22);
            if (prec != 0) {
                group = new ArrayList();
                precedenceGroups.add(group);
            }
            group.add(op22);
            op12 = op22;
        }
    }

    private static Integer computePrecedence(String expr) {
        try {
            XExpression xexpr = OperatorExtensions.toEMFExpression(expr, false);
            if (xexpr != null) {
                OutParameter raw = new OutParameter();
                OutParameter depth = new OutParameter();
                OutParameter assoc = new OutParameter();
                OperatorExtensions.dump(xexpr, (OutParameter<String>)raw, (OutParameter<Integer>)depth, (OutParameter<Associativity>)assoc);
                switch (((Associativity)((Object)assoc.get())).ordinal()) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return -1;
                    }
                    case 0: {
                        return 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private static void append(StringBuilder result, char c, int len) {
        for (int i = 0; i < len; ++i) {
            result.append(c);
        }
    }

    private static Associativity detectAssociativity(String operator) throws Exception {
        String expr;
        XExpression xexpr;
        if (operator.contains("$L")) {
            return Associativity.LEFT_TO_RIGHT;
        }
        if (operator.contains("$R")) {
            return Associativity.RIGHT_TO_LEFT;
        }
        boolean binaryOperator = OperatorExtensions.isBinaryOperator(operator);
        if ((binaryOperator || operator.contains("$i") || operator.contains("$v")) && (xexpr = OperatorExtensions.toEMFExpression(expr = OperatorExtensions.toSARLExpressionRight(operator, OperatorExtensions.toSARLExpressionRight(operator, OperatorExtensions.toSARLExpression(operator))), false)) != null) {
            OutParameter raw = new OutParameter();
            OutParameter depth = new OutParameter();
            OutParameter assoc = new OutParameter();
            OperatorExtensions.dump(xexpr, (OutParameter<String>)raw, (OutParameter<Integer>)depth, (OutParameter<Associativity>)assoc);
            return (Associativity)((Object)assoc.get());
        }
        return Associativity.NONE;
    }

    private static int indexOfOperand(String operator, int start) {
        int idx = operator.indexOf(36, start);
        while (idx >= 0) {
            if (idx - 1 < operator.length()) {
                char c = operator.charAt(idx + 1);
                if (c == 'i' || c == 'R' || c == 'L' && c == 'o') break;
                idx = operator.indexOf(36, idx + 1);
                continue;
            }
            return -1;
        }
        if (idx < 0) {
            return -1;
        }
        return idx;
    }

    private static boolean isBinaryOperator(String operator) {
        int idx2;
        int idx1 = OperatorExtensions.indexOfOperand(operator, 0);
        return idx1 >= 0 && (idx2 = OperatorExtensions.indexOfOperand(operator, idx1 + 1)) > idx1;
    }

    private static String toSARLExpression(String operator) {
        String result = operator.replaceAll("\\$i", "1");
        result = result.replaceAll("\\$L", "1");
        result = result.replaceAll("\\$R", "1");
        result = result.replaceAll("\\$o", "OBJ");
        result = result.replaceAll("\\$t", "java.lang.Integer");
        result = result.replaceAll("\\$v", "VAR");
        return result;
    }

    private static String toSARLExpressionRight(String operator, String rightOperand) {
        String result = OperatorExtensions.replaceRight(operator, "$i", "1", rightOperand);
        result = OperatorExtensions.replaceRight(result, "$L", "1", rightOperand);
        result = OperatorExtensions.replaceRight(result, "$R", "1", rightOperand);
        result = OperatorExtensions.replaceRight(result, "$o", "OBJ", rightOperand);
        result = result.replaceAll("\\$t", "java.lang.Integer");
        result = result.replaceAll("\\$v", "VAR");
        return result;
    }

    private static String toSARLExpressionLeft(String operator, String leftOperand) {
        String result = OperatorExtensions.replaceLeft(operator, "$i", "1", leftOperand);
        result = OperatorExtensions.replaceLeft(result, "$L", "1", leftOperand);
        result = OperatorExtensions.replaceLeft(result, "$R", "1", leftOperand);
        result = OperatorExtensions.replaceLeft(result, "$o", "OBJ", leftOperand);
        result = result.replaceAll("\\$t", "java.lang.Integer");
        result = result.replaceAll("\\$v", "VAR");
        return result;
    }

    private static String replaceRight(String str, String replaced, String replacement, String lastReplacement) {
        int index = str.lastIndexOf(replaced);
        if (index >= 0) {
            StringBuilder r = new StringBuilder();
            if (index + replaced.length() < str.length()) {
                r.append(str.substring(index + replaced.length()));
            }
            r.insert(0, lastReplacement);
            int endIndex = index;
            index = str.lastIndexOf(replaced, endIndex - 1);
            while (index >= 0) {
                r.insert(0, str.substring(index + replaced.length(), endIndex));
                r.insert(0, replacement);
                endIndex = index;
                index = str.lastIndexOf(replaced, endIndex - 1);
            }
            if (endIndex > 0) {
                r.insert(0, str.substring(0, endIndex));
            }
            return r.toString();
        }
        return str;
    }

    private static String replaceLeft(String str, String replaced, String replacement, String firstReplacement) {
        int index = str.indexOf(replaced);
        if (index >= 0) {
            StringBuilder r = new StringBuilder();
            if (index > 0) {
                r.append(str.substring(0, index));
            }
            r.append(firstReplacement);
            int prevIndex = index;
            index = str.indexOf(replaced, prevIndex + 1);
            while (index >= 0) {
                r.append(str.substring(prevIndex + replaced.length(), index));
                r.append(replacement);
                prevIndex = index;
                index = str.indexOf(replaced, prevIndex + 1);
            }
            if (prevIndex + replaced.length() < str.length()) {
                r.append(str.substring(prevIndex + replaced.length()));
            }
            return r.toString();
        }
        return str;
    }

    private static String toText(String operator) {
        String result = operator.replaceAll("\\$i", "");
        result = result.replaceAll("\\$L", "");
        result = result.replaceAll("\\$R", "");
        result = result.replaceAll("\\$o", "");
        result = result.replaceAll("\\$t", "");
        result = result.replaceAll("\\$v", "");
        result = result.trim();
        return result;
    }

    private static enum Associativity {
        NONE{

            @Override
            public String toLabel() {
                return Messages.OperatorExtensions_6;
            }
        }
        ,
        LEFT_TO_RIGHT{

            @Override
            public String toLabel() {
                return Messages.OperatorExtensions_7;
            }
        }
        ,
        RIGHT_TO_LEFT{

            @Override
            public String toLabel() {
                return Messages.OperatorExtensions_8;
            }
        };


        public abstract String toLabel();
    }
}

