/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.common.collect.Iterables;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.util.Utils;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.jdt.core.Flags;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ReflectExtensions {
    private static final String PLUGIN_HELP_PATH = "/META-INF/maven/%s/%s/plugin-help.xml";
    private static Function<Method, String> defaultMethodNameFormatter;
    private static Function<Field, String> defaultFieldNameFormatter;

    private ReflectExtensions() {
    }

    @Deprecated(forRemoval=true, since="0.12")
    public static void setDefaultNameFormatter(Function<Method, String> formatter) {
        defaultMethodNameFormatter = formatter;
    }

    public static void setDefaultMethodNameFormatter(Function<Method, String> formatter) {
        defaultMethodNameFormatter = formatter;
    }

    @Pure
    @Deprecated(forRemoval=true, since="0.12")
    public static Function<Method, String> getDefaultNameFormatter() {
        return ReflectExtensions.getDefaultMethodNameFormatter();
    }

    @Pure
    public static Function<Method, String> getDefaultMethodNameFormatter() {
        return defaultMethodNameFormatter;
    }

    public static void setDefaultFieldNameFormatter(Function<Field, String> formatter) {
        defaultFieldNameFormatter = formatter;
    }

    @Pure
    public static Function<Field, String> getDefaultFieldNameFormatter() {
        return defaultFieldNameFormatter;
    }

    private static boolean isDeprecated(Method method) {
        return Flags.isDeprecated((int)method.getModifiers()) || method.getAnnotation(Deprecated.class) != null;
    }

    private static boolean isDeprecated(Field field) {
        return Flags.isDeprecated((int)field.getModifiers()) || field.getAnnotation(Deprecated.class) != null;
    }

    @Pure
    @Inline(value="getPublicMethodsWithFormat($1, null, $2)", imported={ReflectExtensions.class})
    public static String getPublicMethods(Class<?> type, Class<?> ... otherTypes) {
        return ReflectExtensions.getPublicMethodsWithFormat(type, null, new Class[0]);
    }

    @Pure
    public static String getPublicMethodsWithFormat(Class<?> type, Function<Method, String> nameFormatter, Class<?> ... otherTypes) {
        StringBuilder it = new StringBuilder();
        ReflectExtensions.appendPublicMethods(it, false, nameFormatter, IterableExtensions.flatten(Arrays.asList(Collections.singletonList(type), Arrays.asList(otherTypes))));
        return it.toString();
    }

    @Inline(value="appendPublicMethods($1, $2, null, $4.asList($3))", imported={Arrays.class})
    public static void appendPublicMethods(StringBuilder it, boolean indent, Class<?> ... types) {
        ReflectExtensions.appendPublicMethods(it, indent, null, Arrays.asList(types));
    }

    public static void appendPublicMethods(StringBuilder it, boolean indent, Function<Method, String> nameFormatter, Iterable<? extends Class<?>> types) {
        ReflectExtensions.appendMethods(it, indent, nameFormatter, types, it0 -> Flags.isPublic((int)it0.getModifiers()) && !SarlUtils.isHiddenMember((String)it0.getName()) && !ReflectExtensions.isDeprecated(it0) && !it0.isSynthetic() && it0.getAnnotation(SyntheticMember.class) == null);
    }

    private static void appendMethods(StringBuilder it, boolean indent, Function<Method, String> nameFormatter, Iterable<? extends Class<?>> types, Predicate<Method> selector) {
        LinkedList<String> lines = new LinkedList<String>();
        for (Class<?> type : types) {
            for (Method method : type.getDeclaredMethods()) {
                boolean first;
                Function<Method, String> nformatter;
                if (!selector.test(method)) continue;
                StringBuilder line = new StringBuilder();
                if (indent) {
                    line.append("\t");
                }
                if ((nformatter = nameFormatter) == null) {
                    nformatter = ReflectExtensions.getDefaultMethodNameFormatter();
                }
                String formattedName = nformatter != null ? nformatter.apply(method) : method.getName();
                line.append("def ").append(formattedName);
                if (method.getParameterCount() > 0) {
                    line.append("(");
                    first = true;
                    int i = 1;
                    Parameter[] parameterArray = method.getParameters();
                    int n = parameterArray.length;
                    for (int j = 0; j < n; ++j) {
                        Parameter param = parameterArray[j];
                        if (first) {
                            first = false;
                        } else {
                            line.append(", ");
                        }
                        ReflectExtensions.toType(line, param.getParameterizedType(), method.isVarArgs() && i == method.getParameterCount());
                        String defaultValue = ReflectExtensions.extractDefaultValueString(param);
                        if (Strings.isEmpty((String)defaultValue)) continue;
                        line.append(" = ");
                        line.append(defaultValue);
                    }
                    line.append(")");
                    ++i;
                }
                if (method.getGenericReturnType() != null && !Objects.equals(method.getGenericReturnType(), Void.class) && !Objects.equals(method.getGenericReturnType(), Void.TYPE)) {
                    line.append(" : ");
                    ReflectExtensions.toType(line, method.getGenericReturnType(), false);
                }
                first = true;
                for (TypeVariable<Method> typeVariable : method.getTypeParameters()) {
                    if (first) {
                        line.append(" with ");
                        first = false;
                    } else {
                        line.append(", ");
                    }
                    line.append(typeVariable.getTypeName());
                }
                line.append("\n");
                lines.add(line.toString());
            }
        }
        lines.sort(null);
        for (String line : lines) {
            it.append(line);
        }
    }

    private static String extractDefaultValueString(Parameter parameter) {
        Class<?> container;
        DefaultValue defaultValueAnnotation = parameter.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation == null) {
            return null;
        }
        String methodId = defaultValueAnnotation.value();
        if (!Strings.isEmpty((String)methodId) && (container = parameter.getDeclaringExecutable().getDeclaringClass()) != null) {
            SarlSourceCode sourceCodeAnnotation;
            String methodName;
            Class<?> target;
            int index = methodId.indexOf(35);
            if (index > 0) {
                try {
                    Class<?> type = Class.forName(methodId.substring(0, index), true, container.getClassLoader());
                    target = type;
                }
                catch (Throwable exception) {
                    target = container;
                }
                methodName = Utils.createNameForHiddenDefaultValueFunction((String)methodId.substring(index + 1));
            } else {
                target = container;
                methodName = Utils.createNameForHiddenDefaultValueFunction((String)methodId);
            }
            Method method = (Method)Iterables.find(Arrays.asList(target.getDeclaredMethods()), it -> Strings.equal((String)it.getName(), (String)methodName), null);
            if (method != null && (sourceCodeAnnotation = parameter.getAnnotation(SarlSourceCode.class)) != null) {
                String value = sourceCodeAnnotation.value();
                if (!Strings.isEmpty((String)methodId)) {
                    return value;
                }
            }
        }
        return null;
    }

    @Inline(value="appendPublicFields($1, $2, null, $4.asList($3))", imported={Arrays.class})
    public static void appendPublicFields(StringBuilder it, boolean indent, Class<?> ... types) {
        ReflectExtensions.appendPublicFields(it, indent, null, Arrays.asList(types));
    }

    public static void appendPublicFields(StringBuilder it, boolean indent, Function<Field, String> nameFormatter, Iterable<? extends Class<?>> types) {
        ReflectExtensions.appendFields(it, indent, nameFormatter, types, it0 -> Flags.isPublic((int)it0.getModifiers()) && !SarlUtils.isHiddenMember((String)it0.getName()) && !ReflectExtensions.isDeprecated(it0) && !it0.isSynthetic() && it0.getAnnotation(SyntheticMember.class) == null);
    }

    private static void appendFields(StringBuilder it, boolean indent, Function<Field, String> nameFormatter, Iterable<? extends Class<?>> types, Predicate<Field> selector) {
        LinkedList<String> lines = new LinkedList<String>();
        for (Class<?> type : types) {
            for (Field field : type.getDeclaredFields()) {
                Function<Field, String> nformatter;
                if (!selector.test(field)) continue;
                StringBuilder line = new StringBuilder();
                if (indent) {
                    line.append("\t");
                }
                if ((nformatter = nameFormatter) == null) {
                    nformatter = ReflectExtensions.getDefaultFieldNameFormatter();
                }
                String formattedName = nformatter != null ? nformatter.apply(field) : field.getName();
                if (Modifier.isFinal(field.getModifiers())) {
                    line.append("val ");
                } else {
                    line.append("var ");
                }
                line.append(formattedName);
                if (field.getGenericType() != null && !Objects.equals(field.getGenericType(), Void.class) && !Objects.equals(field.getGenericType(), Void.TYPE)) {
                    line.append(" : ");
                    ReflectExtensions.toType(line, field.getGenericType(), false);
                }
                line.append("\n");
                lines.add(line.toString());
            }
        }
        lines.sort(null);
        for (String line : lines) {
            it.append(line);
        }
    }

    public static void toType(StringBuilder it, Type otype, boolean isVarArg) {
        Class<?> type;
        Class<?> cvalue;
        if (otype instanceof Class) {
            cvalue = otype;
            type = isVarArg ? cvalue.getComponentType() : otype;
        } else {
            type = otype;
        }
        if (type instanceof Class) {
            cvalue = type;
            it.append(cvalue.getSimpleName());
        } else if (type instanceof ParameterizedType) {
            boolean isForProcedure;
            ParameterizedType paramType = (ParameterizedType)((Object)type);
            Type ownerType = paramType.getOwnerType();
            boolean isForFunction = ownerType != null && Functions.class.getName().equals(ownerType.getTypeName());
            boolean bl = isForProcedure = ownerType != null && Procedures.class.getName().equals(ownerType.getTypeName());
            if (!isForFunction && !isForProcedure) {
                it.append(((Class)paramType.getRawType()).getSimpleName());
                if (paramType.getActualTypeArguments().length > 0) {
                    it.append("<");
                    boolean first = true;
                    for (Type subtype : paramType.getActualTypeArguments()) {
                        if (first) {
                            first = false;
                        } else {
                            it.append(", ");
                        }
                        StringBuilder it2 = new StringBuilder();
                        ReflectExtensions.toType(it2, subtype, false);
                        it.append((CharSequence)it2);
                    }
                    it.append(">");
                }
            } else {
                int nb = paramType.getActualTypeArguments().length;
                if (isForFunction) {
                    --nb;
                }
                it.append("(");
                for (int i = 0; i < nb; ++i) {
                    Type subtype = paramType.getActualTypeArguments()[i];
                    if (i > 0) {
                        it.append(", ");
                    }
                    ReflectExtensions.toType(it, subtype, false);
                }
                it.append(") => ");
                if (isForFunction) {
                    ReflectExtensions.toType(it, paramType.getActualTypeArguments()[nb], false);
                } else {
                    it.append("void");
                }
            }
        } else if (type instanceof WildcardType) {
            WildcardType cvalue2 = (WildcardType)((Object)type);
            Type[] types = cvalue2.getUpperBounds();
            ReflectExtensions.toType(it, types[0], false);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType cvalue3 = (GenericArrayType)((Object)type);
            ReflectExtensions.toType(it, cvalue3.getGenericComponentType(), false);
            it.append("[]");
        } else if (type instanceof TypeVariable) {
            TypeVariable cvalue4 = (TypeVariable)((Object)type);
            it.append(cvalue4.getName());
        } else {
            it.append(Object.class.getSimpleName());
        }
        if (isVarArg) {
            it.append("*");
        }
    }

    @Pure
    @Inline(value="getMavenPluginConfiguration($1, $2, $3.class)", imported={ReflectExtensions.class})
    public static List<List<String>> getMavenPluginConfiguration(String mavenPluginGroupId, String mavenPluginArtifactId) {
        return ReflectExtensions.getMavenPluginConfiguration(mavenPluginGroupId, mavenPluginArtifactId, ReflectExtensions.class);
    }

    @Pure
    public static List<List<String>> getMavenPluginConfiguration(String mavenPluginGroupId, String mavenPluginArtifactId, Class<?> classContext) {
        assert (mavenPluginGroupId != null);
        assert (mavenPluginArtifactId != null);
        assert (classContext != null);
        String resourceName = String.format(PLUGIN_HELP_PATH, mavenPluginGroupId, mavenPluginArtifactId);
        URL url = classContext.getResource(resourceName);
        if (url == null && (url = ClassLoader.getSystemClassLoader().getResource(resourceName)) == null) {
            try {
                File userFile = FileSystem.join((File)FileSystem.getUserHomeDirectory(), (String[])new String[]{".m2", "repository"});
                for (String element : mavenPluginGroupId.split(Pattern.quote("."))) {
                    userFile = new File(userFile, element);
                }
                userFile = FileSystem.join((File)userFile, (String[])new String[]{mavenPluginArtifactId, "0.15.1", mavenPluginArtifactId + "-0.15.1.jar"});
                url = FileSystem.toJarURL((File)userFile, (String)resourceName);
            }
            catch (Throwable userFile) {
                // empty catch block
            }
        }
        if (url != null) {
            ArrayList arrayList;
            block19: {
                InputStream is = url.openStream();
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document document = dBuilder.parse(is);
                    Node pluginNode = ReflectExtensions.getSingleChild(document, "plugin");
                    Node mojosNode = ReflectExtensions.getSingleChild(pluginNode, "mojos");
                    TreeMap<String, ArrayList<CallSite>> documentation = new TreeMap<String, ArrayList<CallSite>>();
                    for (Node mojoNode : ReflectExtensions.findNamedChild(mojosNode, "mojo")) {
                        String mojoName = ReflectExtensions.getValue(mojoNode, "goal");
                        Node parametersNode = ReflectExtensions.getSingleChild(mojoNode, "parameters");
                        Node configurationNode = ReflectExtensions.getSingleChild(mojoNode, "configuration");
                        for (Node parameterNode : ReflectExtensions.findNamedChild(parametersNode, "parameter")) {
                            if (!Strings.isEmpty((String)ReflectExtensions.getValue(parameterNode, "deprecated")) || !ReflectExtensions.getBoolean(parameterNode, "editable")) continue;
                            String name = ReflectExtensions.getValue(parameterNode, "name");
                            ArrayList<CallSite> columns = (ArrayList<CallSite>)documentation.get(name);
                            if (columns == null) {
                                columns = new ArrayList<CallSite>();
                                documentation.put(name, columns);
                                columns.add((CallSite)((Object)name));
                                columns.add((CallSite)((Object)mojoName));
                                columns.add((CallSite)((Object)ReflectExtensions.nullIfEmpty(ReflectExtensions.getValue(parameterNode, "type"))));
                                columns.add((CallSite)((Object)ReflectExtensions.nullIfEmpty(ReflectExtensions.getValue(parameterNode, "description"))));
                                columns.add((CallSite)((Object)ReflectExtensions.nullIfEmpty(ReflectExtensions.getDefaultValue(configurationNode, name))));
                                continue;
                            }
                            columns.set(1, (CallSite)((Object)((String)columns.get(1) + ", " + mojoName)));
                        }
                    }
                    arrayList = new ArrayList(documentation.values());
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static String nullIfEmpty(String value) {
        return value == null ? "" : value;
    }

    private static String getDefaultValue(Node node, String parameterName) {
        Node parameterNode = ReflectExtensions.getSingleChild(node, parameterName);
        if (parameterNode instanceof Element) {
            Element cvalue = (Element)parameterNode;
            return Strings.emptyIfNull((String)cvalue.getAttribute("default-value"));
        }
        return null;
    }

    private static String getValue(Node node, String elementName) {
        Node elementNode = ReflectExtensions.getSingleChild(node, elementName);
        if (elementNode != null) {
            return elementNode.getTextContent();
        }
        return null;
    }

    private static boolean getBoolean(Node node, String elementName) {
        String value = ReflectExtensions.getValue(node, elementName);
        if (!Strings.isEmpty((String)value)) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Node getSingleChild(Node node, String elementName) {
        List<Node> namedChild = ReflectExtensions.findNamedChild(node, elementName);
        if (namedChild.isEmpty()) {
            return null;
        }
        if (namedChild.size() > 1) {
            return null;
        }
        return namedChild.get(0);
    }

    private static List<Node> findNamedChild(Node node, String elementName) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!elementName.equals(item.getNodeName())) continue;
            result.add(item);
        }
        return result;
    }

    public static Object callStaticMethod(Class<?> type, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = type.getMethod(methodName, new Class[0]);
        Object value = method.invoke(null, new Object[0]);
        return value;
    }
}

