/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import io.sarl.docs.validator.Messages;
import io.sarl.docs.validator.NoXtextResourceException;
import io.sarl.docs.validator.ScriptExecutor;
import io.sarl.lang.compiler.batch.CleaningPolicy;
import io.sarl.lang.compiler.batch.ICompilatedResourceReceiver;
import io.sarl.lang.compiler.batch.SarlBatchCompiler;
import io.sarl.lang.interpreter.SarlExpressionInterpreter;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlScript;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.junit.jupiter.api.Assertions;

public class SarlScriptExecutor
implements ScriptExecutor {
    private File tmpFolder = null;
    private String classPath = Strings.emptyIfNull(null);
    private String modulePath = Strings.emptyIfNull(null);
    private UnaryOperator<ClassLoader> classLoaderBuilder;
    private String sourceVersion = Strings.emptyIfNull(null);
    private Provider<SarlBatchCompiler> compilerProvider;
    private Provider<IExpressionInterpreter> interpreterProvider;
    private Provider<IEvaluationContext> contextProvider;
    private boolean isDeprecationAsError = true;

    @Inject
    public void setInjector(Injector injector) {
        this.compilerProvider = injector.getProvider(SarlBatchCompiler.class);
        this.interpreterProvider = injector.getProvider(IExpressionInterpreter.class);
        this.contextProvider = injector.getProvider(IEvaluationContext.class);
    }

    @Override
    public void setDeprecationAsError(boolean isError) {
        this.isDeprecationAsError = isError;
    }

    @Override
    public void setTempFolder(File dirname) {
        this.tmpFolder = dirname;
    }

    @Override
    public void setClassPath(String classpath) {
        this.classPath = Strings.emptyIfNull((String)classpath);
    }

    @Override
    public void setModulePath(String modulePath) {
        this.modulePath = Strings.emptyIfNull((String)modulePath);
    }

    @Override
    public void setClassLoaderBuilder(UnaryOperator<ClassLoader> builder) {
        this.classLoaderBuilder = builder;
    }

    @Override
    public void setJavaSourceVersion(String version) {
        this.sourceVersion = Strings.emptyIfNull((String)version);
    }

    private File createRootFolder() throws IOException {
        return FileSystem.createTempDirectory((String)"sarldocs", null, (File)this.tmpFolder);
    }

    private static File createSourceFolder(File root) {
        return new File(root, "src");
    }

    private static File createGenFolder(File root) {
        return new File(root, "src-gen");
    }

    private static File createBinFolder(File root) {
        return new File(root, "bin");
    }

    private static File createFile(File sourceFolder, String content) throws IOException {
        File file = new File(sourceFolder, "test.sarl");
        file.getParentFile().mkdirs();
        Files.write((byte[])content.getBytes(), (File)file);
        return file;
    }

    @Override
    public ScriptExecutor.CompiledFile compile(int lineno, String code, List<String> issues, ICompilatedResourceReceiver receiver) throws Exception {
        File rootFolder = this.createRootFolder();
        File sourceFolder = SarlScriptExecutor.createSourceFolder(rootFolder);
        File genFolder = SarlScriptExecutor.createGenFolder(rootFolder);
        File binFolder = SarlScriptExecutor.createBinFolder(rootFolder);
        SarlBatchCompiler compiler = (SarlBatchCompiler)this.compilerProvider.get();
        compiler.setBasePath(rootFolder.getAbsolutePath());
        compiler.addSourcePath(sourceFolder);
        compiler.setClassOutputPath(binFolder);
        compiler.setOutputPath(genFolder);
        compiler.setGenerateGeneratedAnnotation(false);
        compiler.setGenerateInlineAnnotation(false);
        compiler.setGenerateSyntheticSuppressWarnings(true);
        compiler.setCleaningPolicy(CleaningPolicy.NO_CLEANING);
        compiler.setClassPath(this.classPath);
        compiler.setModulePath(this.modulePath);
        compiler.setJavaSourceVersion(this.sourceVersion);
        compiler.setAllWarningSeverities(Severity.IGNORE);
        compiler.setWarningSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference", this.isDeprecationAsError ? Severity.ERROR : Severity.IGNORE);
        compiler.setJavaCompilerVerbose(false);
        Logger nopLogger = Logger.getAnonymousLogger();
        nopLogger.setLevel(Level.OFF);
        compiler.setLogger(nopLogger);
        if (issues != null) {
            compiler.addIssueMessageListener((severity, issue, uri, message) -> {
                if (issue.isSyntaxError() || severity == Severity.ERROR) {
                    Integer line = issue.getLineNumber();
                    int issueLine = (line == null ? 0 : line) + lineno;
                    issues.add(MessageFormat.format(Messages.SarlScriptExecutor_1, message, issueLine));
                }
            });
        }
        if (receiver != null) {
            compiler.addCompiledResourceReceiver(receiver);
        }
        File file = SarlScriptExecutor.createFile(sourceFolder, code);
        compiler.compile();
        return new ScriptExecutor.CompiledFile(rootFolder, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(int lineno, String code) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        ArrayList resources = new ArrayList();
        ScriptExecutor.CompiledFile outFile = this.compile(lineno, "package x.x.x;\nclass ____Fake_Class____ {\nstatic var __fake_attr__ : Object = {\n" + code + ";\n};\n}", issues, it -> resources.add(it));
        try {
            SarlScriptExecutor.assertNoIssue(lineno, issues);
            if (resources.isEmpty()) {
                throw new NoXtextResourceException(lineno);
            }
            Iterator iterator = resources.iterator();
            if (iterator.hasNext()) {
                IEvaluationContext executionContext;
                IEvaluationResult result;
                Resource resource = (Resource)iterator.next();
                SarlScript script = (SarlScript)resource.getContents().get(0);
                SarlClass clazz = (SarlClass)script.getXtendTypes().get(0);
                SarlField field = (SarlField)clazz.getMembers().get(0);
                XExpression xexpression = field.getInitialValue();
                IExpressionInterpreter interpreter = (IExpressionInterpreter)this.interpreterProvider.get();
                if (interpreter instanceof SarlExpressionInterpreter) {
                    SarlExpressionInterpreter exprEvaluator = (SarlExpressionInterpreter)interpreter;
                    if (this.classLoaderBuilder != null) {
                        ClassLoader expandClassLoader = exprEvaluator.expandClassLoader(this.classLoaderBuilder);
                        System.getProperties().put("SARL_DOC_SCRIPT_CLASS_LOADER", expandClassLoader);
                    }
                }
                if ((result = interpreter.evaluate(xexpression, executionContext = (IEvaluationContext)this.contextProvider.get(), CancelIndicator.NullImpl)).getException() == null) {
                    Object object = result.getResult();
                    return object;
                }
                throw new RuntimeException(result.getException());
            }
        }
        finally {
            if (outFile != null && outFile.getRootFolder() != null) {
                FileSystem.delete((File)outFile.getRootFolder());
            }
        }
        return null;
    }

    private static void assertNoIssue(int lineno, List<String> issues) {
        if (issues != null && !issues.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (String message : issues) {
                msg.append(message).append("\n");
            }
            Assertions.fail((String)MessageFormat.format(Messages.SarlScriptExecutor_0, lineno, msg.toString()));
        }
    }
}

