/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.inject.ImplementedBy;
import io.sarl.docs.validator.SarlScriptExecutor;
import io.sarl.lang.compiler.batch.ICompilatedResourceReceiver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.arakhne.afc.vmutil.FileSystem;

@ImplementedBy(value=SarlScriptExecutor.class)
public interface ScriptExecutor {
    public static final String PROP_CURRENT_FILE = "SARL_DOC_CURRENT_FILE";
    public static final String PROP_CURRENT_FOLDER = "SARL_DOC_CURRENT_FOLDER";
    public static final String PROP_CLASS_LOADER = "SARL_DOC_SCRIPT_CLASS_LOADER";

    public void setDeprecationAsError(boolean var1);

    public void setTempFolder(File var1);

    public void setClassPath(String var1);

    public void setModulePath(String var1);

    public void setClassLoaderBuilder(UnaryOperator<ClassLoader> var1);

    public void setJavaSourceVersion(String var1);

    default public List<String> compile(int lineno, String code) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        CompiledFile file = this.compile(lineno, code, issues, null);
        if (file != null && file.getRootFolder() != null) {
            FileSystem.delete((File)file.getRootFolder());
        }
        return issues;
    }

    public CompiledFile compile(int var1, String var2, List<String> var3, ICompilatedResourceReceiver var4) throws Exception;

    public Object execute(int var1, String var2) throws Exception;

    public static final class CompiledFile {
        private final File rootFolder;
        private final File file;

        public CompiledFile(File root, File file) {
            this.rootFolder = root;
            this.file = file;
        }

        public File getRootFolder() {
            return this.rootFolder;
        }

        public File getCompiledFile() {
            return this.file;
        }
    }
}

