/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import io.sarl.docs.validator.ShellCommand;
import io.sarl.docs.validator.ShellCommandProvider;
import io.sarl.lang.core.util.CliUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.arakhne.afc.vmutil.OperatingSystem;

public final class ShellExtensions {
    public static ShellCommandProvider shellCommandProvider;

    public static String makeExecName(String ... command) throws FileNotFoundException, IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < command.length - 1; ++i) {
            if (i > 0) {
                buffer.append(File.separator);
            }
            buffer.append(command[i]);
        }
        if (command.length > 1) {
            buffer.append(File.separator);
        }
        OperatingSystem os = OperatingSystem.getCurrentOS();
        switch (os) {
            case WIN: {
                buffer.append(command[command.length - 1]);
                buffer.append(".exe");
                break;
            }
            case MACOSX: {
                buffer.append(command[command.length - 1]);
                break;
            }
            default: {
                buffer.append(command[command.length - 1]);
            }
        }
        String cmd = buffer.toString();
        File file = new File(cmd);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("SARL_DOC_CURRENT_FOLDER") + File.separator + file.getPath()).getCanonicalFile();
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return file.getCanonicalPath();
    }

    public static String makeCliOption(String opt) {
        return CliUtilities.getCommandLineOption((String)opt);
    }

    public static String makeCliDefinition(String name, String value) {
        return CliUtilities.getCommandLineDefinition((String)name, (String)value);
    }

    public static String runShellSilently(String ... command) {
        try {
            return ShellExtensions.runShell(command);
        }
        catch (Throwable exceptionToIgnore) {
            return "ERROR: " + String.valueOf(exceptionToIgnore);
        }
    }

    public static String runShell(String ... command) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        Process process = processBuilder.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                output.append(line + "\n");
                line = reader.readLine();
            }
            process.waitFor();
        }
        return output.toString();
    }

    public static String runJavaCommand(Runnable command) throws Exception {
        PrintStream oldStdOut = System.out;
        PrintStream oldStdErr = System.err;
        try {
            String string;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                try (PrintStream newOut = new PrintStream((OutputStream)buffer);){
                    System.setOut(newOut);
                    System.setErr(newOut);
                    command.run();
                }
                buffer.flush();
                string = new String(buffer.toByteArray());
            }
            return string;
        }
        finally {
            System.setOut(oldStdOut);
            System.setErr(oldStdErr);
        }
    }

    public static String whichShellCommand(String commandName) throws FileNotFoundException {
        File executable;
        ShellCommand command;
        ShellCommandProvider provider = shellCommandProvider;
        if (provider != null && (command = provider.getShellCommand(commandName)) != null && (executable = command.executable()) != null) {
            return executable.getAbsolutePath();
        }
        throw new FileNotFoundException(commandName);
    }
}

