/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.validator;

import com.google.common.collect.Iterables;
import io.sarl.docs.validator.Messages;
import io.sarl.lang.core.util.SarlUtils;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.ReflectionUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.framework.Version;

public final class ShouldExtensions {
    private static final int HEX_RADIX = 16;

    private ShouldExtensions() {
    }

    public static boolean shouldBeDate(String actual, String dateFormat) {
        if (actual == null || actual.isEmpty()) {
            return false;
        }
        try {
            DateFormat format = dateFormat == null || dateFormat.isEmpty() ? DateFormat.getDateInstance() : new SimpleDateFormat(dateFormat);
            return format.parse(actual) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean shouldBeDate(String actual) {
        return ShouldExtensions.shouldBeDate(actual, null);
    }

    public static boolean shouldBeNumber(String actual, String numberFormat) {
        if (actual == null || actual.isEmpty()) {
            return false;
        }
        try {
            NumberFormat format = numberFormat == null || numberFormat.isEmpty() ? NumberFormat.getNumberInstance() : new DecimalFormat(numberFormat);
            return format.parse(actual) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean shouldBeNumber(String actual) {
        return ShouldExtensions.shouldBeNumber(actual, null);
    }

    public static boolean shouldBeMavenVersion(String actual, boolean allowSnapshot) {
        if (actual == null) {
            return false;
        }
        StringBuilder pattern = new StringBuilder("^");
        pattern.append("[0-9a-zA-Z_-]+(\\.[0-9a-zA-Z_-]+)*");
        if (allowSnapshot) {
            pattern.append("(?:");
            pattern.append(Matcher.quoteReplacement("-SNAPSHOT"));
            pattern.append(")?");
        }
        pattern.append("$");
        return Pattern.matches(pattern.toString(), actual);
    }

    public static boolean shouldBeMavenVersion(String actual) {
        return ShouldExtensions.shouldBeMavenVersion(actual, true);
    }

    private static Version parseJavaVersion(String version, Version defaultVersion) {
        try {
            Version v;
            Pattern pattern = Pattern.compile("^([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?");
            Matcher matcher = pattern.matcher(version);
            if (matcher.find()) {
                int minor = 0;
                String group = matcher.group(2);
                if (group != null && !group.isEmpty()) {
                    try {
                        minor = Integer.parseInt(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int micro = 0;
                group = matcher.group(3);
                if (group != null && !group.isEmpty()) {
                    try {
                        micro = Integer.parseInt(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int major = Integer.parseInt(matcher.group(1));
                return new Version(major, minor, micro);
            }
            if (version != null && !version.isEmpty() && (v = Version.valueOf((String)version)) != null) {
                return v;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultVersion;
    }

    public static boolean shouldBeJavaRange(String minVersion, String maxVersion) {
        Version minV;
        Version jreV = ShouldExtensions.parseJavaVersion(System.getProperty("java.version"), null);
        if (jreV != null && minVersion != null && (minV = ShouldExtensions.parseJavaVersion(minVersion, null)) != null) {
            Version maxV = null;
            if (maxVersion != null) {
                maxV = ShouldExtensions.parseJavaVersion(maxVersion, null);
            }
            if (maxV == null) {
                return jreV.compareTo(minV) >= 0;
            }
            return jreV.compareTo(minV) >= 0 && jreV.compareTo(maxV) < 0;
        }
        return false;
    }

    public static boolean shouldBeAtLeastJava(String minVersion) {
        return ShouldExtensions.shouldBeJavaRange(minVersion, null);
    }

    public static boolean shouldIterate(Iterator<?> actual, Object expected) {
        return ShouldExtensions.shouldIterate(actual, expected, true);
    }

    public static boolean shouldIterate(Iterator<?> actual, Object expected, boolean significantOrder) {
        Iterator<Object> it;
        if (expected instanceof Iterable) {
            it = ((Iterable)expected).iterator();
        } else if (expected instanceof Array) {
            Array array = (Array)expected;
            it = new ArrayIterator(array);
        } else {
            it = expected instanceof Map ? ((Map)expected).entrySet().iterator() : Collections.singleton(expected).iterator();
        }
        if (significantOrder) {
            while (actual.hasNext()) {
                Object obj = actual.next();
                if (!it.hasNext()) {
                    return false;
                }
                Object eObj = it.next();
                if (!(obj instanceof XExpression ? !ShouldExtensions.shouldBeLiteral((XExpression)obj, eObj) : !Objects.equals(obj, eObj))) continue;
                return false;
            }
            return !it.hasNext();
        }
        LinkedList<Object> expectedElements = new LinkedList<Object>();
        while (it.hasNext()) {
            expectedElements.add(it.next());
        }
        while (actual.hasNext()) {
            Object obj = actual.next();
            Iterator i = expectedElements.iterator();
            boolean found = false;
            while (!found && i.hasNext()) {
                Object eObj = i.next();
                if (obj instanceof XExpression) {
                    if (!ShouldExtensions.shouldBeLiteral((XExpression)obj, eObj)) continue;
                    i.remove();
                    found = true;
                    continue;
                }
                if (obj instanceof JvmIdentifiableElement && Objects.equals(((JvmIdentifiableElement)obj).getQualifiedName(), eObj)) {
                    i.remove();
                    found = true;
                    continue;
                }
                if (obj instanceof JvmTypeReference && Objects.equals(((JvmTypeReference)obj).getQualifiedName(), eObj)) {
                    i.remove();
                    found = true;
                    continue;
                }
                if (!Objects.equals(obj, eObj)) continue;
                i.remove();
                found = true;
            }
            if (found) continue;
            return false;
        }
        return expectedElements.isEmpty();
    }

    public static boolean shouldBeApiURL(String actual, String allowedAPIhostname) {
        if (actual == null || actual.isEmpty()) {
            return false;
        }
        try {
            List<String> hosts;
            URL u = FileSystem.convertStringToURL((String)actual, (boolean)true);
            if (u == null) {
                return false;
            }
            String[] validHostnames = new String[]{"www.sarl.io"};
            if (allowedAPIhostname != null && !allowedAPIhostname.isEmpty()) {
                validHostnames = allowedAPIhostname.split("[ \t]*[,;][ \t]*");
            }
            return (hosts = Arrays.asList(validHostnames)).contains(u.getHost()) && u.getQuery().endsWith(".html") && u.getPath().endsWith("index.html");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Number cleanNumber(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        if (stringRepresentation.startsWith("0x") || stringRepresentation.startsWith("0X")) {
            return new BigInteger(stringRepresentation.substring(2), 16);
        }
        String literal = stringRepresentation.replace("_", "");
        literal = literal.toLowerCase().replaceFirst("l|f|d|(bi)|(bd)$", "");
        return new BigDecimal(literal);
    }

    public static boolean shouldBe(XStringLiteral actual, Object expected) {
        if (actual == null) {
            return false;
        }
        String string = expected == null ? null : expected.toString();
        return Objects.equals(string, actual.getValue());
    }

    public static boolean shouldBe(XBooleanLiteral actual, Object expected) {
        Boolean b;
        if (actual == null) {
            return false;
        }
        if (expected instanceof Boolean) {
            b = (Boolean)expected;
        } else {
            try {
                b = Boolean.valueOf(expected.toString());
            }
            catch (Throwable exception) {
                return false;
            }
        }
        return b.booleanValue() == actual.isIsTrue();
    }

    public static boolean shouldBe(XNumberLiteral actual, Object expected) {
        Number number;
        if (actual == null) {
            return false;
        }
        if (expected instanceof Number) {
            number = (Number)expected;
        } else {
            try {
                number = NumberFormat.getInstance().parse(expected.toString());
            }
            catch (Throwable exception) {
                return false;
            }
        }
        Number anumber = ShouldExtensions.cleanNumber(actual.getValue());
        return number.doubleValue() == anumber.doubleValue();
    }

    public static boolean shouldBe(XTypeLiteral actual, Object expected) {
        if (actual == null) {
            return false;
        }
        String fqn = expected instanceof Class ? ((Class)expected).getName() : expected.toString();
        return actual.getType() != null && Objects.equals(fqn, actual.getType().getQualifiedName());
    }

    public static boolean shouldBe(XCollectionLiteral actual, Object expected) {
        if (actual == null || actual.getElements() == null) {
            return false;
        }
        return ShouldExtensions.shouldIterate(actual.getElements().iterator(), expected, !(actual instanceof XSetLiteral));
    }

    public static boolean shouldBeLiteral(XExpression actual, Object expected) {
        XBinaryOperation op;
        if (actual instanceof XNumberLiteral) {
            return ShouldExtensions.shouldBe((XNumberLiteral)actual, expected);
        }
        if (actual instanceof XBooleanLiteral) {
            return ShouldExtensions.shouldBe((XBooleanLiteral)actual, expected);
        }
        if (actual instanceof XStringLiteral) {
            return ShouldExtensions.shouldBe((XStringLiteral)actual, expected);
        }
        if (actual instanceof XTypeLiteral) {
            return ShouldExtensions.shouldBe((XTypeLiteral)actual, expected);
        }
        if (actual instanceof XNullLiteral) {
            return Objects.equals("null", expected);
        }
        if (actual instanceof XCollectionLiteral) {
            return ShouldExtensions.shouldBe((XCollectionLiteral)actual, expected);
        }
        if (actual instanceof XBinaryOperation && "operator_mappedTo".equals((op = (XBinaryOperation)actual).getFeature().getSimpleName())) {
            Object value;
            Object key;
            if (expected instanceof Pair) {
                key = ((Pair)expected).getKey();
                value = ((Pair)expected).getValue();
            } else if (expected instanceof Map.Entry) {
                key = ((Map.Entry)expected).getKey();
                value = ((Map.Entry)expected).getValue();
            } else {
                return false;
            }
            return ShouldExtensions.shouldBeLiteral(op.getLeftOperand(), key) && ShouldExtensions.shouldBeLiteral(op.getRightOperand(), value);
        }
        return false;
    }

    public static Method shouldHaveDeprecatedMethod(Class<?> type, String name) {
        return ShouldExtensions.shouldHaveMethod(type, name, true);
    }

    public static Method shouldHaveMethod(Class<?> type, String name) {
        return ShouldExtensions.shouldHaveMethod(type, name, false);
    }

    protected static Method shouldHaveMethod(Class<?> type, String name, boolean deprecated) {
        Pattern pattern = Pattern.compile("^([_a-zA-Z0-9]+)\\s*(?:\\(\\s*([_a-zA-Z0-9.\\$]+(?:\\[\\])?\\s*(?:,\\s*[_a-zA-Z0-9.\\$]+(?:\\[\\])?\\s*)*)\\))?(?:\\s*:\\s*([_a-zA-Z0-9.\\$]+(?:\\[\\])?))?$");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            boolean validReturnType;
            Method method;
            String returnText;
            String paramText;
            try {
                paramText = matcher.group(2).trim();
            }
            catch (Throwable exception) {
                paramText = "";
            }
            try {
                returnText = matcher.group(3).trim();
            }
            catch (Throwable exception) {
                returnText = "";
            }
            String[] params = paramText.isEmpty() ? new String[]{} : paramText.split("\\s*,\\s*");
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i].endsWith("[]")) {
                    Class paramType;
                    String typeName = params[i].substring(0, params[i].length() - 2);
                    try {
                        paramType = ReflectionUtil.forName((String)typeName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_2, typeName));
                    }
                    Object tmpArray = Array.newInstance(paramType, 0);
                    types[i] = tmpArray.getClass();
                    continue;
                }
                try {
                    types[i] = ReflectionUtil.forName((String)params[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_2, params[i]));
                }
            }
            String fctName = matcher.group(1);
            try {
                method = type.getDeclaredMethod(fctName, types);
            }
            catch (NoSuchMethodException | SecurityException e) {
                method = null;
            }
            if (method == null) {
                throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_3, name));
            }
            if (returnText == null || returnText.isEmpty()) {
                validReturnType = Void.TYPE.equals(method.getReturnType()) || Void.class.equals(method.getReturnType());
            } else {
                Class rtype;
                try {
                    rtype = ReflectionUtil.forName((String)returnText);
                }
                catch (ClassNotFoundException exception) {
                    throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_2, returnText));
                }
                validReturnType = rtype.equals(method.getReturnType());
            }
            if (validReturnType) {
                Deprecated deprecatedAnnotation = method.getAnnotation(Deprecated.class);
                if (deprecated && deprecatedAnnotation != null || !deprecated && deprecatedAnnotation == null) {
                    return method;
                }
                throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_4, name));
            }
            throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_5, name, method.getReturnType().getName()));
        }
        throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_6, name, pattern));
    }

    public static boolean shouldHaveMethods(Class<?> type, String ... prototypes) {
        return ShouldExtensions.shouldHaveMethods(type, false, prototypes);
    }

    public static boolean shouldHaveMethods(Class<?> type, boolean considerHiddenNames, String ... prototypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            Deprecated deprecatedAnnotation;
            if (!Flags.isPublic((int)method.getModifiers()) || (deprecatedAnnotation = method.getAnnotation(Deprecated.class)) != null || !considerHiddenNames && ShouldExtensions.shouldBeHiddenName(method.getName())) continue;
            methods.add(method);
        }
        for (String prototype : prototypes) {
            Method method = ShouldExtensions.shouldHaveMethod(type, prototype, false);
            if (method == null) {
                throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_0, prototypes, Iterables.toString(methods)));
            }
            methods.remove(method);
        }
        if (!methods.isEmpty()) {
            throw new ShouldException(MessageFormat.format(Messages.ShouldExtensions_1, type.getName(), Iterables.toString(methods)));
        }
        return true;
    }

    public static boolean shouldBeHiddenName(String string) {
        return SarlUtils.isHiddenMember((String)string);
    }

    public static Field shouldHaveDeprecatedField(Class<?> type, String name) {
        return ShouldExtensions.shouldHaveField(type, name, true);
    }

    public static Field shouldHaveField(Class<?> type, String name) {
        return ShouldExtensions.shouldHaveField(type, name, false);
    }

    protected static Field shouldHaveField(Class<?> type, String name, boolean deprecated) {
        block11: {
            try {
                boolean validType;
                String fieldType;
                Pattern pattern = Pattern.compile("^([_a-zA-Z0-9]+)\\s*(?:\\s*:\\s*([_a-zA-Z0-9.\\$]+(?:\\[\\])?))?$");
                Matcher matcher = pattern.matcher(name);
                if (!matcher.matches()) break block11;
                String fieldName = matcher.group(1);
                try {
                    fieldType = matcher.group(2).trim();
                }
                catch (Throwable exception) {
                    fieldType = "";
                }
                Field field = type.getDeclaredField(fieldName);
                if (field == null) {
                    return null;
                }
                if (fieldType != null && !fieldType.isEmpty()) {
                    Class<?> rtype;
                    if (fieldType.endsWith("[]")) {
                        Class paramType = ReflectionUtil.forName((String)fieldType.substring(0, fieldType.length() - 2));
                        Object tmpArray = Array.newInstance(paramType, 0);
                        rtype = tmpArray.getClass();
                    } else {
                        rtype = ReflectionUtil.forName((String)fieldType);
                    }
                    validType = rtype.equals(field.getType());
                } else {
                    validType = true;
                }
                if (validType) {
                    Deprecated deprecatedAnnotation = field.getAnnotation(Deprecated.class);
                    if (deprecated && deprecatedAnnotation != null || !deprecated && deprecatedAnnotation == null) {
                        return field;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean shouldExtend(Class<?> type, String expectedTypes) {
        if (type == null) {
            return false;
        }
        try {
            Class<?> st = type.getSuperclass();
            LinkedList types = new LinkedList();
            if (st == null || Object.class.equals(st)) {
                if (type.isInterface()) {
                    types.addAll(Arrays.asList(type.getInterfaces()));
                }
            } else {
                types.add(st);
            }
            if (expectedTypes == null || expectedTypes.isEmpty()) {
                return types.isEmpty();
            }
            for (String expectedType : expectedTypes.split("\\s*,\\s*")) {
                Class et = ReflectionUtil.forName((String)expectedType);
                if (types.remove(et)) continue;
                return false;
            }
            return types.isEmpty();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean shouldHaveNbMembers(Class<?> type, int expectedNbOfElements) {
        if (type == null) {
            return false;
        }
        try {
            int nb = type.getDeclaredConstructors().length + type.getDeclaredFields().length + type.getDeclaredMethods().length + type.getDeclaredAnnotations().length + type.getDeclaredClasses().length;
            return nb == expectedNbOfElements;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static <K, V> boolean shouldBe(Map<K, V> map, Map<? super K, ? super V> reference) {
        if (map == null) {
            return false;
        }
        if (reference == null || reference.isEmpty()) {
            return map.isEmpty();
        }
        for (Map.Entry<K, V> entry : reference.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                return false;
            }
            V currentValue = map.get(entry.getKey());
            if (Objects.equals(currentValue, entry.getValue())) continue;
            return false;
        }
        return map.size() == reference.size();
    }

    public static boolean shouldHaveProperty(URL propertyFile, String propertyName) {
        boolean bl;
        block8: {
            Properties props = new Properties();
            InputStream is = propertyFile.openStream();
            try {
                props.load(is);
                String value = props.getProperty(propertyName, null);
                boolean bl2 = bl = value != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean shouldHaveProperty(URL propertyFile, Pair<String, String> property) {
        if (propertyFile != null && property != null) {
            boolean bl;
            block9: {
                Properties props = new Properties();
                InputStream is = propertyFile.openStream();
                try {
                    props.load(is);
                    String value = props.getProperty((String)property.getKey(), null);
                    bl = Objects.equals(value, property.getValue());
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        private final Array array;
        private int index;
        private Object obj;

        ArrayIterator(Array array) {
            this.array = array;
            this.searchNext();
        }

        private void searchNext() {
            try {
                this.obj = Array.get(this.array, this.index);
                ++this.index;
            }
            catch (Throwable exception) {
                this.obj = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.obj != null;
        }

        @Override
        public Object next() {
            if (this.obj == null) {
                throw new NoSuchElementException();
            }
            Object object = this.obj;
            this.searchNext();
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ShouldException
    extends RuntimeException {
        private static final long serialVersionUID = 3129485320879065188L;

        public ShouldException(String message) {
            super(message);
        }
    }
}

