# FAQ related to the Runtime Environment 

[:Outline:]


## General Questions about Janus

### What is the SRE?

SRE stands for "SARL Runtime Environment". The SRE is an implementation of an agent platform, which is able to
run a SARL program. The official standard SRE supported by the SARL developers is the
[Janus platform]([:janus.url!]).


### What is Janus?

Janus is an open-source multi-agent platform fully implemented 
in Java [:sarl-dsl.min.jdk.version!]. Janus enables developers to quickly create 
web, enterprise and desktop agent-based applications.
[:Fact:]("[:sarl-dsl.min.jdk.version!]".shouldBeAtLeastJava)

__Janus is an agent execution platform not an agent-oriented language.__

It provides a comprehensive set of features to develop, run, display and monitor agent-based applications.

Janus-based applications can be distributed across a network. 
Janus could be used as an agent-oriented platform, an 
organizational platform, and/or a holonic platform. It 
also natively manages the concept of recursive agents and 
holons.

Official website: [[:janus.url!]]([:janus.url!])


### Where can I ask my question?

If you cannot find an answer to your question in the FAQ, nor the reference documents, nor
the [existing SARL issues](https://github.com/sarl/sarl/issues),
you may ask the SARL developers on 
[the SARL forum](https://groups.google.com/forum/#!forum/sarl), or 
on the [instant messaging forum](https://gitter.im/sarl/Lobby).


### Where can I found information on the release planning of Janus?

Janus is now part of the SARL project.
The release planning of SARL is detailed on the [milestones page](https://github.com/sarl/sarl/milestones)
on Github.

## Installation and Execution

### What is the list of all the error, warning and information messages that may be generated by Janus?

Several run-time errors from the [Janus framework](../tools/Janus.md) are explained [here](../tools/Janus.md#list-of-errors-and-warnings). 



### Is my operating system compatible with Janus?

The [Janus runtime platform]([:janus.url!])
is a Java application. Every operating system which has 
a Java Virtual Machin, especially the Java Development Kit (JDK),
with at least with the [:sarl-run.min.jdk.version!]
standard may be used to run Janus. 
[:Fact:]("[:sarl-run.min.jdk.version!]".shouldBeAtLeastJava)


### What is the version of the Java virtual machine to install?

Janus requires the JDK [:sarl-run.min.jdk.version!] or higher
(and strictly lower than [:sarl-run.next.unsupported.jdk.version!]) to run and compile.
Note that if you plan to create Android applications, you may 
configure your JDK to produce 1.6 class files from [:sarl-run.min.jdk.version!] Java code,
depending of the current supported standard on Android platforms.
[:Fact:]("[:sarl-run.min.jdk.version!]".shouldBeAtLeastJava)


### How to launch an agent in Janus?

Three methods are available for launching one or more agents in the Janus platform:

* [From the command line](../getstarted/RunSARLAgentCLI.md).
* [Inside the Eclipse IDE](../getstarted/RunSARLAgentEclipse.md).
* [From a Java program](../getstarted/RunSARLAgentJava.md).
* [By creating a runnable application file](../tutorials/runtime/CreateRunnableJar.md).



### In the Eclipse SARL product, what is the difference between the launch configurations "SARL Agent" and "SARL Application"?

There is two methods for starting an application that will run SARL agents:

* start an agent that will create all the components of the application, or
* start a standard Java application that will start the SRE later during its execution. 

For the first case, the qualified name of the agent type to be launched must be provided.
This case is supported by the *SARL Agent* launch configuration.

For the second case, the `main()` function of the application should be launched in 
order to start it. This case is supported by the *SARL Application* launch configuration.

Both launch configurations adds the SARL Run-time Environment into the run-time classpath.
The selected SRE depends on the configuration of your Eclipse SARL product.


### In the Eclipse SARL product, what is the difference between the launch configurations "Java Application" and "SARL Application"?

Both "Java Application" and "SARL Application" are launch configurations for starting 
a Java application, i.e. invoking the `main()` function for starting up.

The difference between them is that the "SARL Application" launch configuration is 
automatically adding in the application classpath the SARL Run-time Environment that
is configured into your Eclipse SARL project.
The "Java Application" does not.

Consequently, if you need to run agents and if you start your application with a "Java 
Application" launch configuration, you must add manually the SRE libraries in the classpath.
 

### Error: "The SRE is not standalone. It does not contain the Java dependencies."

This error occurs when there is no SARL Runtime Environment (SRE) installed on your
Eclipse environment, OR when the installed SRE is not compatible with the installed
version of the SARL tools, which are embedded in Eclipse.

For solving this problem, you must download the latest
[Janus platform]([:janus.url!]), and install it in your Eclipse
(Menu `Window&gt; Preferences&gt; SARL&gt; Installed SREs`).


### Error: "Incompatible SRE with SARL 1.1.1.1. Version must be lower than 0.0.0."

This error occurs when the SARL Runtime Environment (SRE) has a version lower than
the version of the SARL tools, which are embedded in the Eclipse IDE.
This difference of version may cause problems during the execution of your agents, since
the capacities' definitions may not be the same.

For solving this problem, you must download the version of the SARL Runtime Environment (SRE)
that is implementing the version of the SARL specification that you're using on Eclipse IDE.
For the Janus platform, the versions of the latest stable and development releases are displayed on
[this page]([:janus.url!]).


### Error: "Agent class not found."

When the Janus platform cannot find the class file for the start-up agent, it
displays the error message `"Agent class not found"`.

For resolving this problem, you should check if:

* the class with the given name exists in the application's class path.
* the class name is given as the first command-line argument to your application.
* the class with the given name is a subtype of `Agent`.
[:Fact:](io.sarl.lang.core.Agent)


For showing the arguments given to Janus, you could launch Janus with the command line option:
`--cli`. This option stops Janus after displaying the command line arguments,
including the `--cli` option.


### Error: "Invalid byte 2 of 4-byte UTF-8 sequence."

When installing Janus as an SRE in the Eclipse interface, the plugin loads the Jar file of the
SRE with the default API.
The Jar archiver uses the default file encoding of the operating system.
On Linux and MacOS 10, it is almost UTF-8. On Windows, it is Latin1. And on MacOS (before 10),
it is Mac-Roman.

The Janus Jar file is generated on a Linux operating system (UTF-8).
When the Java virtual machine tries to uncompress and use the content of the Jar, it
may complain about an invalid charset format.

For solving this issue, you could launch your Eclipse with the command line option
`-Dfile.encoding=UTF-8`, which is forcing the Eclipse product to consider the
file as encoded with the UTF-8 charset.
Note that this option is defined into the Eclipse SARL product since version 0.4.


### How to create a runnable?

Both "Java Application" and "SARL Application" are launch configurations for starting 
a Java application, i.e. invoking the `main()` function for starting up.

The difference between them is that the "SARL Application" launch configuration is 
automatically adding in the application classpath the SARL Run-time Environment that
is configured into your Eclipse SARL project.
The "Java Application" does not.

Consequently, if you need to run agents and if you start your application with a "Java 
Application" launch configuration, you must add manually the SRE libraries in the classpath.

If you want ot create a runnable jar file, read the following comment.


### How to create a runnable JAR file?

In the Java programming environment, a runnable JAR (Java Archive) file represents a self-contained and executable unit that encapsulates both compiled bytecode and necessary metadata, facilitating the distribution and execution of the application. The creation of a runnable JAR file involves the compilation of SARL and Java source code into bytecode by the SARL and Java compilers, followed by the packaging of these class files along with any associated resources into the JAR archive. This process is typically managed through build tools such as Maven or Gradle, which automate the compilation, packaging, and dependency management tasks. 

Different methods may be used for creating the runnable JAR for your application:

#### If you are using Maven for compiling your application

1. First, you have to include in the class path all the needed libraries for running the SARL application, including the SARL runtime environment (SRE) itself. See the section for [adding Janus SRE in the classpth](../getstarted/CreateFirstProject.md#configuration-of-a-runtime-environment-optional).
2. Create a file in the same folder on the Maven POM configuration file that is defining the packaging of the runnable JAR file. The name of this file is assumed to be `run.xml`. More details on the format of this file could be found on the [Maven Assembly plugin page](https://maven.apache.org/plugins/maven-assembly-plugin/assembly.html).
```xml
<assembly xmlns="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0 http://maven.apache.org/xsd/assembly-1.1.0.xsd">
  <id>run</id>
  <formats>
    <format>jar</format>
  </formats>
  <includeBaseDirectory>false</includeBaseDirectory>
  <dependencySets>
    <dependencySet>
      <unpack>true</unpack>
      <scope>runtime</scope>
    </dependencySet>
  </dependencySets>
  <containerDescriptorHandlers>
		<!-- Merge service description's files in a proper way -->
		<containerDescriptorHandler>
			<handlerName>metaInf-services</handlerName>
		</containerDescriptorHandler>
		<!-- Merge plugin description's files in a proper way -->
		<containerDescriptorHandler>
			<handlerName>file-aggregator</handlerName>
			<configuration>
				<filePattern>plugin.properties</filePattern>
				<outputPath>plugin.properties</outputPath>
			</configuration>
		</containerDescriptorHandler>
  </containerDescriptorHandlers>
</assembly>
```
3. Update the Maven POM configuration for creating the runnable JAR file. Here, we use the [Maven Assembly plugin](https://maven.apache.org/plugins/maven-assembly-plugin/assembly.html). In this XML configuration, replace the name of the main class [:runnablejarmainclassmaven:] by the name of the class in your code that is containing the `main()` function.
```xml
<build>
  ...
  <plugins>
      ...
      <plugin>
        <groupId>org.apache.maven.plugins</groupId>
        <artifactId>maven-assembly-plugin</artifactId>
        <version>3.7.1</version>
        <executions>
          <execution>
            <id>run-application</id>
            <phase>package</phase>
            <goals>
              <goal>single</goal>
            </goals>
            <configuration>
              <descriptors>
                <descriptor>run.xml</descriptor>
              </descriptors>
              <archive>
                <manifest>
                  <mainClass>[:runnablejarmainclassmaven](io.sarl.mycode.application.MainClass)</mainClass>
                </manifest>
              </archive>
              <attach>false</attach>
            </configuration>
          </execution>
        </executions>
      </plugin>
      ...
  </plugins>
  ...
</build>
```
4. Run Maven tool:
```bash
$ mvn clean install
```
5. Your runnable JAR file will be generated in the `target` folder generated by the Maven tool.

#### If you are not using Maven for compiling your application

1. First, you have to be sure that you are running your application with a `SARL Application` launch configuration. It is mandatory in order to have a `main()` function for running the application.
2. Second, you have to include in the class path all the needed libraries for running the SARL application, including the SARL runtime environment (SRE) itself. See the section for [adding Janus SRE in the classpth](../getstarted/CreateFirstProject.md#configuration-of-a-runtime-environment-optional).
3. In the SARL development environment, right click on your projet name.
4. Select the `Export` item in the contextual menu.
5. In the Export dialog box, open the `SARL` section and select the export wizard with the name `Runnable SARL application`, and click on `Next`.
6. Select your launch configuration. It is not appearing, it means that your have not defining a `SARL application` launch configuration for your application.
7. Specify the path where to create your runnable JAR file, and click on finish.
   

## Runtime Behavior of Janus


### Are events received in the same order than when they are sent?

__No__.

There is no warranty on the receiving order of the events.
This is a particular implementation choice of the runtime
environment. For example, the
[Janus runtime environment]([:janus.url!]) executes
the event handlers in parallel. The real order of execution depends on
how the Java executor is running the handlers on the threads.



### How events are treated by the run-time environment?

When the event `e` of type `E` is received by an agent the following algorithm is applied:

```text
if "on Initialize" is currently running then
   add e to a buffer of events.
else if "on Destroy" is currently running then
   ignore the event.
else
   [:firefct]{fire(e)}
fi
```

The function [:firefct:] retrieves all the `on E` and runs them in parallel, and
there is a synchronization point after the running of all the `on E` if `E` is
`Initialize` or `Destroy` (for forcing synchronous execution of `on Initialize`
and `on Destroy`). At the end of the `on Initialize` (after synchronization point),
all the buffered events are fired.

Observe that if the event is fired from within the `on Initialize`, the same algorithm
is applied whatever the receiving agent.



### How the spawn function is run by the run-time environment?

Regarding `spawn()`, the function runs in two parts:

1. First, the spawn agent is created. This part is run in the same thread as the
   caller of spawn, so the spawn call blocks.
2. Once the spawn agent has been created, the initialization process runs
   within a separated thread from the spawner agent. So, the call `spawn()` is
   not locked. Then, the created thread runs all the initialization process,
   including the synchronous execution of `on Initialize` (see previous question).
   Consequently, the `on Initialize` of the spawn agent will not block the spawn caller.



### Must I configure the Janus kernels to be connected to other Janus kernels?

__No__.

Janus was designed to discover other kernels automatically.
By default, the different instances of the Janus platform
are connected together without any particular configuration.
The sole constraint is that the kernels must be on the
same local network.


## Contribute to Janus

### Where are the sources for Janus?

The sources for Janus are available inside the SARL project repository on
[Github](https://github.com/sarl/sarl/tree/master/sarl-sre/janus/).


### How can I find the current issues?

Janus Developers use [Github](https://github.com/sarl/sarl)
to manage bug tracking and project workflow. 
The issues are listed on [Github](https://github.com/sarl/sarl/issues). 


### How can I report a problem or a bug in Janus components?


You should submit your issue on 
[this page](https://github.com/sarl/sarl/issues/new).


[:Include:](../includes/legal.inc)
