# Get Started with the SARL language

Welcome to the "Get Started" guide for SATL! Whether you're new to programming or an experienced developer looking to explore a new language, you've come to the right place.

SARL is designed to be intuitive, powerful, and versatile, making it suitable for a wide range of applications that are needing multiagent systems and holonic multiagent systems. This guide will walk you through the basics of setting up your development environment and writing your first program.

By the end of this guide, you'll have the foundations to start building your own projects and exploring the [tutorials](../tutorials/index.md) or more advanced features of SARL.

## Installation

Step-by-step instructions on how to [install SARL on your computer](./InstallSARLTools.md).

## Set-up your project and first code

Creation of your [first project](./CreateFirstProject.md), and its configuration.

Creation of your [first SARL agent](./AgentIntroduction.md).

## Running SARL agents

These is three methods for running agents:

* [Inside the development environment](./RunSARLAgentEclipse.md).
* [From the Shell command-line](./RunSARLAgentCLI.md).
* [From another Java or a SARL program](RunSARLAgentJava.md).

[:Include:](../includes/legal.inc)

