# List of the SARL Compiler Errors and Warnings

This page provides the exhaustive list of error and warning messages that may be generated by the SARL compiler.

The "N." column provides a number that could be used in order to make easier your discussions with the SARL developers on the forums.

The column "Message and Description" contains information and details on each issue.
The **message** gives a template of typical message that is given by the compiler.
The **cause** describes the source of the issue, and provides a short explanation of the cause of the issue.
The **solving** provides guidelines to fix the issue when it is possible.

The "Level" column indicates the level of importance for the issue.
It may be:
* "error": the issue makes the compiler failing and stopping. This type of issue can be ignored neither programmatically (see below) nor with the SARL compiler configuration.
* "warning": the issue is an important message that may have implication on the quality of your program. But, it does not stop the compiler. This type of issue can be ignored neither programmatically (see below) nor with the SARL compiler configuration.
* "info": the issue is a simple information message from the compiler. The impact on the quality of your program is low. The compiler is not stopped when an information message is output. This type of issue can be ignored neither programmatically (see below) nor with  the SARL compiler configuration.
* "configurable": the issue has a level (inside "error", "warning", "info", "ignore") that may be configured by the SARL developers themselves. A default level is assumed for the case the SARL developers did not specify their preferred level for the issue. It could be ignore both programmatically (see below) and with the SARL compiler configuration.
* "delegated": it is similar to "configurable", except that the configuration management is delegated to the Eclipse Java Development Toolkit (JDT), and its preference pages. In the case of delegated error, the associated JDT issue code is also provided for information.


In the case of an issue with a "configurable" or "delegated" level, you could select yourself the level that should be used by the SARL compiler for the issue.
This configuration may be done into the preferences of the Eclipse SARL IDE or in the configuration of the `sarlc` command-line compiler.
Additionally, you could force the SARL compiler to ignore an issue by attaching the annotation `@SuppressWarnings("code")` to the element that is marked with the issue.
In this annotation, the code corresponds to the content of the "Code" column below.
This code may have a short format (e.g., the one shown in the column), or a long format (e.g., if you move your mouse pointer on the code, you should see the long format of the code into a pop-up window).
The long code is provided by the SARL compiler at the end of each of the issue messages.
It is preferable to use the short code as argument to `@SuppressWarnings`. Nevertheless, it may be ambiguous with other issue codes
that could be defined outside the SARL compiler itself (e.g. Eclipse, Checkstyle, etc.). In the case of ambiguity, you could use
the long code as argument to `@SuppressWarnings` too.



| N. | Message and Description | Level | Code |
| -- | ----------------------- | ----- | ---- |
[:Dynamic:]{
	readIssueDescriptionsFromSarlJsonFiles.validateSarlIssueCodes.sort.asTable.renderToMarkdown
}

[:Fact:](readIssueDescriptionsFromSarlJsonFiles.validateSarlIssueMessages)



[:Include:](../includes/legal.inc)
