# The SARL Standard Development Kit

[:Outline:]

This page provides an overview of the SARL Standard Development Kit (SDK), addressing both foundational concepts and advanced features for developing agent-based applications.

## Agent Architectures

The [Agent Architectures documentation](./AgentArchitectures.md) introduces the concepts, design patterns and libraries for building specific models or algorithms in the agents, also known as the agent architectures. It discusses the various architectural styles, such as reactive, proactive, and hybrid architectures, and how they can be implemented using SARL. An example of typical agent architectures is related to goal-oriented behaviors.

## Naming and Namespaces in SARL

The [Naming and Namespaces documentation](./Naming.md) addresses the mechanisms for identifying agents and their components within the SARL framework. Naming conventions and namespaces are vital for ensuring uniqueness and avoiding conflicts in multi-agent systems. This section explains how SARL handles naming, scoping, and resolution of agents and their resources.

## Working Memory for Agents

[Working Memory](./WorkingMemory.md) is a component in agent-based systems, enabling agents to store and manipulate data dynamically during their execution. This [documentation](./WorkingMemory.md) elaborates on how SARL SDK provides mechanisms for agents to maintain a working memory. It also cover the integration of working memory with other agent capabilities, such as perception and action.

## Observing and Probes

[Observing and Probes](./Probing.md) focuses on monitoring and debugging agent-based systems. This documentation likely describes the tools and techniques available in SARL for observing agent states, behaviors, and interactions.

## SRE: Programmatic Access to the SARL Run-time Environment

The [SRE utility documentation](./SRE.md) provides insights into how developers can programmatically interact with the SARL Run-time Environment (SRE). This includes accessing and manipulating agents, their behaviors, and the environment itself during execution in accordance to the core principles of multi-agent systems, such as autonomy. 


[:Include:](../../includes/legal.inc)

