# Janus Command-line Launcher - janus

[:Outline:]

[:Fact:]{(io.sarl.sre.janus.boot.Boot)::getDefaultSreProgramName == '[:name](janus)'}

[:Include:](../includes/janus.inc)

For launching the Janus platform from a command-line shell, you could use the [:name:] tool.

> **_Caution:_** The [:name:] does not provide a support for exchanging events over a computer
> network. If you would like to have benefit of this feature, you should use one of the following
> methods:
> 1. Add a library on the classpath that includes the networking feature to the SRE; or
> 2. Use the version of the SRE that includes the standard network feature: [janusnode](./Janusnode.md).

## Note on the application classpath

The Janus command-line tool adds automatically the Jar files of Janus on the application classpath.
It means that you don't need to add any SRE, including Janus, in the dependencies of your project if you plan to use the Janus command line tool.

For other methods for launching a SARL application, please refer to one of:

* [Running an agent from the command-line shell](../getstarted/RunSARLAgentCLI.md)
* [Running an agent inside SARL Eclipse environment](../getstarted/RunSARLAgentEclipse.md)
* [Running an agent from a Java program progammatically](../getstarted/RunSARLAgentJava.md)


## Usage

The [:name:] tool takes arguments:

```text
[:name!] [OPTIONS] <[:agname](agent_fully_qualified_name)>
```


The [:agname:] is the name of the agent to launch. This name is equal to the
fully qualified name of the agent's type.

> **_Note:_** Janus enables to launch only one agent from the command-line shell. If you want to launch
> more than one agent, you should launch a first agent, which will create the other agents.

You could change the behavior of the [:name:] tool with the command-line options.
For obtaining a list of the options, type:

```text
[:name!] -help
```


## Command-Line Options

The Janus framework provides options on the command-line.
The list of the options is displayed below. This list includes
all the standard modules of Janus. If you add an extra module into
the classpath of your application, more options may become available.



| Option | Description |
| ------ | ----------- |
[:Dynamic:]{
	runShellSilently(whichShellCommand("janus"), "generatemarkdownhelp".makeCliOption)
}



## List of Errors and Warnings

This section provides the non-exhaustive list of error and warning messages that may be generated by Janus.
Indeed, Janus code may generates errors and warnings that are documented below. However, several errors may
occur because of one of the used library. In these errors are not necessary documented, and must be discussed
on [Gitter](https://gitter.im/sarl/Lobby) or [Google Group]([:sarl.url!]/community/forums.html) with the
SARL community.

The "N." column provides a number that could be used in order to make easier your discussions with the SARL developers on the forums.

The column "Message and Description" contains information and details on each issue.
The **message** gives a template of typical message that is given by the compiler.
The **cause** describes the source of the issue, and provides a short explanation of the cause of the issue.
The **solving** provides guidelines to fix the issue when it is possible.

The "Level" column indicates the level of importance for the issue.
It may be:
* "error": the issue makes Janus failing and stopping.
* "warning": the issue is an important message that may have implication on the quality of your program.
* "info": the issue is a simple information message from the compiler. The impact on the quality of your program is low.


The code of the issue, which is appended at the end of the messages, corresponds to the content of the "Code" column below.
This code may have a short format (e.g., the one shown in the column), or a long format (e.g., if you move your mouse pointer on the code, you should see the long format of the code into a pop-up window).
The long code is provided by the SARL compiler at the end of the issue messages.



| N. | Message and Description | Level | Code |
| -- | ----------------------- | ----- | ---- |
[:Dynamic:]{
	readIssueDescriptionsFromDefaultJsonFile.validate(io.sarl.sre.janus.IssueCodes::issueCodeContainers, "Janus SRE").sort.asTable.renderToMarkdown
}



[:Include:](../includes/legal.inc)

