# Janus Command-line Launcher with Network Support - janusnode

[:Outline:]

[:Include:](../includes/janus.inc)

The [`janus`](./Janus.md) tool is the base command-line tool for launching the SRE.
But, it does not provide a support for exchanging events over a computer
network. If you would like to have benefit of this feature, you should use one of the following
methods:

1. Add on the classpath of the `janus` command the [library that includes the networking feature](./JanusNetworkExtension.md) to the SRE; or
2. Use the version of the SRE that already includes the [standard network feature](./JanusNetworkExtension.md): `[:name](janusnode)`.

The [:name:] is explained on this page.

## Basics of the Networking Feature

[:Include:](../includes/hazelcast.inc)

## Note on the application classpath

The `janusnode` command-line tool adds automatically the Jar files of Janus on the application classpath.
It means that you don't need to add any SRE, including Janus, in the dependencies of your project if you plan to use the Janus command line tool.

For other methods for launching a SARL application, please refer to one of:

* [Running an agent from the command-line shell](../getstarted/RunSARLAgentCLI.md)
* [Running an agent inside SARL Eclipse environment](../getstarted/RunSARLAgentEclipse.md)
* [Running an agent from a Java program progammatically](../getstarted/RunSARLAgentJava.md)

## Usage

The [:name:] tool takes arguments:

```text
[:name!] [OPTIONS] <[:agname](agent_fully_qualified_name)>
```


The [:agname:] is the name of the agent to launch. This name is equal to the
fully qualified name of the agent's type.

> **_Note:_** Janus enables to launch only one agent from the command-line shell. If you want to launch
> more than one agent, you should launch a first agent, which will create the other agents.

You could change the behavior of the [:name:] tool with the command-line options.
For obtaining a list of the options, type:

```text
[:name!] -help
```


## Command-Line Options

The Janus framework provides options on the command-line.
The list of the options is displayed below. This list includes
all the standard modules of Janus, and the networking features.
If you add an extra module into the classpath of your application,
more options may become available.



| Option | Description |
| ------ | ----------- |
[:Dynamic:]{
	runShellSilently(whichShellCommand("janusnode"), "generatemarkdownhelp".makeCliOption)
}



## List of Errors and Warnings

The list of error and warning messages that may be generated by Janus are provided on the
help page of the [main command-line tool](./Janus.md).

## Configuration of the networking feature

The configuration of the networking feature is explained on this [page](./JanusNetworkExtension.md).


[:Include:](../includes/legal.inc)

