# Tools Associated to the SARL Programming Language

SARL is provided with a suite of tools designed to enhance development, compilation, and execution of SARL applications. These tools cater to various aspects of the development lifecycle, from writing and compiling code to running applications in different environments.

[:Outline:]

## SARL Syntax Highlighting

- [Definitions of SARL syntax highlighting for several code editors](./SyntaxHighlightning.md)

## Compilation Tools

- [SARL compiler](./Sarlc.md) (sarlc)
- [Maven plugin](./MavenSarlPlugin.md) (sarl-maven-plugin)

## Documentation Tools

- [SARL documentation generator](./Sarldoc.md) (sarldoc)
- [SARL Doclet](./APIDocumentation.md)
- [Markdown Extension for SARL documentation](./DocumentationContribution.md)

## Running Tools

- [Janus without network support](./Janus.md) (janus)
- [Janus wit network support](./Janusnode.md) (janusnode)
- [Maven configuration for using Janus SRE with network connection](./JanusNetworkExtension.md)

[:Include:](../includes/legal.inc)
