# Introduction and exercises to the general SARL syntax

Welcome to the SARL Syntax Exercises! These exercises are designed to help you become familiar with the basic syntax and features of the SARL programming language. Each exercise focuses on a different aspect of SARL, providing you with hands-on experience to reinforce your learning.

To get the most out of these exercises, we recommend that you follow them in the order presented. Happy coding, and enjoy your journey into the world of SARL programming!

| Exercices | Topics |
|-----------|--------|
| [Fundamentals of the SARL syntax](./IntroductionBase.md) | These exercises introduce the foundational elements of SARL syntax. They cover the basic structure of a SARL program, including how write your first SARL script. This is the perfect starting point for beginners. |
| [Function and subprogram definitions](./IntroductionFunction.md) | Functions and suprograms are a fundamental part of any programming language, and these exercises introduce you to defining and using functions and subprograms in SARL. You will learn about function syntax, parameters, return values, and how to call functions |
| [Strings of characters](./IntroductionString.md) | Strings of characters are a fundamental data type used to represent text. These exercises cover string manipulation in SARL, including how to create strings, concatenate them, and use various string methods to perform operations like searching and replacing text |
| [Lambda expressions](./IntroductionLambda.md) | These exercises focus on lambda expressions in SARL. Lambda expressions provide a concise way to represent anonymous functions. You will learn how to use lambda expressions to write more compact and readable code |
| [List-based data structures](./IntroductionList.md) | Lists are a common data structure used to store collections of items. These exercises cover how to create, manipulate, and iterate over lists in SARL. You will learn about various list operations and how to use them effectively in your programs |
| [Map-based or dictionary data structures](./IntroductionMap.md) | Maps (or dictionaries) are another essential data structure that allows you to store key-value pairs. These exercises introduce you to maps in SARL, covering how to create maps, add and remove elements, and perform common operations on maps |
| [Object-oriented programming](./IntroductionClass.md) | In these exercises, you will learn about classes in SARL. It covers how to define classes, create objects, and use inheritance. Understanding classes is crucial for organizing your code and creating reusable components to be used by your agents |

[:Include:](../../includes/legal.inc)

