# Tutorials for the SARL Language

Welcome to the SARL Tutorials page. Here, you will find a collection of tutorials designed to help you master various aspects of the SARL programming language. These tutorials cover a range of topics from basic syntax to advanced concepts in multiagent systems.

| Tutorials | Topics |
|----------|-------|
| [Introduction and exercises to the general SARL syntax](./basesyntax/index.md) | These tutorials are designed for beginners to get acquainted with the basic syntax and structure of SARL. It includes practical exercises to reinforce learning |
| [Agent architectures](./architectures/index.md) | These tutorials delve into various agent architectures i.e. internal agent definitions, that can be implemented using SARL, providing insights into designing agents for specific tasks |
| [Interaction mechanisms between agents](./interaction/index.md) | These tutorials focus on the interaction mechanisms that enable agents to communicate and collaborate |
| [Holonic multiagent systems](./holons/index.md) | These tutorials explore the concept of holonic multiagent systems, where agents can form higher-level structures or holons to achieve complex behaviors |
| [Multiagent system set-up](./mas/index.md) | These tutorials address the broader concerns and challenges that arise when defining or scaling up to multiagent systems |
| [Runtime and Deployment](./runtime/index.md) | These tutorials provides guidelines and explanations related to the run-time environment of the SARL agents and to the deployment of SARL applications |

[:Include:](../includes/legal.inc)

