# Tutorials on Interaction Mechanisms between Agents with the SARL Language

Welcome to the tutorials on interaction mechanisms between agents using the SARL language. These tutorials are designed to help you understand how agents can communicate and interact with each other in a multi-agent system. By exploring these tutorials, you will learn the basics of event exchanges, interaction within private spaces, and customizing interaction mechanisms to suit specific needs.


| Tutorials | Topics |
|----------|-------|
| [Simple Event-based Interaction](./PingPong.md) | This tutorial introduces the basics of event exchanges between agents using a classic "Ping Pong" example. It is an excellent starting point for understanding how agents can send and receive events to communicate with each other |
| [Simple Event-based Interaction](./PingPongSpace.md) | This tutorial builds on the basic Ping Pong example by introducing the concept of private interaction spaces. You will learn how agents can interact within a confined space, which is useful for creating more controlled and modular multi-agent systems |
| [Simple Event-based Interaction](./EventBusOverrideWithCapacity.md) | This advanced tutorial guides you through the process of overriding the default event-based interaction mechanism to apply a specific routing strategy for events between agents. This is useful for customizing how events are delivered and processed in your multi-agent system |

[:Include:](../../includes/legal.inc)

