# Tutorials on the Run-time Environment of SARL and the Deployment of SARL Applications

Welcome to the tutorials on setting up multiagent systems using the SARL language. These tutorials are designed to guide you through the process of creating and initializing multiagent systems, providing you with the foundational knowledge needed to build complex and distributed applications.



| Tutorials | Topics |
|----------|-------|
| [Parallel execution within the agents](./ParallelExecution.md) | This tutorial explores the principles of parallel execution within SARL agents. Parallel execution is crucial for optimizing the performance of multiagent systems, allowing agents to perform tasks concurrently and efficiently |
| [Creatiion of an extension for the Janus SRE](./SreExtension.md) | This tutorial guides you through the process of creating an extension for the Janus SARL Runtime Environment (SRE). Extensions allow you to enhance the functionality of the SRE, adding custom features and capabilities tailored to your specific needs |
| [Creation of a runnable application (Jar) file for SARL application](./CreateRunnableJar.md) | This tutorial provides a comprehensive guide to creating a runnable application (Jar) file for SARL applications. Packaging your SARL application as a Jar file allows for easy distribution and deployment, making it accessible to users and deployable across different environments |

[:Include:](../../includes/legal.inc)

