---
title: "Create your First Project"
layout: default
---

# Create your First Project


<ul class="page_outline" id="page_outline">

<li><a href="#1-create-a-sarl-project-without-maven">1. Create a SARL Project without Maven</a></li>
<ul>
  <li><a href="#11-step-1-entering-the-project-information">1.1. Step 1: Entering the project information</a></li>
  <li><a href="#12-step-2-configuration-of-the-source-folders">1.2. Step 2: Configuration of the source folders"</a></li>
</ul>
<li><a href="#2-create-a-sarl-project-with-maven">2. Create a SARL Project with Maven</a></li>
<ul>
  <li><a href="#21-edit-the-maven-configuration">2.1. Edit the Maven configuration</a></li>
  <li><a href="#22-configuration-of-a-runtime-environment-optional">2.2. Configuration of a runtime environment (optional)</a></li>
</ul>
<li><a href="#3-what-s-next">3. What's next?</a></li>
<li><a href="#4-version-specification">4. Version Specification</a></li>
<li><a href="#5-legal-notice">5. Legal Notice</a></li>

</ul>


For developing with SARL, you should create a project. This document describes two ways for created SARL projects.

Two ways are available for creating a SARL project:
1. creating a SARL project inside Eclipse without Maven, or
2. creating a SARL project with Maven (inside or outside Eclipse).

These two ways are explained below.

## 1. Create a SARL Project without Maven

For creating a project, you should open your Eclipse and click on **File > New > Projects**, and select *SARL Project* in
the SARL category.

![Select the SARL Project Type](./new_sarl_project_screen_1.png)

After clicking on **Next**, the wizard is displaying the first page for creating a SARL project.


### 1.1. Step 1: Entering the project information

You must enter the name of your project. You could change the standard SARL and Java environment configurations as well.


![Enter the Project Information](./new_sarl_project_screen_2.png)


Then you could click on **Next** for continuing the edition of the project's properties, or simply click on the
**Finish** button for creating the project with the default properties.

The rest of this section is devoted to the edition of the additional properties for the SARL project.


### 1.2. Step 2: Configuration of the source folders"

The second page of the wizard contains the building settings. Two tabs are really interesting: the *Source* and the *Libraries*.

The *Source* tab defines the folders in your project that must contains source code files. By default, a SARL project is
composed of four source folders:

* `src/main/java`: for your Java classes;
* `src/main/sarl`: for your SARL scripts;
* `src/main/generated-sources/sarl`: for the Java codes generated by the SARL compiler (you should not change them yourself);
* `src/main/resources`: for the files that are not SARL nor Java code.

The default output folder is `target/classes`.

> **_Note:_** The names of these folders are following the conventions of a Maven-based project (described below). In this way, you will
> be able to turn the Maven nature on your SARL project on/off.

![Source Code Folders](./new_sarl_project_screen_3.png)

## 2. Create a SARL Project with Maven

For creating a project with both the Maven and SARL natures, you should open your Eclipse and click on
**File > New > Others > Maven > Maven Project**.

Follow the steps of the project creation wizard, and finally click on the **Finish** button.

### 2.1. Edit the Maven configuration

Open the file `pom.xml`, and edit it for obtaining a content similar to the configuration below.

Replace the version number `0.15.1` of SARL with the one you want to use. You could search on the
[Maven Central Repository](http://search.maven.org/) for the last available version.

```xml
 <project>
    ...
    <properties>
       ...
       <sarl.version>0.15.1</sarl.version>
	   <jdk.version>21</jdk.version>
	   <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>
    </properties>
    ...
    <build>
       <plugins>
          ...
		  <plugin>
			<groupId>org.apache.maven.plugins</groupId>
			<artifactId>maven-compiler-plugin</artifactId>
			<version>3.14.0</version>
			<configuration>
				<source>${jdk.version}</source>
				<target>${jdk.version}</target>
				<encoding>${project.build.sourceEncoding}</encoding>
			</configuration>
		  </plugin>
          <plugin>
             <groupId>io.sarl.lang</groupId>
             <artifactId>sarl-maven-plugin</artifactId>
             <version>${sarl.version}</version>
             <extensions>true</extensions>
             <configuration>
                <source>${jdk.version}</source>
                <encoding>${project.build.sourceEncoding}</encoding>
             </configuration>
          </plugin>
       </plugins>
    </build>
    ...
    <dependencies>
      ...
       <dependency>
          <groupId>io.sarl.sdk</groupId>
          <artifactId>sdk</artifactId>
          <version>${sarl.version}</version>
       </dependency>
       ...
    </dependencies>
    ...
 </project>
```









The Maven configuration is based on the use of `sarl-maven-plugin`. This plugin is in charge of compiling the SARL and
the Java files. Details about the `sarl-maven-plugin` may be found on [this page](../tools/MavenSarlPlugin.html).

> **_Important Note:_** You must set the `extensions` tag to true for the `sarl-maven-plugin` plugin. If you missed to set it, the plugin
> will not able to be integrated in the Maven life-cycle. The consequence will be that only the Java compiler will be
> invoked.

### 2.2. Configuration of a runtime environment (optional)

For executing your SARL program, a [run-time environment](http://www.sarl.io/runtime/index.html) should be used.
By default, the SARL development environment replaces any reference to the SARL libraries by the run-time environment's libraries
when the SARL program is launched within the SARL environment or when a runnable Jar library is created.

In several specific cases, you may want to include the runtime environment into the Maven dependencies of your project. In
this case, you could replace the Maven dependency to the SARL sdk (as defined in the previous section) by a Maven dependency
to the runtime environment library.

> **_Caution:_** Replacing the SARL sdk library by the SARL run-time environment (SRE) library within the Maven dependencies is not the
> recommended approach by the SARL core developers.

#### Janus as maven dependency

The runtime environment that is recommended by the developers of SARL is [Janus](http://www.sarl.io/runtime/janus/). 

Replace the version number (`3.0.15.1`) of the [Janus platform](http://www.sarl.io/runtime/janus/) with the one you want to use.
You could search on the [Maven Central Repository](http://search.maven.org/) for the last available version.


```xml
 <project>
   ...
    <properties>
       ...
       <janus.version>3.0.15.1</janus.version>
    </properties>
    ...
    <build>
       <plugins>
          ...
          <plugin>
             <groupId>io.sarl.lang</groupId>
             <artifactId>sarl-maven-plugin</artifactId>
             <version>${sarl.version}</version>
             <extensions>true</extensions>
             <configuration>
                <source>${jdk.version}</source>
                <encoding>UTF-8</encoding>
             </configuration>
          </plugin>
       </plugins>
    </build>
    ...
    <dependencies>
       ...
       <dependency>
          <groupId>io.sarl.sre.janus</groupId>
          <artifactId>janus.kernel</artifactId>
          <version>${janus.version}</version>
       </dependency>
       ...
    </dependencies>
    ...
 </project>
```






#### Janus with networking feature as maven dependency

By default, the Janus framework does not activate its network feature. If you would like to build a project with this feature,
you have to use another Maven dependency: `janus.network`.

```xml
 <project>
   ...
    <properties>
       ...
       <janus.version>3.0.15.1</janus.version>
    </properties>
    ...
    <build>
       <plugins>
          ...
          <plugin>
             <groupId>io.sarl.lang</groupId>
             <artifactId>sarl-maven-plugin</artifactId>
             <version>${sarl.version}</version>
             <extensions>true</extensions>
             <configuration>
                <source>${jdk.version}</source>
                <encoding>UTF-8</encoding>
             </configuration>
          </plugin>
       </plugins>
    </build>
    ...
    <dependencies>
       ...
       <dependency>
          <groupId>io.sarl.sre.janus</groupId>
          <artifactId>janus.network</artifactId>
          <version>${janus.version}</version>
       </dependency>
       ...
    </dependencies>
    ...
 </project>
```

## 3. What's next?

In the next section, we will learn how to create our first agent.

[Next>](./AgentIntroduction.html)

## 4. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 5. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>