---
title: "Get Started with the SARL language"
layout: default
---

# Get Started with the SARL language

Welcome to the "Get Started" guide for SATL! Whether you're new to programming or an experienced developer looking to explore a new language, you've come to the right place.

SARL is designed to be intuitive, powerful, and versatile, making it suitable for a wide range of applications that are needing multiagent systems and holonic multiagent systems. This guide will walk you through the basics of setting up your development environment and writing your first program.

By the end of this guide, you'll have the foundations to start building your own projects and exploring the [tutorials](../tutorials/index.html) or more advanced features of SARL.

## 1. Installation

Step-by-step instructions on how to [install SARL on your computer](./InstallSARLTools.html).

## 2. Set-up your project and first code

Creation of your [first project](./CreateFirstProject.html), and its configuration.

Creation of your [first SARL agent](./AgentIntroduction.html).

## 3. Running SARL agents

These is three methods for running agents:

* [Inside the development environment](./RunSARLAgentEclipse.html).
* [From the Shell command-line](./RunSARLAgentCLI.html).
* [From another Java or a SARL program](RunSARLAgentJava.html).

## 4. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 5. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>