---
title: "Welcome to the SARL Language Documentation"
layout: default
---

# Welcome to the SARL Language Documentation

| Section | Description |
|---------|-------------|
| [Get Started](./getstarted/index.html) | New to the SARL language? Start [here](./getstarted/index.html) to learn the basics and set up your environment |
| ** [Tutorials](./tutorials/index.html) ** | **Explore our tutorials to build your skills from basic to advanced levels** |
| [FAQ](./faq/index.html) | Have questions? Check out our [FAQ section](./faq/index.html) for answers to common queries |
| [Best Practices](./bestpractices/index.html) | Learn the [best practices](./bestpractices/index.html) to write efficient and maintainable code |
| ** [Concepts and Syntax](./lang/index.html) ** | **Dive into the metamodel concepts and syntax of the SARL language with detailed explanations and examples** |
| [API Documentation](http://www.sarl.io/docs/api/) | Explore the [full API documentation](http://www.sarl.io/docs/api/) to understand the libraries and modules available |
| [Associated Tools](./tools/index.html) | Find out about the [tools](./tools/index.html) available for editor, compiling, debugging your code and your documentation |

## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>