---
title: "List of the SARL Compiler Errors and Warnings"
layout: default
---

# List of the SARL Compiler Errors and Warnings

This page provides the exhaustive list of error and warning messages that may be generated by the SARL compiler.

The "N." column provides a number that could be used in order to make easier your discussions with the SARL developers on the forums.

The column "Message and Description" contains information and details on each issue.
The **message** gives a template of typical message that is given by the compiler.
The **cause** describes the source of the issue, and provides a short explanation of the cause of the issue.
The **solving** provides guidelines to fix the issue when it is possible.

The "Level" column indicates the level of importance for the issue.
It may be:
* "error": the issue makes the compiler failing and stopping. This type of issue can be ignored neither programmatically (see below) nor with the SARL compiler configuration.
* "warning": the issue is an important message that may have implication on the quality of your program. But, it does not stop the compiler. This type of issue can be ignored neither programmatically (see below) nor with the SARL compiler configuration.
* "info": the issue is a simple information message from the compiler. The impact on the quality of your program is low. The compiler is not stopped when an information message is output. This type of issue can be ignored neither programmatically (see below) nor with  the SARL compiler configuration.
* "configurable": the issue has a level (inside "error", "warning", "info", "ignore") that may be configured by the SARL developers themselves. A default level is assumed for the case the SARL developers did not specify their preferred level for the issue. It could be ignore both programmatically (see below) and with the SARL compiler configuration.
* "delegated": it is similar to "configurable", except that the configuration management is delegated to the Eclipse Java Development Toolkit (JDT), and its preference pages. In the case of delegated error, the associated JDT issue code is also provided for information.


In the case of an issue with a "configurable" or "delegated" level, you could select yourself the level that should be used by the SARL compiler for the issue.
This configuration may be done into the preferences of the Eclipse SARL IDE or in the configuration of the `sarlc` command-line compiler.
Additionally, you could force the SARL compiler to ignore an issue by attaching the annotation `@SuppressWarnings("code")` to the element that is marked with the issue.
In this annotation, the code corresponds to the content of the "Code" column below.
This code may have a short format (e.g., the one shown in the column), or a long format (e.g., if you move your mouse pointer on the code, you should see the long format of the code into a pop-up window).
The long code is provided by the SARL compiler at the end of each of the issue messages.
It is preferable to use the short code as argument to `@SuppressWarnings`. Nevertheless, it may be ambiguous with other issue codes
that could be defined outside the SARL compiler itself (e.g. Eclipse, Checkstyle, etc.). In the case of ambiguity, you could use
the long code as argument to `@SuppressWarnings` too.



| N. | Message and Description | Level | Code |
| -- | ----------------------- | ----- | ---- |
| 1 | **Message:** Cannot instantiate the abstract type *type-name*<br>**Cause:** This error is generated when you try to create an instance of an abstract class<br>**Solving:** Replace *type-name* by the name of a concrete class | Error | [abstract_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.abstract_class_instantiation") |
| 2 | **Message:** Cannot directly invoke the abstract method *func-prototype* of the type *name*<br>**Cause:** The function with the given *func-prototype* is defined as non-abstract in the current type, and it is defined as `abstract` into the super-type. You try to call the super-type's method by using `super.function`. But, the super-type's function is `abstract`. Consequently, it cannot be invoked<br>**Solving:** Remove the call to the super-type function | Configurable; Default is: Error | [abstract_method_invocation](: "org.eclipse.xtext.xbase.validation.IssueCodes.abstract_method_invocation") |
| 3 | **Message:** Abstract methods do not specify a body<br>**Cause:** You have defined a method within an interface of a capacity with an associated block of code. Since Java 1.8, the default implementation within interfaces (i.e., a block of code that may be considered as the function's implementation if the class implementing the interface is not providing its own code) is introduced. If you are using SARL upon an older Java environment, this error message is generated<br>**Solving:** Remove the code block | Error | [abstract_method_with_body](: "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_with_body") |
| 4a | **Message:** Ambiguous *feature-call*. The *feature-type* *feature-1* and *feature-2* both match<br>**Cause:** You are calling a feature (method, field, etc.). But, the target feature is ambiguous. Multiple candidates were found within the scope of your call. SARL compiler cannot choose the concrete feature to be called. In order to help you, the SARL compiler provides to you the list of candidates<br>**Solving:** Rewrite your code in order to remove the ambiguity | Error | [ambiguous_feature_call](: "org.eclipse.xtext.xbase.validation.IssueCodes.ambiguous_feature_call") |
| 4b | **Message:** Ambiguous *feature-call*. The *feature-type* *list-of-features* and *feature-2* all match<br>**Cause:** You are calling a feature (method, field, etc.). But, the target feature is ambiguous. Multiple candidates were found within the scope of your call. SARL compiler cannot choose the concrete feature to be called. In order to help you, the SARL compiler provides to you the list of candidates<br>**Solving:** Rewrite your code in order to remove the ambiguity | Error | [ambiguous_feature_call](: "org.eclipse.xtext.xbase.validation.IssueCodes.ambiguous_feature_call") |
| 5 | **Message:** Potential ambiguous notation for *expression*. The minus unary operator is applied on the result of the call to function *name* and not on the argument value *value*<br>**Cause:** This warning message is generated for any expression of the form `-value.name`. In this case, the expression could be interpreted in the wrong way. For example, `-125.abs` is interpreted as `-(125.abs)` by SARL, i.e., `-abs(125)`. It is not interpreted as `abs(-125)`. If you would pass `-125` to the function, you must use parentheses, i.e. `(-125).abs`<br>**Solving:** Put parentheses around the minus unary operator and the value, i.e., `(-value).name` | Configurable; Default is: Warning | [ambiguous_interpretation_by_developper](: "io.sarl.lang.validation.IssueCodes.ambiguous_interpretation_by_developper") |
| 6 | **Message:** The anonymous subclass of *type-name* does not implement *list-of-functions*<br>**Cause:** Because anonymous class cannot be abstract, all the abstract functions that are inherited must be implemented into the anonymous class<br>**Solving:** Implement the missed functions | Error | [anonymous_class_missing_members](: "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_missing_members") |
| 7 | **Message:** A static field of an anonymous class must be final<br>**Cause:** Because an anonymous class is a class, we can declare `static` fields for sharing data between the difference instances of the anonymous class (that is the usual usage of static fields for regular classes). However, because an anonymous class is attached to its enclosing context, any side-effect applied by the change of the static field's value must be avoided. That's why a static field in an anonymous class must be unmodifiable, i.e., defined with `val` or marked with the `final` modifier<br>**Solving:** Replace `var` keyword by `val`; or add the `static` modifier to the field | Error | [anonymous_class_static_field](: "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_static_field") |
| 8 | **Message:** A method of an anonymous class cannot be static<br>**Cause:** Because an anonymous class is not a named type, we cannot refer to its functions with a static notation (that is the name of the type, followed by the name of the function). Consequently, it is forbidden to define a static function into an anonymous class<br>**Solving:** Remove `static` modifier from the function prototype | Error | [anonymous_class_static_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_static_method") |
| 9a | **Message:** Assignment to final field<br>**Cause:** You try to assign a value to a field that is declared as final, e.g., `val myvar` or `final var myvar`. Since the field is declared as final, its value cannot be changed<br>**Solving:** Remove the final modifier on the field; or assign to another not-final field | Error | [assignment_to_final](: "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final") |
| 9b | **Message:** Assignment to final parameter<br>**Cause:** You try to assign a value to a parameter. Parameters are always considered as final from the SARL specification. Since the parameter is declared as final, its value cannot be changed<br>**Solving:** Assign to another not-final variable | Error | [assignment_to_final](: "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final") |
| 9c | **Message:** Assignment to final variable<br>**Cause:** You try to assign a value to a variable that is declared as final, e.g., `val myvar` or `final var myvar`. Since the variable is declared as final, its value cannot be changed<br>**Solving:** Remove the final modifier on the variable; or assign to another not-final variable | Error | [assignment_to_final](: "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final") |
| 10 | **Message:** The left-hand side of an assignment must be a variable<br>**Cause:** According to the definition of the assignment operator, the left operand must always be a variable or a field that is not declared as final. When this error message is generated, it means that the left operand is neither a variable nor a field.<br>Please not that the use of the assignment operator may be considered as a call to a "setter" function. In this case, this error message is not generated<br>**Solving:** Replace the left operand with an appropriate variable or field | Error | [assignment_to_no_variable](: "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_no_variable") |
| 11 | **Message:** A dispatch method's name must not start with an underscore<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. Internally, each block is attached to an hidden function with a name started with an underscore `_` character. In order to avoid any conflict with the internal functions, it is forbidden to start the name of a dispatch function with an underscore character<br>**Solving:** Rename your dispatch function | Error | [case_func_name_starts_with_underscore](: "org.eclipse.xtend.core.validation.IssueCodes.case_func_name_starts_with_underscore") |
| 12 | **Message:** A dispatch method must not declare any type parameters<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. This error message is generated when a generic type parameter is defined in the dispatch function prototype; that is forbidden<br>**Solving:** Remove generic type declaration | Error | [case_function_with_type_params](: "org.eclipse.xtend.core.validation.IssueCodes.case_function_with_type_params") |
| 13 | **Message:** A dispatch method must at least have one parameter declared<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. This error message is generated when a dispatch function has no parameter delcared<br>**Solving:** Add a formal parameter | Error | [case_function_without_params](: "org.eclipse.xtend.core.validation.IssueCodes.case_function_without_params") |
| 14 | **Message:** Recursive constructor invocation<br>**Cause:** You have defined several constructors into your type that are calling other constructors in the type. The sequence of constructor's calls contains a loop; that is forbidden. An example of failing code is:<br><code>class X {<br>&nbsp;&nbsp;new (x : int) {<br>&nbsp;&nbsp;&nbsp;&nbsp;this('c')<br>&nbsp;&nbsp;}<br>&nbsp;&nbsp;new (x : char) {<br>&nbsp;&nbsp;&nbsp;&nbsp;this(1)<br>&nbsp;&nbsp;}<br>}</code><br>**Solving:** Rewrite your code to avoid cyclic calls to the constructors | Error | [circular_constructor_invocation](: "org.eclipse.xtext.xbase.validation.IssueCodes.circular_constructor_invocation") |
| 15a | **Message:** Invalid supertype. Expecting a class<br>**Cause:** According to the syntax of SARL, a type (class, agent, skill, etc.) extends another type. This error message indicates to you that the type after `extends` is not a type implemented with a Java class, when it is expected to have one<br>**Solving:** Remove the `extends` statement; or replace the invalid type by the appropriate class | Error | [class_expected](: "org.eclipse.xtext.xbase.validation.IssueCodes.class_expected") |
| 15b | **Message:** Superclass must be a class<br>**Cause:** According to the syntax of SARL, a class extends another class. This error message indicates to you that the type after `extends` is not a class<br>**Solving:** Remove the `extends` statement; or replace the invalid type by the appropriate class | Error | [class_expected](: "org.eclipse.xtext.xbase.validation.IssueCodes.class_expected") |
| 16 | **Message:** The class *type-name* must be defined abstract because it does not implement *list-of-functions*<br>**Cause:** You have defined abstract functions into *type-name*, or abstract functions are inherited without beeing implemented. In this case, the *type-name* must also be defined as `abstract` because abstract functions can only be defined into an abstract type<br>**Solving:** Add `abstract` modifier to *type-name* | Error | [class_must_be_defined_abstract](: "org.eclipse.xtext.xbase.validation.IssueCodes.class_must_be_defined_abstract") |
| 17a | **Message:** The non-abstract method *first-prototype* inherited from *first-type* conflicts with the method *second-prototype* inherited from *second-type*<br>**Cause:** This error message is generated when the current type inherited from two functions from types *first-type* and *second-type*, and there is a conflict between the signatures of these functions | Error | [conflicting_default_methods](: "org.eclipse.xtext.xbase.validation.IssueCodes.conflicting_default_methods") |
| 17b | **Message:** The type *type-name* inherits multiple implementations of the method *func-prototype* from *first-type* and *second-type*<br>**Cause:** This error message is generated when the current type with name *type-name* inherited a block of code for the function with the signature *func-prototype*, either from the super-type named *first-type* and the one named *second-type*. It is impossible for the SARL compiler to determine which one of the two blocks of code to be associated to *type-name* | Error | [conflicting_default_methods](: "org.eclipse.xtext.xbase.validation.IssueCodes.conflicting_default_methods") |
| 18 | **Message:** Constant condition is always *boolean-constant*<br>**Cause:** The loop, if-then and switch statements may have a boolean condition that is evalued to `true` or `false`. In this case, the statement itself is superfluous. For example, in the case of a while-loop, if the condition is alwaus `true`, the loop will never exit. This issue message notifies you that a potentiel problem is detected because of the evaluation of an expression to `true` or `false` | Configurable; Default is: Warning | [constant_condition](: "org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition") |
| 19 | **Message:** Constructors are only permitted within agents, behaviors, skills, events and classes<br>**Cause:** You try to define a construction in a type that cannot contains a constructor construct. Only specific types could contain a constructor. They are basically those that may corresponds to an object-oriented class, e.g. class, agent, behavior and skill | Error | [constructor_not_permitted](: "org.eclipse.xtend.core.validation.IssueCodes.constructor_not_permitted") |
| 20a | **Message:** Type parameters are not supported for constructors<br>**Cause:** A constructor cannot have generic type parameters<br>**Solving:** Remove the generic type parameters | Error | [constructor_type_params_not_supported](: "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported") |
| 20b | **Message:** Unexpected type parameter to a static constructor<br>**Cause:** A static constructor cannot have generic type parameters<br>**Solving:** Remove the generic type parameters | Error | [constructor_type_params_not_supported](: "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported") |
| 21 | **Message:** *any-message*<br>**Cause:** Sometime, the Java code that is generated by the SARL compiler may contain compilation errors from the Java compiler point of view. This error code enables the SARL validator to forward the errors that were found into the Java code to be automatically attached to the SARL statement that is the source of the failing Java code<br>**Solving:** Contact the SARL development team | Configurable; Default is: Error | [copyJavaProblems](: "org.eclipse.xtext.builder.copyJavaProblems") |
| 22a | **Message:** 'Create'-method *name* is not permitted in an interface<br>**Cause:** Creation method is inspired from the [factory-method design pattern](https://en.wikipedia.org/wiki/Factory_method_pattern). It is forbidden to define this type of method inside an interface<br>**Solving:** Remove the creation method from the interface and move it in another type | Error | [create_functions_must_not_be_abstract](: "create_functions_must_not_be_abstract") |
| 22b | **Message:** The 'create'-method *func-name* in type *type-name* must not be abstract<br>**Cause:** Creation method is inspired from the [factory-method design pattern](https://en.wikipedia.org/wiki/Factory_method_pattern). It is forbidden to define this type of method without code<br>**Solving:** Add source code to the creation method | Error | [create_functions_must_not_be_abstract](: "create_functions_must_not_be_abstract") |
| 23 | **Message:** The inheritance hierarchy of *type* contains cycles<br>**Cause:** According the inheritance definition, that is common to SARL and the object-oriented programming languages, cyclic into the inheritance hierarchy is totally forbidden | Error | [cyclic_inheritance](: "org.eclipse.xtext.xbase.validation.IssueCodes.cyclic_inheritance") |
| 24a | **Message:** The constructor *name* is deprecated<br>**Cause:** The constructor that you are calling is marked as deprecated directly, or one of its enclosing types is marked as deprecated<br>**Solving:** Read the deprecation comment and update your code accordingly<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.deprecation | Delegated; Default is: Warning | [deprecated_member_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference") |
| 24b | **Message:** The enum literal *name* is deprecated<br>**Cause:** The enum literal that you are using is marked as deprecated directly, or one of its enclosing types is marked as deprecated<br>**Solving:** Read the deprecation comment and update your code accordingly<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.deprecation | Delegated; Default is: Warning | [deprecated_member_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference") |
| 24c | **Message:** The field *name* is deprecated<br>**Cause:** The field that you are accessor is marked as deprecated directly, or one of its enclosing types is marked as deprecated<br>**Solving:** Read the deprecation comment and update your code accordingly<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.deprecation | Delegated; Default is: Warning | [deprecated_member_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference") |
| 24d | **Message:** The method *func-prototype* from the type *container-name* is deprecated<br>**Cause:** The method that you are calling is marked as deprecated directly, or one of its enclosing types is marked as deprecated<br>**Solving:** Read the deprecation comment and update your code accordingly<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.deprecation | Delegated; Default is: Warning | [deprecated_member_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference") |
| 24e | **Message:** The type *name* is deprecated<br>**Cause:** The type that you are referencing is marked as deprecated directly, or one of its enclosing types is marked as deprecated<br>**Solving:** Read the deprecation comment and update your code accordingly<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.deprecation | Delegated; Default is: Warning | [deprecated_member_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference") |
| 25a | **Message:** Discouraged boolean value. The guard is always true<br>**Cause:** It is discouraged to have the constant `true` as condition of an behavior unit's guard. Indeed, a condition that is always evaluated to true makes the test void and time consuming for nothing<br>**Solving:** Remove the guard of the behavior unit | Configurable; Default is: Warning | [discouraged_boolean_expression](: "io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression") |
| 25b | **Message:** Unexpected assertion due to its positive test result<br>**Cause:** It is discouraged to have the constant `true` as condition of the `assert` statement. Indeed, a condition that is always evaluated to true for an assertion test makes this test void and time consuming for nothing<br>**Solving:** Remove the `assert` statement | Configurable; Default is: Warning | [discouraged_boolean_expression](: "io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression") |
| 26 | **Message:** Discouraged capacity definition. A capacity without actions defined inside is not useful since it cannot be called by an agent or a behavior<br>**Cause:** Message is explicit. There no sense to create a capacity without action according to the SARL metamodel<br>**Solving:** Define an action within the capacity; or delete the capacity | Configurable; Default is: Warning | [discouraged_capacity_definition](: "io.sarl.lang.validation.IssueCodes.discouraged_capacity_definition") |
| 27 | **Message:** Invalid action name '*n*'. You must not give to an action a name with reserved characters<br>**Cause:** Several names are discouraged to be used by the SARL compiler. One reason may be because the name is expected to be used as part of the language in future releases. Or, the name is amgiguous. For example, the name "self" is discouraged by the SARL compiler<br>**Solving:** Change the function name | Configurable; Default is: Warning | [discouraged_function_name](: "io.sarl.lang.validation.IssueCodes.discouraged_function_name") |
| 28 | **Message:** Discouraged use of the *name* keyword inside a basic loop<br>**Cause:** The SARL keyword with the *name* cannot be used in a loop. For example, `break` and `continue` statements enable to stop the execution of a loop step by continuing the execution after the loop itself or at the next loop step, respectivelly. However, according the algothimic best practices, it is not recommended to use the `break` or `continue` statement for stopping a loop. It may denote a poor algorithmic analysis<br>**Solving:** Rewrite the loop code | Configurable; Default is: Warning | [discouraged_loop_breaking_keyword_use](: "io.sarl.lang.validation.IssueCodes.discouraged_loop_breaking_keyword_use") |
| 29a | **Message:** Possible invalid usage of '*name*'. An impure function is detected into the sequence of calls on '*name*'. Because an impure function has a possible side effect and side effect is not allowed on '*name*', it may cause an unexpected or invalid running behavior. You have to ensure by yourself that the usage of '*name*' is valid<br>**Cause:** The keyword with *name* represents a read-only feature. It is usually `occurrence` that represents the current instance of the just-received event within a behavior unit. It is assumed within the SARL operational semantics that `occurrence` instance is an unmodifiable event in order to ensure consistency between the different behavior units that handle the `occurrence`. This message is generated one component of the `occurrence` event is used in a way that its value may be changed. The SARL compiler is not sure that a change is applied to the `occurrence` from the code analysis. It notifies you that you have to double check the usage of `occurrence` and validate that no side-effect exist on it. If the used component of `occurrence` is of immutable type, then this issue does not exist<br>**Solving:** Rewrite your code to avoid the use of the impure function(s) | Configurable; Default is: Warning | [discouraged_occurrence_readonly_use](: "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use") |
| 29b | **Message:** Possible invalid usage of '*name*'. The value of the feature '*name*' or one of its component is used as an argument of a function. This function is not marked as a pure function, i.e. without side effect. Because side effect is not allowed on '*name*', it may cause an unexpected or invalid running behavior. You have to ensure by yourself that the usage of '*name*' is valid<br>**Cause:** The keyword with *name* is a read-only feature that seems to be used as an read-write variable<br>**Solving:** Mark with `@Pure` the function that takes the feature with *name* as argument; or Change your code to avoid the passing of the feature with *name*` to the concerned function | Configurable; Default is: Warning | [discouraged_occurrence_readonly_use](: "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use") |
| 29c | **Message:** Possible invalid usage of '*name*'. The value of the feature '*name*' or one of its component seems to be copied within a local variable. Because side effect is not allowed on '*name*', it may cause an unexpected or invalid running behavior. You have to ensure by yourself that the usage of '*name*' is valid<br>**Cause:** The keyword with *name* is a read-only feature that seems to be used as an read-write variable<br>**Solving:** Rewrite your code to avoid the use of the impure function(s) | Configurable; Default is: Warning | [discouraged_occurrence_readonly_use](: "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use") |
| 30 | **Message:** Discouraged feature call: *feature*. You should use the dedicated language keyword, or an agent's capacity in place of this feature call<br>**Cause:** This error is generated when a discouraged feature call is detected. The features that outside the best practices are: `System::err`, `System::out`, `System::setErr`, `System::setOut`, `System::console`, `System::inheritedChannel`, `System::exit` (when called from an object-oriented type), with a named starting with "InputOutput" or "Thread". these different features are considered to be too low level to be used into a agent-oriented program<br>**Solving:** Remove the call | Error | [discouraged_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference") |
| 31 | **Message:** Dispatch methods have arguments with different primitive types<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. You could define more formal parameters than the mandatory one. This issue message is generated when the formal parameters at the same position into the prototypes of a dispatch function have not the same primitive type. It may cause issues, e.g., a loose of information due the automatic boxing of the parameter values<br>**Solving:** Change the primitive types to have the same in all the prototypes | Configurable; Default is: Warning | [dispatch_functions_different_primitive_args](: "org.eclipse.xtend.core.validation.IssueCodes.dispatch_functions_different_primitive_args") |
| 32 | **Message:** Static and non-static dispatch methods can not be mixed<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. It is forbidden to mix static and not static prototypes for a single dispatch function<br>**Solving:** Make static or non-static all the prototypes of the same dispatch function | Error | [dispatch_functions_mixed_static_and_non_static](: "dispatch_functions_mixed_static_and_non_static") |
| 33 | **Message:** The dispatch method *fct-name* in type *type-name* must not be abstract<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. Because of this definition, it is forbidden to define, implictly or explicitly, a dispatch function as abstract<br>**Solving:** Add block of code for the dispatch function | Error | [dispatch_functions_must_not_be_abstract](: "dispatch_functions_must_not_be_abstract") |
| 34 | **Message:** The dispatch method must not be static because the dispatch methods in the superclass are not static<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. This error message is generated when a dispatch function into the current type is defined as static function; while the dispatch functions defined into the super-type are not defined as static. You cannot mix static and non-static definitions<br>**Solving:** Remove `static` modifier from the prototype of the local dispatch function | Error | [dispatch_functions_non_static_expected](: "dispatch_functions_non_static_expected") |
| 35 | **Message:** The dispatch method must be static because the dispatch methods in the superclass are static<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. This error message is generated when a dispatch function into the current type is not defined as static function; while the dispatch functions defined into the super-type are defined as static. You cannot mix static and non-static definitions<br>**Solving:** Add `static` modifier to the prototype of the local dispatch function | Error | [dispatch_functions_static_expected](: "dispatch_functions_static_expected") |
| 36 | **Message:** All local dispatch methods must have the same visibility<br>**Cause:** A dispatch function is a function to which multiple blocks of code are attached to. Each block of code is invoked according to a specific type of the first formal parameter of the dispatch function. It is forbidden to define the different prototypes for a single dispatch function with different visibilities<br>**Solving:** Use the same function visility for all the prototypes of the same dispatch function | Error | [dispatch_functions_with_different_visibility](: "dispatch_functions_with_different_visibility") |
| 37a | **Message:** Dispatch method has same name and number of parameters as non-dispatch method<br>**Cause:** A conflict is detected between the name of a dispatch function and the name of not-dispatching function. In this case, the SARL compiler is still able to invoke both functions. Nevertheless, it introduces an ambiguity for the caller of the functions that may have a call to the wrong function. This issue message notifies you that you have to take care of this situation, and ensure that the calls to functions are targeted the right function code<br>**Solving:** Rename the dispatch function; or the non-dispatch function | Configurable; Default is: Warning | [dispatch_plain_function_name_clash](: "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash") |
| 37b | **Message:** Non-dispatch method has same name and number of parameters as dispatch method<br>**Cause:** A conflict is detected between the name of a dispatch function and the name of not-dispatching function. In this case, the SARL compiler is still able to invoke both functions. Nevertheless, it introduces an ambiguity for the caller of the functions that may have a call to the wrong function. This issue message notifies you that you have to take care of this situation, and ensure that the calls to functions are targeted the right function code<br>**Solving:** Rename the dispatch function; or the non-dispatch function | Configurable; Default is: Warning | [dispatch_plain_function_name_clash](: "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash") |
| 38 | **Message:** Duplicate case<br>**Cause:** Into a `switch` statement, you have specified multiple times the same `case`, i.e., with the same case expression. Then, it is impossible to branch to a single `case` from the expression evaluated by the `switch` statement. This ambiguous branching is forbidden<br>**Solving:** Remove one of the cases; or merge the two cases into a single case | Error | [duplicate_case](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_case") |
| 39a | **Message:** Duplicate extension with same type<br>**Cause:** [Extension on fields](./expr/Extension.md) is supported by SARL syntax. This error message is generated when two extensions have the same name. It is forbidden because they generate two hidden fields with the same name<br>**Solving:** Rename one of the extensions | Error | [duplicate_field](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_field") |
| 39b | **Message:** Duplicate field *name*<br>**Cause:** It is forbidden to define multiple fields with the same name into the same type. This error message is generated when two fields have the given *name*<br>**Solving:** Rename one of the two fields | Error | [duplicate_field](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_field") |
| 40 | **Message:** Duplicate interface<br>**Cause:** This warning message is generated when a type is implemented the same interface multiple times`<br>**Solving:** Remove the extra declarations of the implemented interface | Configurable; Default is: Warning | [duplicate_interface](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_interface") |
| 41a | **Message:** Duplicate dispatch methods. Primitives cannot overload their wrapper types in dispatch methods<br>**Cause:** It is forbidden to define a dispatch function without the same prototype/erasure as an inherited dispatch function<br>**Solving:** Change the prototype of the dispatch function in order to be compatible with the prototype of the inherited dispatch function | Error | [duplicate_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method") |
| 41b | **Message:** Duplicate method *func-prototype* in type *type-name*<br>**Cause:** It is forbidden to define two times a function with the same prototype/erasure. This error message is generated when two functions has the same prototype inside the current type declaration<br>**Solving:** Rename one of the functions; or change the erasure of one of them | Error | [duplicate_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method") |
| 41c | **Message:** Name clash: The method *func-prototype* of type *type-name* has the same erasure as *other-prototype* of type *other-type* but does not override it<br>**Cause:** It is forbidden to define a non-static function without the same prototype/erasure as an inherited non-static static function<br>**Solving:** Change the *func-prototype* to be compatible with *other-prototype* | Error | [duplicate_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method") |
| 41d | **Message:** The instance method *func-prototype* cannot override the static method *static-prototype* of type *type-name*<br>**Cause:** It is forbidden to define a function with the same prototype/erasure as an inherited static function without adding the `static`modifier to the inheriting function prototype<br>**Solving:** Add `static` modifier to the function prototype | Error | [duplicate_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method") |
| 41e | **Message:** The method *func-prototype* has the same erasure *func-erasure* as another method in type *type-name*<br>**Cause:** It is forbidden to define two times a function with the same prototype/erasure. This error message is generated when two functions has the same prototype inside the current type declaration<br>**Solving:** Rename one of the functions; or change the erasure of one of them | Error | [duplicate_method](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method") |
| 42a | **Message:** Duplicate implicit parameter '*name*'<br>**Cause:** You cannot define with the same *name* two formal parameters into the same function. In the context of the erroneous code, an implicit parameter may be defined and named `it`. You may have also explicitly defined a formal parameter named `it`. There is a conflict between the names<br>**Solving:** Rename your explicit formal parameter | Error | [duplicate_parameter_name](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name") |
| 42b | **Message:** Duplicate parameter *name*<br>**Cause:** You cannot define with the same *name* two formal parameters into the same function<br>**Solving:** Rename one of the formal parameters | Error | [duplicate_parameter_name](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name") |
| 43a | **Message:** Duplicate nested type *name*<br>**Cause:** It is forbidden to define into an enclosing type two type declarations with the same given *name*<br>**Solving:** Rename one of the inner types | Error | [duplicate_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type") |
| 43b | **Message:** Duplicate type *name*<br>**Cause:** It is forbidden to define into a SARL file two type declarations with the same given *name*<br>**Solving:** Rename one of the types | Error | [duplicate_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type") |
| 43c | **Message:** The type *name* is already defined<br>**Cause:** It is forbidden to define into a SARL file two type declarations with the same given *name*<br>**Solving:** Rename one of the types | Error | [duplicate_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type") |
| 43d | **Message:** The type *name* is already defined in file *filename*<br>**Cause:** It is forbidden to define into a SARL file two type declarations with the same given *name*<br>**Solving:** Rename one of the types | Error | [duplicate_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type") |
| 44 | **Message:** Duplicate type *name*<br>**Cause:** This warning message is generated two types are defined in the same file with the same name<br>**Solving:** Change the name of one of the duplicate types | Error | [duplicate_type_name](: "io.sarl.lang.validation.IssueCodes.duplicate_type_name") |
| 45 | **Message:** The operator '*name*' should be replaced by '*name*=' when null is one of the arguments<br>**Cause:** This error message is generated when one of the (in)equality test operators `==` and `!=` is invoked with the null literal as left or right operand, e.g. `x == null` or `null == x`, and the other operand being of primitive type. These two test operators implement deep (in)equality tests. A better practice is to invoke the operator `===` or `!==`, which implement reference tests. Indeed, `null` value is a reference to nothing. It is better to compare a reference to another reference. And, the reference test operators are the most efficient for that<br>**Solving:** Replace `==` by `===`, or `!=` by `!==` | Configurable; Default is: Warning | [equals_with_null](: "org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null") |
| 46 | **Message:** Exception *type-name* is declared twice<br>**Cause:** You have declared two times the same exception after a `throw` keyword<br>**Solving:** Remove one occurrence of *type-name* | Error | [exception_declared_twice](: "org.eclipse.xtext.xbase.validation.IssueCodes.exception_declared_twice") |
| 47 | **Message:** No exception of type *type-name* can be thrown; an exception type must be a subclass of Throwable<br>**Cause:** You have specified a type after the `thrown` keyword that is not a subtype of `Throwable`. This type comes from the Java API, and represents all the throwable objects, e.g., the exceptions, into the virtual machine. You must given sub-types of `Throwable` after the `thrown` keyword<br>**Solving:** Remove *type-name*; or replace it by an appropriate type | Error | [exception_not_throwable](: "org.eclipse.xtext.xbase.validation.IssueCodes.exception_not_throwable") |
| 48 | **Message:** Cannot access the *type-name* *feature-name* with parentheses<br>**Cause:** This error is generated when you try to access to a field with parentheses. Let be the field `x` defined. The code `x()` causes this error because `x` is a field, not a method<br>**Solving:** Remove the parentheses | Error | [field_access_with_parentheses](: "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses") |
| 49 | **Message:** The final field *name* may already have been assigned<br>**Cause:** You try to change the value of a final field after it was initialized. A value could be given to a final field only one time, i.e. its initialization<br>**Solving:** Remove the expression that try to change the final field | Error | [field_already_initialized](: "org.eclipse.xtext.xbase.validation.IssueCodes.field_already_initialized") |
| 50a | **Message:** The blank final derived field *name* may not have been initialized<br>**Cause:** Final fields must be initialized when they are declared, or inside the enclosing type constructor (when writing a constructor is possible). You have declared a final field that is never initialized<br>**Solving:** Add initialization value to the field | Error | [field_not_initialized](: "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized") |
| 50b | **Message:** The blank final field *name* may not have been initialized<br>**Cause:** Final fields must be initialized when they are declared, or inside the enclosing type constructor (when writing a constructor is possible). You have declared a final field that is never initialized<br>**Solving:** Add initialization value to the field | Error | [field_not_initialized](: "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized") |
| 51a | **Message:** Access restriction: The type *name* is not accessible<br>**Cause:** This error is generated when a reference to the type with the given *name* is detected, and the type is not visible/accessible<br>**Solving:** Remove type reference | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51b | **Message:** Default value's expression cannot reference the not-pure operation: *name*<br>**Cause:** This error message is generated when a reference to a non-pure function is detected into the expression of the default value for a formal parameter. Only pure functions could be used for building a default value expression in order to avoid unexpected side-effects<br>**Solving:** Remove the reference to the not-pure function | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51c | **Message:** Forbidden annotation in a SARL program<br>**Cause:** An annotation is used into the code. But this annotation is forbidden because it is reserved for internal usage, or it is not supported by the SARL compiler<br>**Solving:** Remove the annotation | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51d | **Message:** Forbidden annotation to the agent-oriented type *type-name*<br>**Cause:** An active annotation, i.e. an annotation that causes a specific generation of code by the SARL compiler, is attached to an agent-oriented type, e.g. `agent`, `behavior`, etc. But, it is forbidden to attached the active annotation to an agent-oriented type<br>**Solving:** Remove the active annotation | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51e | **Message:** Forbidden annotation to the object-oriented type *type-name*<br>**Cause:** An active annotation, i.e. an annotation that causes a specific generation of code by the SARL compiler, is attached to an object-oriented type, e.g. `class`, `interface`, etc. But, it is forbidden to attached the active annotation to an object-oriented type<br>**Solving:** Remove the active annotation | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51f | **Message:** Forbidden feature call: *feature*<br>**Cause:** This error is generated when a forbidden feature call is detected. The forbidden features to call are: `System::exit` when it is inde an agent-oriented type, e.g. `agent`; with a name containing the forbidden character &#x24;.; or the feature is part of a private API and the caller is not part of the private API<br>**Solving:** Remove the call | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 51g | **Message:** Forbidden reference to not final field *name* from a constructor's default value expression<br>**Cause:** This error message is generated when a reference to a not-final field is detected into the expression of the default value for a constructor's formal parameter. Only final fields could be used for building a default value expression of a constructor in order to avoid unexpected side-effects<br>**Solving:** Remove the reference to the not final field | Error | [forbidden_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference") |
| 52 | **Message:** The generic type parameter '*name*' is hiding the generic type parameter of '*type-name*'<br>**Cause:** This error is generated when you declared a generic type parameter for an action that has the same name as another generic type parameter that is declared into the enclosing type (class, or interface)<br>**Solving:** Change the *name* | Error | [generic_type_name_shadowing](: "io.sarl.lang.validation.IssueCodes.generic_type_name_shadowing") |
| 53a | **Message:** Cannot instantiate the *name*<br>**Cause:** You try to create an instance of a type named *name* with the `new` instruction. The type with the given *name* cannot be instanciated due to several reasons, e.g., it is defiend as abstract, it has no visible constructor, etc | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 53b | **Message:** Cannot instantiate the annotation type *name*<br>**Cause:** You try to create an instance of an annotation named *name* with the `new` instruction. It is impossible to create an instance of annotation | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 53c | **Message:** Cannot instantiate the enum type *name*<br>**Cause:** You try to create an instance of an enumeration named *name* with the `new` instruction. It is impossible to create an instance of enumeration | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 53d | **Message:** Cannot instantiate the interface type *name*<br>**Cause:** You try to create an instance of an interface named *name* with the `new` instruction. It is impossible to create an instance of interface | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 53e | **Message:** Cannot instantiate the primitive type *name*<br>**Cause:** You try to create an instance of a primitive type named *name* with the `new` instruction. Since a primitive type is not object-oriented, it is impossible to create an instance of primitive type | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 53f | **Message:** Cannot instantiate the type parameter *name*<br>**Cause:** You try to create an instance of a type parameter named *name* with the `new` instruction. Since the concrete type represented by the type parameter is not known at compile time, creation of an instance of *name* is impossible | Error | [illegal_class_instantiation](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_class_instantiation") |
| 54 | **Message:** Cannot reference the field '*name*' before it is defined<br>**Cause:** You try to have access to a field before it is defined within the sequence of statements ofyour code. This error should never append in SARL code. It was defined for "safety" reasons<br>**Solving:** Move the field definition before its first usage | Error | [illegal_forward_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference") |
| 55 | **Message:** Illegal redefinition of the default value for the formal parameter *name*. Inherited value is: *original value*. While the current value is: *redefined value*<br>**Cause:** This error message is generated when you declared a default value for a formal parameter that is different from the corresponding default value that was declared into the super types. You cannot change the default value of a formal parameter because it may cause unexpected side-effects for the callers of the function<br>**Solving:** Remove the redundant declaration fo the default value | Error | [illegal_parameter_default_value_redefinition](: "io.sarl.lang.validation.IssueCodes.illegal_parameter_default_value_redefinition") |
| 56 | **Message:** Implicit return<br>**Cause:** By default, it is not necessary to specify an explicit `return` statement inside the code block of a function. The SARL compilier assumes that the last executed instruction gives the value to be returned by the function. This issue message is generated when an implicit return is used within a function<br>**Solving:** Add an explicit `return` | Configurable; Default is: Ignored | [implicit_return](: "org.eclipse.xtend.core.validation.IssueCodes.implicit_return") |
| 57 | **Message:** The import '*package-1*.*name*' collides with the import '*package-2*.*name*'<br>**Cause:** This error is generated when you define into the list of `import` two types with the same simple name. In this case, it is impossible to determine if an occurrence of *name* into the code refers to the type in the package *package-1* or in the package *package-2*<br>**Solving:** Remove one of the `import` | Error | [import_collision](: "org.eclipse.xtext.xbase.validation.IssueCodes.import_collision") |
| 58 | **Message:** The import '*package*.*name*' conflicts with a type defined in the same file<br>**Cause:** You are importing a type with the given *name* into the given *package*. But, you have also defined a local type with the *name*. In this case, it is impossible to determine if an occurrence of *name* into the code refers to the local type or the imported type<br>**Solving:** Rename the local type | Error | [import_conflict](: "org.eclipse.xtext.xbase.validation.IssueCodes.import_conflict") |
| 59 | **Message:** The import *name* cannot be resolved<br>**Cause:** The *name* that is provided after an `import` cannot be found<br>**Solving:** Remove the `import` statement | Configurable; Default is: Error | [import_unresolved](: "org.eclipse.xtext.xbase.validation.IssueCodes.import_unresolved") |
| 60 | **Message:** The import '*name*' is never used<br>**Cause:** This issue message is generated when an `import` statement does not provide features that are used into the current file<br>**Solving:** Remove `import` statement | Configurable; Default is: Warning | [import_unsued](: "org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued") |
| 61 | **Message:** The use of wildcard imports is deprecated<br>**Cause:** You are importing all the types that are defined into a package with `import pkg.*`. This instruction has two major drawbacks. Firstly, the really used types within the current are not explicit because of the wildcard. Second, the SARL compiler loads in memory too much type definitions for compiling the current file<br>**Solving:** Replace the wildcard by the really used types | Configurable; Default is: Warning | [import_wildcard_deprecated](: "org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated") |
| 62 | **Message:** The declared exception *exception-type* is not compatible with throws clause in *exception-list*<br>**Cause:** According the inheritance definition, that is common to SARL and the object-oriented programming languages, overridable functions as associated to a contract with their callers. This contract indicates that the prototype of the function will never changed, and the function will have the same thrown exceptions always. This contract must be fullfil by the overriding functions. This error message is generated when your overriding function has a list of exceptions after the `thrown` keyword that is not compatible with the list defined into the inherited function. An exception of type "a" in the overriding function must be also a "b", where "a" is equals to "b" or a sub-type of "b"<br>**Solving:** Change the list of exceptions after `throws` keyword to the appropriate exception types | Error | [incompatible_throws_clause](: "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_throws_clause") |
| 63a | **Message:** Incompatible types. Expected *expected-type* but was *actual-type*<br>**Cause:** The value that is specified after a `return` statement has a type that is incompatible with the return type of the enclosing function<br>**Solving:** Rewrite the return's expression in order to have a compatible type; or change the return type of the function to be compatible with those of the return expression | Error | [incompatible_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types") |
| 63b | **Message:** No exception of type *type-name* can be thrown; an exception type must be a subclass of Throwable<br>**Cause:** Inside a `catch` statement, you have specified a *type-name* that does not correspond to a sub-type of `Throwable`. The parameter of the `catch` statement must be a throwable type, or a collection of throwable types<br>**Solving:** Rewrite *type-name* by an appropriate throwable type | Error | [incompatible_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types") |
| 63c | **Message:** Type mismatch: cannot convert from *source-type* to *target-type*<br>**Cause:** The value cannot be converted from the *source-type* to the *target-type* because there is neither implicit nor explicit conversion function<br>**Solving:** Rewrite the expression in order to have a compatible type | Error | [incompatible_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types") |
| 64a | **Message:** The enum constant *name* needs a corresponding case label in this enum switch on *type-name*<br>**Cause:** You have specified an enumerated value to a `switch` condition. The enumeration constant with the given *name* has not a corresponding `case` into the `switch`. It means that all the possible cases are not explicitly covered; It is preferrable they are all covered<br>**Solving:** Add a `case` for the missed constant *name* | Configurable; Default is: Warning | [incomplete_cases_on_enum](: "org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum") |
| 64b | **Message:** The enum constants *list-of-names* need a corresponding case label in this enum switch on *type-name*<br>**Cause:** You have specified an enumerated value to a `switch` condition. The enumeration constants with the given names have not corresponding `case` into the `switch`. It means that all the possible cases are not explicitly covered; It is preferrable they are all covered<br>**Solving:** Add a `case` for each missed constant name | Configurable; Default is: Warning | [incomplete_cases_on_enum](: "org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum") |
| 65a | **Message:** Incompatible return type of dispatch method. Expected *inherited type* but was *specified type*<br>**Cause:** This error message is generated when an overriding function has a *specified type* that is incompatible with the *inherited type* defined for the method into the super-type<br>**Solving:** Replace the return type with a compatible type | Error | [incomptible_return_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type") |
| 65b | **Message:** The return type is incompatible with *func-prototype*<br>**Cause:** This error message is generated when an overriding function has a specified type that is incompatible with the inherited type defined for the method into the super-type<br>**Solving:** Replace the return type with a compatible type | Error | [incomptible_return_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type") |
| 66 | **Message:** The static *feature-type* *feature-name* should be accessed in a static way<br>**Cause:** For a instance function, you try to access to a static feature using a non-static syntax, e.g. `obj.StaticFeature`. It is preferable to use the static call syntax, e.g. `MyType::StaticFeature`, where `MyType` is the type of the object `obj` from the previous example<br>**Solving:** Replace the non-static syntax by the static syntax<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.staticAccessReceiver | Delegated; Default is: Warning | [instance_access_to_static_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member") |
| 67a | **Message:** Extended interface must be an interface<br>**Cause:** According to the syntax of SARL, an interface extends another interface. This error message indicates to you that the type after `extends` is not an interface<br>**Solving:** Remove the `extends` statement; or replace the invalid type by the appropriate class | Error | [interface_expected](: "org.eclipse.xtext.xbase.validation.IssueCodes.interface_expected") |
| 67b | **Message:** Implemented interface must be an interface<br>**Cause:** According to the syntax of SARL, a class implements interfaces. This error message indicates to you that one type after `implements` is not an interface<br>**Solving:** Remove the `extends` statement; or replace the invalid type by the appropriate class | Error | [interface_expected](: "org.eclipse.xtext.xbase.validation.IssueCodes.interface_expected") |
| 67c | **Message:** Invalid supertype. Expecting *feature*<br>**Cause:** According to the syntax of SARL, a type (agent, capacity, etc.) extends another type. This error message indicates to you that the type after `extends` is not of a type that is expected. The name of the *feature* shows the expectation<br>**Solving:** Remove the `extends` statement; or replace the invalid type by the appropriate type | Error | [interface_expected](: "org.eclipse.xtext.xbase.validation.IssueCodes.interface_expected") |
| 68 | **Message:** *any-message*<br>**Cause:** This error is generated when the SARL compiler has encountered an internal error | Error | [internal_error](: "io.sarl.lang.validation.IssueCodes.internal_error") |
| 69 | **Message:** Invalid type: '*type-name*'. Only *capacities* can be used after the keyword '*uses*'<br>**Cause:** The keyword `uses` enables to uses and import capacities within the scope of the entity (agent, behavior, etc.) in which the `uses` is specified. This error is generated when the type named *type-name* that is specified after an `uses` is not a sub-type of `Capacity`, i.e. it is not a capacity type<br>**Solving:** Remove the *type-name* after the keyword `uses`; or replace *type-name* by the name of an appropriate capacity | Error | [invalid_capacity_type](: "io.sarl.lang.validation.IssueCodes.invalid_capacity_type") |
| 70a | **Message:** Cannot cast from *type-name-1* to *type-name-2*<br>**Cause:** The operands of the cast operator `as` have not compatible types. SARL compiler has found no way to convert a value of the type with name *type-name-1*, which is the type of the left operand of the `as` operator, to a value of the type with name *type-name-2*, which is the right operand of the `as` operator<br>**Solving:** Change the left expression in order to be of a compatible type with the right operand; or Replace *type-name-2* by an appropriate type name; or Define a "to*type-name-2*()" function if *type-name-2* is a class; or Define a "*type-name-2Value()" function if *type-name-2* is a primitive type | Error | [invalid_cast](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast") |
| 70b | **Message:** Cannot cast from void to *type-name-2*<br>**Cause:** Since `void` represents the fact that there is not value, it is impossible to convert "nothing" to a value, whatever its type<br>**Solving:** Remove `as` operator | Error | [invalid_cast](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast") |
| 71a | **Message:** Cannot refer to an instance field *field-name* while explicitly invoking a constructor<br>**Cause:** According to the standards of object-oriented programming, nothing could append into an object before it was constructed. It means that when you are calling a constructor from inside a constructor's block of code, the object is not yet built. Consequently, you cannot have access to the object's fields (not static)<br>**Solving:** Rewrite the arguments to avoid the access to the object's field | Error | [invalid_constructor_argument](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument") |
| 71b | **Message:** Cannot refer to an instance method while explicitly invoking a constructor<br>**Cause:** According to the standards of object-oriented programming, nothing could append into an object before it was constructed. It means that when you are calling a constructor from inside a constructor's block of code, the object is not yet built. Consequently, you cannot have access to the object's method (not static)<br>**Solving:** Rewrite the arguments to avoid the access to the object's method | Error | [invalid_constructor_argument](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument") |
| 72 | **Message:** Constructor call must be the first expression in a constructor<br>**Cause:** According to the standards of object-oriented programming, nothing could append into an object before it was constructed. It means that the first possible instruction within any constructor's code is a call to another constructor. This call may be explicit or implicit. This error is generated by your constructor's code starts with statements that are not a constructor calls, followed by a constructor call<br>**Solving:** Move the constructor call first | Error | [invalid_constructor_invocation](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation") |
| 73a | **Message:** Invalid annotation value. *skill-name* is not an implementation of *capacity-name*<br>**Cause:** The `@DefaultSkill` annotation enables to specify programmatically the skill that may be used by default by an agent for implementing a capacity. The parameter named *skill-name* of the `@DefaultSill` must be a skill that implements the capacity *capacity-name*<br>**Solving:** Remove the `@DefaultSkill`; or replace *skill-name* by an appropriate skill type name | Error | [invalid_default_skill_annotation](: "io.sarl.lang.validation.IssueCodes.invalid_default_skill_annotation") |
| 73b | **Message:** Invalid annotation value. It must be a type literal to a skill<br>**Cause:** The `@DefaultSkill` annotation enables to specify programmatically the skill that may be used by default by an agent for implementing a capacity. The parameter of the annotation must be the type name of a skill<br>**Solving:** Remove the `@DefaultSkill`; or replace *skill-name* by an appropriate skill type name | Error | [invalid_default_skill_annotation](: "io.sarl.lang.validation.IssueCodes.invalid_default_skill_annotation") |
| 74 | **Message:** Return is not allowed in creation expression<br>**Cause:** This error message is generated when a `return` statement is defined in a context that cannot allow a return, such as a creation expression<br>**Solving:** Remove the `return` statement | Error | [invalid_early_exit](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit") |
| 75a | **Message:** Supertype must be a subtype of '*type-name*'<br>**Cause:** This error message is generated when the provided type after the `extends` statement is invalid; because it is not a sub-type of *type-name* strictly (i.e., not *type-name* itself)<br>**Solving:** Remove the type after `extends`; or replace it by the appropriate name of a sub-type of *type-name* | Error | [invalid_extended_type](: "io.sarl.lang.validation.IssueCodes.invalid_extended_type") |
| 75b | **Message:** Supertype must be of type '*type-name*'<br>**Cause:** This error message is generated when the provided type after the `extends` statement is invalid; because it is neither equals to *type-name* nor a sub-type of *type-name*<br>**Solving:** Remove the type after `extends`; or replace it by the appropriate name of a sub-type of *type-name* | Error | [invalid_extended_type](: "io.sarl.lang.validation.IssueCodes.invalid_extended_type") |
| 76 | **Message:** The primitive type *name* is not a valid extension<br>**Cause:** [Extension on fields](./expr/Extension.html) is supported by SARL syntax. The purpose is to call the member of an object or a type that is marked by `extension`. A primitive type has no member. Consequently, using the `extension` on a variable of primitive type is impossile<br>**Solving:** Remove `extension`; or replace the primitive type by its object-oriented equivalent | Error | [invalid_extension_type](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_extension_type") |
| 77 | **Message:** *any-message*<br>**Cause:** Extra-language generator is an extension module of the SARL compiler. It has the role to generate source code in a specific programming language, e.g., Python, that is not supported by the core generator of the SARL compiler, i.e., Java. When the extra-language generator encounters an issue (error, warning or information), it is notified with is issue code | Error | [invalid_extra_language_generation](: "io.sarl.lang.validation.IssueCodes.invalid_extra_language_generation") |
| 78 | **Message:** Invalid type: '*type-name*'. Only events can be used after the keyword 'fires'<br>**Cause:** The keyword `fires` specifies the events that could be fired by a function. This error is generated when the type named *type-name* that is specified after an `fires` is not a sub-type of `Capacity`, i.e. it is not a capacity type<br>**Solving:** Remove the *type-name* after the keyword `fires`; or replace *type-name* by the name of an appropriate capacity | Error | [invalid_firing_event_type](: "io.sarl.lang.validation.IssueCodes.invalid_firing_event_type") |
| 79 | **Message:** *any-message*<br>**Cause:** This error message is generated when you pass an invalid type to a generic parameter type. *Caution: this issue seems not to have a message template from the Xtext/Xbase source code*<br>**Solving:** Change the type argument | Error | [invalid_generic_argument_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_generic_argument_types") |
| 80 | **Message:** '*name*' is not a valid identifier<br>**Cause:** This error is generated when you are using an identifier that is corresponding to a keyword of the Java programming language. Since the SARL compiler create Java source file, in order to make the generated files compilable, any variable with a name equals to a JAva keyword must be avoided<br>**Solving:** Change the *name* | Error | [invalid_identifier](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_identifier") |
| 81a | **Message:** Invalid implemented type: '*type-name*'. Only subtypes of '*expected-name*' are allowed for '*element-name*'<br>**Cause:** This error message is generated when the provided type named *type-name* is invalid when it is specified for an `implements` statement; because it is not a sub-type of *expected-name* strictly (i.e., not *expected-name* itself). When it is used for the definition of *element-name*, an implemented type must fullfil the previous typing constraint<br>**Solving:** Remove *type-name*; or replace it by the appropriate name of a sub-type of *expected-name* | Error | [invalid_implemented_type](: "io.sarl.lang.validation.IssueCodes.invalid_implemented_type") |
| 81b | **Message:** Invalid implemented type: '*type-name*'. Only the type '*expected-name*' and one of its subtypes are allowed for '*element-name*'<br>**Cause:** This error message is generated when the provided type named *type-name* is invalid when it is specified for an `implements` statement; because it is neither equals to *expected-name* nor a sub-type of *expected-name*. When it is used for the definition of *element-name*, an implemented type must fullfil the previous typing constraint<br>**Solving:** Remove *type-name*; or replace it by the appropriate name of a sub-type of *expected-name* | Error | [invalid_implemented_type](: "io.sarl.lang.validation.IssueCodes.invalid_implemented_type") |
| 82a | **Message:** Expression with side effect is not allowed in guards<br>**Cause:** The guard that is specified for a behavior unit may have side effect, i.e. it may modify the state of the current agent/behavior/skill, or of another object. According to the SARL specification, the behavior units' guards must not have any side-effect because the guard's expression could be evaluated in parallel for different behavior units on the same event. In order to be consistent between the different evaluations of the guard, the guard expression cannot change the state of any object<br>**Solving:** Rewrite the guard expression to avoid the uses of side-effect expressions | Error | [invalid_inner_expression](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression") |
| 82b | **Message:** This expression is not allowed in this context, since it doesn't cause any side effects<br>**Cause:** This error is generated when you write an expression without side effect, where one is expected. For example, the following code generates this error:<br><code>def fct : void {<br>&nbsp;&nbsp;var x = 1<br>}</code><br>In this case, the variable declaration has not side effect; and should not be used in this context<br>**Solving:** Remove the expression without side-effect | Error | [invalid_inner_expression](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression") |
| 83a | **Message:** Cannot perform instanceof check against parameterized type *type-name*<br>**Cause:** You have written a `instanceof` operator with a right operand containing a generic type parameter, e.g. `x instanceof MyType<T>`. It is impossible for now to the SARL compiler to consider the generic type parameter, e.g. `T`<br>**Solving:** Remove the generic type parameter from the right operand's expression | Error | [invalid_instanceof](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof") |
| 83b | **Message:** Cannot perform instanceof check against primitive type *type-name*<br>**Cause:** You have written a primitive type as right operand of the `instanceof` operator. Since a primitive type is not object-oriented, it is impossible to test if an object is of a primitive type using the `instanceof` operator<br>**Solving:** Remove `instanceof` operator; or Replace the primitive type by its object-oriented equivalent type | Error | [invalid_instanceof](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof") |
| 83c | **Message:** Incompatible conditional operand types *type-name-1* and *type-name-2*<br>**Cause:** When you are testing expression typing with `instanceof`, the types of the operands are not compatible. It means that the values of the operands cannot be compared. Therefore, the `instanceof` operator becomes useless<br>**Solving:** Remove the `instanceof` operator; or Rewrite the `instanceof` expression to have compatible types for both operands | Error | [invalid_instanceof](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof") |
| 84a | **Message:** '*name*' is not allowed as member name<br>**Cause:** *Name* is reserved by the SARL compiler. They cannot be used for naming your type members<br>**Solving:** Change the name of your type member | Error | [invalid_member_name](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name") |
| 84b | **Message:** Invalid action name '*name*'. You must not give to an action a name with reserved characters<br>**Cause:** You have defined an name for an action/function/method that contains forbidden characters. The major forbidden character is &#x24;. It is not allowed to use it inside a name, even if it is allowed into the Java specification<br>**Solving:** Rename your action | Error | [invalid_member_name](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name") |
| 84c | **Message:** Invalid character '*value*' in a member name<br>**Cause:** The member name contains the reserved character, usually &#x24;. This character is used by the SARL compiler for naming hidden features and it is forbidden to the SARL developers to use this character in her/his feature names to avoid any collision with the SARL internal features<br>**Solving:** Remove the dollar character *value* from the member name | Error | [invalid_member_name](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name") |
| 84d | **Message:** The nested type *type-name* cannot hide an enclosing type<br>**Cause:** You have define an inner type with a *name*. One of the enclosing types has also the same *name*. It is forbidden because it hides the features of the enclosing type from the inner type<br>**Solving:** Rename your inner type | Error | [invalid_member_name](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name") |
| 85a | **Message:** Abstract method *member-name* cannot be final<br>**Cause:** It is forbidden to declare a function abstract and final at the same time. Indeed, a `final` function disables the function overriding, and an `abstract` function must be always overridden<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85b | **Message:** Abstract method *member-name* cannot be private<br>**Cause:** It is forbidden to declare a function abstract and private at the same time. Indeed, a `private` function cannot be overridden because it is not visible, and an `abstract` function must be always overridden<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85c | **Message:** Abstract method *member-name* cannot be static<br>**Cause:** It is forbidden to declare a function abstract and static at the same time. Indeed, a `static` function cannot be overridden, and an `abstract` function must be always overridden<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85d | **Message:** Duplicate modifier for the *name*<br>**Cause:** Duplicate modifiers are not allowed<br>**Solving:** Remove the duplicate modifier | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85e | **Message:** Illegal modifier for the *feature*; only *list-of-modifiers* are permitted<br>**Cause:** You have used a modifier that is not allowed. The *list-of-modifiers* shows you the valid modifiers at the place of the issue<br>**Solving:** Remove the modifier | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85f | **Message:** Invalid modifier '*name*' for the protocol parameter. Accepted modifiers are: *modifier-list*<br>**Cause:** You have specified a modifier with the given *name* to a protocol parameter. According to the BSPL protocol specification, the modifiers are specific and limited to the *modifier-list*<br>**Solving:** Replace *name* by a valid modifier | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85g | **Message:** Invalid modifier '*name*' for the protocol parameter. This modifier cannot be specified at the same time as *other-name*<br>**Cause:** This issue message is generated when you have speicifed two modifers with the *name* and *other-name*. These two modifiers cannot be specified at the time for a protocol parameter<br>**Solving:** Remove *name* or *other-name* | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85h | **Message:** Invalid modifier '*name*' for the target role in the protocol message. Accepted modifiers are: *modifier-list*<br>**Cause:** You have specified a modifier with the given *name* as the receiving role in a protocol message. According to the BSPL protocol specification, the modifiers are specific and limited to the *modifier-list*<br>**Solving:** Replace *name* by a valid modifier | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85i | **Message:** Invalid modifier '*name*' for the target role of the protocol message. This modifier cannot be specified at the same time as *other-name*<br>**Cause:** This issue message is generated when you have speicifed two modifers with the *name* and *other-name*. These two modifiers cannot be specified at the time for the receiving role of a protocol message<br>**Solving:** Remove *name* or *other-name* | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85j | **Message:** Method *member-name* with a body cannot be abstract<br>**Cause:** An abstract function is by definition a function without a body<br>**Solving:** Remove the `abstract` modifier; or remove the block of code | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85k | **Message:** Native methods do not specify a body<br>**Cause:** A native function is always implemented by a very-low level library, usually written in C programming language. You cannot provide a block of code for a native function<br>**Solving:** Remove the `native` modifier; or remove the block of code | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85l | **Message:** The *member-name* can either be abstract or final, not both<br>**Cause:** It is forbidden to declare a function abstract and final at the same time. Indeed, a `final` function disables the function overriding, and an `abstract` function must be always overridden<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85m | **Message:** The *member-name* can either be abstract or static, not both<br>**Cause:** It is forbidden to declare a function abstract and static at the same time. Indeed, a `static` function cannot be overridden, and an `abstract` function must be always overridden<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85n | **Message:** The *member-name* can either be var or val / final, not both<br>**Cause:** `var` modifier is for declared a modifiable variable. `val` modifier (or `final val`) is for declaring a unmodifiable variable. You cannot use `var` and `val` at the same time<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85o | **Message:** The *member-name* can only set one of *modifiers*<br>**Cause:** You cannot specify more than one visibility modifier at a time<br>**Solving:** Select and use one of the visibility modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 85p | **Message:** The field *name* can be either final or volatile, not both<br>**Cause:** It is forbidden to declare a field with the both modifiers at the same time. A `final` field does not need synchronization, that is provided by `volatile`<br>**Solving:** Remove one of the two modifiers | Error | [invalid_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier") |
| 86a | **Message:** The *type-name-1* is already covered by the caught *type-name-2*<br>**Cause:** You have specified multiple types, including *type-name-1* and *type-name-2*, into a multi-`catch` statement. The *type-name-1* is redundant because it is a sub-type of *type-name-2*<br>**Solving:** Remove *type-name*-1 | Error | [invalid_multitype_part](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_multitype_part") |
| 86b | **Message:** The caught *type-name* is redundant<br>**Cause:** You have specified multiple types, including *type-name*, into a multi-`catch` statement. The *type-name* is specified more than one time. You must not specify a type more than one time<br>**Solving:** Remove one occurrence of *type-name* | Error | [invalid_multitype_part](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_multitype_part") |
| 87 | **Message:** Cannot *expression* refer to the non-final variable *var-name* inside a lambda expression<br>**Cause:** You have written an expression inside a closure/lambda expression that is referring a variable that is not marked as final. In this case, the state of the variable becomes unpredictable for the internal class that is supporting the lambda expression implementation (due to the targeting to Java). That's why only final (or quasi-final) variables could be used in lambda expressions<br>**Solving:** Replace `var` definition of the variable by a `var` definition; or Use another final variable from the lambda expression | Error | [invalid_mutable_variable_access](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access") |
| 88a | **Message:** Nested agents are not allowed inside *enclosing-type*<br>**Cause:** It is not allowed by the SARL language's syntax to define an `agent` inside another type declaration, named *enclosing-type*<br>**Solving:** Move the agent definition outside the enclosing type | Error | [invalid_nested_definition](: "io.sarl.lang.validation.IssueCodes.invalid_nested_definition") |
| 88b | **Message:** Nested behaviors are not allowed inside *enclosing-type*<br>**Cause:** It is not allowed by the SARL language's syntax to define a `behavior` inside another type declaration, named *enclosing-type*<br>**Solving:** Move the behavior definition outside the enclosing type | Error | [invalid_nested_definition](: "io.sarl.lang.validation.IssueCodes.invalid_nested_definition") |
| 88c | **Message:** Nested capacities are not allowed inside *enclosing-type*<br>**Cause:** It is not allowed by the SARL language's syntax to define a `capacity` inside another type declaration, named *enclosing-type*<br>**Solving:** Move the capacity definition outside the enclosing type | Error | [invalid_nested_definition](: "io.sarl.lang.validation.IssueCodes.invalid_nested_definition") |
| 88d | **Message:** Nested events are not allowed inside *enclosing-type*<br>**Cause:** It is not allowed by the SARL language's syntax to define an `event` inside another type declaration, named *enclosing-type*<br>**Solving:** Move the event definition outside the enclosing type | Error | [invalid_nested_definition](: "io.sarl.lang.validation.IssueCodes.invalid_nested_definition") |
| 88e | **Message:** Nested skills are not allowed inside *enclosing-type*<br>**Cause:** It is not allowed by the SARL language's syntax to define a `skill` inside another type declaration, named *enclosing-type*<br>**Solving:** Move the capacity definition outside the enclosing type | Error | [invalid_nested_definition](: "io.sarl.lang.validation.IssueCodes.invalid_nested_definition") |
| 89a | **Message:** Invalid number of arguments. The *feature-type* *feature-prototype* is not applicable for the arguments *list-of-arguments*<br>**Cause:** You are calling a feature (method or constructor) with a *list-of-arguments*. But, the called feature required a different number of arguments<br>**Solving:** Call the feature with the correct number of arguments | Error | [invalid_number_of_arguments](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments") |
| 89b | **Message:** Invalid number of arguments. The *feature-type* *feature-prototype* is not applicable without arguments<br>**Cause:** You are calling a feature (method or constructor) without arguments. But, the called feature required to have arguments<br>**Solving:** Add arguments into your calling expression | Error | [invalid_number_of_arguments](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments") |
| 90a | **Message:** Incorrect number of arguments for type *type-name* ; it cannot be parameterized with arguments *type-arguments*<br>**Cause:** You are referencing a type with a list of generic type arguments (*list-arguments*). But, the referenced type required a different number of generic type arguments<br>**Solving:** Reference the type with the correct number of arguments | Error | [invalid_number_of_type_arguments](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments") |
| 90b | **Message:** Invalid number of type arguments. The *feature-type* *feature-name* is not applicable for the type arguments *type-arguments*<br>**Cause:** You are calling a feature (method or constructor) with a list of generic type arguments (*list-arguments*). But, the feature required a different number of generic type arguments<br>**Solving:** Call the feature with the correct number of arguments | Error | [invalid_number_of_type_arguments](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments") |
| 91a | **Message:** Invalid use of the unmodifiable feature '*name*'. You cannot use '*name*' as the operand of a postfix operator because it causes a side effect<br>**Cause:** Several SARL constructs must be considered as read-only, such as `occurrence` that represents the current instance of the just-received event within a behavior unit. In this example, it is assumed within the SARL operational semantics that the `occurrence` is an unmodifiable event in order to ensure consistency between the different behavior units that handle the `occurrence`. This error message is generated when you try to change the value of `occurrence` with a postfix operator, e.g., `++`, that is forbidden | Error | [invalid_occurrence_readonly_use](: "io.sarl.lang.validation.IssueCodes.invalid_occurrence_readonly_use") |
| 91b | **Message:** Invalid use of the unmodifiable feature '*name*'. You cannot use '*name*' at the left-side of an assignment operator<br>**Cause:** The keyword with the *name* is considered as a read-only construct. Usually it is `occurrence` that represents the current instance of the just-received event within a behavior unit. It is assumed within the SARL operational semantics that `occurrence` instance is an unmodifiable event in order to ensure consistency between the different behavior units that handle the `occurrence`. This error message is generated when you try to assign a value to an `occurrence`, that is forbidden | Error | [invalid_occurrence_readonly_use](: "io.sarl.lang.validation.IssueCodes.invalid_occurrence_readonly_use") |
| 92 | **Message:** Incompatible operand types *left* and *right*<br>**Cause:** When you are testing expression equality with `===`, the types of the operands are not compatible. It means that the values of the operands cannot be compared<br>**Solving:** Rewrite your code in order to have compatible types for both operands | Error | [invalid_operand_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_operand_types") |
| 93a | **Message:** The binary operator '*name*' allows at most two arguments<br>**Cause:** You try to use the operator *name* with zero or one operand; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93b | **Message:** The binary operator '*name*' requires at least one argument<br>**Cause:** You try to use the operator *name* with zero operand; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93c | **Message:** The operator '*name*' allows at most two arguments<br>**Cause:** You try to use the operator *name* with more than two operands; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93d | **Message:** The static binary operator '*name*' requires exactly two arguments<br>**Cause:** You try to use the operator *name* with zero or one operand; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93e | **Message:** The static operator '*name*' allows at most two arguments<br>**Cause:** You try to use the operator *name* without operand, when it requires at least one<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93f | **Message:** The static operator '*name*' requires at least one argument<br>**Cause:** You try to use the operator *name* without argument, when it requires at least one<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93g | **Message:** The static unary operator '*name*' requires exactly one argument<br>**Cause:** You try to use the operator *name* with a number of operand that is not equal to 1; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 93h | **Message:** The unary operator '*name*' allows at most one argument<br>**Cause:** You try to use the operator *name* with more than 1 operand; that is not allowed<br>**Solving:** Rewrite the expression with the failing operator | Configurable; Default is: Error | [invalid_operator_signature](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature") |
| 94a | **Message:** Invalid return inside throw<br>**Cause:** It is forbidden to specify a `return` statement into a `throw` expression because the outer early-exit point (`throw`) could be never reached due to the execution of the inner early-exit point (`return`). It is inconsistent to do a regular return for a function inside the expression of an exceptional exit from the same function<br>**Solving:** Remove `return` from the `throw` expression | Error | [invalid_return](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return") |
| 94b | **Message:** Invalid return's expression<br>**Cause:** SARL compiler infers that the type of the expression after a `return` statement is of type `void`. It is impossible to return "nothing" when a value is expected<br>**Solving:** Change the return expression in order to compute a value of the appropriate type | Error | [invalid_return](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return") |
| 94c | **Message:** Return cannot be nested<br>**Cause:** It is forbidden to specify a `return` statement into another `return` expression because the outer early-exit point could be never reached due to the execution of the inner early-exit point. It is inconsistent to do a return for a function inside the expression that computes another value to be returned from the same function<br>**Solving:** Remove the inner `return` from the outer `return` expression | Error | [invalid_return](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return") |
| 94d | **Message:** The function must return a result of type *type-name*<br>**Cause:** An incompatibility between the type of the expression after a `return` statement and those of the return value of the enclosing function is detected. Both types must be compatible, i.e., the type of the expression after the `return` statement must be equal to or a sub-type of the function's return type<br>**Solving:** Update the expression of the `return` statement to have an appropriate type | Error | [invalid_return](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return") |
| 94e | **Message:** Void functions cannot return a value<br>**Cause:** You are specifying a `return` statement with an expression inside a procedure, i.e. a function returning "nothing". Is it inconsistent to compute a value to be returned while the function does not return it<br>**Solving:** Remove the expression from the `return` statement | Error | [invalid_return](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return") |
| 95 | **Message:** Incompatible SARL library on the classpath. Actual: *actual-version*. Expected: *expected-version*<br>**Cause:** The SARL library found on the classpath (*actual-version*) is not compatible with the compiler's version (*expected-version*)<br>**Solving:** Reconfigure your project to have the SARL libraries with *expected-version* into the classpath | Error | [invalid_sarl_lib_on_classpath](: "io.sarl.lang.validation.IssueCodes.invalid_sarl_lib_on_classpath") |
| 96 | **Message:** Cannot call super of an anonymous class from a lambda expression<br>**Cause:** A closure/lambda expression is implemented by an anonymous class at the background, i.e. Java. You try to use the `super` statement that represents the instance viewed as the super-type of the associated anonymous class. However, it is forbidden to use `super` because the closure/lambda expression hides the background implementation, inclusing `super`<br>**Solving:** Remove `super` | Error | [invalid_super_call](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_super_call") |
| 97 | **Message:** The resource '*var-name*' of type *type-name* does not implement java.lang.AutoCloseable<br>**Cause:** The try-with-resource statement enables you to automatically close an opened resource (file, socket, etc.). The given resource, named *var-named* must implement the interface `AutoCloseable` in order to be able to be automatically closed. This constraint comes from the Java underground API<br>**Solving:** Change the resource by using one that is auto-closeable | Error | [invalid_try_resource_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_try_resource_type") |
| 98a | **Message:** 'void[]' is not a valid type<br>**Cause:** This error is generated when you are specifying a type literal representing an array of `void`, e.g. `void[]` or `void[][]`. An array of void cannot be created in memory. It is therefore impossible to specify this type with a type literal<br>**Solving:** Replace `void` by and appropriate type | Error | [invalid_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type") |
| 98b | **Message:** Invalid type for the parameter '*name*'. Only the type *type-name* is allowed in the declaration of the main function of the program<br>**Cause:** You have specified a type for the formal parameter *name* of the main function. This type is invalid since only the type *type-name* is allowed by the operating system<br>**Solving:** Replace the parameter's type by *type-name* | Error | [invalid_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type") |
| 98c | **Message:** Undefined type for the default value of the formal parameter *name*<br>**Cause:** The type of the default for the formal parameter with the given *name* cannot be infered by the SARL compiler<br>**Solving:** Change the default value's expression in order to make its type inferable | Error | [invalid_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type") |
| 98d | **Message:** Undefined type for the formal parameter *name*<br>**Cause:** A type specification is missed for the formal parameter with the given *name*<br>**Solving:** Add a type to the formal parameter | Error | [invalid_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type") |
| 99a | **Message:** Invalid type argument. Type arguments cannot be applied to the type literal *name*<br>**Cause:** You have specified a generic type argument into a type literal such as `typeof`; that is invalid. For example, `typeof(Collection)` is valid; but `typeof(Collection<String>)` is not<br>**Solving:** Remove the generic type argument | Error | [invalid_type_arguments_on_type_literal](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_arguments_on_type_literal") |
| 99b | **Message:** Invalid type arguments. Type arguments cannot be applied to the type literal *name*<br>**Cause:** You have specified generic type arguments into a type literal such as `typeof`; that is invalid. For example, `typeof(Collection)` is valid; but `typeof(Collection<String, Integer>)` is not<br>**Solving:** x | Error | [invalid_type_arguments_on_type_literal](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_arguments_on_type_literal") |
| 100a | **Message:** The array type *type-name* cannot be used as a type parameter bound<br>**Cause:** It is forbidden to use an array type into the generic type bounds, e.g. `<? extends Integer[]>`<br>**Solving:** Replace the array into the generic bounds by an appropriate type | Error | [invalid_type_parameter_bounds](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_parameter_bounds") |
| 100b | **Message:** The type parameter %name% cannot be used as a type parameter bound with additional bounds<br>**Cause:** If you put a generic type paramater as bounds of another generic type parameter, it is forbidden to add more bounding constraints. For example, `<A, B extends A>` is valid. But, `<A, B extends A & Cloneable>` is invalid<br>**Solving:** Remove the additional bounding constraint | Error | [invalid_type_parameter_bounds](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_parameter_bounds") |
| 101 | **Message:** Invalid use of the *name* keyword. It could only be used inside loops<br>**Cause:** `break` and `continue` statements enable to stop the execution of a loop step by continuing the execution after the loop itself or at the next loop step, respectively. The keyword with *name* is not supposed to be used outside a loop expression<br>**Solving:** Remove the `break` statement | Error | [invalid_use_of_loop_breaking_keyword](: "io.sarl.lang.validation.IssueCodes.invalid_use_of_loop_breaking_keyword") |
| 102a | **Message:** Create methods can not be static<br>**Cause:** Creation method is inspired from the [factory-method design pattern](https://en.wikipedia.org/wiki/Factory_method_pattern). It cannot be defined with the `static` modifier<br>**Solving:** Remove the `static` modifier | Error | [invalid_use_of_static](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static") |
| 102b | **Message:** Create methods can not have type parameters<br>**Cause:** Creation method is inspired from the [factory-method design pattern](https://en.wikipedia.org/wiki/Factory_method_pattern). It cannot have generic type parameters<br>**Solving:** Remove the generic type parameters | Error | [invalid_use_of_static](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static") |
| 103a | **Message:** Cannot perform instanceof check against type parameter *name*. Use its erasure *erasure-name* instead since further generic type information will be erased at runtime<br>**Cause:** You specify a generic type parameter as the right operand of an `instanceof`, e.g. `x instanceof T`. Since there is no keept information about the generic types at runtime, the `instanceof` operator cannot proceed. The *erasure-name* is the base definition of *name* related to its bounds<br>**Solving:** Replace *name* by *erasure-name* | Error | [invalid_use_of_type_parameter](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter") |
| 103b | **Message:** Cannot perform type switch against type parameter *name*. Use its erasure Object instead since further generic type information will be erased at runtime<br>**Cause:** You specify a generic type parameter as the type guard of a `case`, e.g. `T case 1`. Since there is no keept information about the generic types at runtime, the `case` statement cannot filter according to the type of the value. It is therefore recommended to use `Object` as the type guard<br>**Solving:** Remove the type guard | Error | [invalid_use_of_type_parameter](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter") |
| 103c | **Message:** Illegal class literal for the type parameter *name*<br>**Cause:** You specify a generic type parameter as a type literal, e.g. `typeof(T)`. Since there is no keept information about the generic types at runtime, the `typeof` operator cannot reply the class at runtime<br>**Solving:** Replace *name* by an appropriate type from the erasure of *name* | Error | [invalid_use_of_type_parameter](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter") |
| 104a | **Message:** A vararg may not be an extension<br>**Cause:** By definition a variadic parameter, e.g., `a : int*` is a kind of list of argument values. Since the extension mechanism is associated to a single instance of object, and the variadic parameter may contains more than one, there is an incompatibility between the variadic parameter and the extension mechanism<br>**Solving:** Remove the keyword `extension` to the variadic parameter | Error | [invalid_use_of_varArg](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg") |
| 104b | **Message:** A vararg must be the last parameter<br>**Cause:** By definition a variadic parameter, e.g., `a : int*`, must be the last formal parameter of a function<br>**Solving:** Move the variadic parameter at the last position in the list of the formal parameters | Error | [invalid_use_of_varArg](: "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg") |
| 105a | **Message:** Create method *name* may not declare return type void<br>**Cause:** Create method is defined as a design pattern for creating objects in memory. By design, they are supposed to return the created object and not void<br>**Solving:** Replace the void return type by the type of the created object | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105b | **Message:** Primitive void cannot be used here<br>**Cause:** This message is generated in to cases.<br>a) Generic type argument: it is forbidden to put primitive `void` as generic type arguments, e.g. `Collection<void>`.<br>b) Guard type into a switch case: it is forbidden to put primitive `void` as guard type, e.g. `void case 1`<br>**Solving:** Replace `void` by its appropriate equivalent class | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105c | **Message:** Primitives are not allowed as type guards<br>**Cause:** It is forbidden to put primitive type as guard type, e.g. `int case 1`<br>**Solving:** Replace the primitive type by its appropriate equivalent class | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105d | **Message:** Primitives cannot be used as type arguments<br>**Cause:** It is forbidden to put primitive types as generic type arguments, e.g. `Collection<int>`. You must use only classes as generic type arguments, e.g. `Collection<Integer>`<br>**Solving:** Replace the primitive type by its appropriate equivalent class | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105e | **Message:** The inherited return type void of *name* is invalid for create method<br>**Cause:** Create method is defined as a design pattern for creating objects in memory. By design, they are supposed to return the created object and not void<br>**Solving:** Replace the void return type by the type of the created object | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105f | **Message:** The primitive 'void' cannot be the type of a function parameter<br>**Cause:** This error is generated when a reference to a function, a.k.a. as pointer to a function, is specified with a `void` type. A function has parameters and returns values. It is not `void`<br>**Solving:** Replace `void` by an appropriate pointer to a function | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105g | **Message:** The primitive 'void' cannot be the type of a parameter<br>**Cause:** A formal parameter must have a type. Consequently, `void` cannot be specified as the type of a formal parameter<br>**Solving:** Replace `void` by an appropriate type | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105h | **Message:** The primitive type cannot be a type argument<br>**Cause:** It is forbidden to put primitive types as generic type parameters, e.g. `Collection<int>`. You must use only classes as generic type parameters, e.g. `Collection<Integer>`<br>**Solving:** Replace the primitive type by its appropriate equivalent class | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105i | **Message:** void is an invalid type for the create method *func-prototype*<br>**Cause:** Create method is defined as a design pattern for creating objects in memory. By design, they are supposed to return the created object and not void<br>**Solving:** Replace the void return type by the type of the created object | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 105j | **Message:** void is an invalid type for the variable *name*<br>**Cause:** Since a variable is supposed to contain a value, it is important to specify the size of memory that is occupied bythe variable. This specification is done by giving a type to the variable. `void` is not a valid type in this context<br>**Solving:** Replace `void` by an appropriate type | Error | [invalid_use_of_void](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void") |
| 106 | **Message:** Wildcard types are not allowed in this context<br>**Cause:** It is forbidden to put wildcard as generic type parameters, e.g. `Collection<?>`. You must use only classes as generic type parameters, e.g. `Collection<Integer>`<br>**Solving:** Replace the wildcard by an appropriate class | Error | [invalid_use_of_wild_card](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_wild_card") |
| 107a | **Message:** Invalid type constraint. Cannot use multiple lower bounds in wildcards<br>**Cause:** Inside a type reference, you have specified a type constraints with too much lower bounds, e.g. `new MyType<? super Number &amp; CharSequence>`. Currently, SARL does not support multiple lower bounds into the generic type references<br>**Solving:** Modify the bounds to have maximum one lower bound | Error | [invalid_wildcard_constraints](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_wildcard_constraints") |
| 107b | **Message:** Invalid type constraint. Cannot use multiple upper bounds in wildcards<br>**Cause:** Inside a type reference, you have specified a type constraints with too much upper bounds, e.g. `new MyType<? extends Number &amp; CharSequence>`. Currently, SARL does not support multiple upper bounds into the generic type references<br>**Solving:** Modify the bounds to have maximum one upper bound | Error | [invalid_wildcard_constraints](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_wildcard_constraints") |
| 108 | **Message:** Invalid number format: *explaination*<br>**Cause:** A number literal has not a valid syntax<br>**Solving:** Change the number literal to fullfil the number syntax | Error | [invalidNumberFormat](: "org.eclipse.xtext.xbase.validation.IssueCodes.invalidNumberFormat") |
| 109a | **Message:** Cannot access the private *feature* in a subclass context<br>**Cause:** You try to access to a field that is declared as `private` into the super-type | Error | [invisible_feature](: "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature") |
| 109b | **Message:** The field *feature* is not visible<br>**Cause:** You try to access to a field that is declared as `private` into its enclosing type | Error | [invisible_feature](: "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature") |
| 109c | **Message:** The method *feature* is not visible<br>**Cause:** You try to access to a method that is declared as `private` into its enclosing type | Error | [invisible_feature](: "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature") |
| 110 | **Message:** sarlDoc: *type-ref* cannot be resolved to a type<br>**Cause:** A hyperlink to a type into the Javadoc points to an unknown type named *type-ref*<br>**Solving:** Change the *type-name*<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.invalidJavadoc | Delegated; Default is: Ignored | [java_doc_linking](: "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking") |
| 111 | **Message:** Use 'as' keyword for type casting<br>**Cause:** SARL has detected possible improper usage of the parentheses, i.e., a type reference enclosed by parentheses is found. This syntax is well known is other programming languages such as Java or C++, as the casting operator. However, the casting operator in SARL is `as`. For example, this error is detected when you starts a code block with the improper syntax, e.g. `{(Integer) 1}`<br>**Solving:** Replace the Java-like casting operator by `as` | Configurable; Default is: Error | [java_style_type_cast](: "org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast") |
| 112a | **Message:** Couldn't find a valid version of the JDK in the classpath. The generator configuration specifies the version *current-version*. Please change the configuration in order to use a version greater than or equal to *min-version* AND strictly lower than *max-version*<br>**Cause:** SARL needs a specific version of the Java Development Kit (JDK) in order to be executed. The *current-version* of the JDK that is used for compiling your SARL project is not compatible with SARL. It is recommended to use a JDK version between *min-version* (inclusive) and *max-version* (exclusive)<br>**Solving:** Change the configuration of your SARL project for using an appropriate JDK version | Error | [jdk_not_on_classpath](: "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath") |
| 112b | **Message:** SARL compiler couldn't be executed on the JDK version *current-version*. Please use the JDK greater than or equal to *min-version* AND strictly lower than *max-version*<br>**Cause:** SARL needs a specific version of the Java Development Kit (JDK) in order to be executed. The *current-version* of the JDK is not compatible with SARL. It is recommended to use a JDK version between *min-version* (inclusive) and *max-version* (exclusive)<br>**Solving:** Run SARL with an appropriate JDK version | Error | [jdk_not_on_classpath](: "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath") |
| 113 | **Message:** Left-hand side of an assignment must be an variable<br>**Cause:** The left operand of the assignment operator `=` must be a variable (local, field, or indirect) | Error | [left_hand_side_must_be_variable](: "left_hand_side_must_be_variable") |
| 114a | **Message:** *name* cannot be resolved to a type<br>**Cause:** You have specified a type *name* into your code, e.g. `typeof(MyType)`. But, no type declaration was found for *name* into the current compilation scope<br>**Solving:** Replace *name* by an appropriate type name; or Add the type *name* into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 114b | **Message:** Couldn't resolve reference to *name*<br>**Cause:** You have written a reference to a feature that cannot be found from the current compilation scope. Since, it cannot be found, SARL compiler cannot determine the concrete type of the feature<br>**Solving:** Replace *name* by an appropriate feature; or Add the feature into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 114c | **Message:** The method *func-prototype* is undefined<br>**Cause:** You have specified a function call to *func-prototype* into your code, e.g. `myfct()`. But, no method declaration was found for *func-prototype* into the current compilation scope<br>**Solving:** Replace *func-prototype* by an appropriate function call; or Add the method into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 114d | **Message:** The method *func-prototype* is undefined for the type *type-name*<br>**Cause:** You have specified a function call to *func-prototype* into your code, e.g. `myfct()`. But, no method declaration was found for *func-prototype* into the current compilation scope<br>**Solving:** Replace *func-prototype* by an appropriate function call; or Add the method into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 114e | **Message:** The method or field *name* is undefined<br>**Cause:** You have specified a function call to *name*, or a reference to the field *name*, into your code. But, neither a method declaration nor a field declaration was found into the current compilation scope<br>**Solving:** Replace *name* by an appropriate function call or field reference; or Add the method/field into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 114f | **Message:** The method or field *name* is undefined for the type *type-name*<br>**Cause:** You have specified a function call to *name*, or a reference to the field *name*, into your code. But, neither a method declaration nor a field declaration was found into the current compilation scope<br>**Solving:** Replace *name* by an appropriate function call or field reference; or Add the method/field into the compilation scope, by using an `import` statement for example | Error | [Linking](: "org.eclipse.xtext.diagnostics.Diagnostic.Linking") |
| 115 | **Message:** Cannot access the *type-name* *feature-name* with parentheses<br>**Cause:** This error is generated when you try to access to a local variable with parentheses. Let be the local variable `x` defined. The code `x()` causes this error because `x` is a variable, not a method<br>**Solving:** Remove the parentheses | Error | [local_var_access_with_parentheses](: "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses") |
| 116 | **Message:** Discouraged manual definition of an inline expression. Inline expression definition is reserved for advanced usage<br>**Cause:** The `@Inline` annotation enables the SARL compiler to replace the call to the annotated function by the expression specified inside the annotation. It may be useful for making faster the generated Java code. However, the expression inside `@Inline` must be written in valid Java and following strict inlining rules. That's why, the explicit usage of `@Inline` is not recommended, except to advanced SARL developers<br>**Solving:** Remove the `@Inline` annotation | Configurable; Default is: Warning | [manual_inline_definition](: "io.sarl.lang.validation.IssueCodes.manual_inline_definition") |
| 117a | **Message:** The abstract method *func-name* in type *type-name* can only be defined by an abstract class<br>**Cause:** An abstract method/function is a function without block of code. The keyword `abstract` could be missed on a function only if the enclosing type is defined as abstract too<br>**Solving:** Add the modifier `abstract` into the prototype of *func-name* | Error | [missing_abstract](: "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract") |
| 117b | **Message:** The method *func-name* in type *type-name* should be declared abstract<br>**Cause:** An abstract method/function is a function without block of code. The keyword `abstract` could be missed but it is a good practice to specify it explicitle. This warning is generated to notify you that an `abstract` is missed and may be added to the function prototype<br>**Solving:** Add the modifier `abstract` into the prototype of *func-name* | Warning | [missing_abstract](: "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract") |
| 118 | **Message:** The abstract method *func-prototype* in type *type-name* can only be defined by an abstract class<br>**Cause:** It is forbidden to define an abstract function into an anonymous class<br>**Solving:** Add block of code for the function with prototype *func-prototype* | Error | [missing_abstract_in_anonymous](: "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_in_anonymous") |
| 119 | **Message:** The class '*name*' is not declared abstract<br>**Cause:** The name of the class starts with the word `Abstract`, and the class has not the `abstract` modifier. Because the term "abstract" is part of the name of the class, it is a good practice to declare the class as abstract<br>**Solving:** Add `abstract` modifier to the class; or remove "Abstract" from *name* | Configurable; Default is: Warning | [missing_abstract_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_modifier") |
| 120 | **Message:** The annotation must define the attribute '*name*'<br>**Cause:** An annotation needs to have a specified value. This error message is generated when no value is specified into the annotation<br>**Solving:** Add a value to the annotation | Error | [missing_attribute_definition](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_attribute_definition") |
| 121 | **Message:** Missing code for a static constructor<br>**Cause:** A static constructor could be defined for initializing the static fields of a type. It is forbidden to define a static constructor without a block of code<br>**Solving:** Add a block of code to the static constructor | Error | [missing_body](: "io.sarl.lang.validation.IssueCodes.missing_body") |
| 122 | **Message:** No default constructor in super type *other-type*. *type-name* must define an explicit constructor<br>**Cause:** You have define a type named *type-name* with a default constructor. But, the super-class does not have a default constructor. It is then impossible for your implicit default constructor to invoke a default constructor from the super-class. You must define explicitly your own constructor. *This issue should never occur because the constructors from the super type are inherited when there is no explicit constructor defined* | Error | [missing_constructor](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_constructor") |
| 123 | **Message:** Value must be initialized<br>**Cause:** Final variables, a.k.a. value, could be declared with `val`, and must be initialized when they are declared. You have declared a final variable that is never initialized<br>**Solving:** Add initialization value to the final variable | Error | [missing_initialization](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_initialization") |
| 124 | **Message:** The method *func-prototype* of type *type-name* should use override keyword since it actually overrides a supertype method<br>**Cause:** A function with the prototype *func-prototype* is defined into the type *type-name*. The same function prototype is defined into and inherited from a super-type. A good practice is to replace the `def` keyword by `override` in order to make explicit the fact that the function into *type-name* overrides another function | Configurable; Default is: Ignored | [missing_override](: "org.eclipse.xtend.core.validation.IssueCodes.missing_override") |
| 125a | **Message:** Nested classes must be static<br>**Cause:** SARL specification forces to have static inner classes due to implementation of Xtext/Xtend<br>**Solving:** Add `static` modifier to the nested class | Error | [missing_static_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier") |
| 125b | **Message:** Potential missing of the *name* modifier. This function has the same name as the main function of the program and therefore should be declared with this modifier<br>**Cause:** You have declared a function that has the same name as the usual main function of the program. If it is the main function, the modifier *name* is mandatory<br>**Solving:** Add *name* modifier to the function | Configurable; Default is: Error | [missing_static_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier") |
| 126 | **Message:** The overridden method is synchronized, the current one is not synchronized<br>**Cause:** According the inheritance definition, that is common to SARL and the object-oriented programming languages, overridable functions as associated to a contract with their callers. This contract indicates that the prototype of the function will never changed, and the function will have the same modifiers always. This contract must be fullfil by the overriding functions. This warning message is generated when your overriding function has not the `synchronized` modifier, and the inherited function has the `synchronized` modifier. It is a good practice to exhibit the same modifiers as the inherited function<br>**Solving:** Add `synchronized` modifier to your function | Error | [missing_synchronized](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_synchronized") |
| 127a | **Message:** Missing implemented type '*type-name-1*' for '*type-name-2*'<br>**Cause:** SARL detects for the declaration of the type named *type-name-2* that an implementation specification after `implements` is missed. The expected implementation must be a type that is equal to or a sub-type of the type named *type-named-1*<br>**Solving:** Add an appropriate implemented type | Error | [missing_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type") |
| 127b | **Message:** Type cannot be derived<br>**Cause:** Within a variable declaration with `var` or `val`, no type was specified. SARL was failed to infer the type of the variable, notably because an initialization expression is missed for the variable. Because a variable must have a type, it is forbidden to let the variable type free<br>**Solving:** Add an explicit type to the variable, or Add an initialization expression for the variable | Error | [missing_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type") |
| 128 | **Message:** Multiple annotations of non-repeatable type @*name*. Only annotation types marked @Repeatable can be used multiple times at one target<br>**Cause:** By definition, an annotation could be attached multiple times to an element only if it is declared as repeatable with the `@Repeatable` annotation. This issue message is generated when the annotation with the given *name* is attached multiple times to an element, and the annotation `@Repeatable` is not attached to the declaration of the annotation with the given *name* | Error | [multiple_annotations_used](: "org.eclipse.xtend.core.validation.IssueCodes.multiple_annotations_used") |
| 129 | **Message:** No default constructor in super type *type-name*. Another constructor must be invoked explicitly<br>**Cause:** You have define a type extending the type *type-name* and with an explicit constructor. Inside the code of this explicit constructor, you call the default constructor (implicitly or explicitly). But, the super-type does not have a default constructor<br>**Solving:** Update you constructor code in order to invoke a constructor of the super-type | Error | [must_invoke_super_constructor](: "org.eclipse.xtext.xbase.validation.IssueCodes.must_invoke_super_constructor") |
| 130 | **Message:** The attribute value is undefined for the annotation type *name*<br>**Cause:** You are trying to provide a value to an annotation, but the field `value` is not defined into the annotation.<br>This error may occur when you write `@MyAnnotion("value")` with a definition of `MyAnnotation` without a field named `value`. In this example, assuming that the declared field is named `myfield`, the correct notation is `@MyAnnotation(myfield = "value")`.<br>As for other languages as Java, SARL assumes that if the name of the attribute is not provided, the default attribute name is `value`<br>**Solving:** Add the name of the attribute before the value | Error | [no_attribute_value](: "org.eclipse.xtext.xbase.validation.IssueCodes.no_attribute_value") |
| 131a | **Message:** No enclosing instance of the type *name* is accessible in scope<br>**Cause:** You are referencing a feature within the type *type* that is defined non-statically. But, these is no accessible instance of the type *name* within the enclosing types. The following example is a typical example for this error:<br><code>class A {<br>&nbsp;&nbsp;def f : void {}<br>&nbsp;&nbsp;static class B {<br>&nbsp;&nbsp;&nbsp;&nbsp;def g : void {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;f<br>&nbsp;&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;}<br>}</code><br>The reference to `f` causes this error because the instance of `A` is inaccessible from `B` due to its `static` declaration | Error | [no_enclosing_instance_available](: "org.eclipse.xtext.xbase.validation.IssueCodes.no_enclosing_instance_available") |
| 131b | **Message:** The enclosing type does not extend or implement the interface *name*<br>**Cause:** Your are calling a feature (method or field) from the super-type by using the syntax `super.feature`. The super-type does not implement the interface *name* that is required to access to the specified feature | Error | [no_enclosing_instance_available](: "org.eclipse.xtext.xbase.validation.IssueCodes.no_enclosing_instance_available") |
| 132 | **Message:** The value for an annotation attribute must be a constant expression<br>**Cause:** It is forbidden to give a value to an annotation that is not a constant expression, i.e., an expression without variable reference, function calls, etc<br>**Solving:** Rewrite the value expression to have only constant features inside | Error | [no_illegal_value](: "org.eclipse.xtext.xbase.validation.IssueCodes.no_illegal_value") |
| 133 | **Message:** Cannot use null-safe feature call on primitive receiver<br>**Cause:** Null-safe call of an method, e.g. `obj?.feature`, enables you to test the nullity of an object before calling a feature on it. But, you have applied the null-safe call on a primitive type variable, i.e. `obj` is of primitive type. This is impossible because a primitive variable does not contain an object<br>**Solving:** Remove the null-safe operator | Error | [null_safe_feature_call_on_primitive](: "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive") |
| 134 | **Message:** Null-safe call of primitive-valued feature *feature-name*, default value *value* will be used<br>**Cause:** This issue message is generated when a null-safe test is used for computing a primitive-type value. For example, the code `list?.isEmpty` explicitly replies the value of `isEmpty` if the `list` is not null. But when `list` is null, nothing indicates what could be the boolean value to give. SARL compiler assumes the default value for the primitive type, e.g. `false` for boolean.<br>This issue message is also generated when your are using an incomplete if-then statement, e.g. `var b = if (condition) true`. There is no `else`, so that the default value for the primitive type is assumed if the condition is evaluated to false<br>**Solving:** Update your code to have a complete coverage of the cases | Configurable; Default is: Warning | [null_safe_feature_call_on_primitive_valued_feature](: "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature") |
| 135 | **Message:** Superfluous @Override annotation<br>**Cause:** From JAva language API, the annotation `@Override` is defined in order to mark a function as a function that is overridding another function. The usage of this annotation is not recommended, even it is still possible. This warning message is generated when the function is already defined with the `override` keyword, and annotated with `@Override`. In this case, the annotation is superfluous<br>**Solving:** Remove `@Override` | Warning | [obsolete_annotation_override](: "org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override") |
| 136 | **Message:** Unnecessary cast from *type-name-1* to *type-name-2*<br>**Cause:** You are using a cast operator `as`. But, the type of the left-operand expression is already compatible with the specified type as right operand. In other words, it is not necessary to cast explicitly the left expression to the right type<br>**Solving:** Remove `as` operator<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck | Delegated; Default is: Warning | [obsolete_cast](: "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast") |
| 137 | **Message:** The expression of type *type-name-1* is already of type *type-name-2*<br>**Cause:** You are using `instanceof`. But, the type of the left-operand expression is already compatible with the specified type as right operand. In other words, it is not necessary to test the type of the expression again the type; or the `instanceof` operator is always evaluated to true<br>**Solving:** Remove `instanceof` operator, and any "else" statement that is associated with the operator<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck | Delegated; Default is: Warning | [obsolete_instanceof](: "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof") |
| 138a | **Message:** The method *func-prototype* of type *type-name* must override a superclass method<br>**Cause:** You have used the keyword `override` for declaring the function with prototype *func-prototype*. Since the function in *type-name* is not overriding a function from the super type with the same erasure, but this latter does not exist<br>**Solving:** Replace `override` by `def` | Error | [obsolete_override](: "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override") |
| 138b | **Message:** The method *func-prototype* of type *type-name* shadows the method *other-prototype* of type *other-type*, but does not override it<br>**Cause:** You have used the keyword `override` for declaring the function with prototype *func-prototype*. Since the function in *type-name* is not overriding a function from *other-type* with the same erasure, but with differences into the prototype such that your function is hidding the function of *other-type*. You function should be defined with `def` instead of `overrride`<br>**Solving:** Replace `override` by `def` | Error | [obsolete_override](: "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override") |
| 139a | **Message:** Constructor call without parentheses<br>**Cause:** This error message is generated when a constructor is defined without a formal parameter, e.g. `new ()`, and this constructor is called without parentheses, e.g. `this`. In several programming standards, it is considered as a good practice to write the parentheses for each constructor call, even if there is no argument to pass to<br>**Solving:** Add `()` | Configurable; Default is: Ignored | [operation_without_parentheses](: "org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses") |
| 139b | **Message:** Method call without parentheses<br>**Cause:** This error message is generated when a function is defined without a formal parameter, e.g. `def fct()`, and this function is called without parentheses, e.g. `fct`. In several programming standards, it is considered as a good practice to write the parentheses for each method call, even if there is no argument to pass to<br>**Solving:** Add `()` | Configurable; Default is: Ignored | [operation_without_parentheses](: "org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses") |
| 140a | **Message:** Attempt to override final class<br>**Cause:** You define a class that is extending another class. But, the super class was defined as not extendable, with the `final` modifier. You cannot extend a class that is not extendable<br>**Solving:** Change the super-type | Error | [overridden_final](: "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final") |
| 140b | **Message:** Attempt to override final method *func-prototype*<br>**Cause:** You define a function with the given prototype *func-prototype* that is overriding an inherited function. But, the inherited function was defined as not overridable, with the `final` modifier. You cannot override a function that is not overridable<br>**Solving:** Remove your function | Error | [overridden_final](: "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final") |
| 141a | **Message:** Cannot reduce the visibility of the overridden method *name*<br>**Cause:** According the inheritance definition, that is common to SARL and the object-oriented programming languages, overridable functions as associated to a contract with their callers. This contract indicates that the prototype of the function will never changed, and the function will have the same accessibility/visibility always. This contract must be fullfil by the overriding functions. This error message is generated when your overriding function has a visibility lower than the visibility of the inherited function<br>**Solving:** Change the visibility of your function by moving up at least to the same visibility as the inherited function | Error | [override_reduces_visibility](: "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility") |
| 141b | **Message:** Synthetic dispatch method reduces visibility of overridden method *name*<br>**Cause:** According the inheritance definition, that is common to SARL and the object-oriented programming languages, overridable functions as associated to a contract with their callers. This contract indicates that the prototype of the function will never changed, and the function will have the same accessibility/visibility always. This contract must be fullfil by the overriding functions. This error message is generated when your overriding function has a visibility lower than the visibility of the inherited function<br>**Solving:** Change the visibility of your function by moving up at least to the same visibility as the inherited function | Error | [override_reduces_visibility](: "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility") |
| 142 | **Message:** Redundant definition of the default value for the formal parameter *name*<br>**Cause:** This warning message is generated when you declared a default value for a formal parameter that has already a default value declared into one of the super types. It is not necessary to redefine the same default value for the formal parameter<br>**Solving:** Remove the redundant declaration fo the default value | Configurable; Default is: Warning | [parameter_default_value_redefinition](: "io.sarl.lang.validation.IssueCodes.parameter_default_value_redefinition") |
| 143 | **Message:** The field *field-name* should be synchronized for avoiding value inconsistency due to parallel execution<br>**Cause:** Within the SARL operational semantic, a SARL program is executed in parallel, i.e., all the behavior units and the individual agent tasks are executed in different threaded tasks. Due to this run-time principle, the access to the fields within the scope of an agent (agent, behavior, skill) must be considered carefully. This issue code is generated by the compiler in order to notify the SARL developer that a synchronization issue may occur on the field named *field-name*. In this case, the SARL compiler cannot infer a default synchronization policy, it is recommended to the SARL developer to implement explicitly a synchronization method<br>**Solving:** Put the field access into a synchronization block | Configurable; Default is: Warning | [potential_field_synchronization_problem](: "io.sarl.lang.validation.IssueCodes.potential_field_synchronization_problem") |
| 144a | **Message:** Potential inefficient value conversion. This operation is based on a call to the function '*func-name*', which generates a value of type '*origin-type*' that is converted on-the-fly to '*target-type*'<br>**Cause:** When the `as` casting operator is used, SARL compiler infers the best method to convert the origin expression of type *origin-type* to the target *target-type*. The possible methods are:<br>1) Direct low-level cast that is natively supported by the virtual machine.<br>2) If *target-type* is a primitive type, find a function named "*target-type*Value()" within the current scope.<br>3) If *target-type* is not a primitive type, find a function named "to*target-type*()" within the current scope.<br>If none of these cases fits, an cast error is generated. However, the cases 2 and 3 means that a cast operator will be supported by a call to *func-name* function. Depending on the implementation of *func-name*, the call may be inefficient at run-time | Configurable; Default is: Warning | [potential_inefficient_value_conversion](: "io.sarl.lang.validation.IssueCodes.potential_inefficient_value_conversion") |
| 144b | **Message:** Potential inefficient value conversion. This operation is based on a call to the function '*func-name*', which may cause inefficient code execution<br>**Cause:** When the `as` casting operator is used, SARL compiler infers the best method to convert the origin expression to a target type. The possible methods are:<br>1) Direct low-level cast that is natively supported by the virtual machine.<br>2) If the target type is a primitive type, find a function named "*type-name*Value()" within the current scope.<br>3) If the target type is not a primitive type, find a function named "to*type-name*()" within the current scope.<br>If none of these cases fits, an cast error is generated. However, the cases 2 and 3 means that a cast operator will be supported by a call to a function. Depending on the implementation of the called function, the call may be inefficient at run-time | Configurable; Default is: Warning | [potential_inefficient_value_conversion](: "io.sarl.lang.validation.IssueCodes.potential_inefficient_value_conversion") |
| 145 | **Message:** Potential problem of data sharing outside the control of the agent. The field '*name*' is declared with the static modifier. It enables the code to change the field value outside a direct control of the agent; that is breaking partly the agent autonomy principle<br>**Cause:** This warning message is generated when you declared a field with the `static` modifier into an agent or on of its components. Basically, a static field is defined outside an instance of agent or component. In other words, the static field could be used for sharing data between the components of the agents, and between the agents themselves. This method of data sharing is breaking the agent autonomy principle. It should be used only for sharing constant data between the agents<br>**Solving:** Remove the `static` modifier | Configurable; Default is: Warning | [potential_memory_sharing_outside_agent_control](: "io.sarl.lang.validation.IssueCodes.potential_memory_sharing_outside_agent_control") |
| 146a | **Message:** The operator '*name*' is undefined for the argument types *type-name* and null<br>**Cause:** This error message is generated when an (in)equality test operator, i.e., `==`, `===`, `!=` or `!==`, is invoked with the null literal as right operand, e.g. `x == null`, and the left operand being of primitive type. The problem is due to the usage of the keyword `null` that is not corresponding to a specific type. In this case, the SARL compiler cannot determine the best operator implementation<br>**Solving:** Initialize to `null` a local variable with the expected type for the right operand, and use this local variable as right operand | Error | [primitive_compared_to_null](: "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null") |
| 146b | **Message:** The operator '*name*' is undefined for the argument types null and *type-name*<br>**Cause:** This error message is generated when an (in)equality test operator, i.e., `==`, `===`, `!=` or `!==`, is invoked with the null literal as left operand, e.g. `null == x`, and the right operand being of primitive type. The problem is due to the usage of the keyword `null` that is not corresponding to a specific type. In this case, the SARL compiler cannot determine the best operator implementation<br>**Solving:** Initialize to `null` a local variable with the expected type for the left operand, and use this local variable as left operand | Error | [primitive_compared_to_null](: "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null") |
| 146c | **Message:** The operator '?:' is undefined for arguments of type *type-name*<br>**Cause:** This error message may be generated when your are using the elvis operator, with a primitive type value as left operand and the `null` literal as right operand, e.g. `x ?: null`. The problem is due to the usage of the keyword `null` that is not corresponding to a specific type. In this case, the SARL compiler cannot determine the best operator implementation<br>**Solving:** Initialize to `null` a local variable with the expected type for the right operand, and use this local variable as right operand | Error | [primitive_compared_to_null](: "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null") |
| 147 | **Message:** *any-message*<br>**Cause:** It is possible to generate issue messages when a feature is used or invoked from the SARL code. The specification of the issue message is done by using one of the annotations `@ErrorOnCall`, `@WarningOnCall` or `@InfoOnCall` that takes an message (*any-message*). This annotation is attached to the feature for which a call must generate the issue | Configurable; Default is: Error | [programmatic_issue_annotation](: "io.sarl.lang.validation.IssueCodes.programmatic_issue_annotation") |
| 148a | **Message:** *expression* uses the raw type *name*. References to generic type *name* should be parameterized<br>**Cause:** The given *expression* is referencing a generic type with the given *name* without specifying its generic type arguments<br>**Solving:** Add the missed generic type arguments | Configurable; Default is: Warning | [raw_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type") |
| 148b | **Message:** *name* is a raw type. References to generic type *name* should be parameterized<br>**Cause:** You are referencing a generic type with the given *name* without specifying its generic type arguments<br>**Solving:** Add the missed generic type arguments | Configurable; Default is: Warning | [raw_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type") |
| 149 | **Message:** Redundant use of the capacity '*capacity-name*'<br>**Cause:** The capacity named *capacity-name* is specified more than one time after a `uses` statement. It is not necessary to specify a capacity name multiple name, since the compiler has already activated the access to the capacity's functions with the first occurrence of *capacity-name*<br>**Solving:** Remove the redundant *capacity-name* from the `uses` statement | Error | [redundant_capacity_use](: "io.sarl.lang.validation.IssueCodes.redundant_capacity_use") |
| 150a | **Message:** Redundant case<br>**Cause:** You have written a case without block of code that falls through the default case. It may be a piece of code like:<br><code>switch (v) {<br>&nbsp;&nbsp;case 1,<br>}</code><br>It is clear that `case 1` falls through a case that is not given. In this case, it is considered as an error because the fall-through cannot be implemented<br>**Solving:** Remove the fall-through case; or add a block of code to the redundant case | Error | [redundant_case](: "org.eclipse.xtext.xbase.validation.IssueCodes.redundant_case") |
| 150b | **Message:** Redundant case<br>**Cause:** You have written a case without block of code that falls through the default case. It may be a piece of code like:<br><code>switch (v) {<br>&nbsp;&nbsp;case 1,<br>&nbsp;&nbsp;default: {}<br>}</code><br>It is clear that `case 1` is redundant with `default` since this last is covering the `1` value<br>**Solving:** Remove the redundant case | Warning | [redundant_case](: "org.eclipse.xtext.xbase.validation.IssueCodes.redundant_case") |
| 151a | **Message:** Duplicate implemented feature '*interface-name*'<br>**Cause:** An interface, named *interface-name*, is implemented by a class. But, the interface with name *interface-name* is already implemented by the same class. It is not allowed by the SARL compiler to implement two time the same interface into a single class<br>**Solving:** Remove the redundant *interface-name* | Error | [redundant_interface_implementation](: "io.sarl.lang.validation.IssueCodes.redundant_interface_implementation") |
| 151b | **Message:** The feature '*interface-name*' is already implemented by the super-type '*type-name*'<br>**Cause:** This error may occur in two cases.<br>First, the interface named *interface-name* is implemented by the current class. But, it is also implemented by one of the super classes, named *type-name*, or it is a super-interface, named *type-name*, of another implemented interface by the class. The current specification of the interface implementation becomes redundant and unnecessary.<br>Second, the interface named *interface-name* is extended by the current interface. But, it is also defined as a super-interface for the super-interface named *type-name*. The current specification of the interface implementation becomes redundant and unnecessary<br>**Solving:** Remove the redundant *interface-name* | Configurable; Default is: Warning | [redundant_interface_implementation](: "io.sarl.lang.validation.IssueCodes.redundant_interface_implementation") |
| 152a | **Message:** The constructor *constructor-prototype* has an argument of void type<br>**Cause:** One of the generic type arguments that is implicitly associated to the given constructor is specified as to be `void` or non-found into the classpath | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 152b | **Message:** The constructor *constructor-prototype* refers to the missing type *name*<br>**Cause:** The given constructor is associated to a type that was not found into the classpath | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 152c | **Message:** The field *field-name* has an illegal argument type<br>**Cause:** One of the generic type arguments that is implicitly associated to the field *field-name* is specified as to be `void` or non-found into the classpath | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 152d | **Message:** The field *field-name* refers to the missing type *name*<br>**Cause:** The given field is associated to a type that was not found into the classpath. The non-found type may be the raw type of the field, or one of the generic type parameters | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 152e | **Message:** The method *func-prototype* from the type *type-name* has an illegal argument type<br>**Cause:** One of the generic type arguments that is implicitly associated to the given method is specified as to be `void` or non-found into the classpath | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 152f | **Message:** The method *func-prototype* from the type *type-name* refers to the missing type *name*<br>**Cause:** The given method is associated to a type that was not found into the classpath | Error | [refer_invalid_types](: "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types") |
| 153 | **Message:** Expecting the return type *type-name*. It is recommended to write the return type, even if it is inferred from the overridden function<br>**Cause:** SARL compiler is able to infer the type of the return values of a function according to the inherited prototype for the same function. In this case, it is not mandatory to specify explitly the return type into the overiding prototypes. Nevertheless, it is considered as a good practice to specify the return type. This issue message informs the developer of this recommendation<br>**Solving:** Add the return type into the overriding function prototype | Configurable; Default is: Warning | [return_type_specification_is_recommended](: "io.sarl.lang.validation.IssueCodes.return_type_specification_is_recommended") |
| 154 | **Message:** SARL library not found on the classpath. Error code: *code*; Resources on classpath are:<br>*classpath*<br>Declared fields in SARLVersion class:<br>*sarl-verison*<br>**Cause:** The SARL library is not on the *classpath*. The cause of the error is specified by the given *code* that is one of NO_SARL_VERSION_CLASS (SARL version class not found), NO_SARL_VERSION_DECLARED_TYPE (SARL version class is not a Xtext declared type), NO_SARL_VERSION_FIELD (SARL version field not found), NO_SARL_VERSION_VALUE (SARL version value not found), or INVALID_SARL_VERSION_BYTECODE (the byte code (the class) of `SARLVersion` does not contains the expected field)<br>**Solving:** Reconfigure your project to have the SARL libraries into the classpath | Error | [sarl_lib_not_on_classpath](: "io.sarl.lang.validation.IssueCodes.sarl_lib_not_on_classpath") |
| 155 | **Message:** Single dispatch method<br>**Cause:** This issue is generated because you have defined a single function to be a dispatch function. It is not efficient to have a single function to be invoked in the definition of a dispatch function<br>**Solving:** Remove the dispatch keyword | Configurable; Default is: Warning | [single_case_function](: "org.eclipse.xtend.core.validation.IssueCodes.single_case_function") |
| 156a | **Message:** Cannot make a static reference to the non-static *feature-type* *feature-name*<br>**Cause:** You are making a reference to a non-static feature (function call or field reference) from a static context. Accessing to a non-static feature needs to provide the instance of the object to access to; that is missed from a static context<br>**Solving:** Add the missed object reference | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 156b | **Message:** Cannot make a static reference to the non-static *feature-type* *feature-name* from the type *type-name*<br>**Cause:** You are making a reference to a non-static feature (function call or field reference) from a static context within the type *type-name*. Accessing to a non-static feature needs to provide the instance of the object to access to; that is missed from a static context<br>**Solving:** Add the missed object reference | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 156c | **Message:** Cannot make a static reference to the non-static type *name*<br>**Cause:** When you are defining the generic type arguments, you have to specify types as arguments, e.g. `Collection<MyType>`. Generic type arguments could only refer to statically declared types<br>**Solving:** Replace the non-static type reference by an appropriate static type reference | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 156d | **Message:** Cannot make an implicit reference to this from a static context<br>**Cause:** You are making an implicit reference to the current object `this` from a static context. Since it is a static context, `this` does not exist or is not accessible from it<br>**Solving:** Add the missed object reference | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 156e | **Message:** Cannot make an implicit static reference to the non-static extension *name*<br>**Cause:** You have defined a non-static extension in the enclosing code. And , you are making a reference to a non-static extension feature (function call usually) from a static context. Accessing to a non-static feature needs to provide the instance of the object to access to; that is missed from a static context<br>**Solving:** Replace implicit reference by explicit reference to the right object | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 156f | **Message:** Cannot use *name* in a static context<br>**Cause:** You cannot reference a type with *name* from a static context when the type *name* is not statically defined<br>**Solving:** Replace the non-static type reference by an appropriate static type reference | Error | [static_access_to_instance_member](: "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member") |
| 157 | **Message:** Suspiciously overloaded method. The *feature-type* *list-of-features* overloads the *feature-type* *list-of-rejected-features*<br>**Cause:** You are calling a feature (method, field, etc.). The target feature that is find by the SARL compiler seems to overload another feature, but not direct through an overriding. Indeed, with the extension method mechanism, candidates for being the target feature may be defined in the current type (regular linking), or imported from static types or from objects (extension linking). The selected target feature seems to hide another feature outside the inheritance mechanism between the types<br>**Solving:** Rewrite your code to remove the suspicious call | Configurable; Default is: Warning | [suspiciously_overloaded_feature](: "org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature") |
| 158 | **Message:** *any-message*<br>**Cause:** This error is generated when your SARL code has an improper syntax, and cannot be parsed by the SARL compiler. The error message provides the detail of the invalid syntax | Error | [Syntax](: "org.eclipse.xtext.diagnostics.Diagnostic.Syntax") |
| 159 | **Message:** *any-message*<br>**Cause:** This error is generated when your SARL code has an improper syntax, and cannot be parsed by the SARL compiler. The error message provides the detail of the invalid syntax and the position into your source code that is under failure | Error | [Syntax.Range](: "org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range") |
| 160 | **Message:** The ternary operator is not allowed. Use a normal if-expression<br>**Cause:** The ternary operator is the inline if-then-else expression. In some best programming practices, the inline if-then-else are considered as a bad practice. This issue message is generated when an ternary operator is used in your code<br>**Solving:** Replace the ternary operator by the equivalent if-then-else statement | Configurable; Default is: Ignored | [ternary_if_operator_is_not_allowed](: "org.eclipse.xtend.core.validation.IssueCodes.ternary_if_operator_is_not_allowed") |
| 161a | **Message:** Cannot infer type<br>**Cause:** It is too complex for the SARL compiler to infer the type of the marked feature<br>**Solving:** Define explicitly the type of the feature | Error | [too_little_type_information](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information") |
| 161b | **Message:** Cannot infer type from recursive usage. Type 'Object' is used<br>**Cause:** You code has a type-free feature, e.g. a local variable. SARL cannot infer the type of the feature because a cycle is detected regarding the type definitions<br>**Solving:** Define explicitly the type of the feature | Error | [too_little_type_information](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information") |
| 161c | **Message:** The field *name* needs an explicit type since there is no initialization expression to infer the type from<br>**Cause:** You have defined a field without explicitly specifying its type. However, there is not initialization epxression assigned to the field for determining the field's type<br>**Solving:** Define explicitly the type of the field | Error | [too_little_type_information](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information") |
| 161d | **Message:** There is no context to infer the closure's argument types from. Consider typing the arguments or put the closures into a typed context<br>**Cause:** This error is generated when the SARL compiler cannot infer the type of a formal parameter of a closure/lambda expression from the usage context<br>**Solving:** Define explicitly the formal parameters within the closure; or Make more explicit within the enclosing context the type of the closure's formal parameter | Error | [too_little_type_information](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information") |
| 161e | **Message:** There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context<br>**Cause:** This error is generated when the SARL compiler cannot infer the type of the first formal parameter of a closure/lambda expression from the usage context<br>**Solving:** Define explicitly the formal parameters within the closure; or Make more explicit within the enclosing context the type of the closure's first formal parameter | Error | [too_little_type_information](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information") |
| 162 | **Message:** The maximum number of parameters for a closure is six<br>**Cause:** A constrain given by the underground Java API is the maximum number of formal parameters that could be defined for a closure/lambda expression<br>**Solving:** Reduce the number of formal parameters of your closure | Error | [too_many_params_in_closure](: "org.eclipse.xtext.xbase.validation.IssueCodes.too_many_params_in_closure") |
| 163 | **Message:** The type *type-name* is not generic; it cannot be parameterized with arguments *type-arguments*<br>**Cause:** You have specified generic type parameters to a type that does not accept generic type parameters, e.g. `Object<String>`, `int<String>`, `MyEnum<String>`, `MyAnnotation<String>`<br>**Solving:** Remove the generic type parameters | Error | [type_argument_on_non_generic_type](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_argument_on_non_generic_type") |
| 164a | **Message:** Bounds mismatch: The type argument *type-argument* is not a valid substitute for the bounded type parameter *parameter* of the *feature-type* *feature-signature*<br>**Cause:** The generic *type-argument* does not match the type bounding constraints of the corresponding generic type parameter of the specified feature. If the bounding constraint is `extends`, then the *type-argument* is not a sub-type of the one specified into the constraint. If the bounding constraint is `super`, then the *type-argument* is not a super-type of the one specified into the constraint<br>**Solving:** Replace *type-argument* by an appropriate type | Error | [type_bounds_missmatch](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch") |
| 164b | **Message:** Bounds mismatch: The type arguments *type-arguments* are not a valid substitute for the bounded type parameters *parameters* of the *feature-type* *feature-signature*<br>**Cause:** The type that is specified after a `on` statement is not a SARL event, i.e. a sub-type of the type `Event`<br>**Solving:** Replace *type* by an appropriate event type | Error | [type_bounds_missmatch](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch") |
| 164c | **Message:** Bounds mismatch: The type arguments *type-arguments* are not a valid substitute for the bounded type parameters *type-parameters* of the super type *super-type*<br>**Cause:** When the *super-type* is defined with generic *type-parameters*, a reference to this *super-type* is provided with *type-arguments* that are not compatible with the specified *type-parameters*, i.e., at least one of the specified bounds is not compatible with the provided *type-arguments*<br>**Solving:** Replace the invalid *type-argument* by a type that is compatible with the *type-parameters* | Error | [type_bounds_missmatch](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch") |
| 164d | **Message:** Invalid type: '*type*'. Only *type* can be used after the keyword '*kw*'<br>**Cause:** The type that is specified after the given keyword *kw* is not of the expected type. For example, after a `on` statement, only a SARL event is expected<br>**Solving:** Replace *type* by an appropriate event type | Error | [type_bounds_missmatch](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch") |
| 165 | **Message:** Illegal forward reference to type parameter *name*<br>**Cause:** Since Java 5, forward references in type parameters are not allowed. Let define a list of generic type parameters `<A, B extends C, C extends A>`. In the previous example, `C` has a backward reference to `A`; and `B` has a forward reference to `C`. Then, `extends C` causes the generation of this error message. In other words, a local generic type parameters msut be declared before its usage into the bounds of another generic type parameter<br>**Solving:** Change the order of the generic type parameters | Error | [type_parameter_forward_reference](: "org.eclipse.xtext.xbase.validation.IssueCodes.type_parameter_forward_reference") |
| 166 | **Message:** Unexpected definition of a default value for the formal parameter '*name*'. It is not allowed to define a default value at this place<br>**Cause:** This error is generated when you have declared a default value for a formal parameter in a place where it is not allowed to do<br>**Solving:** Remove the default value | Error | [unexpected_default_value](: "io.sarl.lang.validation.IssueCodes.unexpected_default_value") |
| 167 | **Message:** Unexpected exception to a static constructor<br>**Cause:** A static constructor could be defined for initializing the static fields of a type. It is forbidden to define a list of thrown exceptions for a static constructor because they cannot be catched<br>**Solving:** Remove the `thrown` definition | Error | [unexpected_exception_throw](: "io.sarl.lang.validation.IssueCodes.unexpected_exception_throw") |
| 168 | **Message:** Unexpected formal parameter to a static constructor<br>**Cause:** A static constructor could be defined for initializing the static fields of a type. It is forbidden to define a formal parameter for a static constructor because their is no way to assign values to the corresponding arguments<br>**Solving:** Remove the formal parameter(s) from static constructor | Error | [unexpected_formal_parameter](: "io.sarl.lang.validation.IssueCodes.unexpected_formal_parameter") |
| 169 | **Message:** The syntax for type literals is typeof(*name*) or *name<br>**Cause:** The type literal, i.e. the name of the type, with *name* must follow a string syntax, that is explained in the error message<br>**Solving:** Use the correct syntax | Error | [unexpected_invocation_on_type_literal](: "org.eclipse.xtext.xbase.validation.IssueCodes.unexpected_invocation_on_type_literal") |
| 170 | **Message:** Unexpected definition of a type parameter (generic type) for the main function. It is not allowed to define a type parameter for a main function<br>**Cause:** This error is generated when you have declared a type parameter (or generic type) for a main function, when it is not allowed<br>**Solving:** Remove the type parameters | Error | [unexpected_type_parameter](: "io.sarl.lang.validation.IssueCodes.unexpected_type_parameter") |
| 171a | **Message:** Unhandled exception type *type-name*<br>**Cause:** Exception *type-name* has been declared to be throwable by instructions within the code block of an method or a constructor. But, the method or the constructor has no declaration of *type-name* with `throws`. This is not an error stricly because SARL compiler is able to propagate the definition of the exceptions to the enclosing function or constructor<br>**Solving:** Add *type-name* to `throws` | Configurable; Default is: Ignored | [unhandled_exception](: "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") |
| 171b | **Message:** Unhandled exception type *type-name* thrown by automatic close() invocation on *feature*<br>**Cause:** An exception is declared to be throwable by the `close()` function, which is automatically/implicitly invoked. This exception is not catched. This is not an error stricly because SARL compiler is able to propagate the definition of the exceptions to the enclosing function or constructor<br>**Solving:** Add `catch` statement | Configurable; Default is: Ignored | [unhandled_exception](: "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") |
| 171c | **Message:** Unhandled exception types *type-name-1* and *type-name-2*<br>**Cause:** Exceptions have been declared to be throwable by instructions within the code block of an method or a constructor. But, the method or the constructor has no declaration of *type-name-1* and *typename-2* with `throws`. This is not an error stricly because SARL compiler is able to propagate the definition of the exceptions to the enclosing function or constructor<br>**Solving:** Add *type-name-1* and *type-name-2* to `throws` | Configurable; Default is: Ignored | [unhandled_exception](: "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") |
| 172 | **Message:** The firing declaration of the event *type* is not considered by the SARL compiler. Only early-exit events are considered<br>**Cause:** An event is specified in the liste of fired events of an action. However, the specified event is not marked as an early-exit event. Consequently, the event is not yet supported by the SARL compiler<br>**Solving:** Remove the event from the list of fired events | Configurable; Default is: Information | [unnecessary_fired_event](: "io.sarl.lang.validation.IssueCodes.unnecessary_fired_event") |
| 173a | **Message:** Duplicate modifier '*name*' for the protocol parameter<br>**Cause:** This issue message is generated when the modifier *name* is specified multiple times on a protocol parameter<br>**Solving:** Remove the extra *name* modifier | Configurable; Default is: Warning | [unnecessary_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier") |
| 173b | **Message:** Duplicate modifier '*name*' for the target role in the protocol message<br>**Cause:** This issue message is generated when the modifier *name* is specified multiple times on a receiver role of a protocol message<br>**Solving:** Remove the extra *name* modifier | Configurable; Default is: Warning | [unnecessary_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier") |
| 173c | **Message:** The *name* modifier is unnecessary on *member-name*<br>**Cause:** This issue message is generated when the modifier *name* is specified on a member that has a default visibility equals to *name*<br>**Solving:** Remove the *name* modifier | Configurable; Default is: Warning | [unnecessary_modifier](: "org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier") |
| 174 | **Message:** Unqualified super reference is not allowed in interface context<br>**Cause:** You try to use the `super` statement from an interface. Because an interface has no associated instance of object and consequently not super-type instance, you cannot call `super`<br>**Solving:** Remove `super` | Configurable; Default is: Error | [unqualified_super_call](: "org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call") |
| 175 | **Message:** Dead code. The guard is always false<br>**Cause:** The guard that is specified for a behavior unit is evaluated by the compiler to be always false. In this case, the code of the behavior unit has absolutely no change to be executed. It may denote a problem is the design of the entity in which the behavior unit is defined, e.g. an agent<br>**Solving:** Change the guard condition; or remove the entier behavior unit | Configurable; Default is: Warning | [unreachable_behavior_unit](: "io.sarl.lang.validation.IssueCodes.unreachable_behavior_unit") |
| 176 | **Message:** Unreachable code: The case can never match. It is already handled by a previous condition<br>**Cause:** You have specified a `case` that is already handled by another `case` before. It means that this `case` will never match because the previous one will do<br>**Solving:** Remove `case` | Configurable; Default is: Warning | [unreachable_case](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case") |
| 177 | **Message:** Unreachable code: The catch block can never match. It is already handled by a previous condition<br>**Cause:** You have specified a `catch` that is already handled by another `catch` before. It means that this `catch` will never match because the previous one will do<br>**Solving:** Remove `catch` | Configurable; Default is: Warning | [unreachable_catch_block](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_catch_block") |
| 178a | **Message:** Dead code: The variable *name* will never be assigned<br>**Cause:** This error message is generated when a line of code cannot be reached in all the case. For example a loop with a `true` condition should never exit from looping. Then, all the statements after the loop becomes unreachable<br>**Solving:** Remove the dead code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 178b | **Message:** Unreachable code<br>**Cause:** This error message is generated when a line of code cannot be reached in all the case. For example a loop with a `true` condition should never exit from looping. Then, all the statements after the loop becomes unreachable<br>**Solving:** Remove the dead code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 178c | **Message:** Unreachable code<br>**Cause:** This error message is generated when a line of code cannot be reached in all the case. For example a loop with a `true` condition should never exit from looping. Then, all the statements after the loop becomes unreachable<br>**Solving:** Remove the dead code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 178d | **Message:** Unreachable code. The last argument expression does not complete normally<br>**Cause:** This error message is generated when the evaluation of the last argument causes a stop of the execution sequence that avoid to call the method/constructor for switch the argument is computed<br>**Solving:** Remove the unreachable code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 178e | **Message:** Unreachable code. The right argument expression does not complete normally<br>**Cause:** This error message is generated when the evaluation of the right argument causes a stop of the execution sequence that avoid to call the operator for switch the argument is computed<br>**Solving:** Remove the unreachable code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 178f | **Message:** Unreachable expression<br>**Cause:** This error message is generated when a line of code cannot be reached in all the case. For example a loop with a `true` condition should never exit from looping. Then, all the statements after the loop becomes unreachable<br>**Solving:** Remove the unreachable code | Error | [unreachable_code](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code") |
| 179 | **Message:** Unreachable code: The if condition can never match. It is already handled by a previous condition<br>**Cause:** Inside a condition of `if` statement, you have specified multiple tests with `instanceof`. Since all the boolean conditions are evaluated from left to right, an `instanceof` test never matches because a left-most `instanceof` already matches the same scope of types<br>**Solving:** Remove the unmatchable `instanceof` | Configurable; Default is: Warning | [unreachable_instance_of](: "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of") |
| 180a | **Message:** Protocol calls are not yet supported by the SARL compiler<br>**Cause:** The protocol call that is defined in the BSPL protocol specification is not yet implemented in the SARL toolchain<br>**Solving:** Remove the protocol call | Error | [unsupported_statement](: "io.sarl.lang.validation.IssueCodes.unsupported_statement") |
| 180b | **Message:** The statement '*name*' is not yet supported by the SARL compiler<br>**Cause:** The keyword with the *name* is recognized as a keyword y the SARL compiler. However, it is not yet fully supported by the compiler. The keyword is reserved for future usage<br>**Solving:** Remove the statement | Warning | [unsupported_statement](: "io.sarl.lang.validation.IssueCodes.unsupported_statement") |
| 181a | **Message:** The capacity '*capacity-name*' is not used<br>**Cause:** This issue is generated when *capacity-name* is specified after a `uses` statement, but none of the capacity's functions is invoked from the current entity (agent, etc.)<br>**Solving:** Remove *capacity-name* from the `uses` statement | Configurable; Default is: Warning | [unused_agent_capacity](: "io.sarl.lang.validation.IssueCodes.unused_agent_capacity") |
| 181b | **Message:** Unnecessary use of the capacity '*capacity-name*' because it is implemented by the current skill<br>**Cause:** This issue is generated when the capacity named *capacity-name* is specified after a `uses` keyword; and it is at the same time an implemented capacity by the skill in which the `uses` statement is specified. The `uses` specification is redundant, because the functions that are defined into the capacity *capacity-name* are already accessible due to their local implementation<br>**Solving:** Remove *capacity-name* from the `uses` statement | Configurable; Default is: Warning | [unused_agent_capacity](: "io.sarl.lang.validation.IssueCodes.unused_agent_capacity") |
| 182 | **Message:** The value of the local variable *name* is not used<br>**Cause:** You have declared a local variable with the given *name*, but never use it somewhere<br>**Solving:** Remove the variable declaration; or Use the variable | Configurable; Default is: Warning | [unused_local_variable](: "org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable") |
| 183a | **Message:** The extension *name* is not used in *type*<br>**Cause:** This warning is generated because you have declared to use an extension field with *name* in the given *type* that is never used. This is not a problem for running your program. But, it makes your binary executable file larger than stricly necessary<br>**Solving:** Remove the extension<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unusedPrivateMember | Delegated; Default is: Warning | [unused_private_member](: "org.eclipse.xtend.core.validation.IssueCodes.unused_private_member") |
| 183b | **Message:** The extension *type*.*name* is not used<br>**Cause:** This warning is generated because you have declared to use an extension with *name* in the given *type* that is never used. This is not a problem for running your program. But, it makes your binary executable file larger than stricly necessary<br>**Solving:** Remove the extension<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unusedPrivateMember | Delegated; Default is: Warning | [unused_private_member](: "org.eclipse.xtend.core.validation.IssueCodes.unused_private_member") |
| 183c | **Message:** The method *func-prototype* from the type *type-name* is never used locally<br>**Cause:** This warning is generated because you have defined a private function that is never called. This is not a problem for running your program. But, it makes your binary executable file larger than stricly necessary<br>**Solving:** Remove the private function<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unusedPrivateMember | Delegated; Default is: Warning | [unused_private_member](: "org.eclipse.xtend.core.validation.IssueCodes.unused_private_member") |
| 183d | **Message:** The value of the field *type*.*name* is not used<br>**Cause:** This warning is generated because you have defined a private field with *name* in the given *type* that is never used. This is not a problem for running your program. But, it makes your binary executable file larger than stricly necessary<br>**Solving:** Remove the private field<br>**Delegated to:** org.eclipse.jdt.core.compiler.problem.unusedPrivateMember | Delegated; Default is: Warning | [unused_private_member](: "org.eclipse.xtend.core.validation.IssueCodes.unused_private_member") |
| 184 | **Message:** Unused type parameter *name*. This type parameter is not used for determining if a behavior unit matches a received event<br>**Cause:** This warning is generated when you have declared a generic type parameter in an event that is not locally used in this event. When an event is received by an agent, this type parameter cannot be used to detemrine the activable behavior unit in that agent<br>**Solving:** Remove the type parameter | Warning | [unused_type_parameter](: "io.sarl.lang.validation.IssueCodes.unused_type_parameter") |
| 185 | **Message:** Discouraged use of reserved annotation. @*name* is an annotation that is reserved for the compiler usage<br>**Cause:** SARL core library defines a collection of SARL annotations that are dedicated to the internal usage of the SARL compiler. They are supposed to never be in the SARL code directly. This issue message is generated when one of these SARL annotations is explicitly specified into the code<br>**Solving:** Remove the SARL annotation from your code | Configurable; Default is: Warning | [use_reserved_sarl_annotation](: "io.sarl.lang.validation.IssueCodes.use_reserved_sarl_annotation") |
| 186a | **Message:** '*name*' is a reserved keyword which is not allowed as identifier. Please choose another word<br>**Cause:** You defined the name of a feature by using a *name* that is equal to a SARL keyword. As in all programming languages, it is forbidden to use a language keyword as identifier<br>**Solving:** Change *name* to another identifier that is not a SARL keyword | Error | [used_reserved_keyword](: "io.sarl.lang.parser.SyntaxIssueCodes.used_reserved_keyword") |
| 186b | **Message:** '*name*' is a reserved keyword which is not allowed as identifier. Please choose another word or alternatively confuse your co-workers by escaping it like this: "*simple-solution*"<br>**Cause:** You defined the name of a feature by using a *name* that is equal to a SARL keyword. As in all programming languages, it is forbidden to use a language keyword as identifier. This error message problem to you a *simple-solution*<br>**Solving:** Apply *name* to *simple-solution* or to another name that is not a SARL keyword | Error | [used_reserved_keyword](: "io.sarl.lang.parser.SyntaxIssueCodes.used_reserved_keyword") |
| 187a | **Message:** '*name*' is not a valid name<br>**Cause:** This is the general error for notifying you that the name of an element is invalid. Most of the time, it is due to the use of a forbidden character into the *name*. The major forbidden character is &#x24;. It is not allowed to use it inside a name, even if it is allowed into the Java specification<br>**Solving:** Rename the element | Error | [variable_name_disallowed](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed") |
| 187b | **Message:** Invalid name '*name*'. You must not give to *feature* a name with reserved characters<br>**Cause:** You have defined an name for the given *feature* that contains forbidden characters. The usual forbidden character is &#x24;. It is not allowed to use it inside a name because the SARL compiler uses it for internal implementation<br>**Solving:** Rename your field | Error | [variable_name_disallowed](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed") |
| 187c | **Message:** Invalid name '*name*'. You must not give to *feature* the same name as a reserved keyword<br>**Cause:** You have defined an name for a *feature* that is equal to a reserved keyword<br>**Solving:** Rename your field | Error | [variable_name_disallowed](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed") |
| 188a | **Message:** '*name*' is a discouraged name<br>**Cause:** This is the general message for notifying you that the name of an element is discouraged. Most of the time, it is due to the fact it may cause ambiguity with SARL language keywords, e.g. `self`<br>**Solving:** Rename the element | Configurable; Default is: Warning | [variable_name_discouraged](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged") |
| 188b | **Message:** 'self' is a discouraged name<br>**Cause:** `self` is a name that is used in several other programming languages as a synonym of `this`. In order to avoid ambiguity, `self` is a discouraged name<br>**Solving:** Rename the element | Configurable; Default is: Warning | [variable_name_discouraged](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged") |
| 189a | **Message:** Duplicate local variable *name*<br>**Cause:** You have declared two different variables in the same scope but with exactly the same name. It is simply forbidden to hide local variables<br>**Solving:** Rename one of the local variables | Error | [variable_name_shadowing](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing") |
| 189b | **Message:** The field '*field-name*' in '*type-name*' is hidding the inherited field '*super-field-name*'<br>**Cause:** You have declared a field with the name *field-name* into the current type; but an accessible field with the same name is also declared into a super-type. It means that the value of the field into the super-type will not be accessible directly from the current type<br>**Solving:** Rename field *field-name* | Configurable; Default is: Warning | [variable_name_shadowing](: "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing") |
| 190 | **Message:** The type *type-name* cannot extend or implement *other-type*. A supertype may not specify any wildcard<br>**Cause:** The super-type named *other-type* is defined with wildcard into its generic type parameters. It is forbidden to extends or implement a super-type with a wildcard | Error | [wildcard_in_supertype](: "org.eclipse.xtext.xbase.validation.IssueCodes.wildcard_in_supertype") |
| 191a | **Message:** The annotation @*name* is disallowed for this location<br>**Cause:** An annotation is defined in order to be attached to a specific type of element (type, field, method, etc.). This error is generated when an annotation with the given *name* is attached to a wrong type of element | Error | [wrong_annotation_target](: "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target") |
| 191b | **Message:** Unexpected annotation to a static constructor<br>**Cause:** A static constructor cannot have an annotation attached to it. This issue message is generated when a static constructor is annotated | Error | [wrong_annotation_target](: "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target") |






## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>