---
title: "Annotation Type"
layout: default
---

# Annotation Type


<ul class="page_outline" id="page_outline">

<li><a href="#1-define-an-annotation">1. Define an Annotation</a></li>
<li><a href="#2-modifiers">2. Modifiers</a></li>
<ul>
  <li><a href="#21-top-annotation-type-modifiers">2.1. Top Annotation Type Modifiers</a></li>
  <li><a href="#22-nested-annotation-type-modifiers">2.2. Nested Annotation Type Modifiers</a></li>
  <li><a href="#23-value-modifiers">2.3. Value Modifiers</a></li>
</ul>
<li><a href="#3-references">3. References</a></li>
<li><a href="#4-version-specification">4. Version Specification</a></li>
<li><a href="#5-legal-notice">5. Legal Notice</a></li>

</ul>


An annotation is a form of syntactic metadata that can be added to SARL source code.
Annotations can be reflective in that they can be embedded in binary files generated by the
SARL compiler, and may be retained by the Virtual Machine to be made retrievable at run-time.


## 1. Define an Annotation

For defining an annotation, you could use the `annotation` keyword.

The following example defines the annotation `MyAnnotation`.
This annotation defines three parameters:

* `value`, an array of strings of characters, without default value;
* `isTricky`, a boolean value, with the default `false`;
* `lotteryNumbers`, an array of integer numbers, with a default value.

Examples:

```sarl
annotation MyAnnotation {
  val value : String[]
  val isTricky : boolean = false
  val lotteryNumbers : int[] = #[ 42, 137 ]
}
```



## 2. Modifiers

Modifiers are used to modify declarations of types and type members.
This section introduces the modifiers for the annotation types.
The modifiers are usually written before the keyword for defining the annotation type.

The complete description of the modifiers' semantic is available on [this page](./Modifiers.html).

### 2.1. Top Annotation Type Modifiers

A top annotation type may be declared with one or more modifiers, which affect its runtime behavior:

* Access modifiers:
	* `public`: the annotation type is accessible from any other type (default);
	* `package`: the annotation type is accessible from only the types in the same package.
* `abstract`: the annotation type is abstract and cannot be instanced.

Examples:

```sarl
public annotation TopAnnotationType1 {
}
package annotation TopAnnotationType2 {
}
abstract annotation TopAnnotationType3 {
}
```



### 2.2. Nested Annotation Type Modifiers

A nested annotation type may be declared with one or more modifiers, which affect its runtime behavior:

* Access modifiers:
	* `public`: there are no restrictions on accessing the annotation type (default);
	* `protected`: the annotation type is accessible within the same package, and derived classes;
	* `package`: the annotation type is accessible only within the same package as its class;
	* `private`: the annotation type is accessible only within its class.
* `abstract`: the annotation type is abstract and cannot be instanced.
* `static`: the inner annotation type do not have access to the non-static members of the enclosing type.

> **_Terminology:_** Nested annotation types are divided into two categories: static and non-static.
> Nested annotation types that are declared static are called **static nested annotation types**.
> Non-static nested annotation types are called**inner annotation types**.

> **_Note:_** The modifiers may differ from the previously described, depending on the enclosing type, e.g. agent.

```sarl
class EnclosingClass {
	public annotation NestedAnnotationType1 {
	}
	protected annotation NestedAnnotationType2 {
	}
	package annotation NestedAnnotationType3 {
	}
	private annotation NestedAnnotationType4 {
	}
	abstract annotation NestedAnnotationType5 {
	}
	static annotation NestedAnnotationType6 {
	}
}
```



### 2.3. Value Modifiers

The modifiers for the values in an annotation type are:

* Access modifiers:
	* `public`: there are no restrictions on accessing the value;
* `static`: the value is a class value, not an instance value.

Examples:

```sarl
public val val1 : int
static val val2 : int
```


## 3. References

This documentation is based on documentations from the Xtext and Xtend projects, and from the Java tutorials.
Thank you to the contributors to these documents.

* [Xtend](https://www.eclipse.org/xtend/documentation.html)
* [Xtext](https://www.eclipse.org/Xtext/documentation.html)
* [Java Tutorials](https://docs.oracle.com/javase/tutorial/)

## 4. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 5. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>