---
title: "The SARL Standard Development Kit"
layout: default
---

# The SARL Standard Development Kit


<ul class="page_outline" id="page_outline">

<li><a href="#1-agent-architectures">1. Agent Architectures</a></li>
<li><a href="#2-naming-and-namespaces-in-sarl">2. Naming and Namespaces in SARL</a></li>
<li><a href="#3-working-memory-for-agents">3. Working Memory for Agents</a></li>
<li><a href="#4-observing-and-probes">4. Observing and Probes</a></li>
<li><a href="#5-sre-programmatic-access-to-the-sarl-run-time-environment">5. SRE: Programmatic Access to the SARL Run-time Environment</a></li>
<li><a href="#6-version-specification">6. Version Specification</a></li>
<li><a href="#7-legal-notice">7. Legal Notice</a></li>

</ul>


This page provides an overview of the SARL Standard Development Kit (SDK), addressing both foundational concepts and advanced features for developing agent-based applications.

## 1. Agent Architectures

The [Agent Architectures documentation](./AgentArchitectures.html) introduces the concepts, design patterns and libraries for building specific models or algorithms in the agents, also known as the agent architectures. It discusses the various architectural styles, such as reactive, proactive, and hybrid architectures, and how they can be implemented using SARL. An example of typical agent architectures is related to goal-oriented behaviors.

## 2. Naming and Namespaces in SARL

The [Naming and Namespaces documentation](./Naming.html) addresses the mechanisms for identifying agents and their components within the SARL framework. Naming conventions and namespaces are vital for ensuring uniqueness and avoiding conflicts in multi-agent systems. This section explains how SARL handles naming, scoping, and resolution of agents and their resources.

## 3. Working Memory for Agents

[Working Memory](./WorkingMemory.html) is a component in agent-based systems, enabling agents to store and manipulate data dynamically during their execution. This [documentation](./WorkingMemory.html) elaborates on how SARL SDK provides mechanisms for agents to maintain a working memory. It also cover the integration of working memory with other agent capabilities, such as perception and action.

## 4. Observing and Probes

[Observing and Probes](./Probing.html) focuses on monitoring and debugging agent-based systems. This documentation likely describes the tools and techniques available in SARL for observing agent states, behaviors, and interactions.

## 5. SRE: Programmatic Access to the SARL Run-time Environment

The [SRE utility documentation](./SRE.html) provides insights into how developers can programmatically interact with the SARL Run-time Environment (SRE). This includes accessing and manipulating agents, their behaviors, and the environment itself during execution in accordance to the core principles of multi-agent systems, such as autonomy. 


## 6. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 7. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>