---
title: "Maven Plugin for the SARL Compiler - sarl-maven-plugin"
layout: default
---

# Maven Plugin for the SARL Compiler - sarl-maven-plugin


<ul class="page_outline" id="page_outline">

<li><a href="#1-note-on-the-application-classpath">1. Note on the application classpath</a></li>
<li><a href="#2-usage">2. Usage</a></li>
<li><a href="#3-configuration">3. Configuration</a></li>
<li><a href="#4-version-specification">4. Version Specification</a></li>
<li><a href="#5-legal-notice">5. Legal Notice</a></li>

</ul>


[Apache Maven](http://maven.apache.org) is a build automation tool used primarily for Java projects.

Maven addresses two aspects of building software: first, it describes how software is built, 
and second, it describes its dependencies.
Unlike earlier tools like [Apache Ant](https://en.wikipedia.org/wiki/Apache_Ant), it uses conventions
for the build procedure, and only exceptions need to be written down.
An XML file describes the software project being built, its dependencies on other external modules
and components, the build order, directories, and required plug-ins. It comes with pre-defined
targets for performing certain well-defined tasks such as compilation of code and its packaging.

In order to compile SARL code within a Maven-based project, a compilation plug-in is provided, named
`sarl-maven-plugin`.
 
## 1. Note on the application classpath

The sarl-maven-plugin plugin does not deal with the run-time classpath of the application.
It is a tool that is compiling the SARL code to the target language, e.g. Java.
It means that it does not enforce if a SARL runtime environment is installed and used in your application.

For launching a SARL application, please refer to one of:

* [Running an agent from the command-line shell](../getstarted/RunSARLAgentCLI.html)
* [Running an agent inside SARL Eclipse environment](../getstarted/RunSARLAgentEclipse.html)
* [Running an agent from a Java program progammatically](../getstarted/RunSARLAgentJava.html)


## 2. Usage

Open the file `pom.xml` of your project, and edit it for obtaining a content similar to the
configuration below.

Replace the version number `0.15.1` of SARL with the one you want to use. You could search on the
[Maven Central Repository](http://search.maven.org/) for the last available version.


```xml
 <project>
    ...
    <properties>
       ...
       <sarl.version>0.15.1</sarl.version>
       <jdk.version>21</jdk.version>
       <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>
    </properties>
    ...
    <build>
       <plugins>
          ...
          <plugin>
             <groupId>io.sarl.lang</groupId>
             <artifactId>sarl-maven-plugin</artifactId>
             <version>${sarl.version}</version>
             <extensions>true</extensions>
             <configuration>
                <source>${jdk.version}</source>
                <encoding>${project.build.sourceEncoding}</encoding>
             </configuration>
          </plugin>
		  <plugin>
			<groupId>org.apache.maven.plugins</groupId>
			<artifactId>maven-compiler-plugin</artifactId>
			<version>3.14.0</version>
			<configuration>
				<source>${jdk.version}</source>
				<encoding>${project.build.sourceEncoding}</encoding>
			</configuration>
		  </plugin>
       </plugins>
    </build>
    ...
    <dependencies>
      ...
       <dependency>
          <groupId>io.sarl.sdk</groupId>
          <artifactId>sdk</artifactId>
          <version>${sarl.version}</version>
       </dependency>
       ...
    </dependencies>
    ...
 </project>
```









## 3. Configuration

The configuration section may contains the following elements.

| Property | Maven Goal | Property Type | Description | Default Value |
| -------- | ---------- | ------------- | ----------- | ------------- |
| encoding | compile, testCompile | java.lang.String | Encoding. |  |
| extraGenerators | compile, testCompile | java.lang.String[] | Indicates if the extra-language generators to be enabled. |  |
| failWhenMissedSRE | compile, testCompile | boolean | If the SRE on the classpath is verified, this parameter indicates if SRE missing generates an error or not. | false |
| fixClasspathJdtJse | compile, testCompile | boolean | Indicates if the JRE must be first on the classpath. | false |
| generateCloneFunctions | compile, testCompile | boolean | Indicates if the clone functions must be generated by the SARL maven plugin. | true |
| generateEqualityTestFunctions | compile, testCompile | boolean | Indicates if the equality test functions must be generated by the SARL maven plugin. | true |
| generateInlines | compile, testCompile | boolean | Indicates if the inline annotations must be generated by the SARL maven plugin. | false |
| generatePures | compile, testCompile | boolean | Indicates if the pure annotations must be generated by the SARL maven plugin. | true |
| generateSerialNumberFields | compile, testCompile | boolean | Indicates if the serial number fields must be generated by the SARL maven plugin. | true |
| generateStorageFiles | compile, testCompile | boolean | Indicates if the storage files should be generated. | true |
| generateToStringFunctions | compile, testCompile | boolean | Indicates if the toString functions must be generated by the SARL maven plugin. | true |
| generateTraceFiles | compile, testCompile | boolean | Indicates if the trace files should be generated. | true |
| input | clean, compile, initialize, testCompile | java.io.File | The directory in which the standard SARL code files are located. | src/main/sarl |
| integrationTestInput | clean, compile, initialize, testCompile | java.io.File | The directory in which the integration test SARL code files are located. | src/it/sarl |
| issueSeverities | compile, testCompile | java.util.Map&lt;java.lang.String, java.lang.String&gt; | Overriding of the issue severities. |  |
| javaCompiler | compile, testCompile | java.lang.String | Indicates the Java compiler to be invoked by the SARL maven plugin. |  |
| optimization | compile, testCompile | java.lang.String | Indicates the level of optimization. |  |
| output | clean, compile, initialize, testCompile | java.io.File | The directory in which the Java code files are generated from the standard SARL code files. | src/main/generated-sources/sarl |
| skip | clean, compile, initialize, testCompile | boolean | Skip the execution of the mojo. | false |
| source | compile, testCompile | java.lang.String | Version of the Java specification used for the source files. | 21 |
| tempDirectory | compile, testCompile | java.io.File | Location of the temporary compiler directory. |  |
| testInput | clean, compile, initialize, testCompile | java.io.File | The directory in which the test SARL code files are located. | src/test/sarl |
| testOutput | clean, compile, initialize, testCompile | java.io.File | The directory in which the Java code files are generated from the test SARL code files. | src/test/generated-sources/sarl |
| tycho | compile, testCompile | boolean | Indicates if the classpath is provided by Tycho. | false |
| verifySREInDependencies | compile, testCompile | boolean | Indicates if the the plugin verify if SRE is in the Maven dependencies. | true |
| warningsAsErrors | compile, testCompile | boolean | Indicates if all the SARL warnings are considered as errors. | false |




## 4. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 5. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>