---
title: "Tools Associated to the SARL Programming Language"
layout: default
---

# Tools Associated to the SARL Programming Language

SARL is provided with a suite of tools designed to enhance development, compilation, and execution of SARL applications. These tools cater to various aspects of the development lifecycle, from writing and compiling code to running applications in different environments.


<ul class="page_outline" id="page_outline">

<li><a href="#1-sarl-syntax-highlighting">1. SARL Syntax Highlighting</a></li>
<li><a href="#2-compilation-tools">2. Compilation Tools</a></li>
<li><a href="#3-documentation-tools">3. Documentation Tools</a></li>
<li><a href="#4-running-tools">4. Running Tools</a></li>
<li><a href="#5-version-specification">5. Version Specification</a></li>
<li><a href="#6-legal-notice">6. Legal Notice</a></li>

</ul>


## 1. SARL Syntax Highlighting

- [Definitions of SARL syntax highlighting for several code editors](./SyntaxHighlightning.html)

## 2. Compilation Tools

- [SARL compiler](./Sarlc.html) (sarlc)
- [Maven plugin](./MavenSarlPlugin.html) (sarl-maven-plugin)

## 3. Documentation Tools

- [SARL documentation generator](./Sarldoc.html) (sarldoc)
- [SARL Doclet](./APIDocumentation.html)
- [Markdown Extension for SARL documentation](./DocumentationContribution.html)

## 4. Running Tools

- [Janus without network support](./Janus.html) (janus)
- [Janus wit network support](./Janusnode.html) (janusnode)
- [Maven configuration for using Janus SRE with network connection](./JanusNetworkExtension.html)

## 5. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 6. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>