---
title: "Introduction and exercises to the general SARL syntax"
layout: default
---

# Introduction and exercises to the general SARL syntax

Welcome to the SARL Syntax Exercises! These exercises are designed to help you become familiar with the basic syntax and features of the SARL programming language. Each exercise focuses on a different aspect of SARL, providing you with hands-on experience to reinforce your learning.

To get the most out of these exercises, we recommend that you follow them in the order presented. Happy coding, and enjoy your journey into the world of SARL programming!

| Exercices | Topics |
|-----------|--------|
| [Fundamentals of the SARL syntax](./IntroductionBase.html) | These exercises introduce the foundational elements of SARL syntax. They cover the basic structure of a SARL program, including how write your first SARL script. This is the perfect starting point for beginners. |
| [Function and subprogram definitions](./IntroductionFunction.html) | Functions and suprograms are a fundamental part of any programming language, and these exercises introduce you to defining and using functions and subprograms in SARL. You will learn about function syntax, parameters, return values, and how to call functions |
| [Strings of characters](./IntroductionString.html) | Strings of characters are a fundamental data type used to represent text. These exercises cover string manipulation in SARL, including how to create strings, concatenate them, and use various string methods to perform operations like searching and replacing text |
| [Lambda expressions](./IntroductionLambda.html) | These exercises focus on lambda expressions in SARL. Lambda expressions provide a concise way to represent anonymous functions. You will learn how to use lambda expressions to write more compact and readable code |
| [List-based data structures](./IntroductionList.html) | Lists are a common data structure used to store collections of items. These exercises cover how to create, manipulate, and iterate over lists in SARL. You will learn about various list operations and how to use them effectively in your programs |
| [Map-based or dictionary data structures](./IntroductionMap.html) | Maps (or dictionaries) are another essential data structure that allows you to store key-value pairs. These exercises introduce you to maps in SARL, covering how to create maps, add and remove elements, and perform common operations on maps |
| [Object-oriented programming](./IntroductionClass.html) | In these exercises, you will learn about classes in SARL. It covers how to define classes, create objects, and use inheritance. Understanding classes is crucial for organizing your code and creating reusable components to be used by your agents |

## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>