---
title: "Tutorials for the SARL Language"
layout: default
---

# Tutorials for the SARL Language

Welcome to the SARL Tutorials page. Here, you will find a collection of tutorials designed to help you master various aspects of the SARL programming language. These tutorials cover a range of topics from basic syntax to advanced concepts in multiagent systems.

| Tutorials | Topics |
|----------|-------|
| [Introduction and exercises to the general SARL syntax](./basesyntax/index.html) | These tutorials are designed for beginners to get acquainted with the basic syntax and structure of SARL. It includes practical exercises to reinforce learning |
| [Agent architectures](./architectures/index.html) | These tutorials delve into various agent architectures i.e. internal agent definitions, that can be implemented using SARL, providing insights into designing agents for specific tasks |
| [Interaction mechanisms between agents](./interaction/index.html) | These tutorials focus on the interaction mechanisms that enable agents to communicate and collaborate |
| [Holonic multiagent systems](./holons/index.html) | These tutorials explore the concept of holonic multiagent systems, where agents can form higher-level structures or holons to achieve complex behaviors |
| [Multiagent system set-up](./mas/index.html) | These tutorials address the broader concerns and challenges that arise when defining or scaling up to multiagent systems |
| [Runtime and Deployment](./runtime/index.html) | These tutorials provides guidelines and explanations related to the run-time environment of the SARL agents and to the deployment of SARL applications |

## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>