---
title: "Tutorials on Interaction Mechanisms between Agents with the SARL Language"
layout: default
---

# Tutorials on Interaction Mechanisms between Agents with the SARL Language

Welcome to the tutorials on interaction mechanisms between agents using the SARL language. These tutorials are designed to help you understand how agents can communicate and interact with each other in a multi-agent system. By exploring these tutorials, you will learn the basics of event exchanges, interaction within private spaces, and customizing interaction mechanisms to suit specific needs.


| Tutorials | Topics |
|----------|-------|
| [Simple Event-based Interaction](./PingPong.html) | This tutorial introduces the basics of event exchanges between agents using a classic "Ping Pong" example. It is an excellent starting point for understanding how agents can send and receive events to communicate with each other |
| [Simple Event-based Interaction](./PingPongSpace.html) | This tutorial builds on the basic Ping Pong example by introducing the concept of private interaction spaces. You will learn how agents can interact within a confined space, which is useful for creating more controlled and modular multi-agent systems |
| [Simple Event-based Interaction](./EventBusOverrideWithCapacity.html) | This advanced tutorial guides you through the process of overriding the default event-based interaction mechanism to apply a specific routing strategy for events between agents. This is useful for customizing how events are delivered and processed in your multi-agent system |

## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>