---
title: "Tutorials on the Run-time Environment of SARL and the Deployment of SARL Applications"
layout: default
---

# Tutorials on the Run-time Environment of SARL and the Deployment of SARL Applications

Welcome to the tutorials on setting up multiagent systems using the SARL language. These tutorials are designed to guide you through the process of creating and initializing multiagent systems, providing you with the foundational knowledge needed to build complex and distributed applications.



| Tutorials | Topics |
|----------|-------|
| [Parallel execution within the agents](./ParallelExecution.html) | This tutorial explores the principles of parallel execution within SARL agents. Parallel execution is crucial for optimizing the performance of multiagent systems, allowing agents to perform tasks concurrently and efficiently |
| [Creatiion of an extension for the Janus SRE](./SreExtension.html) | This tutorial guides you through the process of creating an extension for the Janus SARL Runtime Environment (SRE). Extensions allow you to enhance the functionality of the SRE, adding custom features and capabilities tailored to your specific needs |
| [Creation of a runnable application (Jar) file for SARL application](./CreateRunnableJar.html) | This tutorial provides a comprehensive guide to creating a runnable application (Jar) file for SARL applications. Packaging your SARL application as a Jar file allows for easy distribution and deployment, making it accessible to users and deployable across different environments |

## 1. Version Specification

* Specification: SARL General-purpose Agent-Oriented Programming Language ("Specification")
* Version: 0.15
* Status: Stable Release
* Release: 2025-09-11

## 2. Legal Notice

> Copyright &copy; 2014-2025 [SARL.io, the Original Authors and Main Authors](http://www.sarl.io/about/index.html).
>
> Documentation text and medias are licensed under the Creative Common CC-BY-SA-4.0;
> you may not use this file except in compliance with CC-BY-SA-4.0.
> You may obtain a copy of [CC-BY-4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.en).
>
> Examples of SARL code are licensed under the Apache License, Version 2.0;
> you may not use this file except in compliance with the Apache License.
> You may obtain a copy of the [Apache License](http://www.apache.org/licenses/LICENSE-2.0).
>
> You are free to reproduce the content of this page on copyleft websites such as Wikipedia.

<small>Generated with the translator docs.generator 0.15.1.</small>