/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.experienceindex;

import io.sarl.api.experienceindex.SarlExperienceIndex;
import io.sarl.eclipse.experienceindex.Messages;
import io.sarl.eclipse.experienceindex.SarlExperienceIndexPlugin;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SarlExperienceIndexResultDialog
extends IconAndMessageDialog {
    private static final int GLOBAL_ICON_SIZE = 256;
    private static final String BACKGROUND_IMAGE = "icons/sei_background.png";
    private static final String ICON = "icons/sei.png";
    private static final String SEI_FONT = "arial";
    private static final int SEI_FONT_SIZE = 110;
    private static final int SEI_FONT_STYLE = 1;
    private static final int SEI_FONT_COLOR_RED = 94;
    private static final int SEI_FONT_COLOR_GREEN = 105;
    private static final int SEI_FONT_COLOR_BLUE = 114;
    private final SarlExperienceIndex.SEI sei;
    private SoftReference<Image> globalImage;

    public SarlExperienceIndexResultDialog(Shell parentShell, SarlExperienceIndex.SEI sei) {
        super(parentShell);
        this.sei = sei;
        this.message = MessageFormat.format(Messages.SarlExperienceIndexResultDialog_0, Float.valueOf(sei.getBaseScore()), Float.valueOf(sei.getCpuScore()), Float.valueOf(sei.getMemoryScore()), Float.valueOf(sei.getDiskScore()));
    }

    public static int open(Shell parent, SarlExperienceIndex.SEI sei) {
        SarlExperienceIndexResultDialog dialog = new SarlExperienceIndexResultDialog(parent, sei);
        return dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        return composite;
    }

    protected Image getImage() {
        Image img;
        Image image = img = this.globalImage != null ? this.globalImage.get() : null;
        if (img == null) {
            Display display = this.getShell().getDisplay();
            img = new Image((Device)display, 256, 256);
            GC gc = new GC((Drawable)img);
            Image backimg = SarlExperienceIndexPlugin.getDefault().getImage(BACKGROUND_IMAGE);
            gc.setAntialias(1);
            gc.drawImage(backimg, 0, 0);
            backimg.dispose();
            gc.setForeground(new Color((Device)display, 94, 105, 114));
            Font newFont = new Font((Device)display, SEI_FONT, 110, 1);
            gc.setFont(newFont);
            String text = MessageFormat.format(Messages.SarlExperienceIndexResultDialog_1, Float.valueOf(this.sei.getBaseScore()));
            Point size = gc.textExtent(text);
            gc.drawText(text, (256 - size.x) / 2, (256 - size.y) / 2, 1);
            newFont.dispose();
            gc.dispose();
            this.globalImage = new SoftReference<Image>(img);
        }
        return img;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SarlExperienceIndexResultDialog_2);
        shell.setImage(SarlExperienceIndexPlugin.getDefault().getImage(ICON));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

