/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class SARLEclipsePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "io.sarl.eclipse";
    private static SARLEclipsePlugin instance;

    public SARLEclipsePlugin() {
        SARLEclipsePlugin.setDefault(this);
    }

    public ILog getILog() {
        return this.getLog();
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void setDefault(SARLEclipsePlugin defaultInstance) {
        instance = defaultInstance;
    }

    public static SARLEclipsePlugin getDefault() {
        return instance;
    }

    public Image getImage(String imagePath) {
        ImageDescriptor descriptor = this.getImageDescriptor(imagePath);
        if (descriptor == null) {
            return null;
        }
        return descriptor.createImage();
    }

    public ImageDescriptor getImageDescriptor(String imagePath) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(imagePath);
        if (descriptor == null && (descriptor = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)imagePath).orElse(null)) != null) {
            this.getImageRegistry().put(imagePath, descriptor);
        }
        return descriptor;
    }

    public IStatus createStatus(int severity, String message, Throwable cause) {
        return this.createStatus(severity, 0, message, cause);
    }

    public IStatus createStatus(int severity, int code, String message, Throwable cause) {
        String msg = message;
        if (Strings.isNullOrEmpty((String)msg)) {
            msg = cause.getLocalizedMessage();
            if (Strings.isNullOrEmpty((String)msg)) {
                msg = cause.getMessage();
            }
            if (Strings.isNullOrEmpty((String)msg)) {
                msg = cause.getClass().getSimpleName();
            }
        }
        if (cause != null) {
            StackTraceElement[] stackTraces;
            ArrayList<IStatus> childStatuses = new ArrayList<IStatus>();
            StackTraceElement[] stackTraceElementArray = stackTraces = cause.getStackTrace();
            int n = stackTraces.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTrace = stackTraceElementArray[n2];
                IStatus status = this.createStatus(severity, stackTrace.toString());
                childStatuses.add(status);
                ++n2;
            }
            IStatus[] children = new IStatus[childStatuses.size()];
            if (!childStatuses.isEmpty()) {
                childStatuses.toArray(children);
            }
            return new MultiStatus(PLUGIN_ID, code, children, msg, cause);
        }
        return new Status(severity, PLUGIN_ID, code, msg, cause);
    }

    public IStatus createStatus(int severity, Throwable cause) {
        return this.createStatus(severity, 0, null, cause);
    }

    public IStatus createStatus(int severity, int code, Throwable cause) {
        return this.createStatus(severity, code, null, cause);
    }

    public IStatus createStatus(int severity, String message) {
        return this.createStatus(severity, 0, message);
    }

    public IStatus createStatus(int severity, int code, String message) {
        return this.createStatus(severity, code, message, null);
    }

    public IStatus createOkStatus() {
        return Status.OK_STATUS;
    }

    public IStatus createMultiStatus(IStatus ... status) {
        return this.createMultiStatus(Arrays.asList(status));
    }

    public IStatus createMultiStatus(Iterable<? extends IStatus> status) {
        IStatus max = SARLEclipsePlugin.findMax(status);
        MultiStatus multiStatus = max == null ? new MultiStatus(PLUGIN_ID, 0, null, null) : new MultiStatus(PLUGIN_ID, 0, max.getMessage(), max.getException());
        for (IStatus iStatus : status) {
            multiStatus.add(iStatus);
        }
        return multiStatus;
    }

    private static IStatus findMax(Iterable<? extends IStatus> status) {
        IStatus max = null;
        for (IStatus iStatus : status) {
            if (max != null && max.getSeverity() <= iStatus.getSeverity()) continue;
            max = iStatus;
        }
        return max;
    }

    public void logErrorMessage(String message) {
        this.getILog().log((IStatus)new Status(4, PLUGIN_ID, message, null));
    }

    public void logDebugMessage(String message) {
        Debug.println((String)message);
    }

    public void logDebugMessage(Throwable cause) {
        Debug.printStackTrace((Throwable)cause);
    }

    public void logDebugMessage(String message, Throwable cause) {
        Debug.println((String)message);
        if (cause != null) {
            Debug.printStackTrace((Throwable)cause);
        }
    }

    public void log(Throwable exception) {
        if (exception instanceof CoreException) {
            this.getILog().log((IStatus)new Status(4, PLUGIN_ID, exception.getMessage(), exception.getCause()));
        } else if (exception != null) {
            this.getILog().log((IStatus)new Status(4, PLUGIN_ID, exception.getMessage(), exception));
        } else {
            this.getILog().log((IStatus)new Status(4, PLUGIN_ID, "Internal Error", exception));
        }
    }

    public IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public void savePreferences() {
        IEclipsePreferences prefs = this.getPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            this.getILog().log(this.createStatus(4, e));
        }
    }

    public void openError(Shell shell, String title, String message, String reason, Throwable exception) {
        Throwable ex;
        Throwable throwable = ex = exception != null ? Throwables.getRootCause((Throwable)exception) : null;
        if (ex != null) {
            this.log(ex);
            IStatus status = this.createStatus(4, reason, ex);
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }
}

