/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.buildpath;

import io.sarl.apputils.eclipseextensions.buildpath.AbstractSARLBasedClasspathContainer;
import io.sarl.apputils.eclipseextensions.buildpath.SARLBundleBuildPath;
import io.sarl.apputils.uiextensions.Bundles;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.buildpath.Messages;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;

public class SARLClasspathContainer
extends AbstractSARLBasedClasspathContainer {
    public SARLClasspathContainer(IPath containerPath, IJavaProject javaProject) {
        this(containerPath, javaProject, null);
    }

    public SARLClasspathContainer(IPath containerPath, IJavaProject javaProject, Comparator<IClasspathEntry> entryComparator) {
        super(containerPath, javaProject, entryComparator);
    }

    public int getKind() {
        if (this.isModular()) {
            return 1;
        }
        return 2;
    }

    protected void updateBundleList(Set<String> entries) {
        String[] stringArray = SARLBundleBuildPath.getSarlDependencyBundleNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rootBundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)rootBundleName);
            if (bundle != null) {
                for (String symbolicName : Bundles.resolveBundleDependencies((Bundle)bundle).getTransitiveSymbolicNames(true)) {
                    entries.add(symbolicName);
                }
            } else {
                SARLEclipsePlugin.getDefault().logErrorMessage(MessageFormat.format(Messages.SARLClasspathContainer_1, rootBundleName));
            }
            ++n2;
        }
    }

    protected void updateClasspathEntries(Set<IClasspathEntry> entries) {
        String[] stringArray = SARLBundleBuildPath.getSarlDependencyBundleNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rootBundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)rootBundleName);
            if (bundle != null) {
                for (IClasspathEntry entry : Bundles.resolveBundleDependencies((Bundle)bundle).getTransitiveClasspathEntries(true)) {
                    entries.add(entry);
                }
            } else {
                SARLEclipsePlugin.getDefault().logErrorMessage(MessageFormat.format(Messages.SARLClasspathContainer_1, rootBundleName));
            }
            ++n2;
        }
    }

    public String getDescription() {
        return Messages.SARLClasspathContainer_0;
    }
}

