/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.explorer;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import io.sarl.eclipse.explorer.IPackageExplorerLabelProviderBuilder;
import io.sarl.eclipse.explorer.SARLElementImageProvider;
import io.sarl.eclipse.explorer.SARLPackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;

@Singleton
public class DefaultPackageExplorerLabelProviderBuilder
implements IPackageExplorerLabelProviderBuilder {
    private Injector injector;

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector.createChildInjector(new Module[]{new PrivateModule()});
    }

    @Override
    public PackageExplorerLabelProvider newInstance(PackageExplorerContentProvider contentProvider) {
        SARLPackageExplorerLabelProvider provider = new SARLPackageExplorerLabelProvider(contentProvider);
        this.injector.injectMembers((Object)provider);
        return provider;
    }

    private static class PrivateModule
    implements Module {
        PrivateModule() {
        }

        public void configure(Binder binder) {
            binder.bind(JavaElementImageProvider.class).to(SARLElementImageProvider.class);
        }
    }
}

