/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.explorer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.sarl.lang.core.util.SarlUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class SARLElementImageProvider
extends JavaElementImageProvider {
    private final Set<String> fileExtensions = new HashSet<String>();

    @Inject
    public void setFileExtensions(@Named(value="file.extensions") String fileExtensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(Arrays.asList(SarlUtils.getFileExtensions((String)fileExtensions)));
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public ImageDescriptor getBaseImageDescriptor(IJavaElement element, int renderFlags) {
        ImageDescriptor desc;
        if (element.getElementType() == 4 && (desc = this.getPackageFragmentIcon((IPackageFragment)element)) != null) {
            return desc;
        }
        return super.getBaseImageDescriptor(element, renderFlags);
    }

    private ImageDescriptor getPackageFragmentIcon(IPackageFragment fragment) {
        boolean containsJavaElements = false;
        try {
            containsJavaElements = fragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {}
        try {
            Object[] resources;
            if (!containsJavaElements && (resources = fragment.getNonJavaResources()).length > 0) {
                Object[] objectArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.isSarlResource(child)) {
                        return JavaPluginImages.DESC_OBJS_PACKAGE;
                    }
                    ++n2;
                }
                return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
            }
        }
        catch (JavaModelException javaModelException) {}
        if (!containsJavaElements) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    protected boolean isSarlResource(Object resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return this.getFileExtensions().contains(file.getFileExtension());
        }
        return false;
    }
}

