/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.explorer;

import com.google.inject.Inject;
import io.sarl.eclipse.explorer.HiddenFileFilter;
import io.sarl.eclipse.explorer.IPackageExplorerLabelProviderBuilder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public class SARLPackageExplorerPart
extends PackageExplorerPart {
    public static final String ID_PACKAGES = "io.sarl.eclipse.explorer.PackageExplorer";
    private static final String CONTEXT_ID = "io.sarl.eclipse.explorer.PackageExplorer";
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_GROUP_LIBRARIES = "group_libraries";
    private static final int FLAT_LAYOUT = 2;
    private static final boolean DEFAULT_SHOW_LIBRARIES = false;
    private static final boolean DEFAULT_SHOW_FLAT = false;
    private final ReflectExtensions reflect;
    private final IPackageExplorerLabelProviderBuilder packageExplorerLabelProviderProvider;

    @Inject
    public SARLPackageExplorerPart(ReflectExtensions reflect, IPackageExplorerLabelProviderBuilder builder) {
        this.reflect = reflect;
        this.packageExplorerLabelProviderProvider = builder;
        IDialogSettings dialogSettings = this.getDialogSettings();
        try {
            this.reflect.set((Object)this, "fShowLibrariesNode", (Object)(dialogSettings.get(TAG_GROUP_LIBRARIES) == null ? false : dialogSettings.getBoolean(TAG_GROUP_LIBRARIES)));
            try {
                this.reflect.set((Object)this, "fIsCurrentLayoutFlat", (Object)(dialogSettings.getInt(TAG_LAYOUT) == 2 ? 1 : 0));
            }
            catch (NumberFormatException numberFormatException) {
                this.reflect.set((Object)this, "fIsCurrentLayoutFlat", (Object)false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    protected IDialogSettings getDialogSettings() {
        try {
            return (IDialogSettings)this.reflect.get((Object)this, "fDialogSettings");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    public static SARLPackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView("io.sarl.eclipse.explorer.PackageExplorer");
        if (view instanceof SARLPackageExplorerPart) {
            SARLPackageExplorerPart cvalue = (SARLPackageExplorerPart)view;
            return cvalue;
        }
        return null;
    }

    public static SARLPackageExplorerPart openInActivePerspective() {
        try {
            return (SARLPackageExplorerPart)JavaPlugin.getActivePage().showView("io.sarl.eclipse.explorer.PackageExplorer");
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("io.sarl.eclipse.explorer.PackageExplorer");
        super.createPartControl(parent);
        this.internalResetLabelProvider();
        this.restoreFilterAndSorter();
    }

    protected void restoreFilterAndSorter() {
        ProblemTreeViewer viewer = this.getViewer();
        viewer.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        viewer.addFilter((ViewerFilter)new HiddenFileFilter());
    }

    public void rootModeChanged(int newMode) {
        super.rootModeChanged(newMode);
        this.internalResetLabelProvider();
    }

    protected void internalResetLabelProvider() {
        try {
            PackageExplorerLabelProvider provider = this.createLabelProvider();
            this.reflect.set((Object)this, "fLabelProvider", (Object)provider);
            provider.setIsFlatLayout(this.isFlatLayout());
            DecoratingJavaLabelProvider decoratingProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)provider, false, this.isFlatLayout());
            this.reflect.set((Object)this, "fDecoratingLabelProvider", (Object)decoratingProvider);
            this.getViewer().setLabelProvider((IBaseLabelProvider)decoratingProvider);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    protected PackageExplorerLabelProvider getLabelProvider() {
        try {
            return (PackageExplorerLabelProvider)this.reflect.get((Object)this, "fLabelProvider");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    protected ProblemTreeViewer getViewer() {
        try {
            return (ProblemTreeViewer)this.reflect.get((Object)this, "fViewer");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    protected PackageExplorerContentProvider getContentProvider() {
        try {
            return (PackageExplorerContentProvider)this.reflect.get((Object)this, "fContentProvider");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Error(e);
        }
    }

    protected PackageExplorerLabelProvider createLabelProvider() {
        return this.packageExplorerLabelProviderProvider.newInstance(this.getContentProvider());
    }
}

