/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.javadoc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.ui.contentassist.javadoc.ISarlDocumentationProvider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;

public class GenerateJavadocHandler
extends AbstractHandler {
    @Inject
    private Provider<SyncUtil> syncUtil;
    @Inject
    private Provider<ISarlDocumentationProvider> documentProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ((SyncUtil)this.syncUtil.get()).totalSync(false);
            XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IXtextDocument document = editor.getDocument();
                ((ISarlDocumentationProvider)this.documentProvider.get()).generateDocumentationIfPossible(document, selection);
            }
            return null;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

